/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import tla2sany.drivers.FrontEndException;
import tla2sany.drivers.SANY;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.xml.SymbolContext;
import tla2sany.xml.XMLExportingException;
import util.FileUtil;
import util.SimpleFilenameToStream;
import util.ToolIO;

public class XMLExporter {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String TLA_SCHEMA = "http://tla.msr-inria.inria.fr/tlaps/sany.xsd";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public static final void main(String[] args) throws XMLExportingException {
        SpecObj spec2;
        PrintStream out;
        boolean offline_mode;
        block19: {
            if (args.length < 1) {
                throw new IllegalArgumentException("at least one .tla file must be given");
            }
            LinkedList<String> pathsLs = new LinkedList<String>();
            offline_mode = false;
            int lastarg = -1;
            for (int i = 0; i < args.length - 1; ++i) {
                if ("-o".equals(args[i])) {
                    offline_mode = true;
                    lastarg = i;
                    continue;
                }
                if (!"-I".equals(args[i])) continue;
                if (++i > args.length - 2) {
                    throw new IllegalArgumentException("the -I flag must be followed by a directory and at least one .tla file");
                }
                pathsLs.addLast(args[i]);
                lastarg = i;
            }
            ++lastarg;
            String[] paths = new String[pathsLs.size()];
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = (String)pathsLs.get(i);
            }
            if (args.length - lastarg != 1) {
                throw new IllegalArgumentException("Only one TLA file to check allowed!");
            }
            String tla_name = args[lastarg++];
            SimpleFilenameToStream fts = new SimpleFilenameToStream(paths);
            out = System.out;
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            spec2 = new SpecObj(tla_name, fts);
            ToolIO.out.println("\n****** SANY2 " + SANY.version + "\n");
            if (FileUtil.createNamedInputStream(tla_name, spec2.getResolver()) != null) {
                try {
                    SANY.frontEndMain(spec2, tla_name, System.err);
                    if (spec2.getExternalModuleTable() == null) {
                        throw new XMLExportingException("spec " + spec2.getName() + " is malformed - does not have an external module table", null);
                    }
                    if (spec2.getExternalModuleTable().getRootModule() == null) {
                        throw new XMLExportingException("spec " + spec2.getName() + " is malformed - does not have a root module", null);
                    }
                    break block19;
                }
                catch (FrontEndException fe) {
                    fe.printStackTrace();
                    ToolIO.out.println(fe);
                    return;
                }
            }
            ToolIO.out.println("Cannot find the specified file " + tla_name + ".");
            return;
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc2 = docBuilder.newDocument();
            Element rootElement = doc2.createElement("modules");
            doc2.appendChild(rootElement);
            SymbolContext context = new SymbolContext();
            ExternalModuleTable table = spec2.getExternalModuleTable();
            ModuleNode[] externalModules = table.getModuleNodes();
            for (int j = 0; j < externalModules.length; ++j) {
                Element ext_e = externalModules[j].export(doc2, context);
                rootElement.appendChild(ext_e);
            }
            rootElement.insertBefore(context.getContextElement(doc2), rootElement.getFirstChild());
            XMLExporter.insertRootName(doc2, rootElement, spec2);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source2 = new DOMSource(doc2);
            if (!offline_mode) {
                try {
                    SchemaFactory factory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
                    Schema schema = factory.newSchema(new URL(TLA_SCHEMA));
                    Validator validator = schema.newValidator();
                    validator.validate(source2);
                }
                catch (IOException factory) {
                    // empty catch block
                }
            }
            StreamResult result = new StreamResult(out);
            transformer.transform(source2, result);
        }
        catch (ParserConfigurationException pce) {
            throw new XMLExportingException("failed to write XML", pce);
        }
        catch (TransformerException tfe) {
            throw new XMLExportingException("failed to write XML", tfe);
        }
        catch (SAXException se) {
            throw new XMLExportingException("failed to validate XML", se);
        }
    }

    static void insertRootName(Document doc2, Element rootElement, SpecObj spec2) {
        Element el = doc2.createElement("RootModule");
        el.appendChild(doc2.createTextNode(spec2.getName()));
        rootElement.insertBefore(el, rootElement.getFirstChild());
    }
}

