/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.Variable;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tlc2.debug.TLCSourceBreakpoint;
import tlc2.debug.TLCStackFrame;
import tlc2.debug.TLCStateStackFrame;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.TLCState;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.impl.RecordValue;

public class TLCSuccessorsStackFrame
extends TLCStateStackFrame {
    private final transient INextStateFunctor fun;
    private final transient Action a;

    public TLCSuccessorsStackFrame(TLCStackFrame parent, OpDefNode node2, Context ctxt, Tool tool, TLCState s, Action a, INextStateFunctor fun) {
        super(parent, (SemanticNode)node2, ctxt, tool, s);
        this.a = a;
        this.fun = fun;
        this.setName(node2.toString());
    }

    public int getSuccessorId() {
        return this.ctxtId + 4;
    }

    @Override
    public Variable[] getVariables(int vr) {
        if (vr == this.getSuccessorId()) {
            return this.tool.eval(() -> {
                Set<TLCState> aSteps = this.fun.getStates().getSubSet(this.a);
                Variable[] vars = new Variable[aSteps.size()];
                Iterator<TLCState> itr = aSteps.iterator();
                for (int i = 0; i < vars.length; ++i) {
                    RecordValue r = new RecordValue(itr.next());
                    vars[i] = this.getStateAsVariable(r, this.a.getName().toString() + (i + 1));
                }
                return vars;
            });
        }
        return super.getVariables(vr);
    }

    @Override
    public Scope[] getScopes() {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        scopes.addAll(Arrays.asList(super.getScopes()));
        Scope scope = new Scope();
        scope.setName("Successors");
        scope.setVariablesReference(this.getSuccessorId());
        scopes.add(scopes.size() - 1, scope);
        return scopes.toArray(new Scope[scopes.size()]);
    }

    @Override
    public boolean matches(TLCSourceBreakpoint bp) {
        OpDefNode odn = (OpDefNode)this.node;
        if (odn.getTreeNode() != null && odn.getTreeNode().one().length > 0) {
            TreeNode[] one = odn.getTreeNode().one();
            Location location = one[0].getLocation();
            int hits = bp.getHits();
            return bp.getLine() == location.beginLine() && location.beginColumn() <= bp.getColumnAsInt() && bp.getColumnAsInt() <= location.endColumn() && this.fun.getStates().getSubSet(this.a).size() >= hits;
        }
        return false;
    }
}

