/*
 * Decompiled with CFR 0.152.
 */
package tlc2.pprint;

import tlc2.pprint.Node;
import tlc2.pprint.ParseException;

public class Parse {
    private static final char setOpen = '{';
    private static final char setClose = '}';
    private static final char seqOpen = '<';
    private static final char seqClose = '>';
    private static final char recOpen = '[';
    private static final char recClose = ']';
    private static final String recDiv = "|->";
    private static final char funOpen = '(';
    private static final char funClose = ')';
    private static final String funDiv = ":>";
    private static final String funSep = "@@";
    private static final String intDiv = "..";
    private static final String ssDiv = "SUBSET";

    public static Node parse(String string2, int index2) throws ParseException {
        if (string2 == null) {
            throw new ParseException("TLC Bug: while formating output, the formatter was called with a null string for a value");
        }
        if (string2.length() == 0) {
            throw new ParseException("TLC Bug: while formating output, the formatter was called with an empty string for a value");
        }
        if (index2 < 0 || index2 > string2.length() - 1) {
            throw new ParseException("TLC Bug: while formating output, the formatter was called with a string " + string2 + " for a value and an index " + index2 + " out of bounds");
        }
        index2 = Parse.skipWhitespace(string2, index2);
        if (string2.charAt(index2) == '{') {
            return Parse.parseSet(string2, index2);
        }
        if (string2.charAt(index2) == '<') {
            return Parse.parseSequence(string2, index2);
        }
        if (string2.charAt(index2) == '[') {
            return Parse.parseRecord(string2, index2);
        }
        if (string2.charAt(index2) == '(') {
            return Parse.parseFunction(string2, index2);
        }
        if (string2.regionMatches(index2, ssDiv, 0, ssDiv.length())) {
            return Parse.parseSubset(string2, index2);
        }
        return Parse.parseConstant(string2, index2);
    }

    private static Node parseSet(String string2, int index2) throws ParseException {
        int first = index2;
        int last = index2;
        try {
            Node node2 = new Node(string2, first, 2);
            Node firstelement = null;
            Node lastelement = null;
            ++last;
            last = Parse.skipWhitespace(string2, last);
            while (string2.charAt(last) != '}') {
                Node elt = Parse.parse(string2, last);
                if (firstelement == null) {
                    firstelement = elt;
                    lastelement = elt;
                } else {
                    lastelement.next(elt);
                    lastelement = elt;
                }
                last = elt.last() + 1;
                last = Parse.skipWhitespace(string2, last);
                if (string2.charAt(last) == ',') {
                    ++last;
                }
                last = Parse.skipWhitespace(string2, last);
            }
            node2.children(firstelement);
            node2.last(last);
            return node2;
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a set starting at index " + index2 + " in the value " + string2 + "\n" + e2.getMessage());
        }
        catch (ParseException e3) {
            throw e3;
        }
    }

    private static Node parseSequence(String string2, int index2) throws ParseException {
        int first = index2;
        int last = index2;
        try {
            Node node2 = new Node(string2, first, 3);
            Node firstelement = null;
            Node lastelement = null;
            ++last;
            ++last;
            last = Parse.skipWhitespace(string2, last);
            while (string2.charAt(last) != '>') {
                Node elt = Parse.parse(string2, last);
                if (firstelement == null) {
                    firstelement = elt;
                    lastelement = elt;
                } else {
                    lastelement.next(elt);
                    lastelement = elt;
                }
                last = elt.last() + 1;
                last = Parse.skipWhitespace(string2, last);
                if (string2.charAt(last) == ',') {
                    ++last;
                }
                last = Parse.skipWhitespace(string2, last);
            }
            node2.children(firstelement);
            node2.last(++last);
            return node2;
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a sequence starting at index " + index2 + " in the value " + string2 + "\n" + e2.getMessage());
        }
        catch (ParseException e3) {
            throw e3;
        }
    }

    private static Node parseRecord(String string2, int index2) throws ParseException {
        int first = index2;
        int last = index2;
        try {
            Node node2 = new Node(string2, first, 4);
            Node firstelement = null;
            Node lastelement = null;
            ++last;
            last = Parse.skipWhitespace(string2, last);
            while (string2.charAt(last) != ']') {
                Node elt = Parse.parseRecordPair(string2, last);
                if (firstelement == null) {
                    firstelement = elt;
                    lastelement = elt;
                } else {
                    lastelement.next(elt);
                    lastelement = elt;
                }
                last = elt.last() + 1;
                last = Parse.skipWhitespace(string2, last);
                if (string2.charAt(last) == ',') {
                    ++last;
                }
                last = Parse.skipWhitespace(string2, last);
            }
            node2.children(firstelement);
            node2.last(last);
            return node2;
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a record starting at index " + index2 + " in the value " + string2 + "\n" + e2.getMessage());
        }
        catch (ParseException e3) {
            throw e3;
        }
    }

    private static Node parseRecordPair(String string2, int index2) throws ParseException {
        int first = index2;
        int last = index2;
        try {
            Node node2 = new Node(string2, first, 5);
            Node field = null;
            Node value = null;
            field = Parse.parse(string2, last);
            last = field.last() + 1;
            last = Parse.skipWhitespace(string2, last);
            if (!string2.regionMatches(last, recDiv, 0, recDiv.length())) {
                throw new ParseException("TLC Bug: while formating output, the formatter couldn't find the token |-> while parsing a record field/value pair starting at index " + index2 + " in value " + string2);
            }
            last += recDiv.length();
            last = Parse.skipWhitespace(string2, last);
            value = Parse.parse(string2, last);
            field.next(value);
            node2.children(field);
            node2.last(value.last());
            return node2;
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a record pair starting at index " + index2 + " in the value " + string2 + "\n" + e2.getMessage());
        }
        catch (ParseException e3) {
            throw e3;
        }
    }

    private static Node parseFunction(String string2, int index2) throws ParseException {
        int first = index2;
        int last = index2;
        try {
            Node node2 = new Node(string2, first, 6);
            Node firstpair = null;
            Node lastpair = null;
            ++last;
            last = Parse.skipWhitespace(string2, last);
            while (string2.charAt(last) != ')') {
                Node pair2 = Parse.parseFunctionPair(string2, last);
                if (firstpair == null) {
                    firstpair = pair2;
                    lastpair = pair2;
                } else {
                    lastpair.next(pair2);
                    lastpair = pair2;
                }
                last = pair2.last() + 1;
                last = Parse.skipWhitespace(string2, last);
                if (string2.regionMatches(last, funSep, 0, funSep.length())) {
                    last += funSep.length();
                }
                last = Parse.skipWhitespace(string2, last);
            }
            node2.children(firstpair);
            node2.last(last);
            return node2;
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a function starting at index " + index2 + " in the value " + string2 + "\n" + e2.getMessage());
        }
        catch (ParseException e3) {
            throw e3;
        }
    }

    private static Node parseSubset(String string2, int index2) throws ParseException {
        int first = index2;
        int last = index2;
        try {
            Node node2 = new Node(string2, first, 8);
            last += 6;
            last = Parse.skipWhitespace(string2, last);
            Node elt = Parse.parse(string2, last);
            node2.children(elt);
            node2.last(elt.last());
            return node2;
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a SUBSET starting at index " + index2 + " in the value " + string2 + "\n" + e2.getMessage());
        }
        catch (ParseException e3) {
            throw e3;
        }
    }

    private static Node parseFunctionPair(String string2, int index2) throws ParseException {
        int first = index2;
        int last = index2;
        try {
            Node node2 = new Node(string2, first, 7);
            Node domain = null;
            Node range2 = null;
            domain = Parse.parse(string2, last);
            last = domain.last() + 1;
            last = Parse.skipWhitespace(string2, last);
            if (!string2.regionMatches(last, funDiv, 0, funDiv.length())) {
                throw new ParseException("TLC Bug: while formating output, the formatter couldn't find token :> while parsing a function arg/value pair starting at index " + index2 + " in value " + string2);
            }
            last += funDiv.length();
            last = Parse.skipWhitespace(string2, last);
            range2 = Parse.parse(string2, last);
            domain.next(range2);
            node2.children(domain);
            node2.last(range2.last());
            return node2;
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a function pair starting at index " + index2 + " in the value " + string2 + "\n" + e2.getMessage());
        }
        catch (ParseException e3) {
            throw e3;
        }
    }

    private static Node parseConstant(String string2, int index2) throws ParseException {
        try {
            Node node2;
            int first;
            int last = first = Parse.skipWhitespace(string2, index2);
            if (string2.charAt(first) == '\"') {
                while (string2.charAt(++last) != '\"') {
                }
                return new Node(string2, first, last, 1);
            }
            if (Character.isDigit(string2.charAt(last)) && (node2 = Parse.parseInterval(string2, index2)) != null) {
                return node2;
            }
            if (string2.charAt(last) == '-') {
                ++last;
                while (Character.isDigit(string2.charAt(last)) && ++last != string2.length()) {
                }
                return new Node(string2, first, --last, 1);
            }
            if (Character.isLetterOrDigit(string2.charAt(last))) {
                while (Character.isLetterOrDigit(string2.charAt(last)) && ++last != string2.length()) {
                }
                return new Node(string2, first, --last, 1);
            }
            throw new ParseException("TLC Bug: while formating output, the formatter discovered an illegal character while parsing a constant starting at index " + first + " in the value " + string2);
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while parsing a constant starting at index " + index2 + " in the value " + string2 + "\n" + e2.getMessage());
        }
        catch (ParseException e3) {
            throw e3;
        }
    }

    private static Node parseInterval(String string2, int index2) {
        try {
            int first;
            int last;
            if (!Character.isDigit(string2.charAt(last))) {
                return null;
            }
            for (last = first = index2; last < string2.length() && Character.isDigit(string2.charAt(last)); ++last) {
            }
            if (!string2.startsWith(intDiv, last)) {
                return null;
            }
            ++last;
            if (!Character.isDigit(string2.charAt(++last))) {
                return null;
            }
            while (Character.isDigit(string2.charAt(last)) && ++last != string2.length()) {
            }
            return new Node(string2, first, --last, 1);
        }
        catch (StringIndexOutOfBoundsException e2) {
            return null;
        }
    }

    public static int skipWhitespace(String string2, int index2) throws ParseException {
        try {
            int i = index2;
            while (Character.isWhitespace(string2.charAt(i))) {
                ++i;
            }
            return i;
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new ParseException("TLC Bug: while formating output, the formatter ran off the end of the string while skipping whitespace starting at index " + index2 + " in the value " + string2 + "\n" + e2.getMessage());
        }
    }
}

