/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import model.InJarFilenameToStream;
import tlc2.TLC;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.EvalException;
import tlc2.tool.IStateFunctor;
import tlc2.tool.ModelChecker;
import tlc2.tool.TLCState;
import tlc2.tool.TLCTrace;
import tlc2.tool.distributed.DistApp;
import tlc2.tool.distributed.DistributedFPSetTLCServer;
import tlc2.tool.distributed.InternRMI;
import tlc2.tool.distributed.TLCApp;
import tlc2.tool.distributed.TLCServerRMI;
import tlc2.tool.distributed.TLCServerThread;
import tlc2.tool.distributed.TLCWorkerRMI;
import tlc2.tool.distributed.fp.FPSetRMI;
import tlc2.tool.distributed.fp.IFPSetManager;
import tlc2.tool.distributed.fp.NonDistributedFPSetManager;
import tlc2.tool.distributed.management.TLCServerMXWrapper;
import tlc2.tool.distributed.selector.BlockSelectorFactory;
import tlc2.tool.distributed.selector.IBlockSelector;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.FP64;
import util.Assert;
import util.FileUtil;
import util.MailSender;
import util.UniqueString;

public class TLCServer
extends UnicastRemoteObject
implements TLCServerRMI,
InternRMI {
    public static final String SERVER_NAME = "TLCServer";
    public static final String SERVER_WORKER_NAME = "TLCServerWORKER";
    public static final String THREAD_NAME_PREFIX = "TLCWorkerThread-";
    static long finalNumberOfDistinctStates = -1L;
    public static int Port = Integer.getInteger(TLCServer.class.getName() + ".port", 10997);
    private static final int REPORT_INTERVAL = Integer.getInteger(TLCServer.class.getName() + ".report", 60000);
    private static final boolean VETO_CLEANUP = Boolean.getBoolean(TLCServer.class.getName() + ".vetoCleanup");
    private static final int expectedFPSetCount = Integer.getInteger(TLCServer.class.getName() + ".expectedFPSetCount", 0);
    private long distinctStatesPerMinute;
    private long statesPerMinute;
    protected final AtomicLong workerStatesGenerated = new AtomicLong(0L);
    private final ExecutorService es = Executors.newCachedThreadPool();
    public final IFPSetManager fpSetManager;
    public final IStateQueue stateQueue;
    public final TLCTrace trace;
    private final DistApp work;
    private final String metadir;
    private final String filename;
    private TLCState errState = null;
    private boolean done = false;
    private boolean keepCallStack = false;
    private final Map<TLCServerThread, TLCWorkerRMI> threadsToWorkers = new ConcurrentHashMap<TLCServerThread, TLCWorkerRMI>();
    private final IBlockSelector blockSelector;

    public TLCServer(TLCApp work) throws IOException, NotBoundException {
        Assert.check(work != null, "TLC server found null work.");
        this.metadir = work.getMetadir();
        int end = this.metadir.length();
        if (this.metadir.endsWith(FileUtil.separator)) {
            --end;
        }
        int start2 = this.metadir.lastIndexOf(FileUtil.separator, end - 1);
        this.filename = this.metadir.substring(start2 + 1, end);
        this.work = work;
        this.stateQueue = new DiskStateQueue(this.metadir);
        this.trace = new TLCTrace(this.metadir, this.work.getFileName(), this.work);
        this.fpSetManager = this.getFPSetManagerImpl(work, this.metadir, expectedFPSetCount);
        this.blockSelector = BlockSelectorFactory.getBlockSelector(this);
    }

    protected IFPSetManager getFPSetManagerImpl(TLCApp work, String metadir, int fpsetCount) throws IOException {
        FPSet fpSet = FPSetFactory.getFPSet(work.getFPSetConfiguration());
        fpSet.init(1, metadir, work.getFileName());
        return new NonDistributedFPSetManager(fpSet, InetAddress.getLocalHost().getCanonicalHostName(), this.trace);
    }

    @Override
    public final Boolean getCheckDeadlock() {
        return this.work.getCheckDeadlock();
    }

    @Override
    public final Boolean getPreprocess() {
        return this.work.getPreprocess();
    }

    @Override
    public IFPSetManager getFPSetManager() {
        return this.fpSetManager;
    }

    @Override
    public final long getIrredPolyForFP() {
        return FP64.getIrredPoly();
    }

    @Override
    public final UniqueString intern(String str2) {
        return UniqueString.uniqueStringOf(str2);
    }

    @Override
    public final synchronized void registerWorker(TLCWorkerRMI worker) throws IOException {
        this.stateQueue.resumeAllStuck();
        TLCServerThread thread2 = new TLCServerThread(worker, worker.getURI(), this, this.es, this.blockSelector);
        this.threadsToWorkers.put(thread2, worker);
        thread2.start();
        MP.printMessage(7001, worker.getURI().toString());
    }

    @Override
    public synchronized void registerFPSet(FPSetRMI fpSet, String hostname) throws RemoteException {
        throw new UnsupportedOperationException("Not applicable for non-distributed TLCServer");
    }

    public TLCWorkerRMI removeTLCServerThread(TLCServerThread thread2) {
        TLCWorkerRMI worker = this.threadsToWorkers.remove(thread2);
        if (worker != null) {
            MP.printMessage(7002, thread2.getUri().toString());
        }
        return worker;
    }

    public final synchronized boolean setErrState(TLCState s, boolean keep2) {
        if (this.done) {
            return false;
        }
        this.done = true;
        this.errState = s;
        this.keepCallStack = keep2;
        return true;
    }

    public final void setDone() {
        this.done = true;
    }

    public void addStatesGeneratedDelta(long delta) {
        this.workerStatesGenerated.addAndGet(delta);
    }

    public void checkpoint() throws IOException, InterruptedException {
        if (this.stateQueue.suspendAll()) {
            MP.printMessage(2195, "-- Checkpointing of run " + this.metadir + " compl");
            this.stateQueue.beginChkpt();
            this.trace.beginChkpt();
            this.fpSetManager.checkpoint(this.filename);
            this.stateQueue.resumeAll();
            UniqueString.internTbl.beginChkpt(this.metadir);
            this.stateQueue.commitChkpt();
            this.trace.commitChkpt();
            UniqueString.internTbl.commitChkpt(this.metadir);
            this.fpSetManager.commitChkpt();
            MP.printMessage(2196, "eted.");
        }
    }

    public final void recover() throws IOException, InterruptedException {
        this.trace.recover();
        this.stateQueue.recover();
        this.fpSetManager.recover(this.filename);
    }

    private final void doInit() throws Throwable {
        DoInitFunctor functor = new DoInitFunctor();
        this.work.getInitStates(functor);
        if (functor.e != null) {
            throw functor.e;
        }
    }

    public final void close(boolean cleanup) throws IOException {
        this.trace.close();
        this.fpSetManager.close(cleanup);
        if (cleanup && !VETO_CLEANUP) {
            FileUtil.deleteDir(new File(this.metadir), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modelCheck() throws IOException, InterruptedException, NotBoundException {
        long startTime = System.currentTimeMillis();
        boolean recovered = false;
        if (this.work.canRecover()) {
            MP.printMessage(2197, this.metadir);
            this.recover();
            MP.printMessage(2198, String.valueOf(this.fpSetManager.size()), String.valueOf(this.stateQueue.size()));
            recovered = true;
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        Registry rg = LocateRegistry.createRegistry(Port);
        rg.rebind(SERVER_NAME, this);
        this.waitForFPSetManager();
        if (!recovered) {
            try {
                MP.printMessage(2189);
                this.doInit();
                MP.printMessage(2190, String.valueOf(this.stateQueue.size()), "(s)");
            }
            catch (Throwable e2) {
                this.done = true;
                if (e2 instanceof EvalException && ((EvalException)e2).getErrorCode() == 2145 && (((EvalException)e2).getMessage().contains("TLCSet") || ((EvalException)e2).getMessage().contains("TLCGet")) || e2 instanceof Assert.TLCRuntimeException && ((Assert.TLCRuntimeException)e2).errorCode == 2154) {
                    MP.printError(2156, "TLCSet & TLCGet operators not supported by distributed TLC.");
                }
                String msg = e2.getMessage();
                if (msg == null) {
                    msg = e2.toString();
                }
                if (!this.hasNoErrors()) {
                    MP.printError(2102, new String[]{msg, this.errState.toString()});
                } else {
                    MP.printError(1000, msg);
                }
                this.work.setCallStack();
                try {
                    this.doInit();
                }
                catch (Throwable e1) {
                    MP.printError(2103, this.work.printCallStack());
                }
            }
        }
        if (this.done) {
            TLCServer.printSummary(1, 0L, this.stateQueue.size(), this.fpSetManager.size(), false);
            MP.printMessage(2186, TLC.convertRuntimeToHumanReadable(System.currentTimeMillis() - startTime));
            this.es.shutdown();
            this.close(false);
            return;
        }
        rg.rebind(SERVER_WORKER_NAME, this);
        MP.printMessage(7000, hostname);
        long oldNumOfGenStates = 0L;
        long oldFPSetSize = 0L;
        Object object = this;
        synchronized (object) {
            this.wait(REPORT_INTERVAL);
        }
        while (true) {
            if (TLCGlobals.doCheckPoint()) {
                this.checkpoint();
            }
            object = this;
            synchronized (object) {
                if (!this.done) {
                    long l = this.getStatesGenerated();
                    long fpSetSize = this.fpSetManager.size();
                    double factor = (double)REPORT_INTERVAL / 60000.0;
                    this.statesPerMinute = (long)((double)(l - oldNumOfGenStates) / factor);
                    this.distinctStatesPerMinute = (long)((double)(fpSetSize - oldFPSetSize) / factor);
                    MP.printMessage(2200, String.valueOf(this.trace.getLevelForReporting()), MP.format(l), MP.format(fpSetSize), MP.format(this.getNewStates()), MP.format(this.statesPerMinute), MP.format(this.distinctStatesPerMinute));
                    this.wait(REPORT_INTERVAL);
                    oldFPSetSize = fpSetSize;
                    oldNumOfGenStates = l;
                }
                if (this.done) {
                    break;
                }
            }
        }
        Assert.check(!this.hasNoErrors() || this.stateQueue.isEmpty(), 1000);
        for (Map.Entry entry : this.threadsToWorkers.entrySet()) {
            TLCServerThread thread2 = (TLCServerThread)entry.getKey();
            TLCWorkerRMI worker = (TLCWorkerRMI)entry.getValue();
            thread2.join();
            int sentStates = thread2.getSentStates();
            int receivedStates = thread2.getReceivedStates();
            double cacheHitRatio = thread2.getCacheRateRatio();
            URI name2 = thread2.getUri();
            MP.printMessage(7003, name2.toString(), Integer.toString(sentStates), Integer.toString(receivedStates), cacheHitRatio < 0.0 ? "n/a" : String.format("%1$,.2f", cacheHitRatio));
            try {
                worker.exit();
            }
            catch (NoSuchObjectException e3) {
                MP.printWarning(1000, "Ignoring attempt to exit dead worker");
            }
            catch (ConnectException e4) {
                MP.printWarning(1000, "Ignoring attempt to exit dead worker");
            }
            catch (ServerException e5) {
                MP.printWarning(1000, "Ignoring attempt to exit dead worker");
            }
            finally {
                this.threadsToWorkers.remove(thread2);
            }
        }
        this.es.shutdown();
        finalNumberOfDistinctStates = this.fpSetManager.size();
        long statesGenerated = this.getStatesGenerated();
        long statesLeftInQueue = this.getNewStates();
        int level = this.trace.getLevelForReporting();
        this.statesPerMinute = 0L;
        this.distinctStatesPerMinute = 0L;
        if (this.hasNoErrors()) {
            long actualDistance = this.fpSetManager.checkFPs();
            long statesSeen = this.fpSetManager.getStatesSeen();
            ModelChecker.reportSuccess(finalNumberOfDistinctStates, actualDistance, statesSeen);
        } else if (this.keepCallStack) {
            this.work.setCallStack();
        }
        TLCServer.printSummary(level, statesGenerated, statesLeftInQueue, finalNumberOfDistinctStates, this.hasNoErrors());
        MP.printMessage(2186, TLC.convertRuntimeToHumanReadable(System.currentTimeMillis() - startTime));
        MP.flush();
        this.close(this.hasNoErrors());
        rg.unbind(SERVER_WORKER_NAME);
        rg.unbind(SERVER_NAME);
        UnicastRemoteObject.unexportObject(this, false);
    }

    protected void waitForFPSetManager() throws InterruptedException {
    }

    public long getStatesGeneratedPerMinute() {
        return this.statesPerMinute;
    }

    public long getDistinctStatesGeneratedPerMinute() {
        return this.distinctStatesPerMinute;
    }

    public long getAverageBlockCnt() {
        return this.blockSelector.getAverageBlockCnt();
    }

    private boolean hasNoErrors() {
        return this.errState == null;
    }

    public synchronized long getNewStates() {
        long res2 = this.stateQueue.size();
        for (TLCServerThread thread2 : this.threadsToWorkers.keySet()) {
            res2 += (long)thread2.getCurrentSize();
        }
        return res2;
    }

    public long getStatesGenerated() {
        return this.workerStatesGenerated.get() + this.fpSetManager.getStatesSeen();
    }

    public static final void printSummary(int level, long statesGenerated, long statesLeftInQueue, long distinctStates, boolean success) throws IOException {
        if (TLCGlobals.tool) {
            MP.printMessage(2200, String.valueOf(level), MP.format(statesGenerated), MP.format(distinctStates), MP.format(statesLeftInQueue), "0", "0");
        }
        MP.printMessage(2199, String.valueOf(statesGenerated), String.valueOf(distinctStates), String.valueOf(statesLeftInQueue));
        if (success) {
            MP.printMessage(2194, String.valueOf(level));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        MP.printMessage(2262, "TLC Server " + TLCGlobals.versionOfTLC);
        TLCStandardMBean tlcServerMXWrapper = TLCStandardMBean.getNullTLCStandardMBean();
        MailSender mail = null;
        TLCServer server2 = null;
        TLCApp app = null;
        try {
            TLCGlobals.setNumWorkers(0);
            mail = new MailSender();
            app = TLCApp.create(argv);
            mail.setModelName(System.getProperty("modelName", app.getFileName()));
            mail.setSpecName(System.getProperty("specName", app.getFileName()));
            server2 = expectedFPSetCount > 0 ? new DistributedFPSetTLCServer(app, expectedFPSetCount) : new TLCServer(app);
            tlcServerMXWrapper = new TLCServerMXWrapper(server2);
            if (server2 != null) {
                Runtime.getRuntime().addShutdownHook(new Thread(new WorkerShutdownHook(server2)));
                server2.modelCheck();
            }
        }
        catch (Throwable e2) {
            System.gc();
            if (e2 instanceof StackOverflowError) {
                MP.printError(1005, e2);
            } else if (e2 instanceof OutOfMemoryError) {
                MP.printError(1001, e2);
            } else {
                MP.printError(1000, e2);
            }
            if (server2 != null) {
                try {
                    server2.close(false);
                }
                catch (Exception e1) {
                    MP.printError(1000, e1);
                }
            }
        }
        finally {
            if (!server2.es.isShutdown()) {
                server2.es.shutdownNow();
            }
            tlcServerMXWrapper.unregister();
            if (mail != null) {
                boolean send2;
                List<File> files = new ArrayList<File>();
                if (app != null) {
                    files = app.getModuleFiles();
                }
                if (!(send2 = mail.send(files))) {
                    MP.printMessage(1000, "Sending result mail failed.");
                    System.exit(1);
                }
            }
        }
    }

    public int getWorkerCount() {
        return this.threadsToWorkers.size();
    }

    synchronized TLCServerThread[] getThreads() {
        return this.threadsToWorkers.keySet().toArray(new TLCServerThread[this.threadsToWorkers.size()]);
    }

    public boolean isRunning() {
        return !this.done;
    }

    @Override
    public boolean isDone() throws RemoteException {
        return this.done;
    }

    @Override
    public String getSpecFileName() throws RemoteException {
        return this.work.getFileName();
    }

    @Override
    public String getConfigFileName() throws RemoteException {
        return this.work.getConfigName();
    }

    @Override
    public byte[] getFile(String file2) throws RemoteException {
        String name2 = new File(file2).getName();
        File f = new InJarFilenameToStream("/model/").resolve(name2);
        return this.read(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] read(File file2) {
        byte[] buffer;
        block19: {
            FileInputStream in;
            RuntimeException pending;
            block16: {
                if (file2.isDirectory()) {
                    throw new RuntimeException("Unsupported operation, file " + file2.getAbsolutePath() + " is a directory");
                }
                if (file2.length() > Integer.MAX_VALUE) {
                    throw new RuntimeException("Unsupported operation, file " + file2.getAbsolutePath() + " is too big");
                }
                pending = null;
                in = null;
                buffer = new byte[(int)file2.length()];
                in = new FileInputStream(file2);
                in.read(buffer);
                if (in == null) break block16;
                try {
                    in.close();
                }
                catch (Exception e2) {
                    if (pending != null) break block16;
                    pending = new RuntimeException("Exception occured on closing file" + file2.getAbsolutePath(), e2);
                }
            }
            if (pending != null) {
                throw new RuntimeException(pending);
            }
            break block19;
            catch (Exception e3) {
                block17: {
                    try {
                        pending = new RuntimeException("Exception occured on reading file " + file2.getAbsolutePath(), e3);
                        if (in == null) break block17;
                    }
                    catch (Throwable throwable) {
                        block18: {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception e4) {
                                    if (pending != null) break block18;
                                    pending = new RuntimeException("Exception occured on closing file" + file2.getAbsolutePath(), e4);
                                }
                            }
                        }
                        if (pending != null) {
                            throw new RuntimeException(pending);
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception e5) {
                        if (pending != null) break block17;
                        pending = new RuntimeException("Exception occured on closing file" + file2.getAbsolutePath(), e5);
                    }
                }
                if (pending != null) {
                    throw new RuntimeException(pending);
                }
            }
        }
        return buffer;
    }

    private static class WorkerShutdownHook
    implements Runnable {
        private final TLCServer server;

        public WorkerShutdownHook(TLCServer aServer) {
            this.server = aServer;
        }

        @Override
        public void run() {
            if (this.server.threadsToWorkers.isEmpty()) {
                return;
            }
            try {
                LocateRegistry.getRegistry(Port).lookup(TLCServer.SERVER_NAME);
            }
            catch (AccessException e1) {
                return;
            }
            catch (RemoteException e1) {
                return;
            }
            catch (NotBoundException e1) {
                return;
            }
            for (TLCWorkerRMI worker : this.server.threadsToWorkers.values()) {
                try {
                    worker.exit();
                }
                catch (ConnectException connectException) {
                }
                catch (NoSuchObjectException noSuchObjectException) {
                }
                catch (IOException e2) {
                    MP.printError(1000, e2);
                }
            }
        }
    }

    private class DoInitFunctor
    implements IStateFunctor {
        private Throwable e;

        private DoInitFunctor() {
        }

        @Override
        public Object addElement(TLCState curState) {
            block5: {
                if (this.e != null) {
                    return curState;
                }
                try {
                    long fp;
                    boolean inConstraints = TLCServer.this.work.isInModel(curState);
                    boolean seen = false;
                    if (inConstraints && !(seen = TLCServer.this.fpSetManager.put(fp = curState.fingerPrint()))) {
                        curState.uid = TLCServer.this.trace.writeState(fp);
                        TLCServer.this.stateQueue.enqueue(curState);
                    }
                    if (!inConstraints || !seen) {
                        TLCServer.this.work.checkState(null, curState);
                    }
                }
                catch (Exception e2) {
                    if (!TLCServer.this.setErrState(curState, true)) break block5;
                    this.e = e2;
                }
            }
            return curState;
        }
    }
}

