/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp.dfid;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RemoteException;
import tlc2.output.MP;
import tlc2.tool.fp.dfid.FPIntSet;
import util.Assert;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FileUtil;
import util.WrongInvocationException;

public class MemFPIntSet
extends FPIntSet {
    private String metadir;
    private String filename;
    private static final int MaxLoad = 20;
    private static final int LogInitialCapacity = 16;
    private int[][] table;
    private long count;
    private long threshold;
    private int mask;

    public MemFPIntSet() throws RemoteException {
        this(16, 20);
    }

    public MemFPIntSet(int logInitialCapacity, int maxLoad) throws RemoteException {
        int initialCapacity = 1 << logInitialCapacity;
        this.count = 0L;
        this.threshold = initialCapacity * maxLoad;
        this.table = new int[initialCapacity][];
        this.mask = initialCapacity - 1;
    }

    @Override
    public final void init(int numThreads, String metadir, String filename) {
        this.metadir = metadir;
        this.filename = filename;
    }

    @Override
    public final synchronized long size() {
        return this.count;
    }

    public final synchronized long sizeof() {
        long size = 28L;
        size += (long)(16 + this.table.length * 8);
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i] == null) continue;
            size += (long)(16 + this.table[i].length * 4);
        }
        return size;
    }

    @Override
    public final synchronized void setLeveled(long fp) {
        int index2 = (int)(fp & (long)this.mask);
        int[] list = this.table[index2];
        if (list != null) {
            int listlen = list.length;
            for (int i = 0; i < listlen; i += 3) {
                long fp1 = (long)list[i] << 32 | (long)list[i + 1] & 0xFFFFFFFFL;
                if (fp1 != fp) continue;
                list[i + 2] = list[i + 2] & 0xFFFFFFFD | Leveled;
                return;
            }
        }
        throw new WrongInvocationException("MemFPIntSet.setLeveled: The fp must have been in the set.");
    }

    @Override
    public final synchronized int setStatus(long fp, int status) {
        int index2 = (int)(fp & (long)this.mask);
        int[] list = this.table[index2];
        if (list != null) {
            int listlen = list.length;
            for (int i = 0; i < listlen; i += 3) {
                long fp1 = (long)list[i] << 32 | (long)list[i + 1] & 0xFFFFFFFFL;
                if (fp != fp1) continue;
                int status1 = list[i + 2];
                list[i + 2] = status1 | status;
                return status1;
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            index2 = (int)(fp & (long)this.mask);
            list = this.table[index2];
        }
        int len = list == null ? 0 : list.length;
        int[] newList = new int[len + 3];
        if (list != null) {
            System.arraycopy(list, 0, newList, 0, len);
        }
        newList[len] = (int)(fp >>> 32);
        newList[len + 1] = (int)fp;
        newList[len + 2] = Level << 2 | Leveled | status;
        this.table[index2] = newList;
        ++this.count;
        return 0;
    }

    @Override
    public final synchronized int getStatus(long fp) {
        int index2 = (int)(fp & (long)this.mask);
        int[] list = this.table[index2];
        if (list != null) {
            int listlen = list.length;
            for (int i = 0; i < listlen; i += 3) {
                long fp1 = (long)list[i] << 32 | (long)list[i + 1] & 0xFFFFFFFFL;
                if (fp1 != fp) continue;
                return list[i + 2];
            }
        }
        return 0;
    }

    @Override
    public final boolean allLeveled() {
        for (int i = 0; i < this.table.length; ++i) {
            int[] bucket = this.table[i];
            if (bucket == null) continue;
            for (int j = 0; j < bucket.length; j += 3) {
                if ((bucket[j + 2] & 2) == Leveled) continue;
                return false;
            }
        }
        return true;
    }

    private final void rehash() {
        long min2 = this.count;
        long max2 = 0L;
        int[][] oldTable = this.table;
        int oldCapacity = oldTable.length;
        int[][] newTable = new int[oldCapacity * 2][];
        int onebitmask = oldCapacity;
        for (int i = 0; i < oldCapacity; ++i) {
            int[] list = oldTable[i];
            if (list == null) continue;
            int cnt0 = 0;
            int cnt1 = 0;
            int listlen = list.length;
            if ((long)listlen < min2) {
                min2 = listlen;
            }
            if ((long)listlen > max2) {
                max2 = listlen;
            }
            for (int j = 0; j < listlen; j += 3) {
                if ((list[j + 1] & onebitmask) == 0) {
                    cnt0 += 3;
                    continue;
                }
                cnt1 += 3;
            }
            if (cnt0 == 0) {
                newTable[i + oldCapacity] = list;
                continue;
            }
            if (cnt1 == 0) {
                newTable[i] = list;
                continue;
            }
            int[] list0 = new int[cnt0];
            int[] list1 = new int[cnt1];
            for (int j = 0; j < listlen; j += 3) {
                if ((list[j + 1] & onebitmask) == 0) {
                    list0[cnt0 - 3] = list[j];
                    list0[cnt0 - 2] = list[j + 1];
                    list0[cnt0 - 1] = list[j + 2];
                    cnt0 -= 3;
                    continue;
                }
                list1[cnt1 - 3] = list[j];
                list1[cnt1 - 2] = list[j + 1];
                list1[cnt1 - 1] = list[j + 2];
                cnt1 -= 3;
            }
            newTable[i] = list0;
            newTable[i + oldCapacity] = list1;
        }
        this.threshold *= 2L;
        this.table = newTable;
        this.mask = newTable.length - 1;
    }

    @Override
    public final void exit(boolean cleanup) throws IOException {
        if (cleanup) {
            File file2 = new File(this.metadir);
            FileUtil.deleteDir(file2, true);
        }
        String hostname = InetAddress.getLocalHost().getHostName();
        MP.printMessage(2211, hostname);
        System.exit(0);
    }

    @Override
    public final long checkFPs() {
        long dis = Long.MAX_VALUE;
        for (int i = 0; i < this.table.length; ++i) {
            int[] bucket = this.table[i];
            if (bucket == null) continue;
            for (int j = 0; j < bucket.length; j += 3) {
                int k;
                for (k = j + 3; k < bucket.length; k += 3) {
                    long x = (long)bucket[j] << 32 | (long)bucket[j + 1];
                    long y = (long)bucket[k] << 32 | (long)bucket[k + 1];
                    dis = Math.min(dis, Math.abs(x - y));
                }
                for (k = i + 1; k < this.table.length; ++k) {
                    int[] bucket1 = this.table[k];
                    if (bucket1 == null) continue;
                    for (int m = 0; m < bucket1.length; m += 3) {
                        long dis1;
                        long x = (long)bucket[j] << 32 | (long)bucket[j + 1];
                        long y = (long)bucket1[m] << 32 | (long)bucket1[m + 1];
                        long l = dis1 = x > y ? x - y : y - x;
                        if (dis1 < 0L) continue;
                        dis = Math.min(dis, dis1);
                    }
                }
            }
        }
        return dis;
    }

    @Override
    public final void beginChkpt(String fname) throws IOException {
        BufferedDataOutputStream dos = new BufferedDataOutputStream(this.chkptName(fname, "tmp"));
        for (int i = 0; i < this.table.length; ++i) {
            int[] bucket = this.table[i];
            if (bucket == null) continue;
            for (int j = 0; j < bucket.length; ++j) {
                dos.writeInt(bucket[j]);
            }
        }
        dos.close();
    }

    @Override
    public final void beginChkpt() throws IOException {
        this.beginChkpt(this.filename);
    }

    @Override
    public final void commitChkpt(String fname) throws IOException {
        File oldChkpt = new File(this.chkptName(fname, "chkpt"));
        File newChkpt = new File(this.chkptName(fname, "tmp"));
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("MemFPIntSet.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    @Override
    public final void commitChkpt() throws IOException {
        this.commitChkpt(this.filename);
    }

    @Override
    public final void recover(String fname) throws IOException {
        BufferedDataInputStream dis = new BufferedDataInputStream(this.chkptName(fname, "chkpt"));
        try {
            while (!dis.atEOF()) {
                int index2;
                int[] list;
                int fhi = dis.readInt();
                int flo = dis.readInt();
                int level = dis.readInt();
                if (this.count >= this.threshold) {
                    this.rehash();
                }
                int len = (list = this.table[index2 = flo & this.mask]) == null ? 0 : list.length;
                int[] newList = new int[len + 3];
                if (list != null) {
                    System.arraycopy(list, 0, newList, 0, len);
                }
                newList[len] = fhi;
                newList[len + 1] = flo;
                newList[len + 2] = level;
                this.table[index2] = newList;
                ++this.count;
            }
        }
        catch (EOFException e2) {
            Assert.fail(2161, "checkpoints");
        }
        dis.close();
    }

    @Override
    public final void recover() throws IOException {
        this.recover(this.filename);
    }

    private final String chkptName(String fname, String ext) {
        return this.metadir + FileUtil.separator + fname + ".fp." + ext;
    }
}

