/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;
import tlc2.TLCGlobals;
import tlc2.value.IValueOutputStream;
import util.BufferedDataOutputStream;

public final class ValueOutputStream
implements IValueOutputStream {
    private final BufferedDataOutputStream dos;
    private final HandleTable handles;

    public ValueOutputStream(File file2) throws IOException {
        this(file2, TLCGlobals.useGZIP);
    }

    public ValueOutputStream(File file2, boolean compress) throws IOException {
        this(new FileOutputStream(file2), compress);
    }

    public ValueOutputStream(OutputStream out, boolean compress) throws IOException {
        if (compress) {
            GZIPOutputStream os = new GZIPOutputStream(out);
            this.dos = new BufferedDataOutputStream(os);
        } else {
            this.dos = new BufferedDataOutputStream(out);
        }
        this.handles = new HandleTable();
    }

    public ValueOutputStream(String fname) throws IOException {
        this(fname, TLCGlobals.useGZIP);
    }

    public ValueOutputStream(String fname, boolean zip2) throws IOException {
        if (zip2) {
            GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(fname));
            this.dos = new BufferedDataOutputStream(os);
        } else {
            this.dos = new BufferedDataOutputStream(fname);
        }
        this.handles = new HandleTable();
    }

    @Override
    public final void writeShort(short x) throws IOException {
        this.dos.writeShort(x);
    }

    @Override
    public final void writeInt(int x) throws IOException {
        this.dos.writeInt(x);
    }

    @Override
    public final void writeLong(long x) throws IOException {
        this.dos.writeLong(x);
    }

    @Override
    public final void close() throws IOException {
        this.dos.close();
    }

    @Override
    public final void writeShortNat(short x) throws IOException {
        if (x > 127) {
            this.dos.writeShort(-x);
        } else {
            this.dos.writeByte((byte)x);
        }
    }

    @Override
    public final void writeNat(int x) throws IOException {
        if (x > Short.MAX_VALUE) {
            this.dos.writeInt(-x);
        } else {
            this.dos.writeShort((short)x);
        }
    }

    @Override
    public final void writeLongNat(long x) throws IOException {
        if (x <= Integer.MAX_VALUE) {
            this.dos.writeInt((int)x);
        } else {
            this.dos.writeLong(-x);
        }
    }

    @Override
    public final void writeByte(byte b) throws IOException {
        this.dos.writeByte(b);
    }

    @Override
    public final void writeBoolean(boolean b) throws IOException {
        this.dos.writeBoolean(b);
    }

    @Override
    public final BufferedDataOutputStream getOutputStream() {
        return this.dos;
    }

    @Override
    public final int put(Object obj) {
        return this.handles.put(obj);
    }

    private static class HandleTable {
        private int[] spine = new int[17];
        private int[] next;
        private Object[] values;
        private int size;
        private int threshold;

        HandleTable() {
            Arrays.fill(this.spine, -1);
            this.next = new int[16];
            this.values = new Object[16];
            this.size = 0;
            this.threshold = (int)((double)this.spine.length * 0.75);
        }

        final int put(Object val2) {
            int index2 = (System.identityHashCode(val2) & Integer.MAX_VALUE) % this.spine.length;
            int i = this.spine[index2];
            while (i >= 0) {
                if (this.values[i] == val2) {
                    return i;
                }
                i = this.next[i];
            }
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
                index2 = (System.identityHashCode(val2) & Integer.MAX_VALUE) % this.spine.length;
            }
            this.values[this.size] = val2;
            this.next[this.size] = this.spine[index2];
            this.spine[index2] = this.size++;
            return -1;
        }

        private final void growEntries() {
            int newLength = this.next.length * 2;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newValues = new Object[newLength];
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.values = newValues;
        }

        private final void growSpine() {
            int len = this.spine.length * 2 + 1;
            this.spine = new int[len];
            this.threshold = (int)((double)len * 0.75);
            Arrays.fill(this.spine, -1);
            int i = 0;
            while (i < this.size) {
                int index2 = (System.identityHashCode(this.values[i]) & Integer.MAX_VALUE) % len;
                this.next[i] = this.spine[index2];
                this.spine[index2] = i++;
            }
        }
    }
}

