/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.primes.Primes;
import tlc2.tool.FingerprintException;
import tlc2.util.RandomGenerator;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;

public abstract class EnumerableValue
extends Value
implements Enumerable {
    private static Map<Integer, int[]> MULTIPLIERS = new ConcurrentHashMap<Integer, int[]>();

    @Override
    public Value isSubsetEq(Value other) {
        try {
            Value elem;
            ValueEnumeration Enum2 = this.elements();
            while ((elem = Enum2.nextElement()) != null) {
                if (other.member(elem)) continue;
                return BoolValue.ValFalse;
            }
            return BoolValue.ValTrue;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public EnumerableValue getRandomSubset(int kOutOfN) {
        return ((SetEnumValue)this.toSetEnum()).getRandomSubset(kOutOfN);
    }

    @Override
    public ValueEnumeration elements(Enumerable.Ordering ordering) {
        if (ordering == Enumerable.Ordering.NORMALIZED) {
            Value enumerated = this.toSetEnum();
            if (enumerated != null) {
                return ((Enumerable)((Object)enumerated.normalize())).elements();
            }
        } else if (ordering == Enumerable.Ordering.RANDOMIZED) {
            return this.elements(this.size());
        }
        return this.elements();
    }

    @Override
    public ValueEnumeration elements(int k) {
        final List<Value> values = this.elements().all();
        return new SubsetEnumerator(k){

            @Override
            public Value nextElement() {
                if (!this.hasNext()) {
                    return null;
                }
                return (Value)values.get(this.nextIndex());
            }
        };
    }

    static int[] computeOptimalMandA(int n) {
        if (n < 9) {
            n = 9;
        }
        List<Integer> primeFactors = Primes.primeFactors(n);
        while (n % 4 == 0 || new HashSet<Integer>(primeFactors).size() == primeFactors.size()) {
            primeFactors = Primes.primeFactors(++n);
        }
        int a = 1;
        for (Integer prime : new HashSet<Integer>(primeFactors)) {
            a *= prime.intValue();
        }
        return new int[]{n, ++a};
    }

    abstract class SubsetEnumerator
    implements ValueEnumeration {
        protected final int n;
        protected final int k;
        protected int i;
        private int index;
        protected long a;
        private int m;
        private int c;

        public SubsetEnumerator(int k) {
            this(k, this$0.size());
        }

        public SubsetEnumerator(int k, int n) {
            if (n <= 0) {
                this.n = 0;
                this.k = 0;
                return;
            }
            this.n = n;
            this.k = k;
            int[] vals2 = MULTIPLIERS.computeIfAbsent(n, j -> EnumerableValue.computeOptimalMandA(j));
            this.m = vals2[0];
            this.a = vals2[1];
            Random random = RandomEnumerableValues.get();
            this.index = random.nextInt(n);
            this.c = RandomGenerator.nextPrime(random);
        }

        @Override
        public void reset() {
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i < this.k;
        }

        public int nextIndex() {
            if (this.n <= 0) {
                ++this.i;
                return 0;
            }
            do {
                this.index = (int)((this.a * (long)this.index + (long)this.c) % (long)this.m);
            } while (this.index >= this.n);
            ++this.i;
            assert (0 <= this.index && this.index < this.n);
            return this.index;
        }

        @Override
        public abstract Value nextElement();
    }
}

