/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import java.util.Random;
import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.RandomEnumerableValues;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.Reducible;
import tlc2.value.impl.SetCupValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.TLCVariable;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class IntervalValue
extends EnumerableValue
implements Enumerable,
Reducible {
    public int low;
    public int high;

    public IntervalValue(int low, int high) {
        this.low = low;
        this.high = high;
    }

    @Override
    public final byte getKind() {
        return 23;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof IntervalValue) {
                IntervalValue intv = (IntervalValue)obj;
                int cmp = this.size() - intv.size();
                if (cmp != 0) {
                    return cmp;
                }
                if (this.size() == 0) {
                    return 0;
                }
                return Integer.compare(this.low, intv.low);
            }
            return this.toSetEnum().compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof IntervalValue) {
                IntervalValue intv = (IntervalValue)obj;
                if (this.size() == 0) {
                    return intv.size() == 0;
                }
                return this.low == intv.low && this.high == intv.high;
            }
            return this.toSetEnum().equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            if (elem instanceof IntValue) {
                int x = ((IntValue)elem).val;
                return x >= this.low && x <= this.high;
            }
            if (!(this.low > this.high || elem instanceof ModelValue && ((ModelValue)elem).type == '\u0000')) {
                Assert.fail("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis in the integer interval " + Values.ppr(this.toString()), this.getSource());
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public Value isSubsetEq(Value other) {
        try {
            if (other instanceof IntervalValue) {
                IntervalValue iv = (IntervalValue)other;
                if (iv.low <= this.low && iv.high >= this.high) {
                    return BoolValue.ValTrue;
                }
            }
            return super.isSubsetEq(other);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final int size() {
        try {
            if (this.high < this.low) {
                return 0;
            }
            try {
                return Math.addExact(Math.subtractExact(this.high, this.low), 1);
            }
            catch (ArithmeticException e2) {
                Assert.fail("Size of interval value exceeds the maximum representable size (32bits): " + Values.ppr(this.toString()) + ".", this.getSource());
                return 0;
            }
        }
        catch (OutOfMemoryError | RuntimeException e3) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e3);
            }
            throw e3;
        }
    }

    final Value[] asValues() {
        Value[] values = new Value[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            values[i] = IntValue.gen(this.low + i);
        }
        return values;
    }

    @Override
    public final Value diff(Value val2) {
        try {
            ValueVec diffElems = new ValueVec();
            for (int i = this.low; i <= this.high; ++i) {
                IntValue elem = IntValue.gen(i);
                if (val2.member(elem)) continue;
                diffElems.addElement(elem);
            }
            return new SetEnumValue(diffElems, true, this.cm);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value cap(Value val2) {
        try {
            ValueVec capElems = new ValueVec();
            for (int i = this.low; i <= this.high; ++i) {
                IntValue elem = IntValue.gen(i);
                if (!val2.member(elem)) continue;
                capElems.addElement(elem);
            }
            return new SetEnumValue(capElems, true, this.cm);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value cup(Value set2) {
        try {
            if (this.size() == 0) {
                return set2;
            }
            if (set2 instanceof Reducible) {
                Value elem;
                ValueVec cupElems = new ValueVec();
                for (int i = this.low; i <= this.high; ++i) {
                    cupElems.addElement(IntValue.gen(i));
                }
                ValueEnumeration Enum2 = ((Enumerable)((Object)set2)).elements();
                while ((elem = Enum2.nextElement()) != null) {
                    if (this.member(elem)) continue;
                    cupElems.addElement(elem);
                }
                return new SetEnumValue(cupElems, false, this.cm);
            }
            return new SetCupValue(this, set2, this.cm);
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the interval value " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the interval value " + Values.ppr(this.toString()) + ".", this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final Value normalize() {
        return this;
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val2) {
        try {
            return val2 instanceof IntervalValue && this.high == ((IntervalValue)val2).high && this.low == ((IntervalValue)val2).low;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public void write(IValueOutputStream vos) throws IOException {
        vos.writeByte((byte)23);
        vos.writeInt(this.low);
        vos.writeInt(this.high);
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            fp = FP64.Extend(fp, (byte)5);
            fp = FP64.Extend(fp, this.size());
            for (int i = this.low; i <= this.high; ++i) {
                fp = FP64.Extend(fp, (byte)1);
                fp = FP64.Extend(fp, i);
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public boolean mutates() {
        return false;
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        return this;
    }

    @Override
    public Value toSetEnum() {
        Value[] vals2 = new Value[this.size()];
        for (int i = 0; i < vals2.length; ++i) {
            vals2[i] = IntValue.gen(i + this.low);
        }
        if (coverage) {
            this.cm.incSecondary(vals2.length);
        }
        return new SetEnumValue(vals2, true, this.cm);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean ignored) {
        try {
            if (this.low <= this.high) {
                return sb.append(this.low).append("..").append(this.high);
            }
            return sb.append("{").append("}");
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public EnumerableValue getRandomSubset(int kOutOfN) {
        ValueVec vec2 = new ValueVec(kOutOfN);
        ValueEnumeration ve = this.elements(kOutOfN);
        Value v = null;
        while ((v = ve.nextElement()) != null) {
            vec2.addElement(v);
        }
        return new SetEnumValue(vec2, false, this.cm);
    }

    public Value elementAt(int idx) {
        if (0 <= idx && idx < this.size()) {
            return IntValue.gen(this.low + idx);
        }
        Assert.fail("Attempted to retrieve out-of-bounds element from the interval value " + Values.ppr(this.toString()) + ".", this.getSource());
        return null;
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            return new Enumerator();
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public ValueEnumeration elements(int kOutOfN) {
        return new EnumerableValue.SubsetEnumerator(kOutOfN){

            @Override
            public Value nextElement() {
                if (!this.hasNext()) {
                    return null;
                }
                return IntValue.gen(IntervalValue.this.low + this.nextIndex());
            }
        };
    }

    public Value randomElement() {
        int sz = this.size();
        int index2 = (int)Math.floor(RandomEnumerableValues.get().nextDouble() * (double)sz);
        return this.elementAt(index2);
    }

    @Override
    public TLCVariable toTLCVariable(TLCVariable variable, Random rnd) {
        return this.toSetEnum().toTLCVariable(variable, rnd);
    }

    final class Enumerator
    implements ValueEnumeration {
        int index;

        Enumerator() {
            this.index = IntervalValue.this.low;
        }

        @Override
        public final void reset() {
            this.index = IntervalValue.this.low;
        }

        @Override
        public final Value nextElement() {
            if (this.index <= IntervalValue.this.high) {
                if (Value.coverage) {
                    IntervalValue.this.cm.incSecondary();
                }
                return IntValue.gen(this.index++);
            }
            return null;
        }
    }
}

