/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import tlc2.output.MP;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.impl.Tool;
import tlc2.value.IValue;
import tlc2.value.Values;
import tlc2.value.impl.Applicable;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.WrongInvocationException;

public class MethodValue
extends OpValue
implements Applicable {
    private final MethodHandle mh;
    private final Method md;
    private final int minLevel;

    public static Value get(Method md) {
        return MethodValue.get(md, 0);
    }

    public static Value get(Method md, int minLevel) {
        MethodValue mv = new MethodValue(md, minLevel);
        int acnt = md.getParameterTypes().length;
        boolean isConstant = acnt == 0 && Modifier.isFinal(md.getModifiers());
        return isConstant ? mv.apply(Tool.EmptyArgs, 0) : mv;
    }

    private MethodValue(Method md, int minLevel) {
        this.md = md;
        this.minLevel = minLevel;
        try {
            int parameterCount = this.md.getParameterCount();
            this.mh = parameterCount > 0 ? MethodHandles.publicLookup().unreflect(md).asSpreader(IValue[].class, parameterCount) : MethodHandles.publicLookup().unreflect(md);
        }
        catch (IllegalAccessException e2) {
            throw new Assert.TLCRuntimeException(2154, MP.getMessage(2154, new String[]{md.toString(), e2.getMessage()}));
        }
    }

    @Override
    public final byte getKind() {
        return 12;
    }

    @Override
    public final IValue initialize() {
        this.deepNormalize();
        return this;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            Assert.fail("Attempted to compare operator " + this.toString() + " with value:\n" + obj == null ? "null" : Values.ppr(obj.toString()), this.getSource());
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public final boolean equals(Object obj) {
        try {
            Assert.fail("Attempted to check equality of operator " + this.toString() + " with value:\n" + obj == null ? "null" : Values.ppr(obj.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + elem == null ? "null" : Values.ppr(elem.toString()) + "\nis an element of operator " + this.toString(), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the operator " + this.toString() + " is a finite set.", this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value apply(Value arg, int control) {
        try {
            throw new WrongInvocationException("It is a TLC bug: Should use the other apply method.");
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value apply(Value[] args, int control) {
        try {
            Value res2 = null;
            try {
                res2 = args.length == 0 ? this.mh.invokeExact() : this.mh.invoke(args);
            }
            catch (Throwable e2) {
                if (e2 instanceof InvocationTargetException) {
                    Throwable targetException = ((InvocationTargetException)e2).getTargetException();
                    throw new EvalException(2154, new String[]{this.md.toString(), targetException.getMessage()});
                }
                if (e2 instanceof NullPointerException) {
                    throw new EvalException(2154, new String[]{this.md.toString(), e2.getMessage()});
                }
                if (e2 instanceof EvalException) {
                    throw (EvalException)e2;
                }
                String message = e2.getMessage();
                if (message == null) {
                    StringWriter sw = new StringWriter();
                    e2.printStackTrace(new PrintWriter(sw));
                    message = sw.toString();
                }
                Assert.fail(2154, new String[]{this.md.toString(), message});
            }
            return res2;
        }
        catch (OutOfMemoryError | RuntimeException e3) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e3);
            }
            throw e3;
        }
    }

    @Override
    public final Value select(Value arg) {
        try {
            throw new WrongInvocationException("It is a TLC bug: Attempted to call MethodValue.select().");
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            Assert.fail("Attempted to appy EXCEPT construct to the operator " + this.toString() + ".", this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Assert.fail("Attempted to apply EXCEPT construct to the operator " + this.toString() + ".", this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            Assert.fail("Attempted to compute the domain of the operator " + this.toString() + ".", this.getSource());
            return SetEnumValue.EmptySet;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the operator " + this.toString() + ".", this.getSource());
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            throw new WrongInvocationException("It is a TLC bug: Attempted to normalize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final Value normalize() {
        try {
            throw new WrongInvocationException("It is a TLC bug: Attempted to normalize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val2) {
        try {
            throw new WrongInvocationException("It is a TLC bug: Attempted to initialize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean ignored) {
        try {
            return sb.append("<Java Method: " + this.md + ">");
        }
        catch (OutOfMemoryError | RuntimeException e2) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e2);
            }
            throw e2;
        }
    }

    public final int getMinLevel() {
        return this.minLevel;
    }
}

