/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import util.FileUtil;
import util.FilenameToStream;
import util.ToolIO;

public class SimpleFilenameToStream
implements FilenameToStream {
    public static final String TLA_LIBRARY = "TLA-Library";
    public static final String STANDARD_MODULES_FOLDER = "StandardModules";
    private static final ClassLoader cl = SimpleFilenameToStream.class.getClassLoader();
    private static final String STANDARD_MODULES = "tla2sany/StandardModules/";
    private String[] libraryPaths;

    public SimpleFilenameToStream() {
        this.libraryPaths = this.getLibraryPaths(this.getInstallationBasePath(), null);
    }

    public SimpleFilenameToStream(String libraryPath) {
        this(new String[]{libraryPath});
    }

    public SimpleFilenameToStream(String[] anLibraryPaths) {
        this.libraryPaths = this.getLibraryPaths(this.getInstallationBasePath(), anLibraryPaths);
    }

    private String getInstallationBasePath() {
        URL url = cl.getResource("tla2sany");
        String path2 = url.toString();
        try {
            if (!FilenameToStream.isInJar(path2)) {
                URI uri = new URI(path2);
                return new File(uri).getAbsolutePath();
            }
        }
        catch (URISyntaxException e2) {
            System.err.println(path2);
            e2.printStackTrace();
        }
        catch (IllegalArgumentException e3) {
            System.err.println(path2);
            e3.printStackTrace();
        }
        return path2;
    }

    @Override
    public String getFullPath() {
        StringBuffer buf = new StringBuffer();
        String[] ar = this.libraryPaths;
        for (int i = 0; i < ar.length; ++i) {
            buf.append(ar[i]);
            if (i >= ar.length - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private String[] getLibraryPaths(String installationBasePath, String[] libraries) {
        String[] res2;
        int i;
        String path2 = null;
        if (libraries == null) {
            path2 = System.getProperty(TLA_LIBRARY);
        } else {
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < libraries.length; ++i) {
                buf.append(libraries[i]);
                if (i >= libraries.length - 1) continue;
                buf.append(FileUtil.pathSeparator);
            }
            path2 = buf.toString();
        }
        if (path2 == null) {
            res2 = new String[]{installationBasePath + FileUtil.separator + STANDARD_MODULES_FOLDER + FileUtil.separator};
        } else {
            String[] paths = path2.split(FileUtil.pathSeparator);
            res2 = new String[paths.length + 1];
            for (i = 0; i < paths.length; ++i) {
                res2[i] = paths[i];
                if (res2[i].endsWith(FileUtil.separator)) continue;
                res2[i] = res2[i] + FileUtil.separator;
            }
            res2[paths.length] = installationBasePath + FileUtil.separator + STANDARD_MODULES_FOLDER + FileUtil.separator;
        }
        return res2;
    }

    private final File locate(String name2) {
        String prefix = "";
        File sourceFile = null;
        int idx = 0;
        while (true) {
            InputStream is2;
            if (idx == 0 && ToolIO.getUserDir() != null) {
                sourceFile = new FilenameToStream.TLAFile(ToolIO.getUserDir(), name2, (FilenameToStream)this);
            } else if (FilenameToStream.isInJar(prefix)) {
                is2 = cl.getResourceAsStream(STANDARD_MODULES + name2);
                if (is2 != null) {
                    sourceFile = this.read(name2, cl.getResource(STANDARD_MODULES + name2), is2);
                }
            } else {
                sourceFile = new FilenameToStream.TLAFile(prefix + name2, true, (FilenameToStream)this);
            }
            if (sourceFile.exists()) break;
            if (idx >= this.libraryPaths.length) {
                is2 = cl.getResourceAsStream(name2);
                if (is2 == null) break;
                return this.read(name2, cl.getResource(name2), is2);
            }
            prefix = this.libraryPaths[idx++];
        }
        return sourceFile;
    }

    private File read(String name2, URL location, InputStream is2) {
        FilenameToStream.TLAFile sourceFile = new FilenameToStream.TLAFile(TMPDIR + File.separator + name2, location, true, this);
        sourceFile.deleteOnExit();
        try {
            int len;
            FileOutputStream fos = new FileOutputStream(sourceFile);
            byte[] buf = new byte[1024];
            while ((len = is2.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            fos.close();
            is2.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return sourceFile;
    }

    @Override
    public File resolve(String name2, boolean isModule) {
        int n = name2.indexOf(10);
        if (n >= 0) {
            ToolIO.out.println("*** Warning: module name '" + name2 + "' contained NEWLINE; Only the part before NEWLINE is considered.");
            name2 = name2.substring(0, n);
        }
        String sourceFileName = null;
        if (isModule) {
            if (name2.toLowerCase().endsWith(".tla")) {
                name2 = name2.substring(0, name2.length() - ".tla".length());
            }
            sourceFileName = name2 + ".tla";
        } else {
            sourceFileName = name2;
        }
        return this.locate(sourceFileName);
    }

    public File resolve(String name2) {
        return this.resolve(name2, false);
    }

    @Override
    public boolean isStandardModule(String moduleName) {
        File file2 = this.resolve(moduleName, true);
        if (file2 == null) {
            return false;
        }
        String path2 = file2.getAbsolutePath();
        if (path2 == null) {
            return false;
        }
        return path2.startsWith(this.libraryPaths[this.libraryPaths.length - 1]);
    }
}

