/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed;

import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.concurrent.CountDownLatch;
import tlc2.output.MP;
import tlc2.tool.distributed.TLCApp;
import tlc2.tool.distributed.TLCServer;
import tlc2.tool.distributed.fp.DynamicFPSetManager;
import tlc2.tool.distributed.fp.FPSetRMI;
import tlc2.tool.distributed.fp.IFPSetManager;

public class DistributedFPSetTLCServer
extends TLCServer {
    protected final CountDownLatch latch;
    private final int expectedFPSetCount;

    public DistributedFPSetTLCServer(TLCApp work, int expectedFPSetCount) throws IOException, NotBoundException {
        super(work);
        this.expectedFPSetCount = expectedFPSetCount;
        this.latch = new CountDownLatch(expectedFPSetCount);
    }

    @Override
    protected IFPSetManager getFPSetManagerImpl(TLCApp work, String metadir, int fpsetCount) throws IOException {
        return new DynamicFPSetManager(fpsetCount);
    }

    @Override
    public IFPSetManager getFPSetManager() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            MP.printError(1000, e);
        }
        return this.fpSetManager;
    }

    @Override
    protected void waitForFPSetManager() throws InterruptedException {
        MP.printMessage(7008, Integer.toString(this.expectedFPSetCount));
        this.latch.await();
    }

    @Override
    public synchronized void registerFPSet(FPSetRMI fpSet, String hostname) throws RemoteException {
        this.fpSetManager.register(fpSet, hostname);
        this.latch.countDown();
        long diff = (long)this.expectedFPSetCount - this.latch.getCount();
        MP.printMessage(7009, Long.toString(diff), Integer.toString(this.expectedFPSetCount));
    }
}

