/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import util.Assert;
import util.FileUtil;

public final class MemObjectQueue {
    private static final int InitialSize = 4096;
    private static final int GrowthFactor = 2;
    private int len;
    private Object[] states = new Object[4096];
    private int start = 0;
    private String diskdir;

    public MemObjectQueue(String metadir) {
        this.diskdir = metadir;
    }

    public final void enqueue(Object state) {
        if (this.len == this.states.length) {
            int newLen = Math.max(1, this.len * 2);
            Object[] newStates = new Object[newLen];
            int copyLen = this.states.length - this.start;
            System.arraycopy(this.states, this.start, newStates, 0, copyLen);
            System.arraycopy(this.states, 0, newStates, copyLen, this.start);
            this.states = newStates;
            this.start = 0;
        }
        int last = (this.start + this.len) % this.states.length;
        this.states[last] = state;
        ++this.len;
    }

    public final Object dequeue() {
        if (this.len == 0) {
            return null;
        }
        Object res = this.states[this.start];
        this.states[this.start] = null;
        this.start = (this.start + 1) % this.states.length;
        --this.len;
        return res;
    }

    public final void beginChkpt() throws IOException {
        String filename = this.diskdir + FileUtil.separator + "queue.tmp";
        ObjectOutputStream oos = FileUtil.newOBFOS((String)filename);
        oos.writeInt(this.len);
        int index = this.start;
        for (int i = 0; i < this.len; ++i) {
            oos.writeObject(this.states[index++]);
            if (index != this.states.length) continue;
            index = 0;
        }
        oos.close();
    }

    public final void commitChkpt() throws IOException {
        String oldName = this.diskdir + FileUtil.separator + "queue.chkpt";
        File oldChkpt = new File(oldName);
        String newName = this.diskdir + FileUtil.separator + "queue.tmp";
        File newChkpt = new File(newName);
        if (oldChkpt.exists() && !oldChkpt.delete() || !newChkpt.renameTo(oldChkpt)) {
            throw new IOException("MemStateQueue.commitChkpt: cannot delete " + oldChkpt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recover() throws IOException {
        String filename = this.diskdir + FileUtil.separator + "queue.chkpt";
        ObjectInputStream ois = FileUtil.newOBFIS((String)filename);
        this.len = ois.readInt();
        try {
            for (int i = 0; i < this.len; ++i) {
                this.states[i] = ois.readObject();
            }
        }
        catch (ClassNotFoundException e) {
            ois.close();
            Assert.fail((int)2126, (String)e.getMessage());
        }
        finally {
            ois.close();
        }
    }
}

