/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import tla2sany.semantic.SemanticNode;
import tlc2.tool.FingerprintException;
import tlc2.util.Vect;
import tlc2.value.IValue;
import tlc2.value.Values;
import tlc2.value.impl.Applicable;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.WrongInvocationException;

public class OpRcdValue
extends OpValue
implements Applicable {
    public Vect domain;
    public Vect values;

    public OpRcdValue() {
        this.domain = new Vect();
        this.values = new Vect();
    }

    public OpRcdValue(Vect domain, Vect values) {
        this.domain = domain;
        this.values = values;
    }

    @Override
    public final byte getKind() {
        return 11;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            Assert.fail((String)("Attempted to compare operator " + Values.ppr(this.toString()) + " with value:\n" + Values.ppr(obj.toString())), (SemanticNode)this.getSource());
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            Assert.fail((String)("Attempted to check equality of operator " + Values.ppr(this.toString()) + " with value:\n" + Values.ppr(obj.toString())), (SemanticNode)this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail((String)("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of operator " + Values.ppr(this.toString())), (SemanticNode)this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail((String)("Attempted to check if the operator " + Values.ppr(this.toString()) + " is a finite set."), (SemanticNode)this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final void addLine(Vect vs) {
        try {
            int len = vs.size();
            Value[] args = new Value[len - 2];
            for (int i = 0; i < len - 2; ++i) {
                args[i] = (Value)vs.elementAt(i + 1);
            }
            this.domain.addElement(args);
            this.values.addElement(vs.elementAt(len - 1));
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value apply(Value arg, int control) {
        try {
            throw new WrongInvocationException("Should use the other apply method.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value apply(Value[] args, int control) {
        try {
            int sz = this.domain.size();
            for (int i = 0; i < sz; ++i) {
                Value[] vals = (Value[])this.domain.elementAt(i);
                if (args.length != vals.length) {
                    Assert.fail((String)("Attempted to apply the operator " + Values.ppr(this.toString()) + "\nwith wrong number of arguments."), (SemanticNode)this.getSource());
                }
                boolean matched = true;
                for (int j = 0; j < vals.length && (matched = vals[j].equals(args[j])); ++j) {
                }
                if (!matched) continue;
                return (Value)this.values.elementAt(i);
            }
            String msg = "Attempted to apply operator:\n" + Values.ppr(this.toString()) + "\nto arguments (";
            if (args.length > 0) {
                msg = msg + args[0];
            }
            for (int i = 1; i < args.length; ++i) {
                msg = msg + ", " + args[i];
            }
            Assert.fail((String)(msg + "), which is undefined."), (SemanticNode)this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value select(Value arg) {
        try {
            Assert.fail((String)"Attempted to call OpRcdValue.select(). This is a TLC bug.", (SemanticNode)this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex2) {
        try {
            Assert.fail((String)("Attempted to appy EXCEPT construct to the operator " + Values.ppr(this.toString()) + "."), (SemanticNode)this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Assert.fail((String)("Attempted to apply EXCEPT construct to the operator " + Values.ppr(this.toString()) + "."), (SemanticNode)this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            Assert.fail((String)("Attempted to compute the domain of the operator " + Values.ppr(this.toString()) + "."), (SemanticNode)this.getSource());
            return SetEnumValue.EmptySet;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail((String)("Attempted to compute the number of elements in the operator " + Values.ppr(this.toString()) + "."), (SemanticNode)this.getSource());
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            throw new WrongInvocationException("Should not normalize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            throw new WrongInvocationException("Should not normalize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            for (int i = 0; i < this.values.size(); ++i) {
                defined = defined && ((Value)this.values.elementAt(i)).isDefined();
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            throw new WrongInvocationException("Should not initialize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            sb.append("{ ");
            if (this.values.size() != 0) {
                sb.append("<");
                Value[] args = (Value[])this.domain.elementAt(0);
                for (int j = 0; j < args.length; ++j) {
                    sb = args[j].toString(sb, offset, swallow);
                    sb.append(", ");
                }
                sb = ((Value)this.values.elementAt(0)).toString(sb, offset, swallow);
                sb.append(">");
            }
            for (int i = 1; i < this.values.size(); ++i) {
                sb.append(", <");
                Value[] args = (Value[])this.domain.elementAt(i);
                for (int j = 0; j < args.length; ++j) {
                    sb = args[j].toString(sb, offset, swallow);
                    sb.append(", ");
                }
                sb = ((Value)this.values.elementAt(i)).toString(sb, offset, swallow);
                sb.append(">");
            }
            return sb.append("}");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }
}

