/*
 * Decompiled with CFR 0.152.
 */
package tlc2.output;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tla2sany.semantic.StandardModules;
import tlc2.input.MCParser;
import tlc2.input.MCParserResults;
import tlc2.output.AbstractTLACopier;

public class TLAMonolithCreator
extends AbstractTLACopier {
    private static final String NESTED_MODULE_INDENT = "    ";
    private static final String LOCAL_INSTANCE_REGEX = "^LOCAL INSTANCE ([^\\s]+)\\s*$";
    private static final Pattern LOCAL_INSTANCE_PATTERN = Pattern.compile("^LOCAL INSTANCE ([^\\s]+)\\s*$");
    private final List<File> modulesToEmbed;
    private final Set<String> moduleNamesBeingEmbedded;
    private final Set<String> modulesToSpecifyInExtends;
    private final List<File> modulesToNest;

    public TLAMonolithCreator(String rootSpecName, File sourceLocation, Set<String> entireExtendsList) {
        this(rootSpecName, sourceLocation, null, entireExtendsList, null);
    }

    public TLAMonolithCreator(String rootSpecName, File sourceLocation, List<File> extendeds, Set<String> entireExtendsList, Set<String> allInstantiatedModules) {
        super(rootSpecName, "tmp_" + System.currentTimeMillis() + "_monolith", sourceLocation);
        boolean willEmbedDependents = extendeds != null;
        this.moduleNamesBeingEmbedded = new HashSet<String>();
        this.modulesToNest = new ArrayList<File>();
        this.modulesToEmbed = new ArrayList<File>();
        if (willEmbedDependents) {
            HashSet<String> instantiatedModules = new HashSet<String>(allInstantiatedModules);
            Stack<File> embedStack = new Stack<File>();
            for (File f : extendeds) {
                String moduleName;
                boolean keep;
                String name = f.getName();
                int index = name.toLowerCase().indexOf(".tla");
                if (index == -1) {
                    keep = true;
                    moduleName = name;
                } else {
                    moduleName = name.substring(0, index);
                    boolean bl = keep = !StandardModules.isDefinedInStandardModule((String)moduleName);
                }
                if (!keep) continue;
                embedStack.push(f);
                instantiatedModules.remove(moduleName);
                this.moduleNamesBeingEmbedded.add(moduleName);
            }
            while (!embedStack.isEmpty()) {
                this.modulesToEmbed.add((File)embedStack.pop());
            }
            for (String module : instantiatedModules) {
                if (StandardModules.isDefinedInStandardModule((String)module)) continue;
                this.modulesToNest.add(new File(sourceLocation, module + ".tla"));
            }
        }
        this.modulesToSpecifyInExtends = new HashSet<String>(entireExtendsList);
        if (willEmbedDependents) {
            StandardModules.filterNonStandardModulesFromSet(this.modulesToSpecifyInExtends);
        }
        this.modulesToSpecifyInExtends.add("TLC");
        this.modulesToSpecifyInExtends.add("Toolbox");
    }

    @Override
    protected void copyLine(BufferedWriter writer, String originalLine, int lineNumber) throws IOException {
        if (!this.inBody) {
            Matcher m = this.modulePattern.matcher(originalLine);
            this.inBody = m.find();
            if (!this.vetoLocalInstanceLine(originalLine)) {
                writer.write(originalLine + '\n');
            }
        } else if (originalLine.trim().startsWith("EXTENDS")) {
            writer.write("EXTENDS " + String.join((CharSequence)", ", this.modulesToSpecifyInExtends) + "\n");
            for (File f : this.modulesToNest) {
                this.insertModuleIntoMonolith(f, writer, true);
            }
            for (File f : this.modulesToEmbed) {
                this.insertModuleIntoMonolith(f, writer, false);
            }
            StringBuilder commentLine = new StringBuilder("\n");
            commentLine.append("\\* ").append("\n");
            commentLine.append("\\* ").append(' ');
            commentLine.append(this.originalModuleName);
            commentLine.append(" follows\n");
            commentLine.append("\\* ").append("\n").append("\n");
            writer.write(commentLine.toString());
        } else {
            writer.write(originalLine + '\n');
        }
    }

    @Override
    protected void copyHasFinished() throws IOException {
        Path originalPath = this.sourceFile.toPath();
        Files.delete(originalPath);
        Path monolithPath = this.destinationFile.toPath();
        Files.move(monolithPath, originalPath, new CopyOption[0]);
    }

    private void insertModuleIntoMonolith(File module, BufferedWriter monolithWriter, boolean nestedModule) throws IOException {
        StringBuilder commentLine = new StringBuilder("\n");
        String moduleFilename = module.getName();
        int index = moduleFilename.indexOf(".tla");
        String moduleName = index != -1 ? moduleFilename.substring(0, index) : moduleFilename;
        commentLine.append("\\* ").append("\n");
        commentLine.append("\\* ").append(' ').append(moduleName).append(" follows\n");
        commentLine.append("\\* ").append("\n").append("\n");
        monolithWriter.write(commentLine.toString());
        String regex = "^([-]+ MODULE) " + moduleName;
        Pattern insertingModuleMatcher = Pattern.compile(regex);
        try (BufferedReader br = new BufferedReader(new FileReader(module));){
            String line;
            boolean inModuleBody = false;
            while ((line = br.readLine()) != null) {
                Matcher m;
                if (!inModuleBody) {
                    m = insertingModuleMatcher.matcher(line);
                    inModuleBody = m.find();
                    if (!inModuleBody || !nestedModule) continue;
                    monolithWriter.write(NESTED_MODULE_INDENT + line + '\n');
                    continue;
                }
                if (line.trim().startsWith("EXTENDS")) continue;
                m = CLOSING_BODY_PATTERN.matcher(line);
                if (m.matches()) {
                    if (nestedModule) {
                        monolithWriter.write(NESTED_MODULE_INDENT + line + '\n');
                    }
                    break;
                }
                if (this.vetoLocalInstanceLine(line)) continue;
                if (nestedModule) {
                    monolithWriter.write(NESTED_MODULE_INDENT);
                }
                monolithWriter.write(line + '\n');
            }
        }
    }

    private boolean vetoLocalInstanceLine(String line) {
        Matcher m = LOCAL_INSTANCE_PATTERN.matcher(line);
        if (m.matches()) {
            return this.moduleNamesBeingEmbedded.contains(m.group(1));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String specName;
        File sourceDirectory;
        if (args.length == 0) {
            System.out.println("java tlc2.output.TLAMonolithCreator \\\n\t[-sourceDir=_directory_containing_spec_tla_] \\\n\t_specName_");
            System.exit(-2);
        }
        if (args.length == 1) {
            sourceDirectory = new File(System.getProperty("user.dir"));
            specName = args[0];
        } else {
            sourceDirectory = new File(args[0]);
            specName = args[1];
        }
        File originalTLA = new File(sourceDirectory, specName + ".tla");
        if (!originalTLA.exists()) {
            System.out.println("Excepted to find the TLA file but could not: " + originalTLA.getAbsolutePath());
            System.exit(-3);
        }
        MCParser parser = new MCParser(sourceDirectory, specName, true);
        MCParserResults results = parser.parse();
        File backupTLA = new File(sourceDirectory, specName + "_orig" + ".tla");
        try {
            Files.copy(originalTLA.toPath(), backupTLA.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException ioe) {
            System.out.println("Exception encountered while making a backup of the original TLA file: " + ioe.getMessage());
            System.exit(-1);
        }
        try {
            ArrayList<File> extendeds = new ArrayList<File>();
            for (String extended : results.getOriginalExtendedModules()) {
                extendeds.add(new File(sourceDirectory, extended + ".tla"));
            }
            TLAMonolithCreator creator = new TLAMonolithCreator(specName, sourceDirectory, extendeds, results.getAllExtendedModules(), results.getAllInstantiatedModules());
            creator.copy();
            System.out.println("The monolith file is now present at: " + originalTLA.getAbsolutePath());
        }
        catch (IOException ioe) {
            System.out.println("Exception encountered while making creating the monolith: " + ioe.getMessage());
            System.exit(-4);
        }
        finally {
            System.out.println("The original TLA file was backed up to: " + backupTLA.getAbsolutePath());
        }
    }
}

