/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tla2sany.semantic.ASTConstants;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.LevelNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.IContextEnumerator;
import tlc2.tool.ITool;
import tlc2.tool.Specs;
import tlc2.tool.TLCState;
import tlc2.tool.ToolGlobals;
import tlc2.tool.liveness.LNAction;
import tlc2.tool.liveness.LNAll;
import tlc2.tool.liveness.LNBool;
import tlc2.tool.liveness.LNConj;
import tlc2.tool.liveness.LNDisj;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.LNNeg;
import tlc2.tool.liveness.LNStateAST;
import tlc2.tool.liveness.LNStateEnabled;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.PossibleErrorModel;
import tlc2.tool.liveness.TBGraph;
import tlc2.tool.liveness.TBPar;
import tlc2.util.Context;
import tlc2.util.Vect;
import tlc2.value.IBoolValue;
import tlc2.value.IFcnLambdaValue;
import tlc2.value.IValue;
import tlc2.value.impl.EvaluatingValue;
import tlc2.value.impl.MethodValue;
import util.Assert;
import util.ToolIO;

public class Liveness
implements ToolGlobals,
ASTConstants {
    private static LiveExprNode astToLive(ITool tool, ExprNode expr, Context con, int level) {
        Object realDef;
        if (level == 0 && expr instanceof OpApplNode && ((realDef = tool.lookup(((OpApplNode)expr).getOperator(), Context.Empty, false)) instanceof MethodValue || realDef instanceof EvaluatingValue)) {
            for (SymbolNode p : expr.getAllParams()) {
                level = Math.max(level, p.getLevel());
            }
        }
        if (level == 0) {
            IValue val = tool.eval((SemanticNode)expr, con, TLCState.Empty);
            if (!(val instanceof IBoolValue)) {
                Assert.fail((int)2215, (String[])new String[]{"boolean", expr.toString()});
            }
            return ((IBoolValue)val).getVal() ? LNBool.TRUE : LNBool.FALSE;
        }
        if (level == 1) {
            return new LNStateAST(expr, con);
        }
        return new LNAction(expr, con);
    }

    private static LiveExprNode astToLive(ITool tool, ExprNode expr, Context con) {
        switch (expr.getKind()) {
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                return Liveness.astToLiveAppl(tool, expr1, con);
            }
            case 10: {
                LetInNode expr1 = (LetInNode)expr;
                return Liveness.astToLive(tool, expr1.getBody(), con);
            }
            case 13: {
                SubstInNode expr1 = (SubstInNode)expr;
                Subst[] subs = expr1.getSubsts();
                int slen = subs.length;
                Context con1 = con;
                for (int i = 0; i < slen; ++i) {
                    Subst sub = subs[i];
                    con1 = con1.cons((SymbolNode)sub.getOp(), tool.getVal(sub.getExpr(), con, false));
                }
                return Liveness.astToLive(tool, expr1.getBody(), con1);
            }
        }
        int level = Specs.getLevel((LevelNode)expr, con);
        if (level > 2) {
            Assert.fail((int)2213, (String)expr.toString());
        }
        return Liveness.astToLive(tool, expr, con, level);
    }

    private static LiveExprNode astToLiveAppl(ITool tool, OpApplNode expr, Context con) {
        ExprOrOpArgNode[] args = expr.getArgs();
        int alen = args.length;
        SymbolNode opNode = expr.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            Object val = tool.lookup(opNode, con, false);
            if (val instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)val;
                opcode = BuiltInOPs.getOpCode(opDef.getName());
                if (opcode == 0) {
                    try {
                        FormalParamNode[] formals = opDef.getParams();
                        Context con1 = con;
                        for (int i = 0; i < alen; ++i) {
                            IValue argVal = tool.eval((SemanticNode)args[i], con, TLCState.Empty);
                            con1 = con1.cons((SymbolNode)formals[i], argVal);
                        }
                        LiveExprNode res = Liveness.astToLive(tool, opDef.getBody(), con1);
                        int level = res.getLevel();
                        if (level > 2) {
                            return res;
                        }
                        return Liveness.astToLive(tool, (ExprNode)expr, con, level);
                    }
                    catch (Exception formals) {}
                }
            } else if (val instanceof IBoolValue) {
                return ((IBoolValue)val).getVal() ? LNBool.TRUE : LNBool.FALSE;
            }
            if (opcode == 0) {
                int level = Specs.getLevel((LevelNode)expr, con);
                if (level > 2) {
                    Assert.fail((int)2213, (String)expr.toString());
                }
                return Liveness.astToLive(tool, (ExprNode)expr, con, level);
            }
        }
        switch (opcode) {
            case 2: {
                IContextEnumerator Enum2;
                ExprNode body = (ExprNode)args[0];
                try {
                    Context con1;
                    Enum2 = tool.contexts(expr, con, TLCState.Empty, TLCState.Empty, 0);
                    LNDisj res = new LNDisj(0);
                    while ((con1 = Enum2.nextElement()) != null) {
                        LiveExprNode kid = Liveness.astToLive(tool, body, con1);
                        res.addDisj(kid);
                    }
                    int level = res.getLevel();
                    if (level > 2) {
                        return res;
                    }
                    return Liveness.astToLive(tool, (ExprNode)expr, con, level);
                }
                catch (Exception e) {
                    int level = Specs.getLevel((LevelNode)expr, con);
                    if (level > 2) {
                        Assert.fail((int)2213, (String)expr.toString());
                    }
                    return Liveness.astToLive(tool, (ExprNode)expr, con, level);
                }
            }
            case 3: {
                IContextEnumerator Enum2;
                ExprNode body = (ExprNode)args[0];
                try {
                    Context con1;
                    Enum2 = tool.contexts(expr, con, TLCState.Empty, TLCState.Empty, 0);
                    LNConj res = new LNConj(0);
                    while ((con1 = Enum2.nextElement()) != null) {
                        LiveExprNode kid = Liveness.astToLive(tool, body, con1);
                        res.addConj(kid);
                    }
                    int level = res.getLevel();
                    if (level > 2) {
                        return res;
                    }
                    return Liveness.astToLive(tool, (ExprNode)expr, con, level);
                }
                catch (Exception e) {
                    int level = Specs.getLevel((LevelNode)expr, con);
                    if (level > 2) {
                        if (e instanceof Assert.TLCRuntimeException) {
                            Assert.fail((int)2213, (String[])new String[]{expr.toString(), e.getMessage()});
                        } else {
                            Assert.fail((int)2213, (String)expr.toString());
                        }
                    }
                    return Liveness.astToLive(tool, (ExprNode)expr, con, level);
                }
            }
            case 6: 
            case 36: {
                LNConj lnConj = new LNConj(alen);
                for (int i = 0; i < alen; ++i) {
                    LiveExprNode kid = Liveness.astToLive(tool, (ExprNode)args[i], con);
                    lnConj.addConj(kid);
                }
                int level = lnConj.getLevel();
                if (level > 2) {
                    return lnConj;
                }
                return Liveness.astToLive(tool, (ExprNode)expr, con, level);
            }
            case 7: 
            case 37: {
                LNDisj lnDisj = new LNDisj(alen);
                for (int i = 0; i < alen; ++i) {
                    LiveExprNode kid = Liveness.astToLive(tool, (ExprNode)args[i], con);
                    lnDisj.addDisj(kid);
                }
                int level = lnDisj.getLevel();
                if (level > 2) {
                    return lnDisj;
                }
                return Liveness.astToLive(tool, (ExprNode)expr, con, level);
            }
            case 9: {
                try {
                    IFcnLambdaValue fcn;
                    IValue fval = tool.eval((SemanticNode)args[0], con, TLCState.Empty);
                    if (fval instanceof IFcnLambdaValue && !(fcn = (IFcnLambdaValue)((Object)fval)).hasRcd()) {
                        tool.getFcnContext(fcn, args, con, TLCState.Empty, TLCState.Empty, 0);
                        return Liveness.astToLive(tool, (ExprNode)fcn.getBody(), con);
                    }
                }
                catch (Exception fval) {
                    // empty catch block
                }
                int level = expr.getLevel();
                if (level > 2) {
                    Assert.fail((int)2213, (String)expr.toString());
                }
                return Liveness.astToLive(tool, (ExprNode)expr, con, level);
            }
            case 11: {
                LiveExprNode guard = Liveness.astToLive(tool, (ExprNode)args[0], con);
                LiveExprNode e1 = Liveness.astToLive(tool, (ExprNode)args[1], con);
                LiveExprNode e2 = Liveness.astToLive(tool, (ExprNode)args[2], con);
                LNConj conj1 = new LNConj(guard, e1);
                LNConj conj2 = new LNConj(new LNNeg(guard), e2);
                LNDisj res = new LNDisj(conj1, conj2);
                int level = ((LiveExprNode)res).getLevel();
                if (level > 2) {
                    return res;
                }
                return Liveness.astToLive(tool, (ExprNode)expr, con, level);
            }
            case 27: {
                LiveExprNode lnArg = Liveness.astToLive(tool, (ExprNode)args[0], con);
                int level = lnArg.getLevel();
                if (level > 2) {
                    return new LNNeg(lnArg);
                }
                return Liveness.astToLive(tool, (ExprNode)expr, con, level);
            }
            case 38: {
                LiveExprNode lnLeft = Liveness.astToLive(tool, (ExprNode)args[0], con);
                LiveExprNode lnRight = Liveness.astToLive(tool, (ExprNode)args[1], con);
                int level = Math.max(lnLeft.getLevel(), lnRight.getLevel());
                if (level > 2) {
                    return new LNDisj(new LNNeg(lnLeft), lnRight);
                }
                return Liveness.astToLive(tool, (ExprNode)expr, con, level);
            }
            case 48: {
                return new LNAction((ExprNode)expr, con);
            }
            case 53: {
                ExprNode subs = (ExprNode)args[0];
                ExprNode body = (ExprNode)args[1];
                LNNeg en = new LNNeg(new LNStateEnabled(body, con, subs, false));
                LNAction act = new LNAction(body, con, subs, false);
                return new LNDisj(new LNEven(new LNAll(en)), new LNAll(new LNEven(act)));
            }
            case 54: {
                ExprNode subs = (ExprNode)args[0];
                ExprNode body = (ExprNode)args[1];
                LNNeg ln1 = new LNNeg(new LNStateEnabled(body, con, subs, false));
                LNAction ln2 = new LNAction(body, con, subs, false);
                LNDisj disj = new LNDisj(ln1, ln2);
                return new LNAll(new LNEven(disj));
            }
            case 57: {
                LiveExprNode lnLeft = Liveness.astToLive(tool, (ExprNode)args[0], con);
                LiveExprNode lnRight = Liveness.astToLive(tool, (ExprNode)args[1], con);
                LNDisj lnd = new LNDisj(new LNNeg(lnLeft), new LNEven(lnRight));
                return new LNAll(lnd);
            }
            case 59: {
                LiveExprNode lnArg = Liveness.astToLive(tool, (ExprNode)args[0], con);
                return new LNAll(lnArg);
            }
            case 60: {
                LiveExprNode lnArg = Liveness.astToLive(tool, (ExprNode)args[0], con);
                return new LNEven(lnArg);
            }
            case 50: {
                assert (Specs.getLevel((LevelNode)expr, con) == 2);
                ExprNode body = (ExprNode)args[0];
                ExprNode subs = (ExprNode)args[1];
                return new LNAction(body, con, subs, false);
            }
            case 46: {
                return Liveness.astToLive(tool, (ExprNode)args[0], con);
            }
        }
        int level = Specs.getLevel((LevelNode)expr, con);
        if (level > 2) {
            Assert.fail((int)2213, (String)expr.toString());
        }
        return Liveness.astToLive(tool, (ExprNode)expr, con, level);
    }

    private static LiveExprNode parseLiveness(ITool tool) {
        LiveExprNode ln;
        Action[] fairs = tool.getTemporals();
        LNConj lnc = new LNConj(fairs.length);
        for (int i = 0; i < fairs.length; ++i) {
            ln = Liveness.astToLive(tool, (ExprNode)fairs[i].pred, fairs[i].con);
            lnc.addConj(ln);
        }
        Action[] checks = tool.getImpliedTemporals();
        if (checks.length == 0) {
            if (fairs.length == 0) {
                return null;
            }
        } else if (checks.length == 1) {
            ln = Liveness.astToLive(tool, (ExprNode)checks[0].pred, checks[0].con);
            if (lnc.getCount() == 0) {
                return new LNNeg(ln);
            }
            lnc.addConj(new LNNeg(ln));
        } else {
            LNDisj lnd = new LNDisj(checks.length);
            for (int i = 0; i < checks.length; ++i) {
                LiveExprNode ln2 = Liveness.astToLive(tool, (ExprNode)checks[i].pred, checks[i].con);
                lnd.addDisj(new LNNeg(ln2));
            }
            if (lnc.getCount() == 0) {
                return lnd;
            }
            lnc.addConj(lnd);
        }
        return lnc;
    }

    public static OrderOfSolution[] processLiveness(ITool tool) {
        LiveExprNode lexpr = Liveness.parseLiveness(tool);
        if (lexpr == null) {
            return new OrderOfSolution[0];
        }
        lexpr.tagExpr(1);
        lexpr = lexpr.simplify().toDNF();
        if (lexpr instanceof LNBool && !((LNBool)lexpr).b) {
            return new OrderOfSolution[0];
        }
        LNDisj dnf = lexpr instanceof LNDisj ? (LNDisj)lexpr : new LNDisj(lexpr);
        OSExprPem[] pems = new OSExprPem[dnf.getCount()];
        LiveExprNode[] tfs = new LiveExprNode[dnf.getCount()];
        for (int i = 0; i < dnf.getCount(); ++i) {
            OSExprPem pem;
            LiveExprNode ln = dnf.getBody(i).flattenSingleJunctions();
            pems[i] = pem = new OSExprPem();
            if (ln instanceof LNConj) {
                LNConj lnc2 = (LNConj)ln;
                for (int j = 0; j < lnc2.getCount(); ++j) {
                    Liveness.classifyExpr(lnc2.getBody(j), pem);
                }
            } else {
                Liveness.classifyExpr(ln, pem);
            }
            tfs[i] = pem.toTFS();
        }
        TBPar tfbin = new TBPar(dnf.getCount());
        Vect pembin = new Vect(dnf.getCount());
        for (int i = 0; i < dnf.getCount(); ++i) {
            int found = -1;
            LiveExprNode tf = tfs[i];
            for (int j = 0; j < tfbin.size() && found == -1; ++j) {
                LiveExprNode tf0 = tfbin.exprAt(j);
                if ((tf != null || tf0 != null) && (tf == null || tf0 == null || !tf.equals(tf0))) continue;
                found = j;
            }
            if (found == -1) {
                found = tfbin.size();
                tfbin.addElement(tf);
                pembin.addElement(new Vect());
            }
            ((Vect)pembin.elementAt(found)).addElement(pems[i]);
        }
        OrderOfSolution[] oss = new OrderOfSolution[tfbin.size()];
        for (int i = 0; i < tfbin.size(); ++i) {
            int j;
            LiveExprNode tf = tfbin.exprAt(i);
            if (tf == null) {
                oss[i] = new OrderOfSolution(new LNEven[0]);
            } else {
                LiveExprNode tf1 = tf.makeBinary();
                oss[i] = new OrderOfSolution(new TBGraph(tf1), tf1.extractPromises());
            }
            Vect<LiveExprNode> stateBin = new Vect<LiveExprNode>();
            Vect<LiveExprNode> actionBin = new Vect<LiveExprNode>();
            Vect tfPems = (Vect)pembin.elementAt(i);
            oss[i].setPems(new PossibleErrorModel[tfPems.size()]);
            for (j = 0; j < tfPems.size(); ++j) {
                OSExprPem pem = (OSExprPem)tfPems.elementAt(j);
                oss[i].getPems()[j] = new PossibleErrorModel(Liveness.addToBin(pem.AEAction, actionBin), Liveness.addToBin(pem.AEState, stateBin), Liveness.addToBin(pem.EAAction, actionBin));
            }
            oss[i].setCheckState(new LiveExprNode[stateBin.size()]);
            for (j = 0; j < stateBin.size(); ++j) {
                oss[i].getCheckState()[j] = stateBin.elementAt(j);
            }
            oss[i].setCheckAction(new LiveExprNode[actionBin.size()]);
            for (j = 0; j < actionBin.size(); ++j) {
                oss[i].getCheckAction()[j] = actionBin.elementAt(j);
            }
        }
        MP.printMessage(2212, String.valueOf(oss.length));
        return oss;
    }

    private static int addToBin(LiveExprNode check2, Vect<LiveExprNode> bin) {
        LiveExprNode ln;
        int idx;
        if (check2 == null) {
            return -1;
        }
        int len = bin.size();
        for (idx = 0; idx < len && !check2.equals(ln = bin.elementAt(idx)); ++idx) {
        }
        if (idx >= len) {
            bin.addElement(check2);
        }
        return idx;
    }

    private static int[] addToBin(Vect<LiveExprNode> checks, Vect<LiveExprNode> bin) {
        int[] index = new int[checks.size()];
        for (int i = 0; i < checks.size(); ++i) {
            LiveExprNode check2 = checks.elementAt(i);
            index[i] = Liveness.addToBin(check2, bin);
        }
        return index;
    }

    private static void classifyExpr(LiveExprNode ln, OSExprPem pem) {
        LiveExprNode ln1;
        if (ln instanceof LNEven) {
            LiveExprNode ln2;
            LiveExprNode ln12 = ((LNEven)ln).getBody();
            if (ln12 instanceof LNAll && (ln2 = ((LNAll)ln12).getBody()).getLevel() < 3) {
                pem.EAAction.addElement(ln2);
                return;
            }
        } else if (ln instanceof LNAll && (ln1 = ((LNAll)ln).getBody()) instanceof LNEven) {
            LiveExprNode ln2 = ((LNEven)ln1).getBody();
            int level = ln2.getLevel();
            if (level <= 1) {
                pem.AEState.addElement(ln2);
                return;
            }
            if (level == 2) {
                pem.AEAction.addElement(ln2);
                return;
            }
        }
        if (ln.containAction()) {
            Assert.fail((int)2214);
        }
        pem.tfs.addElement(ln);
    }

    public static void printTBGraph(TBGraph tableau) {
        if (tableau == null) {
            ToolIO.out.println("No tableau.");
        } else {
            ToolIO.out.println(tableau.toString());
        }
    }

    private static class OSExprPem {
        private final Vect<LiveExprNode> EAAction = new Vect();
        private final Vect<LiveExprNode> AEState = new Vect();
        private final Vect<LiveExprNode> AEAction = new Vect();
        private final Vect<LiveExprNode> tfs = new Vect();

        public LiveExprNode toTFS() {
            if (this.tfs.size() == 1) {
                return this.tfs.elementAt(0);
            }
            if (this.tfs.size() > 1) {
                LNConj lnc2 = new LNConj(this.tfs.size());
                for (int j = 0; j < this.tfs.size(); ++j) {
                    lnc2.addConj(this.tfs.elementAt(j));
                }
                return lnc2;
            }
            return null;
        }
    }
}

