/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.Serializable;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetFactory;
import util.Assert;
import util.TLCRuntime;

public class FPSetConfiguration
implements Serializable {
    protected int fpBits = 1;
    protected long memoryInBytes = -1L;
    protected double ratio;
    protected String implementation;

    public FPSetConfiguration() {
        this(0.25);
    }

    public FPSetConfiguration(Double aRatio) {
        this(aRatio, System.getProperty(FPSetFactory.IMPL_PROPERTY, FPSetFactory.getImplementationDefault()));
    }

    public FPSetConfiguration(Double aRatio, String implementation) {
        this.ratio = aRatio;
        this.implementation = implementation;
    }

    public boolean allowsNesting() {
        return this.getFpBits() > 0;
    }

    public int getFpBits() {
        if (this.fpBits == 0 && FPSetFactory.isDiskFPSet(this.implementation)) {
            this.fpBits = 1;
        }
        return this.fpBits;
    }

    public void setFpBits(int fpBits) {
        Assert.check((boolean)FPSet.isValid(fpBits), (int)1000);
        this.fpBits = fpBits;
    }

    public long getMemoryInBytes() {
        TLCRuntime instance = TLCRuntime.getInstance();
        if (FPSetFactory.allocatesOnHeap(this.implementation)) {
            if (this.memoryInBytes > 0L) {
                return instance.getFPMemSize((double)this.memoryInBytes * this.ratio);
            }
            return instance.getFPMemSize(this.ratio);
        }
        return instance.getNonHeapPhysicalMemory();
    }

    public long getMemoryInFingerprintCnt() {
        return (long)Math.floor(this.getMemoryInBytes() / 8L);
    }

    public int getMultiFPSetCnt() {
        return 1 << this.getFpBits();
    }

    public void setRatio(double aRatio) {
        Assert.check((aRatio >= 0.0 && aRatio <= 1.0 ? 1 : 0) != 0, (int)1000);
        this.ratio = aRatio;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setMemory(long fpMemSize) {
        Assert.check((fpMemSize >= 0L ? 1 : 0) != 0, (int)1000);
        this.memoryInBytes = fpMemSize;
    }

    public String getImplementation() {
        return this.implementation;
    }
}

