/*
 * Decompiled with CFR 0.152.
 */
package tlc2.model;

import tlc2.value.IValue;
import util.Assert;

public class MCVariable {
    private final String name;
    private final String valueAsString;
    private final IValue tlcValue;
    private String traceExpression;

    public MCVariable(String varName, String value) {
        Assert.check((varName != null ? 1 : 0) != 0, (int)1000);
        this.name = varName;
        Assert.check((value != null ? 1 : 0) != 0, (int)1000);
        this.valueAsString = value;
        this.traceExpression = null;
        this.tlcValue = null;
    }

    public MCVariable(String varName, IValue tlcValue) {
        Assert.check((varName != null ? 1 : 0) != 0, (int)1000);
        this.name = varName;
        this.valueAsString = tlcValue != null ? tlcValue.toString() : "";
        this.traceExpression = null;
        this.tlcValue = tlcValue;
    }

    public String getName() {
        return this.name;
    }

    public IValue getTLCValue() {
        return this.tlcValue;
    }

    public String getSingleLineDisplayName() {
        String s = this.isTraceExplorerExpression() ? this.traceExpression : this.name;
        return s.replaceAll("\\n", "").replaceAll("\\r", "");
    }

    public String getValueAsString() {
        return this.valueAsString;
    }

    public String getValueAsStringReIndentedAs(String indent) {
        String[] split = this.valueAsString.split("(\\r\\n|\\r|\\n)");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            sb.append(indent).append(split[i]);
            if (i >= split.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean isTraceExplorerExpression() {
        return this.traceExpression != null;
    }

    public void setTraceExpression(String expression) {
        this.traceExpression = expression;
    }

    public String getTraceExpression() {
        return this.traceExpression;
    }
}

