/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.Serializable;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tlc2.tool.ToolGlobals;
import tlc2.tool.coverage.CostModel;
import tlc2.util.Context;
import util.UniqueString;

public final class Action
implements ToolGlobals,
Serializable {
    private static final UniqueString UNNAMED_ACTION = UniqueString.uniqueStringOf((String)"UnnamedAction");
    public static final Action UNKNOWN = new Action(SemanticNode.nullSN, Context.Empty, UNNAMED_ACTION);
    public final SemanticNode pred;
    public final Context con;
    private final UniqueString actionName;
    private OpDefNode opDef = null;
    private int id;
    public CostModel cm = CostModel.DO_NOT_RECORD;

    public Action(SemanticNode pred, Context con) {
        this(pred, con, UNNAMED_ACTION);
    }

    private Action(SemanticNode pred, Context con, UniqueString actionName) {
        this.pred = pred;
        this.con = con;
        this.actionName = actionName;
    }

    public Action(SemanticNode pred, Context con, OpDefNode opDef) {
        this(pred, con, opDef != null ? opDef.getName() : UNNAMED_ACTION);
        this.opDef = opDef;
    }

    public final String toString() {
        return "<Action " + this.pred.toString() + ">";
    }

    public final String getLocation() {
        if (this.isNamed()) {
            return this.getLocation(this.actionName.toString());
        }
        return this.getLocation("Action");
    }

    public final String getLocation(String actionName) {
        return "<" + actionName + " " + this.pred.getLocation() + ">";
    }

    public final boolean isNamed() {
        return this.actionName != UNNAMED_ACTION && this.actionName != null && !"".equals(this.actionName.toString());
    }

    public final UniqueString getName() {
        return this.actionName;
    }

    public final OpDefNode getOpDef() {
        return this.opDef;
    }

    public final boolean isDeclared() {
        return this.getDeclaration() != Location.nullLoc;
    }

    public Location getDeclaration() {
        TreeNode tn;
        if (this.opDef != null && (tn = this.opDef.getTreeNode()) != null && tn.one() != null && tn.one().length >= 1) {
            TreeNode treeNode = tn.one()[0];
            assert (treeNode.isKind(366));
            return treeNode.getLocation();
        }
        return Location.nullLoc;
    }

    public final Location getDefinition() {
        return this.pred.getLocation();
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }
}

