/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.lang.reflect.Array;

public final class ObjLongTable<T> {
    private int count;
    private int length;
    private int thresh;
    private T[] keys;
    private long[] elems;

    public ObjLongTable(int size) {
        this.keys = new Object[size];
        this.elems = new long[size];
        this.count = 0;
        this.length = size;
        this.thresh = this.length / 2;
    }

    private final void grow() {
        T[] oldKeys = this.keys;
        long[] oldElems = this.elems;
        this.count = 0;
        this.length = 2 * this.length + 1;
        this.thresh = this.length / 2;
        this.keys = new Object[this.length];
        this.elems = new long[this.length];
        for (int i = 0; i < oldKeys.length; ++i) {
            T key = oldKeys[i];
            if (key == null) continue;
            this.put(key, oldElems[i]);
        }
    }

    public final int size() {
        return this.count;
    }

    public final int put(T k, long elem) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = (k.hashCode() & Integer.MAX_VALUE) % this.length;
        while (true) {
            T key;
            if ((key = this.keys[loc]) == null) {
                this.keys[loc] = k;
                this.elems[loc] = elem;
                ++this.count;
                return loc;
            }
            if (key.equals(k)) {
                this.elems[loc] = elem;
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final int add(T k, long elem) {
        if (this.count >= this.thresh) {
            this.grow();
        }
        int loc = (k.hashCode() & Integer.MAX_VALUE) % this.length;
        while (true) {
            T key;
            if ((key = this.keys[loc]) == null) {
                this.keys[loc] = k;
                this.elems[loc] = elem;
                ++this.count;
                return loc;
            }
            if (key.equals(k)) {
                int n = loc;
                this.elems[n] = this.elems[n] + elem;
                return loc;
            }
            loc = (loc + 1) % this.length;
        }
    }

    public final long get(Object k) {
        int loc = (k.hashCode() & Integer.MAX_VALUE) % this.length;
        T key;
        while ((key = this.keys[loc]) != null) {
            if (key.equals(k)) {
                return this.elems[loc];
            }
            loc = (loc + 1) % this.length;
        }
        return 0L;
    }

    public ObjLongTable<T> mergeInto(ObjLongTable<T> other) {
        T key;
        Enumerator<T> keys2 = other.keys();
        while ((key = keys2.nextElement()) != null) {
            this.add(key, other.get(key));
        }
        return this;
    }

    public T[] toArray(T[] a) {
        a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.count);
        Enumerator<T> keys2 = this.keys();
        Object e = null;
        int i = 0;
        while (true) {
            T t = keys2.nextElement();
            e = t;
            if (t == null) break;
            a[i++] = e;
        }
        return a;
    }

    public final Enumerator<T> keys() {
        return new Enumerator();
    }

    public final class Enumerator<T> {
        int index = 0;

        public final T nextElement() {
            while (this.index < ObjLongTable.this.keys.length) {
                if (ObjLongTable.this.keys[this.index] != null) {
                    return (T)ObjLongTable.this.keys[this.index++];
                }
                ++this.index;
            }
            return null;
        }
    }
}

