/*
 * Decompiled with CFR 0.152.
 */
package tlc2.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import tlc2.TraceExpressionExplorerSpecWriter;
import tlc2.input.AbstractMCOutputConsumer;
import tlc2.input.MCOutputMessage;
import tlc2.model.MCError;
import tlc2.model.MCState;

public class MCOutputParser
extends AbstractMCOutputConsumer {
    private final File mcOutFile;

    MCOutputParser(File outFile) {
        this.mcOutFile = outFile;
    }

    List<MCOutputMessage> parse(boolean returnAllMessages) throws IOException {
        ArrayList<MCOutputMessage> encounteredMessages = returnAllMessages ? new ArrayList<MCOutputMessage>() : null;
        try (BufferedReader br = new BufferedReader(new FileReader(this.mcOutFile));){
            MCOutputMessage message;
            while ((message = this.parseChunk(br)) != null) {
                if (returnAllMessages) {
                    encounteredMessages.add(message);
                }
                if (message.getType() == 1) {
                    this.consumeErrorMessageAndStates(br, message);
                    continue;
                }
                if (message.getCode() != 2186) continue;
                break;
            }
        }
        return encounteredMessages;
    }

    private static String getPrettyPrintForState(MCState state) {
        if (state.isStuttering()) {
            return "<Stuttering>";
        }
        if (state.isBackToState()) {
            return "<Back to state " + state.getStateNumber() + ">";
        }
        return state.getLabel();
    }

    public static void prettyPrintToStream(OutputStream os, File sourceDirectory, String specName) throws IOException {
        File outFile = new File(sourceDirectory, specName + ".out");
        MCOutputParser parser = new MCOutputParser(outFile);
        parser.parse(false);
        File tlaFile = new File(sourceDirectory, specName + ".tla");
        HashMap<String, String> variableTraceExpressionMap = TraceExpressionExplorerSpecWriter.getVariableExpressionMapFromTLAFile(tlaFile);
        MCOutputParser.prettyPrintToStream(os, parser.getError(), variableTraceExpressionMap);
    }

    public static void prettyPrintToStream(OutputStream os, MCError error) {
        MCOutputParser.prettyPrintToStream(os, error, null);
    }

    public static void prettyPrintToStream(OutputStream os, MCError error, HashMap<String, String> variableTraceExpressionMap) {
        PrintStream ps = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        if (error == null) {
            ps.println("The output log contained no error-state messages; there is nothing to display.");
        } else {
            if (variableTraceExpressionMap != null) {
                error.updateStatesForTraceExpression(variableTraceExpressionMap);
            }
            for (MCState state : error.getStates()) {
                ps.println(MCOutputParser.getPrettyPrintForState(state));
                ps.println(state.getConjunctiveDescription(true, "\t", true));
            }
        }
    }
}

