/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tlc2.output.MP;
import util.FileUtil;

public class ObjectPoolStack {
    private String filePrefix;
    private Object[] buf;
    private int hiPool;
    private boolean isIdle;
    private Reader reader;
    private Writer writer;
    private File poolFile;

    public ObjectPoolStack(int bufSize, String filePrefix) {
        this.filePrefix = filePrefix;
        this.buf = new Object[bufSize];
        this.hiPool = 0;
        this.isIdle = true;
        this.reader = new Reader();
        this.writer = new Writer();
        this.poolFile = null;
        this.reader.start();
        this.writer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] write(Object[] outBuf) throws IOException, InterruptedException {
        ObjectPoolStack objectPoolStack = this;
        synchronized (objectPoolStack) {
            while (!this.isIdle) {
                this.wait();
            }
        }
        Object[] res = this.buf;
        this.buf = outBuf;
        this.poolFile = new File(this.filePrefix + Integer.toString(this.hiPool++));
        this.isIdle = false;
        this.writer.notify();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] read(Object[] inBuf) throws IOException, InterruptedException {
        if (this.hiPool == 0) {
            return null;
        }
        ObjectPoolStack objectPoolStack = this;
        synchronized (objectPoolStack) {
            while (!this.isIdle) {
                this.wait();
            }
        }
        Object[] res = this.buf;
        this.buf = inBuf;
        --this.hiPool;
        if (this.hiPool > 0) {
            this.poolFile = new File(this.filePrefix + Integer.toString(this.hiPool - 1));
            this.isIdle = false;
            this.reader.notify();
        }
        return res;
    }

    public final synchronized void beginChkpt(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.hiPool);
    }

    public final void recover(ObjectInputStream ois) throws IOException {
        this.hiPool = ois.readInt();
        if (this.hiPool > 0) {
            this.poolFile = new File(this.filePrefix + Integer.toString(this.hiPool - 1));
            this.isIdle = false;
            this.reader.notify();
        }
    }

    class Writer
    extends Thread {
        Writer() {
        }

        @Override
        public void run() {
            try {
                Writer writer = this;
                synchronized (writer) {
                    while (true) {
                        if (ObjectPoolStack.this.poolFile == null) {
                            this.wait();
                            continue;
                        }
                        ObjectOutputStream oos = FileUtil.newOBFOS((File)ObjectPoolStack.this.poolFile);
                        for (int i = 0; i < ObjectPoolStack.this.buf.length; ++i) {
                            oos.writeObject(ObjectPoolStack.this.buf[i]);
                        }
                        oos.close();
                        ObjectPoolStack.this.poolFile = null;
                        ObjectPoolStack.this.isIdle = true;
                        ObjectPoolStack.this.notify();
                    }
                }
            }
            catch (Exception e) {
                MP.printError(2125, e);
                System.exit(1);
                return;
            }
        }
    }

    class Reader
    extends Thread {
        Reader() {
        }

        @Override
        public void run() {
            try {
                Reader reader = this;
                synchronized (reader) {
                    while (true) {
                        if (ObjectPoolStack.this.poolFile == null) {
                            this.wait();
                            continue;
                        }
                        ObjectInputStream ois = FileUtil.newOBFIS((File)ObjectPoolStack.this.poolFile);
                        for (int i = 0; i < ObjectPoolStack.this.buf.length; ++i) {
                            ((ObjectPoolStack)ObjectPoolStack.this).buf[i] = ois.readObject();
                        }
                        ois.close();
                        ObjectPoolStack.this.poolFile = null;
                        ObjectPoolStack.this.isIdle = true;
                        ObjectPoolStack.this.notify();
                    }
                }
            }
            catch (Exception e) {
                MP.printError(2127, e);
                System.exit(1);
                return;
            }
        }
    }
}

