/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public final class BufferedRandomAccessFile
extends RandomAccessFile {
    static final int LogBuffSz = 13;
    public static final int BuffSz = 8192;
    static final int BuffMask = -8192;
    private boolean dirty;
    private long curr;
    private long lo;
    private long hi;
    private byte[] buff;
    private long maxHi;
    private boolean hitEOF;
    private long diskPos;
    private long mark;
    private static final Object mu = new Object();
    private static byte[][] availBuffs = new byte[100][];
    private static int numAvailBuffs = 0;

    public BufferedRandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
        this.init();
    }

    public BufferedRandomAccessFile(String name, String mode) throws IOException {
        this(new File(name), mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.dirty = false;
        this.hi = 0L;
        this.curr = 0L;
        this.lo = 0L;
        Object object = mu;
        synchronized (object) {
            this.buff = numAvailBuffs > 0 ? availBuffs[--numAvailBuffs] : new byte[8192];
        }
        this.maxHi = 8192L;
        this.hitEOF = false;
        this.diskPos = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.flush();
        Object object = mu;
        synchronized (object) {
            if (numAvailBuffs >= availBuffs.length) {
                byte[][] newBuffs = new byte[numAvailBuffs + 10][];
                System.arraycopy(availBuffs, 0, newBuffs, 0, numAvailBuffs);
                availBuffs = newBuffs;
            }
            BufferedRandomAccessFile.availBuffs[BufferedRandomAccessFile.numAvailBuffs++] = this.buff;
        }
        super.close();
    }

    public void flush() throws IOException {
        this.flushBuffer();
    }

    private boolean flushBuffer() throws IOException {
        if (this.dirty) {
            if (this.diskPos != this.lo) {
                super.seek(this.lo);
            }
            int len = (int)(this.curr - this.lo);
            super.write(this.buff, 0, len);
            this.diskPos = this.curr;
            this.dirty = false;
            return true;
        }
        return false;
    }

    private int fillBuffer() throws IOException {
        int n;
        int cnt = 0;
        for (int rem = this.buff.length; rem > 0 && (n = super.read(this.buff, cnt, rem)) >= 0; rem -= n) {
            cnt += n;
        }
        this.hitEOF = cnt < this.buff.length;
        this.diskPos += (long)cnt;
        return cnt;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos >= this.hi || pos < this.lo) {
            this.flushBuffer();
            this.lo = pos & 0xFFFFFFFFFFFFE000L;
            this.maxHi = this.lo + (long)this.buff.length;
            if (this.diskPos != this.lo) {
                super.seek(this.lo);
                this.diskPos = this.lo;
            }
            int n = this.fillBuffer();
            this.hi = this.lo + (long)n;
        } else if (pos < this.curr) {
            this.flushBuffer();
        }
        this.curr = pos;
    }

    public boolean seeek(long pos) throws IOException {
        boolean pageReadNeeded = true;
        if (pos >= this.hi || pos < this.lo) {
            this.flushBuffer();
            this.lo = pos & 0xFFFFFFFFFFFFE000L;
            this.maxHi = this.lo + (long)this.buff.length;
            if (this.diskPos != this.lo) {
                super.seek(this.lo);
                this.diskPos = this.lo;
            }
            int n = this.fillBuffer();
            this.hi = this.lo + (long)n;
        } else {
            pageReadNeeded = pos < this.curr ? this.flushBuffer() : false;
        }
        this.curr = pos;
        return pageReadNeeded;
    }

    @Override
    public long getFilePointer() {
        return this.curr;
    }

    @Override
    public long length() throws IOException {
        return Math.max(this.curr, super.length());
    }

    @Override
    public int read() throws IOException {
        if (this.curr == this.hi) {
            if (this.hitEOF) {
                return -1;
            }
            this.seek(this.curr);
            if (this.curr == this.hi) {
                return -1;
            }
        }
        try {
            byte res = this.buff[(int)(this.curr - this.lo)];
            ++this.curr;
            return res & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Read past end of file (increase with setLength)?", e);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.curr == this.hi) {
            if (this.hitEOF) {
                return -1;
            }
            this.seek(this.curr);
            if (this.curr == this.hi) {
                return -1;
            }
        }
        len = Math.min(len, (int)(this.hi - this.curr));
        int buffOff = (int)(this.curr - this.lo);
        System.arraycopy(this.buff, buffOff, b, off, len);
        this.curr += (long)len;
        return len;
    }

    public BigInteger readBigInteger(int size) throws IOException {
        byte[] b = new byte[size];
        return new BigInteger(b);
    }

    public final int readShortNat() throws IOException {
        int res = this.readByte();
        if (res >= 0) {
            return res;
        }
        res = res << 16 | this.readByte() & 0xFF;
        return -res;
    }

    public final int readNat() throws IOException {
        int res = this.readShort();
        if (res >= 0) {
            return res;
        }
        res = res << 16 | this.readShort() & 0xFFFF;
        return -res;
    }

    public final long readLongNat() throws IOException {
        long res = this.readInt();
        if (res >= 0L) {
            return res;
        }
        res = res << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        return -res;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.curr == this.hi) {
            if (this.hitEOF && this.hi < this.maxHi) {
                ++this.hi;
            } else {
                this.seek(this.curr);
                if (this.curr == this.hi) {
                    ++this.hi;
                }
            }
        }
        try {
            this.buff[(int)(this.curr - this.lo)] = (byte)b;
            ++this.curr;
            this.dirty = true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Wrote past end of file (increase with setLength)?", e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int n = this.writeAtMost(b, off, len);
            off += n;
            len -= n;
        }
        this.dirty = true;
    }

    public void writeBigInteger(BigInteger bi, int size) throws IOException {
        byte[] b = bi.toByteArray();
        this.write(b, 0, size);
    }

    public final void writeShortNat(int x) throws IOException {
        if (x <= 127) {
            this.writeByte((short)x);
        } else {
            this.writeShort(-x);
        }
    }

    public final void writeNat(int x) throws IOException {
        if (x <= Short.MAX_VALUE) {
            this.writeShort((short)x);
        } else {
            this.writeInt(-x);
        }
    }

    public final void writeLongNat(long x) throws IOException {
        if (x <= Integer.MAX_VALUE) {
            this.writeInt((int)x);
        } else {
            this.writeLong(-x);
        }
    }

    private int writeAtMost(byte[] b, int off, int len) throws IOException {
        if (this.curr == this.hi) {
            if (this.hitEOF && this.hi < this.maxHi) {
                this.hi = this.maxHi;
            } else {
                this.seek(this.curr);
                if (this.curr == this.hi) {
                    this.hi = this.maxHi;
                }
            }
        }
        len = Math.min(len, (int)(this.hi - this.curr));
        int buffOff = (int)(this.curr - this.lo);
        System.arraycopy(b, off, this.buff, buffOff, len);
        this.curr += (long)len;
        return len;
    }

    public void reset() throws IOException {
        this.setLength(0L);
        this.init();
    }

    public long getMark() {
        return this.mark;
    }

    public long mark() {
        long oldMark = this.mark;
        this.mark = this.getFilePointer();
        return oldMark;
    }

    public void seekAndMark(long pos) throws IOException {
        this.mark = pos;
        this.seek(pos);
    }

    public static void main(String[] args) throws IOException {
        String name = "xxx";
        String mode = "rw";
        BufferedRandomAccessFile braf = new BufferedRandomAccessFile(name, mode);
        int x = 100;
        braf.writeLong(x);
        braf.writeLong(x);
        braf.writeLong(x);
        System.err.println("len = " + braf.length() + ", pos = " + braf.getFilePointer());
        braf.close();
        braf = new BufferedRandomAccessFile(name, mode);
        System.err.println("len = " + braf.length() + ", pos = " + braf.getFilePointer());
        braf.seek(braf.length());
        System.err.println("len = " + braf.length() + ", pos = " + braf.getFilePointer());
        braf.writeLong(x);
        braf.writeLong(x);
        braf.writeLong(x);
        System.err.println("len = " + braf.length() + ", pos = " + braf.getFilePointer());
        braf.close();
    }
}

