/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import tlc2.TLCGlobals;
import tlc2.model.MCError;
import tlc2.model.MCState;
import tlc2.output.ErrorTraceMessagePrinterRecorder;
import tlc2.output.MP;
import tlc2.output.SpecTraceExpressionWriter;
import tlc2.tool.Defns;
import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.impl.ModelConfig;
import tlc2.value.impl.ModelValue;

public class TraceExplorationSpec {
    private final ErrorTraceMessagePrinterRecorder recorder;
    private final Path outputPath;
    private final String originalModuleName;
    private final String teSpecModuleName;

    public TraceExplorationSpec(Path output, Date timestamp, String originalModuleName, ErrorTraceMessagePrinterRecorder recorder) {
        this.outputPath = output;
        this.teSpecModuleName = TraceExplorationSpec.deriveTESpecModuleName(originalModuleName, timestamp);
        this.originalModuleName = originalModuleName;
        this.recorder = recorder;
    }

    public TraceExplorationSpec(Path output, String teModuleName, String originalModuleName, ErrorTraceMessagePrinterRecorder recorder) {
        this.outputPath = output;
        this.teSpecModuleName = teModuleName;
        this.originalModuleName = originalModuleName;
        this.recorder = recorder;
    }

    public void generate(ITool specInfo) {
        if (this.recorder.getMCErrorTrace().isEmpty()) {
            return;
        }
        MCError errorTrace = this.recorder.getMCErrorTrace().get();
        if (errorTrace.getStates().size() <= 1 || TLCGlobals.mainChecker != null && TLCGlobals.mainChecker.isRecovery()) {
            return;
        }
        List<String> variables = Arrays.asList(TLCState.Empty.getVarsAsStrings());
        this.outputPath.toFile().mkdirs();
        Path teSpecPath = this.outputPath.resolve(this.teSpecModuleName + ".tla");
        try (FileOutputStream tlaStream = new FileOutputStream(teSpecPath.toFile());){
            this.writeSpecTEStreams(this.teSpecModuleName, this.originalModuleName, specInfo.getModelConfig(), variables, errorTrace, specInfo, tlaStream);
            MP.printMessage(2501, teSpecPath.toString());
        }
        catch (IOException | SecurityException e) {
            MP.printMessage(2502, e.getMessage());
        }
    }

    private void writeSpecTEStreams(String teSpecModuleName, String originalSpecName, ModelConfig modelConfig, List<String> variables, MCError error, ITool specInfo, OutputStream specTETLAOutStream) throws IOException {
        String modelValuesAsConstants;
        List<MCState> trace = error.getStates();
        SpecTraceExpressionWriter writer = new SpecTraceExpressionWriter();
        List<List<String>> constants = modelConfig.getConstantsAsList();
        ModelValue.setValues();
        Set declaredConstantNames = constants.stream().map(l -> (String)l.get(0)).collect(Collectors.toSet());
        HashSet<ModelValue> reifiedConstants = new HashSet<ModelValue>();
        reifiedConstants.addAll(Arrays.asList(ModelValue.mvs));
        reifiedConstants.stream().filter(m -> !declaredConstantNames.contains(m.toString())).collect(Collectors.toSet());
        ArrayList<String> indentedConstants = new ArrayList<String>();
        for (List<String> keyValuePair : constants) {
            if (keyValuePair.size() > 1) {
                String key = keyValuePair.get(0).toString();
                String value = keyValuePair.get(1).toString();
                indentedConstants.add(SpecTraceExpressionWriter.indentString(String.format("%s = %s", key, value), 1));
                continue;
            }
            ModelValue[] line = keyValuePair.get(0).toString();
            indentedConstants.add(SpecTraceExpressionWriter.indentString((String)line, 1));
        }
        for (ModelValue mv : reifiedConstants) {
            indentedConstants.add(SpecTraceExpressionWriter.indentString(String.format("%s = %s", mv, mv), 1));
        }
        if (error.isLasso()) {
            indentedConstants.add("_TTraceLassoStart = " + trace.get(trace.size() - 1).getStateNumber());
            indentedConstants.add("_TTraceLassoEnd = " + (trace.size() - 1));
        }
        writer.addConstants(indentedConstants);
        Defns defns = specInfo.getSpecProcessor().getDefns();
        ArrayList<String> modConstants = new ArrayList<String>();
        for (ModelValue mv : ModelValue.mvs) {
            if (defns.get(mv.toString()) != null) continue;
            modConstants.add(mv.toString());
        }
        if (error.isLasso()) {
            modConstants.add("_TTraceLassoStart");
            modConstants.add("_TTraceLassoEnd");
        }
        String teConstantSpecName = String.format("%s_%s", originalSpecName, "TEConstants");
        HashSet<String> teConstantModuleHashSet = new HashSet<String>();
        teConstantModuleHashSet.add("TLC");
        if (!modConstants.isEmpty()) {
            teConstantModuleHashSet.add(teConstantSpecName);
            modelValuesAsConstants = String.format("CONSTANTS %s\n", String.join((CharSequence)", ", modConstants));
        } else {
            modelValuesAsConstants = "";
        }
        HashSet<String> specTEExtendedModules = new HashSet<String>();
        specTEExtendedModules.add("Toolbox");
        specTEExtendedModules.add("TLCExt");
        specTEExtendedModules.add("Naturals");
        specTEExtendedModules.add("Sequences");
        specTEExtendedModules.addAll(teConstantModuleHashSet);
        writer.addPrimer(teSpecModuleName, originalSpecName, specTEExtendedModules);
        writer.addTraceExpressionInstance(String.format("%s_%s", originalSpecName, "TEExpression"));
        String teTraceName = String.format("%s_%s", originalSpecName, "TETrace");
        writer.addTraceFunctionInstance(teTraceName);
        writer.addProperties(trace, originalSpecName);
        writer.addInitNextTraceFunction(trace, teSpecModuleName, variables, modelConfig);
        if (error.isLassoWithDuplicates()) {
            writer.addView(String.join((CharSequence)", ", variables));
        }
        writer.addFooter();
        writer.append("\n");
        SpecTraceExpressionWriter te = new SpecTraceExpressionWriter();
        String teModuleName = String.format("%s_%s", originalSpecName, "TEExpression");
        te.append("\n");
        writer.append(String.format(" Note that you can extract this module `%s`", teModuleName)).append("\n");
        writer.append("  to a dedicated file to reuse `expression` (the module in the ").append("\n");
        writer.append(String.format("  dedicated `%s.tla` file takes precedence ", teModuleName)).append("\n");
        writer.append(String.format("  over the module `BlockingQueue_TEExpression` below).", teModuleName));
        te.addPrimer(teModuleName, originalSpecName, specTEExtendedModules);
        te.addTraceExpressionStub(originalSpecName, "expression", variables);
        te.addFooter();
        writer.append("\n" + te.toString() + "\n" + "\n");
        writer.append("\n");
        writer.append("Parsing and semantic processing can take forever if the trace below is long.").append("\n");
        writer.append(" In this case, it is advised to deserialize the trace from a binary file.").append("\n");
        writer.append(" To create the file, replace your spec's invariant F with:").append("\n");
        writer.append("  Inv == IF F THEN TRUE ELSE ~IOSerialize(Trace, \"file.bin\", TRUE)").append("\n");
        writer.append(" (IOUtils module is from https://modules.tlapl.us/)");
        HashSet<String> extendedModulesWithIOUtils = new HashSet<String>();
        extendedModulesWithIOUtils.add("IOUtils");
        extendedModulesWithIOUtils.addAll(teConstantModuleHashSet);
        SpecTraceExpressionWriter w = new SpecTraceExpressionWriter();
        w.append("\n");
        w.addPrimer(teTraceName, originalSpecName, extendedModulesWithIOUtils);
        w.append("trace").append(" == ").append("IODeserialize(\"file.bin\", TRUE)\n\n");
        w.addFooter();
        writer.append("\n" + w.getComment() + "\n" + "\n");
        HashSet<String> teTraceExtendedModules = new HashSet<String>();
        teTraceExtendedModules.addAll(teConstantModuleHashSet);
        writer.addPrimer(teTraceName, originalSpecName, teTraceExtendedModules);
        writer.addTraceFunction(trace, "trace", "_trace");
        writer.addAliasToCfg("_expression");
        if (modelValuesAsConstants != "") {
            writer.addFooter();
            writer.append("\n");
            writer.addPrimer(teConstantSpecName, originalSpecName);
            writer.append(modelValuesAsConstants).append("\n");
        }
        writer.wrapConfig(teSpecModuleName);
        writer.writeStreams(specTETLAOutStream, specTETLAOutStream);
    }

    public static String teModuleId(Date timestamp) {
        long secondsSinceEpoch = timestamp.getTime() / 1000L;
        return Long.toString(secondsSinceEpoch);
    }

    public static String deriveTESpecModuleName(String ogModuleName, Date timestamp) {
        return String.format("%s_%s_%s", ogModuleName, "TTrace", TraceExplorationSpec.teModuleId(timestamp));
    }

    public static boolean isTESpecFile(String tlaFilePath) {
        if (null == tlaFilePath) {
            return false;
        }
        try {
            String filename = Paths.get(tlaFilePath, new String[0]).getFileName().toString();
            return filename.matches("^.*_TTrace.*(.tla)?$");
        }
        catch (InvalidPathException e) {
            return false;
        }
    }
}

