/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.ITool;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.LNBool;
import tlc2.tool.liveness.LNDisj;
import tlc2.tool.liveness.LiveExprNode;
import tlc2.tool.liveness.TBPar;
import tlc2.util.Vect;

class LNConj
extends LiveExprNode {
    private final Vect<LiveExprNode> conjs;
    private int info;

    public LNConj(int size) {
        this.conjs = new Vect(size);
        this.info = 0;
    }

    public LNConj(LiveExprNode n) {
        this.conjs = new Vect(1);
        this.conjs.addElement(n);
        int level = n.getLevel();
        this.info = n.containAction() ? level + 8 : level;
    }

    public LNConj(LiveExprNode n1, LiveExprNode n2) {
        this.conjs = new Vect(2);
        this.conjs.addElement(n1);
        this.conjs.addElement(n2);
        boolean hasAct = n1.containAction() || n2.containAction();
        int level = Math.max(n1.getLevel(), n2.getLevel());
        this.info = hasAct ? level + 8 : level;
    }

    public LNConj(Vect<LiveExprNode> conjs) {
        this.conjs = conjs;
        boolean hasAct = false;
        int level = 0;
        for (int i = 0; i < conjs.size(); ++i) {
            LiveExprNode lexpr = conjs.elementAt(i);
            level = Math.max(level, lexpr.getLevel());
            hasAct = hasAct || lexpr.containAction();
        }
        this.info = hasAct ? level + 8 : level;
    }

    public final int getCount() {
        return this.conjs.size();
    }

    public final LiveExprNode getBody(int i) {
        return this.conjs.elementAt(i);
    }

    public final void addConj(LiveExprNode elem) {
        if (elem instanceof LNConj) {
            LNConj elem1 = (LNConj)elem;
            for (int i = 0; i < elem1.getCount(); ++i) {
                this.addConj(elem1.getBody(i));
            }
        } else {
            this.conjs.addElement(elem);
        }
        int level = Math.max(this.getLevel(), elem.getLevel());
        boolean hasAct = this.containAction() || elem.containAction();
        this.info = hasAct ? level + 8 : level;
    }

    @Override
    public final int getLevel() {
        return this.info & 7;
    }

    @Override
    public final boolean containAction() {
        return (this.info & 8) > 0;
    }

    @Override
    public final boolean isPositiveForm() {
        for (int i = 0; i < this.conjs.size(); ++i) {
            LiveExprNode lexpr = this.conjs.elementAt(i);
            if (lexpr.isPositiveForm()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean eval(ITool tool, TLCState s1, TLCState s2) {
        int sz = this.conjs.size();
        for (int i = 0; i < sz; ++i) {
            LiveExprNode item = this.conjs.elementAt(i);
            if (item.eval(tool, s1, s2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void toString(StringBuffer sb, String padding) {
        int len = this.getCount();
        String padding1 = padding + "    ";
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                sb.append(padding);
            }
            sb.append("/\\ (");
            this.getBody(i).toString(sb, padding1);
            sb.append(")");
            if (i == len - 1) continue;
            sb.append("\n");
        }
    }

    @Override
    public String toDotViz() {
        int len = this.getCount();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append("/\\ (");
            sb.append(this.getBody(i).toDotViz());
            sb.append(")");
            if (i == len - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void extractPromises(TBPar promises) {
        this.getBody(0).extractPromises(promises);
        this.getBody(1).extractPromises(promises);
    }

    @Override
    public int tagExpr(int tag) {
        for (int i = 0; i < this.getCount(); ++i) {
            tag = this.getBody(i).tagExpr(tag);
        }
        return tag;
    }

    @Override
    public final LiveExprNode makeBinary() {
        if (this.getCount() == 1) {
            return this.getBody(0).makeBinary();
        }
        int mid = this.getCount() / 2;
        LNConj left = new LNConj(0);
        LNConj right = new LNConj(0);
        for (int i = 0; i < this.getCount(); ++i) {
            if (i < mid) {
                left.addConj(this.getBody(i));
                continue;
            }
            right.addConj(this.getBody(i));
        }
        return new LNConj(left.makeBinary(), right.makeBinary());
    }

    @Override
    public LiveExprNode flattenSingleJunctions() {
        if (this.getCount() == 1) {
            return this.getBody(0).flattenSingleJunctions();
        }
        LNConj lnc2 = new LNConj(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            lnc2.addConj(this.getBody(i).flattenSingleJunctions());
        }
        return lnc2;
    }

    @Override
    public final LiveExprNode toDNF() {
        int count = this.getCount();
        LiveExprNode[] temp = new LiveExprNode[count];
        for (int i = 0; i < count; ++i) {
            temp[i] = this.getBody(i).toDNF();
        }
        Vect<LiveExprNode> nes = new Vect<LiveExprNode>(count);
        int total = 1;
        for (int i = 0; i < count; ++i) {
            LiveExprNode elem = temp[i];
            if (elem instanceof LNDisj) {
                nes.addElement(elem);
                total *= ((LNDisj)elem).getCount();
                continue;
            }
            if (elem instanceof LNConj) {
                LNConj elem1 = (LNConj)elem;
                int count1 = elem1.getCount();
                for (int j = 0; j < count1; ++j) {
                    nes.addElement(elem1.getBody(j));
                }
                continue;
            }
            nes.addElement(elem);
        }
        if (total == 1) {
            return new LNConj(nes);
        }
        int nesSize = nes.size();
        Vect<LiveExprNode> res = new Vect<LiveExprNode>(total);
        for (int i = 0; i < total; ++i) {
            res.addElement(new LNConj(nesSize));
        }
        int num = 1;
        int rCount = total;
        for (int i = 0; i < nesSize; ++i) {
            LiveExprNode ln = nes.elementAt(i);
            if (ln instanceof LNDisj) {
                LNDisj disj = (LNDisj)ln;
                rCount /= disj.getCount();
                int idx = 0;
                for (int j = 0; j < num; ++j) {
                    for (int k = 0; k < disj.getCount(); ++k) {
                        LiveExprNode elem = disj.getBody(k);
                        for (int l = 0; l < rCount; ++l) {
                            ((LNConj)res.elementAt(idx++)).addConj(elem);
                        }
                    }
                }
                num *= disj.getCount();
                continue;
            }
            for (int j = 0; j < total; ++j) {
                ((LNConj)res.elementAt(j)).addConj(ln);
            }
        }
        return new LNDisj(res);
    }

    @Override
    public LiveExprNode simplify() {
        LNConj lnc1 = new LNConj(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            LiveExprNode elem = this.getBody(i).simplify();
            if (elem instanceof LNBool) {
                if (((LNBool)elem).b) continue;
                return LNBool.FALSE;
            }
            lnc1.addConj(elem);
        }
        if (lnc1.getCount() == 0) {
            return LNBool.TRUE;
        }
        if (lnc1.getCount() == 1) {
            return lnc1.getBody(0);
        }
        return lnc1;
    }

    @Override
    public boolean isGeneralTF() {
        for (int i = 0; i < this.getCount(); ++i) {
            if (this.getBody(i).isGeneralTF()) continue;
            return false;
        }
        return super.isGeneralTF();
    }

    @Override
    public LiveExprNode pushNeg() {
        LNDisj lnd = new LNDisj(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            lnd.addDisj(this.getBody(i).pushNeg());
        }
        return lnd;
    }

    @Override
    public LiveExprNode pushNeg(boolean hasNeg) {
        if (hasNeg) {
            LNDisj lnd = new LNDisj(this.getCount());
            for (int i = 0; i < this.getCount(); ++i) {
                lnd.addDisj(this.getBody(i).pushNeg(true));
            }
            return lnd;
        }
        LNConj lnc1 = new LNConj(this.getCount());
        for (int i = 0; i < this.getCount(); ++i) {
            lnc1.addConj(this.getBody(i).pushNeg(false));
        }
        return lnc1;
    }

    @Override
    public boolean equals(LiveExprNode exp) {
        if (exp instanceof LNConj) {
            LNConj exp2 = (LNConj)exp;
            if (this.getCount() != exp2.getCount()) {
                return false;
            }
            for (int i = 0; i < this.getCount(); ++i) {
                if (this.getBody(i).equals(exp2.getBody(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

