/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import tlc2.tool.EvalException;
import tlc2.tool.impl.TLARegistry;
import tlc2.value.IBoolValue;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.Applicable;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.OpLambdaValue;
import tlc2.value.impl.OpRcdValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.UserObj;
import tlc2.value.impl.UserValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueVec;
import util.Assert;
import util.UniqueString;

public class Sequences
extends UserObj
implements ValueConstants {
    public static final long serialVersionUID = 20160822L;
    private Value range;
    private int size;

    public Sequences(Value range, int size) {
        this.range = range;
        this.size = size;
    }

    public static Value Seq(Value range) {
        Sequences obj = new Sequences(range, Integer.MAX_VALUE);
        return new UserValue(obj);
    }

    public static IntValue Len(Value s) {
        if (s instanceof StringValue) {
            return IntValue.gen(((StringValue)s).length());
        }
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq != null) {
            return IntValue.gen(seq.size());
        }
        throw new EvalException(2283, new String[]{"Len", "sequence", Values.ppr(s.toString())});
    }

    public static Value Head(Value s) {
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq != null) {
            if (seq.size() == 0) {
                throw new EvalException(2184, "Head");
            }
            return seq.elems[0];
        }
        throw new EvalException(2283, new String[]{"Head", "sequence", Values.ppr(s.toString())});
    }

    public static Value Tail(Value s) {
        if (s instanceof StringValue) {
            String str = ((StringValue)s).val.toString();
            if (str.equals("")) {
                throw new EvalException(2184, "Tail");
            }
            return new StringValue(str.substring(1));
        }
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq != null) {
            if (seq.size() == 0) {
                throw new EvalException(2184, "Tail");
            }
            int len = seq.size();
            Value[] vals = new Value[len - 1];
            System.arraycopy(seq.elems, 1, vals, 0, vals.length);
            return new TupleValue(vals);
        }
        throw new EvalException(2283, new String[]{"Tail", "sequence", Values.ppr(s.toString())});
    }

    public static Value Cons(Value v, Value s) {
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq == null) {
            throw new EvalException(2182, new String[]{"Cons(v, s)", "sequence", Values.ppr(s.toString())});
        }
        int len = seq.size();
        Value[] values = new Value[len + 1];
        values[0] = v;
        System.arraycopy(seq.elems, 0, values, 1, len);
        return new TupleValue(values);
    }

    public static Value Append(Value s, Value v) {
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq == null) {
            throw new EvalException(2182, new String[]{"Append(s, v)", "sequence", Values.ppr(s.toString())});
        }
        int len = seq.size();
        Value[] values = new Value[len + 1];
        System.arraycopy(seq.elems, 0, values, 0, len);
        values[len] = v;
        return new TupleValue(values);
    }

    public static Value Concat(Value s1, Value s2) {
        int i;
        if (s1 instanceof StringValue) {
            if (!(s2 instanceof StringValue)) {
                throw new EvalException(2182, new String[]{"t \\o s", "string", Values.ppr(s2.toString())});
            }
            UniqueString u1 = ((StringValue)s1).val;
            UniqueString u2 = ((StringValue)s2).val;
            return new StringValue(u1.concat(u2));
        }
        TupleValue seq1 = (TupleValue)s1.toTuple();
        if (seq1 == null) {
            throw new EvalException(2182, new String[]{"s \\o t", "sequence", Values.ppr(s1.toString())});
        }
        TupleValue seq2 = (TupleValue)s2.toTuple();
        if (seq2 == null) {
            throw new EvalException(2182, new String[]{"t \\o s", "sequence", Values.ppr(s2.toString())});
        }
        int len1 = seq1.size();
        int len2 = seq2.size();
        if (len1 == 0) {
            return seq2;
        }
        if (len2 == 0) {
            return seq1;
        }
        Value[] values = new Value[len1 + len2];
        for (i = 0; i < len1; ++i) {
            values[i] = seq1.elems[i];
        }
        for (i = 0; i < len2; ++i) {
            values[i + len1] = seq2.elems[i];
        }
        return new TupleValue(values);
    }

    public static Value SelectInSeq(Value s, Value test) {
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq == null) {
            throw new EvalException(2169, new String[]{"first", "SelectInSeq", "sequence", Values.ppr(s.toString())});
        }
        if (!(test instanceof Applicable)) {
            throw new EvalException(2169, new String[]{"second", "SelectInSeq", "function", Values.ppr(test.toString())});
        }
        int len = seq.size();
        Applicable ftest = (Applicable)((Object)test);
        Value[] args = new Value[1];
        for (int i = 0; i < len; ++i) {
            args[0] = seq.elems[i];
            Value val = ftest.apply(args, 0);
            if (!(val instanceof IBoolValue)) {
                throw new EvalException(2169, new String[]{"second", "SelectInSeq", "boolean-valued function", Values.ppr(test.toString())});
            }
            if (!((BoolValue)val).val) continue;
            return IntValue.gen(i + 1);
        }
        return IntValue.ValZero;
    }

    public static Value SubSeq(Value s, Value m, Value n) {
        boolean isString = false;
        String str = null;
        TupleValue seq = null;
        if (s instanceof StringValue) {
            str = ((StringValue)s).val.toString();
            isString = true;
        }
        if (!isString && (seq = (TupleValue)s.toTuple()) == null) {
            throw new EvalException(2169, new String[]{"first", "SubSeq", "sequence", Values.ppr(s.toString())});
        }
        if (!(m instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"second", "SubSeq", "natural number", Values.ppr(m.toString())});
        }
        if (!(n instanceof IntValue)) {
            throw new EvalException(2169, new String[]{"third", "SubSeq", "natural number", Values.ppr(n.toString())});
        }
        int beg = ((IntValue)m).val;
        int end = ((IntValue)n).val;
        if (beg > end) {
            if (isString) {
                return new StringValue("");
            }
            return TupleValue.EmptyTuple;
        }
        int len = isString ? str.length() : seq.size();
        int sublen = end - beg + 1;
        if (beg < 1 || beg > len) {
            throw new EvalException(2183, new String[]{"second", "SubSeq", "first", Values.ppr(s.toString()), Values.ppr(m.toString())});
        }
        if (end < 1 || end > len) {
            throw new EvalException(2183, new String[]{"third", "SubSeq", "first", Values.ppr(s.toString()), Values.ppr(n.toString())});
        }
        if (isString) {
            return new StringValue(str.substring(beg - 1, end));
        }
        Value[] elems = new Value[sublen];
        for (int i = 0; i < sublen; ++i) {
            elems[i] = seq.elems[beg + i - 1];
        }
        return new TupleValue(elems);
    }

    public static Value SelectSeq(Value s, Value test) {
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq == null) {
            throw new EvalException(2169, new String[]{"first", "SelectSeq", "sequence", Values.ppr(s.toString())});
        }
        int len = seq.size();
        if (len == 0) {
            return TupleValue.EmptyTuple;
        }
        if (!(test instanceof OpLambdaValue) && !(test instanceof OpRcdValue)) {
            throw new EvalException(2169, new String[]{"second", "SelectSeq", "operator", Values.ppr(test.toString())});
        }
        ValueVec vals = new ValueVec();
        Applicable ftest = (Applicable)((Object)test);
        Value[] args = new Value[1];
        for (int i = 0; i < len; ++i) {
            args[0] = seq.elems[i];
            Value val = ftest.apply(args, 0);
            if (val instanceof IBoolValue) {
                if (!((BoolValue)val).val) continue;
                vals.addElement(args[0]);
                continue;
            }
            throw new EvalException(2169, new String[]{"second", "SelectSeq", "boolean-valued operator", Values.ppr(test.toString())});
        }
        Value[] elems = new Value[vals.size()];
        for (int i = 0; i < elems.length; ++i) {
            elems[i] = vals.elementAt(i);
        }
        return new TupleValue(elems);
    }

    @Override
    public final int compareTo(Value s) {
        if (s instanceof UserValue && ((UserValue)s).userObj instanceof Sequences) {
            Sequences seq = (Sequences)((UserValue)s).userObj;
            int cmp = this.size - seq.size;
            if (cmp == 0) {
                cmp = this.range.compareTo(seq.range);
            }
            return cmp;
        }
        if (s instanceof ModelValue) {
            return 1;
        }
        throw new EvalException(2155, new String[]{Values.ppr(this.toString()), Values.ppr(s.toString())});
    }

    @Override
    public final boolean member(Value s) {
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq == null) {
            if (s instanceof ModelValue) {
                return ((ModelValue)s).modelValueMember(this);
            }
            throw new EvalException(2158, new String[]{Values.ppr(s.toString()), Values.ppr(this.toString())});
        }
        int len = seq.size();
        if (len > this.size) {
            return false;
        }
        for (int i = 0; i < seq.elems.length; ++i) {
            if (this.range.member(seq.elems[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isFinite() {
        return this.size != Integer.MAX_VALUE;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        if (this.size == Integer.MAX_VALUE) {
            sb = sb.append("Seq(");
            sb = this.range.toString(sb, offset, swallow);
            sb = sb.append(")");
        } else {
            sb = sb.append("BSeq(");
            sb = this.range.toString(sb, offset, swallow);
            sb = sb.append(", ");
            sb = sb.append(this.size);
            sb = sb.append(")");
        }
        return sb;
    }

    public static Value Insert(Value s, Value v, Value test) {
        int idx;
        TupleValue seq = (TupleValue)s.toTuple();
        if (seq == null) {
            throw new EvalException(2169, new String[]{"first", "Insert", "sequence", Values.ppr(s.toString())});
        }
        if (!(test instanceof Applicable)) {
            throw new EvalException(2169, new String[]{"second", "SubSeq", "function", Values.ppr(test.toString())});
        }
        int len = seq.size();
        Applicable ftest = (Applicable)((Object)test);
        Value[] args = new Value[2];
        args[0] = v;
        Value[] values = new Value[len + 1];
        for (idx = len; idx > 0; --idx) {
            args[1] = seq.elems[idx - 1];
            Value val = ftest.apply(args, 0);
            if (!(val instanceof IBoolValue)) {
                throw new EvalException(2169, new String[]{"third", "Insert", "boolean-valued operator", Values.ppr(test.toString())});
            }
            if (((BoolValue)val).val && v.compareTo(args[1]) < 0) {
                values[idx] = args[1];
                continue;
            }
            values[idx] = v;
            break;
        }
        if (idx == 0) {
            values[0] = v;
        } else {
            for (int i = idx - 1; i >= 0; --i) {
                values[i] = seq.elems[i];
            }
        }
        return new TupleValue(values);
    }

    static {
        Assert.check((TLARegistry.put("Concat", "\\o") == null ? 1 : 0) != 0, (int)2131, (String)"Concat");
    }
}

