/*
contributors: Patricio Gonzalez Vivo
description: extend GLSL min function to add more arguments
use: 
  - min(<float> A, <float> B, <float> C[, <float> D])
  - min(<vec2|vec3|vec4> A)
*/

#ifndef FNC_MMIN
#define FNC_MMIN

float mmin(const float v) { return v; }
float mmin(in float a, in float b) { return min(a, b); }
float mmin(in float a, in float b, in float c) { return min(a, min(b, c)); }
float mmin(in float a, in float b, in float c, in float d) { return min(min(a,b), min(c, d)); }

float mmin(const vec2 v) { return min(v.x, v.y); }
float mmin(const vec3 v) { return mmin(v.x, v.y, v.z); }
float mmin(const vec4 v) { return mmin(v.x, v.y, v.z, v.w); }

#endif
