(ns vybe.nrepl
  "Inspired by (or fork of) https://github.com/djblue/portal/blob/master/src/portal/nrepl.clj"
  (:require [clojure.datafy :as d]
            [clojure.main :as main]
            [clojure.test :as test]
            [nrepl.middleware :refer [set-descriptor!]]
            [nrepl.middleware.caught :as caught]
            [nrepl.middleware.print :as print]
            [nrepl.misc :refer (response-for)]
            [nrepl.transport :as transport]
            [vybe.blender :as vb])
  (:import [java.util Date]
           [nrepl.transport Transport]))

(def ^:no-doc ^:dynamic *vybe-ns* nil)
(def ^:no-doc ^:dynamic *vybe-session* nil)

(defn- -wrap-blender-repl
  [handler {:keys [op session transport] :as msg}]
  (when (and (= "eval" op)
             (not (contains? @session #'*vybe-session*)))
    (swap! session assoc
           #'*vybe-session* nil
           #'vb/*nrepl-init*   (fn [portal]
                                (set! *vybe-session* portal)
                                (println "To quit, type:" :cljs/quit)
                                [:repl portal])))

  (def op op)
  #_(println (:code msg))
  #_(def msg msg)
  (handler msg))
(+ 23 3)

(defn wrap-blender-repl
  [handler]
  (partial #'-wrap-blender-repl handler))

(set-descriptor! #'wrap-blender-repl
                 {:requires #{"clone" #'print/wrap-print #'caught/wrap-caught}
                  :expects #{"eval"}
                  :handles {}})

(def middleware
  [`wrap-blender-repl])
