/*
contributors: Patricio Gonzalez Vivo
description: 'Sanzo Wada''s color palette from ["A Dictionary of Color Combinations"](https://sanzo-wada.dmbk.io/)'
use:
    - <vec3> wada (<int> index)
    - <vec4> wadaCMYK (<int> index)
examples:
    - https://raw.githubusercontent.com/patriciogonzalezvivo/lygia_examples/main/color_wada.frag
license:
    - Copyright (c) 2021 Patricio Gonzalez Vivo under Prosperity License - https://prosperitylicense.com/versions/3.0.0
    - Copyright (c) 2021 Patricio Gonzalez Vivo under Patron License - https://lygia.xyz/license
*/

#ifndef WADA_TOTAL
#define WADA_TOTAL 157
#endif

#ifndef WADA_HERMOSA_PINK
#define WADA_HERMOSA_PINK vec3(1.000, 0.702, 0.941)
#endif
#ifndef HERMOSA_PINK
#define HERMOSA_PINK WADA_HERMOSA_PINK
#endif
#ifndef WADA_HERMOSA_PINK_CMYK
#define WADA_HERMOSA_PINK_CMYK vec4(0.000, 0.300, 0.060, 0.000)
#endif
#ifndef HERMOSA_PINK_CMYK
#define HERMOSA_PINK_CMYK WADA_HERMOSA_PINK_CMYK
#endif

#ifndef WADA_CORINTHIAN_PINK
#define WADA_CORINTHIAN_PINK vec3(1.000, 0.651, 0.851)
#endif
#ifndef CORINTHIAN_PINK
#define CORINTHIAN_PINK WADA_CORINTHIAN_PINK
#endif
#ifndef WADA_CORINTHIAN_PINK_CMYK
#define WADA_CORINTHIAN_PINK_CMYK vec4(0.000, 0.350, 0.150, 0.000)
#endif
#ifndef CORINTHIAN_PINK_CMYK
#define CORINTHIAN_PINK_CMYK WADA_CORINTHIAN_PINK_CMYK
#endif

#ifndef WADA_CAMEO_PINK
#define WADA_CAMEO_PINK vec3(0.902, 0.678, 0.812)
#endif
#ifndef CAMEO_PINK
#define CAMEO_PINK WADA_CAMEO_PINK
#endif
#ifndef WADA_CAMEO_PINK_CMYK
#define WADA_CAMEO_PINK_CMYK vec4(0.100, 0.320, 0.190, 0.000)
#endif
#ifndef CAMEO_PINK_CMYK
#define CAMEO_PINK_CMYK WADA_CAMEO_PINK_CMYK
#endif

#ifndef WADA_FAWN
#define WADA_FAWN vec3(0.820, 0.690, 0.702)
#endif
#ifndef FAWN
#define FAWN WADA_FAWN
#endif
#ifndef WADA_FAWN_CMYK
#define WADA_FAWN_CMYK vec4(0.180, 0.310, 0.300, 0.000)
#endif
#ifndef FAWN_CMYK
#define FAWN_CMYK WADA_FAWN_CMYK
#endif

#ifndef WADA_LIGHT_BROWN_DRAB
#define WADA_LIGHT_BROWN_DRAB vec3(0.690, 0.525, 0.600)
#endif
#ifndef LIGHT_BROWN_DRAB
#define LIGHT_BROWN_DRAB WADA_LIGHT_BROWN_DRAB
#endif
#ifndef WADA_LIGHT_BROWN_DRAB_CMYK
#define WADA_LIGHT_BROWN_DRAB_CMYK vec4(0.080, 0.300, 0.200, 0.250)
#endif
#ifndef LIGHT_BROWN_DRAB_CMYK
#define LIGHT_BROWN_DRAB_CMYK WADA_LIGHT_BROWN_DRAB_CMYK
#endif

#ifndef WADA_CORAL_RED
#define WADA_CORAL_RED vec3(1.000, 0.451, 0.600)
#endif
#ifndef CORAL_RED
#define CORAL_RED WADA_CORAL_RED
#endif
#ifndef WADA_CORAL_RED_CMYK
#define WADA_CORAL_RED_CMYK vec4(0.000, 0.550, 0.400, 0.000)
#endif
#ifndef CORAL_RED_CMYK
#define CORAL_RED_CMYK WADA_CORAL_RED_CMYK
#endif

#ifndef WADA_FRESH_COLOR
#define WADA_FRESH_COLOR vec3(1.000, 0.471, 0.549)
#endif
#ifndef FRESH_COLOR
#define FRESH_COLOR WADA_FRESH_COLOR
#endif
#ifndef WADA_FRESH_COLOR_CMYK
#define WADA_FRESH_COLOR_CMYK vec4(0.000, 0.530, 0.450, 0.000)
#endif
#ifndef FRESH_COLOR_CMYK
#define FRESH_COLOR_CMYK WADA_FRESH_COLOR_CMYK
#endif

#ifndef WADA_GRENADINE_PINK
#define WADA_GRENADINE_PINK vec3(1.000, 0.380, 0.420)
#endif
#ifndef GRENADINE_PINK
#define GRENADINE_PINK WADA_GRENADINE_PINK
#endif
#ifndef WADA_GRENADINE_PINK_CMYK
#define WADA_GRENADINE_PINK_CMYK vec4(0.000, 0.620, 0.580, 0.000)
#endif
#ifndef GRENADINE_PINK_CMYK
#define GRENADINE_PINK_CMYK WADA_GRENADINE_PINK_CMYK
#endif

#ifndef WADA_EOSINE_PINK
#define WADA_EOSINE_PINK vec3(1.000, 0.369, 0.769)
#endif
#ifndef EOSINE_PINK
#define EOSINE_PINK WADA_EOSINE_PINK
#endif
#ifndef WADA_EOSINE_PINK_CMYK
#define WADA_EOSINE_PINK_CMYK vec4(0.000, 0.630, 0.230, 0.000)
#endif
#ifndef EOSINE_PINK_CMYK
#define EOSINE_PINK_CMYK WADA_EOSINE_PINK_CMYK
#endif

#ifndef WADA_SPINEL_RED
#define WADA_SPINEL_RED vec3(1.000, 0.302, 0.788)
#endif
#ifndef SPINEL_RED
#define SPINEL_RED WADA_SPINEL_RED
#endif
#ifndef WADA_SPINEL_RED_CMYK
#define WADA_SPINEL_RED_CMYK vec4(0.000, 0.700, 0.210, 0.000)
#endif
#ifndef SPINEL_RED_CMYK
#define SPINEL_RED_CMYK WADA_SPINEL_RED_CMYK
#endif

#ifndef WADA_OLD_ROSE
#define WADA_OLD_ROSE vec3(0.851, 0.302, 0.600)
#endif
#ifndef OLD_ROSE
#define OLD_ROSE WADA_OLD_ROSE
#endif
#ifndef WADA_OLD_ROSE_CMYK
#define WADA_OLD_ROSE_CMYK vec4(0.150, 0.700, 0.400, 0.000)
#endif
#ifndef OLD_ROSE_CMYK
#define OLD_ROSE_CMYK WADA_OLD_ROSE_CMYK
#endif

#ifndef WADA_EUGENIA_RED_A
#define WADA_EUGENIA_RED_A vec3(0.929, 0.239, 0.400)
#endif
#ifndef EUGENIA_RED_A
#define EUGENIA_RED_A WADA_EUGENIA_RED_A
#endif
#ifndef WADA_EUGENIA_RED_A_CMYK
#define WADA_EUGENIA_RED_A_CMYK vec4(0.070, 0.760, 0.600, 0.000)
#endif
#ifndef EUGENIA_RED_A_CMYK
#define EUGENIA_RED_A_CMYK WADA_EUGENIA_RED_A_CMYK
#endif

#ifndef WADA_EUGENIA_RED_B
#define WADA_EUGENIA_RED_B vec3(0.902, 0.180, 0.451)
#endif
#ifndef EUGENIA_RED_B
#define EUGENIA_RED_B WADA_EUGENIA_RED_B
#endif
#ifndef WADA_EUGENIA_RED_B_CMYK
#define WADA_EUGENIA_RED_B_CMYK vec4(0.000, 0.800, 0.500, 0.100)
#endif
#ifndef EUGENIA_RED_B_CMYK
#define EUGENIA_RED_B_CMYK WADA_EUGENIA_RED_B_CMYK
#endif

#ifndef WADA_RAW_SIENNA
#define WADA_RAW_SIENNA vec3(0.722, 0.369, 0.000)
#endif
#ifndef RAW_SIENNA
#define RAW_SIENNA WADA_RAW_SIENNA
#endif
#ifndef WADA_RAW_SIENNA_CMYK
#define WADA_RAW_SIENNA_CMYK vec4(0.180, 0.580, 1.000, 0.120)
#endif
#ifndef RAW_SIENNA_CMYK
#define RAW_SIENNA_CMYK WADA_RAW_SIENNA_CMYK
#endif

#ifndef WADA_VINACEOUS_TAWNY
#define WADA_VINACEOUS_TAWNY vec3(0.780, 0.263, 0.000)
#endif
#ifndef VINACEOUS_TAWNY
#define VINACEOUS_TAWNY WADA_VINACEOUS_TAWNY
#endif
#ifndef WADA_VINACEOUS_TAWNY_CMYK
#define WADA_VINACEOUS_TAWNY_CMYK vec4(0.170, 0.720, 1.000, 0.060)
#endif
#ifndef VINACEOUS_TAWNY_CMYK
#define VINACEOUS_TAWNY_CMYK WADA_VINACEOUS_TAWNY_CMYK
#endif

#ifndef WADA_JASPER_RED
#define WADA_JASPER_RED vec3(0.980, 0.169, 0.000)
#endif
#ifndef JASPER_RED
#define JASPER_RED WADA_JASPER_RED
#endif
#ifndef WADA_JASPER_RED_CMYK
#define WADA_JASPER_RED_CMYK vec4(0.020, 0.830, 1.000, 0.000)
#endif
#ifndef JASPER_RED_CMYK
#define JASPER_RED_CMYK WADA_JASPER_RED_CMYK
#endif

#ifndef WADA_SPECTRUM_RED
#define WADA_SPECTRUM_RED vec3(0.949, 0.000, 0.000)
#endif
#ifndef SPECTRUM_RED
#define SPECTRUM_RED WADA_SPECTRUM_RED
#endif
#ifndef WADA_SPECTRUM_RED_CMYK
#define WADA_SPECTRUM_RED_CMYK vec4(0.050, 1.000, 1.000, 0.000)
#endif
#ifndef SPECTRUM_RED_CMYK
#define SPECTRUM_RED_CMYK WADA_SPECTRUM_RED_CMYK
#endif

#ifndef WADA_RED_ORANGE
#define WADA_RED_ORANGE vec3(0.910, 0.098, 0.000)
#endif
#ifndef RED_ORANGE
#define RED_ORANGE WADA_RED_ORANGE
#endif
#ifndef WADA_RED_ORANGE_CMYK
#define WADA_RED_ORANGE_CMYK vec4(0.090, 0.900, 1.000, 0.000)
#endif
#ifndef RED_ORANGE_CMYK
#define RED_ORANGE_CMYK WADA_RED_ORANGE_CMYK
#endif

#ifndef WADA_ETRUSCAN_RED
#define WADA_ETRUSCAN_RED vec3(0.788, 0.188, 0.243)
#endif
#ifndef ETRUSCAN_RED
#define ETRUSCAN_RED WADA_ETRUSCAN_RED
#endif
#ifndef WADA_ETRUSCAN_RED_CMYK
#define WADA_ETRUSCAN_RED_CMYK vec4(0.160, 0.800, 0.740, 0.060)
#endif
#ifndef ETRUSCAN_RED_CMYK
#define ETRUSCAN_RED_CMYK WADA_ETRUSCAN_RED_CMYK
#endif

#ifndef WADA_BURNT_SIENNA
#define WADA_BURNT_SIENNA vec3(0.663, 0.204, 0.000)
#endif
#ifndef BURNT_SIENNA
#define BURNT_SIENNA WADA_BURNT_SIENNA
#endif
#ifndef WADA_BURNT_SIENNA_CMYK
#define WADA_BURNT_SIENNA_CMYK vec4(0.220, 0.760, 1.000, 0.150)
#endif
#ifndef BURNT_SIENNA_CMYK
#define BURNT_SIENNA_CMYK WADA_BURNT_SIENNA_CMYK
#endif

#ifndef WADA_OCHRE_RED
#define WADA_OCHRE_RED vec3(0.655, 0.216, 0.294)
#endif
#ifndef OCHRE_RED
#define OCHRE_RED WADA_OCHRE_RED
#endif
#ifndef WADA_OCHRE_RED_CMYK
#define WADA_OCHRE_RED_CMYK vec4(0.180, 0.730, 0.630, 0.200)
#endif
#ifndef OCHRE_RED_CMYK
#define OCHRE_RED_CMYK WADA_OCHRE_RED_CMYK
#endif

#ifndef WADA_SCARLET
#define WADA_SCARLET vec3(0.835, 0.047, 0.259)
#endif
#ifndef SCARLET
#define SCARLET WADA_SCARLET
#endif
#ifndef WADA_SCARLET_CMYK
#define WADA_SCARLET_CMYK vec4(0.100, 0.950, 0.720, 0.070)
#endif
#ifndef SCARLET_CMYK
#define SCARLET_CMYK WADA_SCARLET_CMYK
#endif

#ifndef WADA_CARMINE
#define WADA_CARMINE vec3(0.839, 0.000, 0.212)
#endif
#ifndef CARMINE
#define CARMINE WADA_CARMINE
#endif
#ifndef WADA_CARMINE_CMYK
#define WADA_CARMINE_CMYK vec4(0.000, 1.000, 0.750, 0.160)
#endif
#ifndef CARMINE_CMYK
#define CARMINE_CMYK WADA_CARMINE_CMYK
#endif

#ifndef WADA_INDIAN_LAKE
#define WADA_INDIAN_LAKE vec3(0.800, 0.102, 0.592)
#endif
#ifndef INDIAN_LAKE
#define INDIAN_LAKE WADA_INDIAN_LAKE
#endif
#ifndef WADA_INDIAN_LAKE_CMYK
#define WADA_INDIAN_LAKE_CMYK vec4(0.120, 0.890, 0.350, 0.090)
#endif
#ifndef INDIAN_LAKE_CMYK
#define INDIAN_LAKE_CMYK WADA_INDIAN_LAKE_CMYK
#endif

#ifndef WADA_ROSOLANC_PURPLE
#define WADA_ROSOLANC_PURPLE vec3(0.702, 0.098, 0.671)
#endif
#ifndef ROSOLANC_PURPLE
#define ROSOLANC_PURPLE WADA_ROSOLANC_PURPLE
#endif
#ifndef WADA_ROSOLANC_PURPLE_CMYK
#define WADA_ROSOLANC_PURPLE_CMYK vec4(0.300, 0.900, 0.330, 0.000)
#endif
#ifndef ROSOLANC_PURPLE_CMYK
#define ROSOLANC_PURPLE_CMYK WADA_ROSOLANC_PURPLE_CMYK
#endif

#ifndef WADA_POMEGRANITE_PURPLE
#define WADA_POMEGRANITE_PURPLE vec3(0.725, 0.000, 0.471)
#endif
#ifndef POMEGRANITE_PURPLE
#define POMEGRANITE_PURPLE WADA_POMEGRANITE_PURPLE
#endif
#ifndef WADA_POMEGRANITE_PURPLE_CMYK
#define WADA_POMEGRANITE_PURPLE_CMYK vec4(0.230, 1.000, 0.500, 0.060)
#endif
#ifndef POMEGRANITE_PURPLE_CMYK
#define POMEGRANITE_PURPLE_CMYK WADA_POMEGRANITE_PURPLE_CMYK
#endif

#ifndef WADA_HYDRANGEA_RED
#define WADA_HYDRANGEA_RED vec3(0.620, 0.098, 0.302)
#endif
#ifndef HYDRANGEA_RED
#define HYDRANGEA_RED WADA_HYDRANGEA_RED
#endif
#ifndef WADA_HYDRANGEA_RED_CMYK
#define WADA_HYDRANGEA_RED_CMYK vec4(0.380, 0.900, 0.700, 0.000)
#endif
#ifndef HYDRANGEA_RED_CMYK
#define HYDRANGEA_RED_CMYK WADA_HYDRANGEA_RED_CMYK
#endif

#ifndef WADA_BRICK_RED
#define WADA_BRICK_RED vec3(0.639, 0.129, 0.000)
#endif
#ifndef BRICK_RED
#define BRICK_RED WADA_BRICK_RED
#endif
#ifndef WADA_BRICK_RED_CMYK
#define WADA_BRICK_RED_CMYK vec4(0.220, 0.840, 1.000, 0.180)
#endif
#ifndef BRICK_RED_CMYK
#define BRICK_RED_CMYK WADA_BRICK_RED_CMYK
#endif

#ifndef WADA_CARMINE_RED
#define WADA_CARMINE_RED vec3(0.631, 0.043, 0.169)
#endif
#ifndef CARMINE_RED
#define CARMINE_RED WADA_CARMINE_RED
#endif
#ifndef WADA_CARMINE_RED_CMYK
#define WADA_CARMINE_RED_CMYK vec4(0.250, 0.950, 0.800, 0.160)
#endif
#ifndef CARMINE_RED_CMYK
#define CARMINE_RED_CMYK WADA_CARMINE_RED_CMYK
#endif

#ifndef WADA_POMPEIAN_RED
#define WADA_POMPEIAN_RED vec3(0.663, 0.024, 0.212)
#endif
#ifndef POMPEIAN_RED
#define POMPEIAN_RED WADA_POMPEIAN_RED
#endif
#ifndef WADA_POMPEIAN_RED_CMYK
#define WADA_POMPEIAN_RED_CMYK vec4(0.180, 0.970, 0.740, 0.190)
#endif
#ifndef POMPEIAN_RED_CMYK
#define POMPEIAN_RED_CMYK WADA_POMPEIAN_RED_CMYK
#endif

#ifndef WADA_RED
#define WADA_RED vec3(0.631, 0.000, 0.271)
#endif
#ifndef RED
#define RED WADA_RED
#endif
#ifndef WADA_RED_CMYK
#define WADA_RED_CMYK vec4(0.300, 1.000, 0.700, 0.100)
#endif
#ifndef RED_CMYK
#define RED_CMYK WADA_RED_CMYK
#endif

#ifndef WADA_BROWN
#define WADA_BROWN vec3(0.424, 0.169, 0.067)
#endif
#ifndef BROWN
#define BROWN WADA_BROWN
#endif
#ifndef WADA_BROWN_CMYK
#define WADA_BROWN_CMYK vec4(0.350, 0.740, 0.900, 0.350)
#endif
#ifndef BROWN_CMYK
#define BROWN_CMYK WADA_BROWN_CMYK
#endif

#ifndef WADA_HAYS_RUSSET
#define WADA_HAYS_RUSSET vec3(0.408, 0.098, 0.086)
#endif
#ifndef HAYS_RUSSET
#define HAYS_RUSSET WADA_HAYS_RUSSET
#endif
#ifndef WADA_HAYS_RUSSET_CMYK
#define WADA_HAYS_RUSSET_CMYK vec4(0.370, 0.850, 0.870, 0.350)
#endif
#ifndef HAYS_RUSSET_CMYK
#define HAYS_RUSSET_CMYK WADA_HAYS_RUSSET_CMYK
#endif

#ifndef WADA_VANDYKE_RED
#define WADA_VANDYKE_RED vec3(0.455, 0.035, 0.035)
#endif
#ifndef VANDYKE_RED
#define VANDYKE_RED WADA_VANDYKE_RED
#endif
#ifndef WADA_VANDYKE_RED_CMYK
#define WADA_VANDYKE_RED_CMYK vec4(0.320, 0.950, 0.950, 0.330)
#endif
#ifndef VANDYKE_RED_CMYK
#define VANDYKE_RED_CMYK WADA_VANDYKE_RED_CMYK
#endif

#ifndef WADA_PANSY_PURPLE
#define WADA_PANSY_PURPLE vec3(0.435, 0.000, 0.263)
#endif
#ifndef PANSY_PURPLE
#define PANSY_PURPLE WADA_PANSY_PURPLE
#endif
#ifndef WADA_PANSY_PURPLE_CMYK
#define WADA_PANSY_PURPLE_CMYK vec4(0.340, 1.000, 0.600, 0.340)
#endif
#ifndef PANSY_PURPLE_CMYK
#define PANSY_PURPLE_CMYK WADA_PANSY_PURPLE_CMYK
#endif

#ifndef WADA_PALE_BURNT_LAKE
#define WADA_PALE_BURNT_LAKE vec3(0.451, 0.059, 0.122)
#endif
#ifndef PALE_BURNT_LAKE
#define PALE_BURNT_LAKE WADA_PALE_BURNT_LAKE
#endif
#ifndef WADA_PALE_BURNT_LAKE_CMYK
#define WADA_PALE_BURNT_LAKE_CMYK vec4(0.250, 0.900, 0.800, 0.400)
#endif
#ifndef PALE_BURNT_LAKE_CMYK
#define PALE_BURNT_LAKE_CMYK WADA_PALE_BURNT_LAKE_CMYK
#endif

#ifndef WADA_VIOLET_RED
#define WADA_VIOLET_RED vec3(0.239, 0.000, 0.475)
#endif
#ifndef VIOLET_RED
#define VIOLET_RED WADA_VIOLET_RED
#endif
#ifndef WADA_VIOLET_RED_CMYK
#define WADA_VIOLET_RED_CMYK vec4(0.750, 1.000, 0.500, 0.050)
#endif
#ifndef VIOLET_RED_CMYK
#define VIOLET_RED_CMYK WADA_VIOLET_RED_CMYK
#endif

#ifndef WADA_VISTORIS_LAKE
#define WADA_VISTORIS_LAKE vec3(0.361, 0.173, 0.271)
#endif
#ifndef VISTORIS_LAKE
#define VISTORIS_LAKE WADA_VISTORIS_LAKE
#endif
#ifndef WADA_VISTORIS_LAKE_CMYK
#define WADA_VISTORIS_LAKE_CMYK vec4(0.400, 0.710, 0.550, 0.400)
#endif
#ifndef VISTORIS_LAKE_CMYK
#define VISTORIS_LAKE_CMYK WADA_VISTORIS_LAKE_CMYK
#endif

#ifndef WADA_SULPHER_YELLOW
#define WADA_SULPHER_YELLOW vec3(0.961, 0.961, 0.722)
#endif
#ifndef SULPHER_YELLOW
#define SULPHER_YELLOW WADA_SULPHER_YELLOW
#endif
#ifndef WADA_SULPHER_YELLOW_CMYK
#define WADA_SULPHER_YELLOW_CMYK vec4(0.040, 0.040, 0.280, 0.000)
#endif
#ifndef SULPHER_YELLOW_CMYK
#define SULPHER_YELLOW_CMYK WADA_SULPHER_YELLOW_CMYK
#endif

#ifndef WADA_PALE_LEMON_YELLOW
#define WADA_PALE_LEMON_YELLOW vec3(1.000, 0.961, 0.620)
#endif
#ifndef PALE_LEMON_YELLOW
#define PALE_LEMON_YELLOW WADA_PALE_LEMON_YELLOW
#endif
#ifndef WADA_PALE_LEMON_YELLOW_CMYK
#define WADA_PALE_LEMON_YELLOW_CMYK vec4(0.000, 0.040, 0.380, 0.000)
#endif
#ifndef PALE_LEMON_YELLOW_CMYK
#define PALE_LEMON_YELLOW_CMYK WADA_PALE_LEMON_YELLOW_CMYK
#endif

#ifndef WADA_NAPLES_YELLOW
#define WADA_NAPLES_YELLOW vec3(0.980, 0.929, 0.561)
#endif
#ifndef NAPLES_YELLOW
#define NAPLES_YELLOW WADA_NAPLES_YELLOW
#endif
#ifndef WADA_NAPLES_YELLOW_CMYK
#define WADA_NAPLES_YELLOW_CMYK vec4(0.020, 0.070, 0.440, 0.000)
#endif
#ifndef NAPLES_YELLOW_CMYK
#define NAPLES_YELLOW_CMYK WADA_NAPLES_YELLOW_CMYK
#endif

#ifndef WADA_IVORY_BUFF
#define WADA_IVORY_BUFF vec3(0.922, 0.851, 0.600)
#endif
#ifndef IVORY_BUFF
#define IVORY_BUFF WADA_IVORY_BUFF
#endif
#ifndef WADA_IVORY_BUFF_CMYK
#define WADA_IVORY_BUFF_CMYK vec4(0.080, 0.150, 0.400, 0.000)
#endif
#ifndef IVORY_BUFF_CMYK
#define IVORY_BUFF_CMYK WADA_IVORY_BUFF_CMYK
#endif

#ifndef WADA_SEASHELL_PINK
#define WADA_SEASHELL_PINK vec3(1.000, 0.812, 0.769)
#endif
#ifndef SEASHELL_PINK
#define SEASHELL_PINK WADA_SEASHELL_PINK
#endif
#ifndef WADA_SEASHELL_PINK_CMYK
#define WADA_SEASHELL_PINK_CMYK vec4(0.000, 0.190, 0.230, 0.000)
#endif
#ifndef SEASHELL_PINK_CMYK
#define SEASHELL_PINK_CMYK WADA_SEASHELL_PINK_CMYK
#endif

#ifndef WADA_LIGHT_PINKISH_CINNAMON
#define WADA_LIGHT_PINKISH_CINNAMON vec3(1.000, 0.749, 0.600)
#endif
#ifndef LIGHT_PINKISH_CINNAMON
#define LIGHT_PINKISH_CINNAMON WADA_LIGHT_PINKISH_CINNAMON
#endif
#ifndef WADA_LIGHT_PINKISH_CINNAMON_CMYK
#define WADA_LIGHT_PINKISH_CINNAMON_CMYK vec4(0.000, 0.250, 0.400, 0.000)
#endif
#ifndef LIGHT_PINKISH_CINNAMON_CMYK
#define LIGHT_PINKISH_CINNAMON_CMYK WADA_LIGHT_PINKISH_CINNAMON_CMYK
#endif

#ifndef WADA_PINKISH_CINNAMON
#define WADA_PINKISH_CINNAMON vec3(0.949, 0.678, 0.471)
#endif
#ifndef PINKISH_CINNAMON
#define PINKISH_CINNAMON WADA_PINKISH_CINNAMON
#endif
#ifndef WADA_PINKISH_CINNAMON_CMYK
#define WADA_PINKISH_CINNAMON_CMYK vec4(0.050, 0.320, 0.530, 0.000)
#endif
#ifndef PINKISH_CINNAMON_CMYK
#define PINKISH_CINNAMON_CMYK WADA_PINKISH_CINNAMON_CMYK
#endif

#ifndef WADA_CINNAMON_BUFF
#define WADA_CINNAMON_BUFF vec3(1.000, 0.749, 0.431)
#endif
#ifndef CINNAMON_BUFF
#define CINNAMON_BUFF WADA_CINNAMON_BUFF
#endif
#ifndef WADA_CINNAMON_BUFF_CMYK
#define WADA_CINNAMON_BUFF_CMYK vec4(0.000, 0.250, 0.570, 0.000)
#endif
#ifndef CINNAMON_BUFF_CMYK
#define CINNAMON_BUFF_CMYK WADA_CINNAMON_BUFF_CMYK
#endif

#ifndef WADA_CREAM_YELLOW
#define WADA_CREAM_YELLOW vec3(1.000, 0.722, 0.322)
#endif
#ifndef CREAM_YELLOW
#define CREAM_YELLOW WADA_CREAM_YELLOW
#endif
#ifndef WADA_CREAM_YELLOW_CMYK
#define WADA_CREAM_YELLOW_CMYK vec4(0.000, 0.280, 0.680, 0.000)
#endif
#ifndef CREAM_YELLOW_CMYK
#define CREAM_YELLOW_CMYK WADA_CREAM_YELLOW_CMYK
#endif

#ifndef WADA_GOLDEN_YELLOW
#define WADA_GOLDEN_YELLOW vec3(0.980, 0.580, 0.259)
#endif
#ifndef GOLDEN_YELLOW
#define GOLDEN_YELLOW WADA_GOLDEN_YELLOW
#endif
#ifndef WADA_GOLDEN_YELLOW_CMYK
#define WADA_GOLDEN_YELLOW_CMYK vec4(0.020, 0.420, 0.740, 0.000)
#endif
#ifndef GOLDEN_YELLOW_CMYK
#define GOLDEN_YELLOW_CMYK WADA_GOLDEN_YELLOW_CMYK
#endif

#ifndef WADA_VINACEOUS_CINNAMON
#define WADA_VINACEOUS_CINNAMON vec3(0.961, 0.600, 0.580)
#endif
#ifndef VINACEOUS_CINNAMON
#define VINACEOUS_CINNAMON WADA_VINACEOUS_CINNAMON
#endif
#ifndef WADA_VINACEOUS_CINNAMON_CMYK
#define WADA_VINACEOUS_CINNAMON_CMYK vec4(0.040, 0.400, 0.420, 0.000)
#endif
#ifndef VINACEOUS_CINNAMON_CMYK
#define VINACEOUS_CINNAMON_CMYK WADA_VINACEOUS_CINNAMON_CMYK
#endif

#ifndef WADA_OCHRACEOUS_SALMON
#define WADA_OCHRACEOUS_SALMON vec3(0.851, 0.620, 0.451)
#endif
#ifndef OCHRACEOUS_SALMON
#define OCHRACEOUS_SALMON WADA_OCHRACEOUS_SALMON
#endif
#ifndef WADA_OCHRACEOUS_SALMON_CMYK
#define WADA_OCHRACEOUS_SALMON_CMYK vec4(0.150, 0.380, 0.550, 0.000)
#endif
#ifndef OCHRACEOUS_SALMON_CMYK
#define OCHRACEOUS_SALMON_CMYK WADA_OCHRACEOUS_SALMON_CMYK
#endif

#ifndef WADA_ISABELLA_COLOR
#define WADA_ISABELLA_COLOR vec3(0.765, 0.647, 0.361)
#endif
#ifndef ISABELLA_COLOR
#define ISABELLA_COLOR WADA_ISABELLA_COLOR
#endif
#ifndef WADA_ISABELLA_COLOR_CMYK
#define WADA_ISABELLA_COLOR_CMYK vec4(0.150, 0.280, 0.600, 0.100)
#endif
#ifndef ISABELLA_COLOR_CMYK
#define ISABELLA_COLOR_CMYK WADA_ISABELLA_COLOR_CMYK
#endif

#ifndef WADA_MAPLE
#define WADA_MAPLE vec3(0.761, 0.592, 0.353)
#endif
#ifndef MAPLE
#define MAPLE WADA_MAPLE
#endif
#ifndef WADA_MAPLE_CMYK
#define WADA_MAPLE_CMYK vec4(0.050, 0.260, 0.560, 0.200)
#endif
#ifndef MAPLE_CMYK
#define MAPLE_CMYK WADA_MAPLE_CMYK
#endif

#ifndef WADA_OLIVE_BUFF
#define WADA_OLIVE_BUFF vec3(0.737, 0.827, 0.510)
#endif
#ifndef OLIVE_BUFF
#define OLIVE_BUFF WADA_OLIVE_BUFF
#endif
#ifndef WADA_OLIVE_BUFF_CMYK
#define WADA_OLIVE_BUFF_CMYK vec4(0.160, 0.060, 0.420, 0.120)
#endif
#ifndef OLIVE_BUFF_CMYK
#define OLIVE_BUFF_CMYK WADA_OLIVE_BUFF_CMYK
#endif

#ifndef WADA_ECRU
#define WADA_ECRU vec3(0.753, 0.706, 0.565)
#endif
#ifndef ECRU
#define ECRU WADA_ECRU
#endif
#ifndef WADA_ECRU_CMYK
#define WADA_ECRU_CMYK vec4(0.200, 0.250, 0.400, 0.060)
#endif
#ifndef ECRU_CMYK
#define ECRU_CMYK WADA_ECRU_CMYK
#endif

#ifndef WADA_YELLOW
#define WADA_YELLOW vec3(1.000, 1.000, 0.000)
#endif
#ifndef YELLOW
#define YELLOW WADA_YELLOW
#endif
#ifndef WADA_YELLOW_CMYK
#define WADA_YELLOW_CMYK vec4(0.000, 0.000, 1.000, 0.000)
#endif
#ifndef YELLOW_CMYK
#define YELLOW_CMYK WADA_YELLOW_CMYK
#endif

#ifndef WADA_LEMON_YELLOW
#define WADA_LEMON_YELLOW vec3(0.949, 1.000, 0.149)
#endif
#ifndef LEMON_YELLOW
#define LEMON_YELLOW WADA_LEMON_YELLOW
#endif
#ifndef WADA_LEMON_YELLOW_CMYK
#define WADA_LEMON_YELLOW_CMYK vec4(0.050, 0.000, 0.850, 0.000)
#endif
#ifndef LEMON_YELLOW_CMYK
#define LEMON_YELLOW_CMYK WADA_LEMON_YELLOW_CMYK
#endif

#ifndef WADA_APRICOT_YELLOW
#define WADA_APRICOT_YELLOW vec3(1.000, 0.902, 0.000)
#endif
#ifndef APRICOT_YELLOW
#define APRICOT_YELLOW WADA_APRICOT_YELLOW
#endif
#ifndef WADA_APRICOT_YELLOW_CMYK
#define WADA_APRICOT_YELLOW_CMYK vec4(0.000, 0.100, 1.000, 0.000)
#endif
#ifndef APRICOT_YELLOW_CMYK
#define APRICOT_YELLOW_CMYK WADA_APRICOT_YELLOW_CMYK
#endif

#ifndef WADA_PYRITE_YELLOW
#define WADA_PYRITE_YELLOW vec3(0.769, 0.749, 0.200)
#endif
#ifndef PYRITE_YELLOW
#define PYRITE_YELLOW WADA_PYRITE_YELLOW
#endif
#ifndef WADA_PYRITE_YELLOW_CMYK
#define WADA_PYRITE_YELLOW_CMYK vec4(0.230, 0.250, 0.800, 0.000)
#endif
#ifndef PYRITE_YELLOW_CMYK
#define PYRITE_YELLOW_CMYK WADA_PYRITE_YELLOW_CMYK
#endif

#ifndef WADA_OLIVE_OCHER
#define WADA_OLIVE_OCHER vec3(0.820, 0.741, 0.098)
#endif
#ifndef OLIVE_OCHER
#define OLIVE_OCHER WADA_OLIVE_OCHER
#endif
#ifndef WADA_OLIVE_OCHER_CMYK
#define WADA_OLIVE_OCHER_CMYK vec4(0.180, 0.260, 0.900, 0.000)
#endif
#ifndef OLIVE_OCHER_CMYK
#define OLIVE_OCHER_CMYK WADA_OLIVE_OCHER_CMYK
#endif

#ifndef WADA_YELLOW_OCHER
#define WADA_YELLOW_OCHER vec3(0.878, 0.722, 0.122)
#endif
#ifndef YELLOW_OCHER
#define YELLOW_OCHER WADA_YELLOW_OCHER
#endif
#ifndef WADA_YELLOW_OCHER_CMYK
#define WADA_YELLOW_OCHER_CMYK vec4(0.120, 0.280, 0.880, 0.000)
#endif
#ifndef YELLOW_OCHER_CMYK
#define YELLOW_OCHER_CMYK WADA_YELLOW_OCHER_CMYK
#endif

#ifndef WADA_ORANGE_YELLOW
#define WADA_ORANGE_YELLOW vec3(1.000, 0.671, 0.000)
#endif
#ifndef ORANGE_YELLOW
#define ORANGE_YELLOW WADA_ORANGE_YELLOW
#endif
#ifndef WADA_ORANGE_YELLOW_CMYK
#define WADA_ORANGE_YELLOW_CMYK vec4(0.000, 0.330, 1.000, 0.000)
#endif
#ifndef ORANGE_YELLOW_CMYK
#define ORANGE_YELLOW_CMYK WADA_ORANGE_YELLOW_CMYK
#endif

#ifndef WADA_YELLOW_ORANGE
#define WADA_YELLOW_ORANGE vec3(1.000, 0.549, 0.000)
#endif
#ifndef YELLOW_ORANGE
#define YELLOW_ORANGE WADA_YELLOW_ORANGE
#endif
#ifndef WADA_YELLOW_ORANGE_CMYK
#define WADA_YELLOW_ORANGE_CMYK vec4(0.000, 0.450, 1.000, 0.000)
#endif
#ifndef YELLOW_ORANGE_CMYK
#define YELLOW_ORANGE_CMYK WADA_YELLOW_ORANGE_CMYK
#endif

#ifndef WADA_APRICOT_ORANGE
#define WADA_APRICOT_ORANGE vec3(1.000, 0.451, 0.251)
#endif
#ifndef APRICOT_ORANGE
#define APRICOT_ORANGE WADA_APRICOT_ORANGE
#endif
#ifndef WADA_APRICOT_ORANGE_CMYK
#define WADA_APRICOT_ORANGE_CMYK vec4(0.000, 0.550, 0.750, 0.000)
#endif
#ifndef APRICOT_ORANGE_CMYK
#define APRICOT_ORANGE_CMYK WADA_APRICOT_ORANGE_CMYK
#endif

#ifndef WADA_ORANGE
#define WADA_ORANGE vec3(1.000, 0.322, 0.000)
#endif
#ifndef ORANGE
#define ORANGE WADA_ORANGE
#endif
#ifndef WADA_ORANGE_CMYK
#define WADA_ORANGE_CMYK vec4(0.000, 0.680, 1.000, 0.000)
#endif
#ifndef ORANGE_CMYK
#define ORANGE_CMYK WADA_ORANGE_CMYK
#endif

#ifndef WADA_PEACH_RED
#define WADA_PEACH_RED vec3(1.000, 0.200, 0.098)
#endif
#ifndef PEACH_RED
#define PEACH_RED WADA_PEACH_RED
#endif
#ifndef WADA_PEACH_RED_CMYK
#define WADA_PEACH_RED_CMYK vec4(0.000, 0.800, 0.900, 0.000)
#endif
#ifndef PEACH_RED_CMYK
#define PEACH_RED_CMYK WADA_PEACH_RED_CMYK
#endif

#ifndef WADA_ENGLISH_RED
#define WADA_ENGLISH_RED vec3(0.871, 0.271, 0.000)
#endif
#ifndef ENGLISH_RED
#define ENGLISH_RED WADA_ENGLISH_RED
#endif
#ifndef WADA_ENGLISH_RED_CMYK
#define WADA_ENGLISH_RED_CMYK vec4(0.130, 0.730, 1.000, 0.000)
#endif
#ifndef ENGLISH_RED_CMYK
#define ENGLISH_RED_CMYK WADA_ENGLISH_RED_CMYK
#endif

#ifndef WADA_CINNAMON_RUFOUS
#define WADA_CINNAMON_RUFOUS vec3(0.761, 0.380, 0.173)
#endif
#ifndef CINNAMON_RUFOUS
#define CINNAMON_RUFOUS WADA_CINNAMON_RUFOUS
#endif
#ifndef WADA_CINNAMON_RUFOUS_CMYK
#define WADA_CINNAMON_RUFOUS_CMYK vec4(0.200, 0.600, 0.820, 0.050)
#endif
#ifndef CINNAMON_RUFOUS_CMYK
#define CINNAMON_RUFOUS_CMYK WADA_CINNAMON_RUFOUS_CMYK
#endif

#ifndef WADA_ORANGE_RUFOUS
#define WADA_ORANGE_RUFOUS vec3(0.753, 0.322, 0.000)
#endif
#ifndef ORANGE_RUFOUS
#define ORANGE_RUFOUS WADA_ORANGE_RUFOUS
#endif
#ifndef WADA_ORANGE_RUFOUS_CMYK
#define WADA_ORANGE_RUFOUS_CMYK vec4(0.180, 0.650, 1.000, 0.080)
#endif
#ifndef ORANGE_RUFOUS_CMYK
#define ORANGE_RUFOUS_CMYK WADA_ORANGE_RUFOUS_CMYK
#endif

#ifndef WADA_SULPHINE_YELLOW
#define WADA_SULPHINE_YELLOW vec3(0.729, 0.651, 0.000)
#endif
#ifndef SULPHINE_YELLOW
#define SULPHINE_YELLOW WADA_SULPHINE_YELLOW
#endif
#ifndef WADA_SULPHINE_YELLOW_CMYK
#define WADA_SULPHINE_YELLOW_CMYK vec4(0.240, 0.320, 1.000, 0.040)
#endif
#ifndef SULPHINE_YELLOW_CMYK
#define SULPHINE_YELLOW_CMYK WADA_SULPHINE_YELLOW_CMYK
#endif

#ifndef WADA_KHAKI
#define WADA_KHAKI vec3(0.714, 0.518, 0.000)
#endif
#ifndef KHAKI
#define KHAKI WADA_KHAKI
#endif
#ifndef WADA_KHAKI_CMYK
#define WADA_KHAKI_CMYK vec4(0.240, 0.450, 1.000, 0.060)
#endif
#ifndef KHAKI_CMYK
#define KHAKI_CMYK WADA_KHAKI_CMYK
#endif

#ifndef WADA_CITRON_YELLOW
#define WADA_CITRON_YELLOW vec3(0.651, 0.831, 0.051)
#endif
#ifndef CITRON_YELLOW
#define CITRON_YELLOW WADA_CITRON_YELLOW
#endif
#ifndef WADA_CITRON_YELLOW_CMYK
#define WADA_CITRON_YELLOW_CMYK vec4(0.350, 0.170, 0.950, 0.000)
#endif
#ifndef CITRON_YELLOW_CMYK
#define CITRON_YELLOW_CMYK WADA_CITRON_YELLOW_CMYK
#endif

#ifndef WADA_BUFFY_CITRINE
#define WADA_BUFFY_CITRINE vec3(0.533, 0.553, 0.165)
#endif
#ifndef BUFFY_CITRINE
#define BUFFY_CITRINE WADA_BUFFY_CITRINE
#endif
#ifndef WADA_BUFFY_CITRINE_CMYK
#define WADA_BUFFY_CITRINE_CMYK vec4(0.420, 0.400, 0.820, 0.080)
#endif
#ifndef BUFFY_CITRINE_CMYK
#define BUFFY_CITRINE_CMYK WADA_BUFFY_CITRINE_CMYK
#endif

#ifndef WADA_DARK_CITRINE
#define WADA_DARK_CITRINE vec3(0.494, 0.529, 0.263)
#endif
#ifndef DARK_CITRINE
#define DARK_CITRINE WADA_DARK_CITRINE
#endif
#ifndef WADA_DARK_CITRINE_CMYK
#define WADA_DARK_CITRINE_CMYK vec4(0.380, 0.340, 0.670, 0.200)
#endif
#ifndef DARK_CITRINE_CMYK
#define DARK_CITRINE_CMYK WADA_DARK_CITRINE_CMYK
#endif

#ifndef WADA_LIGHT_GRAYISH_OLIVE
#define WADA_LIGHT_GRAYISH_OLIVE vec3(0.463, 0.518, 0.306)
#endif
#ifndef LIGHT_GRAYISH_OLIVE
#define LIGHT_GRAYISH_OLIVE WADA_LIGHT_GRAYISH_OLIVE
#endif
#ifndef WADA_LIGHT_GRAYISH_OLIVE_CMYK
#define WADA_LIGHT_GRAYISH_OLIVE_CMYK vec4(0.430, 0.360, 0.620, 0.190)
#endif
#ifndef LIGHT_GRAYISH_OLIVE_CMYK
#define LIGHT_GRAYISH_OLIVE_CMYK WADA_LIGHT_GRAYISH_OLIVE_CMYK
#endif

#ifndef WADA_KRONGBERGS_GREEN
#define WADA_KRONGBERGS_GREEN vec3(0.459, 0.573, 0.263)
#endif
#ifndef KRONGBERGS_GREEN
#define KRONGBERGS_GREEN WADA_KRONGBERGS_GREEN
#endif
#ifndef WADA_KRONGBERGS_GREEN_CMYK
#define WADA_KRONGBERGS_GREEN_CMYK vec4(0.480, 0.350, 0.700, 0.120)
#endif
#ifndef KRONGBERGS_GREEN_CMYK
#define KRONGBERGS_GREEN_CMYK WADA_KRONGBERGS_GREEN_CMYK
#endif

#ifndef WADA_OLIVE
#define WADA_OLIVE vec3(0.443, 0.525, 0.000)
#endif
#ifndef OLIVE
#define OLIVE WADA_OLIVE
#endif
#ifndef WADA_OLIVE_CMYK
#define WADA_OLIVE_CMYK vec4(0.480, 0.380, 1.000, 0.150)
#endif
#ifndef OLIVE_CMYK
#define OLIVE_CMYK WADA_OLIVE_CMYK
#endif

#ifndef WADA_ORANGE_CITRINE
#define WADA_ORANGE_CITRINE vec3(0.549, 0.396, 0.063)
#endif
#ifndef ORANGE_CITRINE
#define ORANGE_CITRINE WADA_ORANGE_CITRINE
#endif
#ifndef WADA_ORANGE_CITRINE_CMYK
#define WADA_ORANGE_CITRINE_CMYK vec4(0.280, 0.480, 0.920, 0.240)
#endif
#ifndef ORANGE_CITRINE_CMYK
#define ORANGE_CITRINE_CMYK WADA_ORANGE_CITRINE_CMYK
#endif

#ifndef WADA_SUDAN_BROWN
#define WADA_SUDAN_BROWN vec3(0.608, 0.325, 0.282)
#endif
#ifndef SUDAN_BROWN
#define SUDAN_BROWN WADA_SUDAN_BROWN
#endif
#ifndef WADA_SUDAN_BROWN_CMYK
#define WADA_SUDAN_BROWN_CMYK vec4(0.250, 0.600, 0.650, 0.190)
#endif
#ifndef SUDAN_BROWN_CMYK
#define SUDAN_BROWN_CMYK WADA_SUDAN_BROWN_CMYK
#endif

#ifndef WADA_OLIVE_GREEN
#define WADA_OLIVE_GREEN vec3(0.345, 0.467, 0.118)
#endif
#ifndef OLIVE_GREEN
#define OLIVE_GREEN WADA_OLIVE_GREEN
#endif
#ifndef WADA_OLIVE_GREEN_CMYK
#define WADA_OLIVE_GREEN_CMYK vec4(0.560, 0.400, 0.850, 0.220)
#endif
#ifndef OLIVE_GREEN_CMYK
#define OLIVE_GREEN_CMYK WADA_OLIVE_GREEN_CMYK
#endif

#ifndef WADA_LIGHT_BROWNISH_OLIVE
#define WADA_LIGHT_BROWNISH_OLIVE vec3(0.439, 0.412, 0.204)
#endif
#ifndef LIGHT_BROWNISH_OLIVE
#define LIGHT_BROWNISH_OLIVE WADA_LIGHT_BROWNISH_OLIVE
#endif
#ifndef WADA_LIGHT_BROWNISH_OLIVE_CMYK
#define WADA_LIGHT_BROWNISH_OLIVE_CMYK vec4(0.420, 0.460, 0.730, 0.240)
#endif
#ifndef LIGHT_BROWNISH_OLIVE_CMYK
#define LIGHT_BROWNISH_OLIVE_CMYK WADA_LIGHT_BROWNISH_OLIVE_CMYK
#endif

#ifndef WADA_DEEP_GRAYISH_OLIVE
#define WADA_DEEP_GRAYISH_OLIVE vec3(0.314, 0.329, 0.137)
#endif
#ifndef DEEP_GRAYISH_OLIVE
#define DEEP_GRAYISH_OLIVE WADA_DEEP_GRAYISH_OLIVE
#endif
#ifndef WADA_DEEP_GRAYISH_OLIVE_CMYK
#define WADA_DEEP_GRAYISH_OLIVE_CMYK vec4(0.500, 0.480, 0.780, 0.370)
#endif
#ifndef DEEP_GRAYISH_OLIVE_CMYK
#define DEEP_GRAYISH_OLIVE_CMYK WADA_DEEP_GRAYISH_OLIVE_CMYK
#endif

#ifndef WADA_PALE_RAW_UMBER
#define WADA_PALE_RAW_UMBER vec3(0.369, 0.251, 0.090)
#endif
#ifndef PALE_RAW_UMBER
#define PALE_RAW_UMBER WADA_PALE_RAW_UMBER
#endif
#ifndef WADA_PALE_RAW_UMBER_CMYK
#define WADA_PALE_RAW_UMBER_CMYK vec4(0.460, 0.630, 0.870, 0.320)
#endif
#ifndef PALE_RAW_UMBER_CMYK
#define PALE_RAW_UMBER_CMYK WADA_PALE_RAW_UMBER_CMYK
#endif

#ifndef WADA_SEPIA
#define WADA_SEPIA vec3(0.314, 0.239, 0.000)
#endif
#ifndef SEPIA
#define SEPIA WADA_SEPIA
#endif
#ifndef WADA_SEPIA_CMYK
#define WADA_SEPIA_CMYK vec4(0.480, 0.600, 1.000, 0.400)
#endif
#ifndef SEPIA_CMYK
#define SEPIA_CMYK WADA_SEPIA_CMYK
#endif

#ifndef WADA_MADDER_BROWN
#define WADA_MADDER_BROWN vec3(0.396, 0.075, 0.000)
#endif
#ifndef MADDER_BROWN
#define MADDER_BROWN WADA_MADDER_BROWN
#endif
#ifndef WADA_MADDER_BROWN_CMYK
#define WADA_MADDER_BROWN_CMYK vec4(0.360, 0.880, 1.000, 0.380)
#endif
#ifndef MADDER_BROWN_CMYK
#define MADDER_BROWN_CMYK WADA_MADDER_BROWN_CMYK
#endif

#ifndef WADA_MARS_BROWN_TOBACCO
#define WADA_MARS_BROWN_TOBACCO vec3(0.322, 0.125, 0.000)
#endif
#ifndef MARS_BROWN_TOBACCO
#define MARS_BROWN_TOBACCO WADA_MARS_BROWN_TOBACCO
#endif
#ifndef WADA_MARS_BROWN_TOBACCO_CMYK
#define WADA_MARS_BROWN_TOBACCO_CMYK vec4(0.390, 0.760, 1.000, 0.470)
#endif
#ifndef MARS_BROWN_TOBACCO_CMYK
#define MARS_BROWN_TOBACCO_CMYK WADA_MARS_BROWN_TOBACCO_CMYK
#endif

#ifndef WADA_VANDYKE_BROWN
#define WADA_VANDYKE_BROWN vec3(0.212, 0.137, 0.016)
#endif
#ifndef VANDYKE_BROWN
#define VANDYKE_BROWN WADA_VANDYKE_BROWN
#endif
#ifndef WADA_VANDYKE_BROWN_CMYK
#define WADA_VANDYKE_BROWN_CMYK vec4(0.560, 0.710, 0.970, 0.520)
#endif
#ifndef VANDYKE_BROWN_CMYK
#define VANDYKE_BROWN_CMYK WADA_VANDYKE_BROWN_CMYK
#endif

#ifndef WADA_TURQUOISE_GREEN
#define WADA_TURQUOISE_GREEN vec3(0.710, 1.000, 0.761)
#endif
#ifndef TURQUOISE_GREEN
#define TURQUOISE_GREEN WADA_TURQUOISE_GREEN
#endif
#ifndef WADA_TURQUOISE_GREEN_CMYK
#define WADA_TURQUOISE_GREEN_CMYK vec4(0.290, 0.000, 0.240, 0.000)
#endif
#ifndef TURQUOISE_GREEN_CMYK
#define TURQUOISE_GREEN_CMYK WADA_TURQUOISE_GREEN_CMYK
#endif

#ifndef WADA_GLAUCOUS_GREEN
#define WADA_GLAUCOUS_GREEN vec3(0.702, 0.910, 0.761)
#endif
#ifndef GLAUCOUS_GREEN
#define GLAUCOUS_GREEN WADA_GLAUCOUS_GREEN
#endif
#ifndef WADA_GLAUCOUS_GREEN_CMYK
#define WADA_GLAUCOUS_GREEN_CMYK vec4(0.300, 0.090, 0.240, 0.000)
#endif
#ifndef GLAUCOUS_GREEN_CMYK
#define GLAUCOUS_GREEN_CMYK WADA_GLAUCOUS_GREEN_CMYK
#endif

#ifndef WADA_DARK_GREENISH_GLAUCOUS
#define WADA_DARK_GREENISH_GLAUCOUS vec3(0.702, 0.851, 0.639)
#endif
#ifndef DARK_GREENISH_GLAUCOUS
#define DARK_GREENISH_GLAUCOUS WADA_DARK_GREENISH_GLAUCOUS
#endif
#ifndef WADA_DARK_GREENISH_GLAUCOUS_CMYK
#define WADA_DARK_GREENISH_GLAUCOUS_CMYK vec4(0.300, 0.150, 0.360, 0.000)
#endif
#ifndef DARK_GREENISH_GLAUCOUS_CMYK
#define DARK_GREENISH_GLAUCOUS_CMYK WADA_DARK_GREENISH_GLAUCOUS_CMYK
#endif

#ifndef WADA_YELLOW_GREEN
#define WADA_YELLOW_GREEN vec3(0.651, 1.000, 0.278)
#endif
#ifndef YELLOW_GREEN
#define YELLOW_GREEN WADA_YELLOW_GREEN
#endif
#ifndef WADA_YELLOW_GREEN_CMYK
#define WADA_YELLOW_GREEN_CMYK vec4(0.350, 0.000, 0.720, 0.000)
#endif
#ifndef YELLOW_GREEN_CMYK
#define YELLOW_GREEN_CMYK WADA_YELLOW_GREEN_CMYK
#endif

#ifndef WADA_LIGHT_GREEN_YELLOW
#define WADA_LIGHT_GREEN_YELLOW vec3(0.741, 0.949, 0.149)
#endif
#ifndef LIGHT_GREEN_YELLOW
#define LIGHT_GREEN_YELLOW WADA_LIGHT_GREEN_YELLOW
#endif
#ifndef WADA_LIGHT_GREEN_YELLOW_CMYK
#define WADA_LIGHT_GREEN_YELLOW_CMYK vec4(0.260, 0.050, 0.850, 0.000)
#endif
#ifndef LIGHT_GREEN_YELLOW_CMYK
#define LIGHT_GREEN_YELLOW_CMYK WADA_LIGHT_GREEN_YELLOW_CMYK
#endif

#ifndef WADA_NIGHT_GREEN
#define WADA_NIGHT_GREEN vec3(0.478, 1.000, 0.000)
#endif
#ifndef NIGHT_GREEN
#define NIGHT_GREEN WADA_NIGHT_GREEN
#endif
#ifndef WADA_NIGHT_GREEN_CMYK
#define WADA_NIGHT_GREEN_CMYK vec4(0.520, 0.000, 1.000, 0.000)
#endif
#ifndef NIGHT_GREEN_CMYK
#define NIGHT_GREEN_CMYK WADA_NIGHT_GREEN_CMYK
#endif

#ifndef WADA_OLIVE_YELLOW
#define WADA_OLIVE_YELLOW vec3(0.600, 0.702, 0.200)
#endif
#ifndef OLIVE_YELLOW
#define OLIVE_YELLOW WADA_OLIVE_YELLOW
#endif
#ifndef WADA_OLIVE_YELLOW_CMYK
#define WADA_OLIVE_YELLOW_CMYK vec4(0.400, 0.300, 0.800, 0.000)
#endif
#ifndef OLIVE_YELLOW_CMYK
#define OLIVE_YELLOW_CMYK WADA_OLIVE_YELLOW_CMYK
#endif

#ifndef WADA_ARTEMESIA_GREEN
#define WADA_ARTEMESIA_GREEN vec3(0.396, 0.663, 0.561)
#endif
#ifndef ARTEMESIA_GREEN
#define ARTEMESIA_GREEN WADA_ARTEMESIA_GREEN
#endif
#ifndef WADA_ARTEMESIA_GREEN_CMYK
#define WADA_ARTEMESIA_GREEN_CMYK vec4(0.570, 0.280, 0.390, 0.080)
#endif
#ifndef ARTEMESIA_GREEN_CMYK
#define ARTEMESIA_GREEN_CMYK WADA_ARTEMESIA_GREEN_CMYK
#endif

#ifndef WADA_ANDOVER_GREEN
#define WADA_ANDOVER_GREEN vec3(0.361, 0.541, 0.451)
#endif
#ifndef ANDOVER_GREEN
#define ANDOVER_GREEN WADA_ANDOVER_GREEN
#endif
#ifndef WADA_ANDOVER_GREEN_CMYK
#define WADA_ANDOVER_GREEN_CMYK vec4(0.600, 0.400, 0.500, 0.100)
#endif
#ifndef ANDOVER_GREEN_CMYK
#define ANDOVER_GREEN_CMYK WADA_ANDOVER_GREEN_CMYK
#endif

#ifndef WADA_RAINETTE_GREEN
#define WADA_RAINETTE_GREEN vec3(0.522, 0.722, 0.341)
#endif
#ifndef RAINETTE_GREEN
#define RAINETTE_GREEN WADA_RAINETTE_GREEN
#endif
#ifndef WADA_RAINETTE_GREEN_CMYK
#define WADA_RAINETTE_GREEN_CMYK vec4(0.420, 0.200, 0.620, 0.100)
#endif
#ifndef RAINETTE_GREEN_CMYK
#define RAINETTE_GREEN_CMYK WADA_RAINETTE_GREEN_CMYK
#endif

#ifndef WADA_PISTACHIO_GREEN
#define WADA_PISTACHIO_GREEN vec3(0.337, 0.667, 0.412)
#endif
#ifndef PISTACHIO_GREEN
#define PISTACHIO_GREEN WADA_PISTACHIO_GREEN
#endif
#ifndef WADA_PISTACHIO_GREEN_CMYK
#define WADA_PISTACHIO_GREEN_CMYK vec4(0.640, 0.290, 0.560, 0.060)
#endif
#ifndef PISTACHIO_GREEN_CMYK
#define PISTACHIO_GREEN_CMYK WADA_PISTACHIO_GREEN_CMYK
#endif

#ifndef WADA_SEA_GREEN
#define WADA_SEA_GREEN vec3(0.200, 1.000, 0.490)
#endif
#ifndef SEA_GREEN
#define SEA_GREEN WADA_SEA_GREEN
#endif
#ifndef WADA_SEA_GREEN_CMYK
#define WADA_SEA_GREEN_CMYK vec4(0.800, 0.000, 0.510, 0.000)
#endif
#ifndef SEA_GREEN_CMYK
#define SEA_GREEN_CMYK WADA_SEA_GREEN_CMYK
#endif

#ifndef WADA_BENZOL_GREEN
#define WADA_BENZOL_GREEN vec3(0.000, 0.851, 0.451)
#endif
#ifndef BENZOL_GREEN
#define BENZOL_GREEN WADA_BENZOL_GREEN
#endif
#ifndef WADA_BENZOL_GREEN_CMYK
#define WADA_BENZOL_GREEN_CMYK vec4(1.000, 0.150, 0.550, 0.000)
#endif
#ifndef BENZOL_GREEN_CMYK
#define BENZOL_GREEN_CMYK WADA_BENZOL_GREEN_CMYK
#endif

#ifndef WADA_LIGHT_PORCELAIN_GREEN
#define WADA_LIGHT_PORCELAIN_GREEN vec3(0.137, 0.757, 0.486)
#endif
#ifndef LIGHT_PORCELAIN_GREEN
#define LIGHT_PORCELAIN_GREEN WADA_LIGHT_PORCELAIN_GREEN
#endif
#ifndef WADA_LIGHT_PORCELAIN_GREEN_CMYK
#define WADA_LIGHT_PORCELAIN_GREEN_CMYK vec4(0.860, 0.220, 0.500, 0.030)
#endif
#ifndef LIGHT_PORCELAIN_GREEN_CMYK
#define LIGHT_PORCELAIN_GREEN_CMYK WADA_LIGHT_PORCELAIN_GREEN_CMYK
#endif

#ifndef WADA_GREEN
#define WADA_GREEN vec3(0.251, 0.788, 0.271)
#endif
#ifndef GREEN
#define GREEN WADA_GREEN
#endif
#ifndef WADA_GREEN_CMYK
#define WADA_GREEN_CMYK vec4(0.750, 0.210, 0.730, 0.000)
#endif
#ifndef GREEN_CMYK
#define GREEN_CMYK WADA_GREEN_CMYK
#endif

#ifndef WADA_DULL_VIRIDIAN_GREEN
#define WADA_DULL_VIRIDIAN_GREEN vec3(0.098, 0.800, 0.200)
#endif
#ifndef DULL_VIRIDIAN_GREEN
#define DULL_VIRIDIAN_GREEN WADA_DULL_VIRIDIAN_GREEN
#endif
#ifndef WADA_DULL_VIRIDIAN_GREEN_CMYK
#define WADA_DULL_VIRIDIAN_GREEN_CMYK vec4(0.900, 0.200, 0.800, 0.000)
#endif
#ifndef DULL_VIRIDIAN_GREEN_CMYK
#define DULL_VIRIDIAN_GREEN_CMYK WADA_DULL_VIRIDIAN_GREEN_CMYK
#endif

#ifndef WADA_OIL_GREEN
#define WADA_OIL_GREEN vec3(0.431, 0.663, 0.000)
#endif
#ifndef OIL_GREEN
#define OIL_GREEN WADA_OIL_GREEN
#endif
#ifndef WADA_OIL_GREEN_CMYK
#define WADA_OIL_GREEN_CMYK vec4(0.530, 0.280, 1.000, 0.080)
#endif
#ifndef OIL_GREEN_CMYK
#define OIL_GREEN_CMYK WADA_OIL_GREEN_CMYK
#endif

#ifndef WADA_DIAMINE_GREEN
#define WADA_DIAMINE_GREEN vec3(0.106, 0.557, 0.075)
#endif
#ifndef DIAMINE_GREEN
#define DIAMINE_GREEN WADA_DIAMINE_GREEN
#endif
#ifndef WADA_DIAMINE_GREEN_CMYK
#define WADA_DIAMINE_GREEN_CMYK vec4(0.870, 0.320, 0.910, 0.180)
#endif
#ifndef DIAMINE_GREEN_CMYK
#define DIAMINE_GREEN_CMYK WADA_DIAMINE_GREEN_CMYK
#endif

#ifndef WADA_COSSACK_GREEN
#define WADA_COSSACK_GREEN vec3(0.196, 0.557, 0.075)
#endif
#ifndef COSSACK_GREEN
#define COSSACK_GREEN WADA_COSSACK_GREEN
#endif
#ifndef WADA_COSSACK_GREEN_CMYK
#define WADA_COSSACK_GREEN_CMYK vec4(0.760, 0.320, 0.910, 0.180)
#endif
#ifndef COSSACK_GREEN_CMYK
#define COSSACK_GREEN_CMYK WADA_COSSACK_GREEN_CMYK
#endif

#ifndef WADA_LINCOLN_GREEN
#define WADA_LINCOLN_GREEN vec3(0.251, 0.329, 0.086)
#endif
#ifndef LINCOLN_GREEN
#define LINCOLN_GREEN WADA_LINCOLN_GREEN
#endif
#ifndef WADA_LINCOLN_GREEN_CMYK
#define WADA_LINCOLN_GREEN_CMYK vec4(0.600, 0.480, 0.860, 0.370)
#endif
#ifndef LINCOLN_GREEN_CMYK
#define LINCOLN_GREEN_CMYK WADA_LINCOLN_GREEN_CMYK
#endif

#ifndef WADA_BLACKISH_OLIVE
#define WADA_BLACKISH_OLIVE vec3(0.196, 0.306, 0.165)
#endif
#ifndef BLACKISH_OLIVE
#define BLACKISH_OLIVE WADA_BLACKISH_OLIVE
#endif
#ifndef WADA_BLACKISH_OLIVE_CMYK
#define WADA_BLACKISH_OLIVE_CMYK vec4(0.560, 0.320, 0.630, 0.550)
#endif
#ifndef BLACKISH_OLIVE_CMYK
#define BLACKISH_OLIVE_CMYK WADA_BLACKISH_OLIVE_CMYK
#endif

#ifndef WADA_DEEP_SLATE_OLIVE
#define WADA_DEEP_SLATE_OLIVE vec3(0.090, 0.153, 0.075)
#endif
#ifndef DEEP_SLATE_OLIVE
#define DEEP_SLATE_OLIVE WADA_DEEP_SLATE_OLIVE
#endif
#ifndef WADA_DEEP_SLATE_OLIVE_CMYK
#define WADA_DEEP_SLATE_OLIVE_CMYK vec4(0.760, 0.600, 0.800, 0.620)
#endif
#ifndef DEEP_SLATE_OLIVE_CMYK
#define DEEP_SLATE_OLIVE_CMYK WADA_DEEP_SLATE_OLIVE_CMYK
#endif

#ifndef WADA_NILE_BLUE
#define WADA_NILE_BLUE vec3(0.749, 1.000, 0.902)
#endif
#ifndef NILE_BLUE
#define NILE_BLUE WADA_NILE_BLUE
#endif
#ifndef WADA_NILE_BLUE_CMYK
#define WADA_NILE_BLUE_CMYK vec4(0.250, 0.000, 0.100, 0.000)
#endif
#ifndef NILE_BLUE_CMYK
#define NILE_BLUE_CMYK WADA_NILE_BLUE_CMYK
#endif

#ifndef WADA_PALE_KINGS_BLUE
#define WADA_PALE_KINGS_BLUE vec3(0.671, 0.961, 0.929)
#endif
#ifndef PALE_KINGS_BLUE
#define PALE_KINGS_BLUE WADA_PALE_KINGS_BLUE
#endif
#ifndef WADA_PALE_KINGS_BLUE_CMYK
#define WADA_PALE_KINGS_BLUE_CMYK vec4(0.330, 0.040, 0.070, 0.000)
#endif
#ifndef PALE_KINGS_BLUE_CMYK
#define PALE_KINGS_BLUE_CMYK WADA_PALE_KINGS_BLUE_CMYK
#endif

#ifndef WADA_LIGHT_GLAUCOUS_BLUE
#define WADA_LIGHT_GLAUCOUS_BLUE vec3(0.651, 0.902, 0.859)
#endif
#ifndef LIGHT_GLAUCOUS_BLUE
#define LIGHT_GLAUCOUS_BLUE WADA_LIGHT_GLAUCOUS_BLUE
#endif
#ifndef WADA_LIGHT_GLAUCOUS_BLUE_CMYK
#define WADA_LIGHT_GLAUCOUS_BLUE_CMYK vec4(0.350, 0.100, 0.140, 0.000)
#endif
#ifndef LIGHT_GLAUCOUS_BLUE_CMYK
#define LIGHT_GLAUCOUS_BLUE_CMYK WADA_LIGHT_GLAUCOUS_BLUE_CMYK
#endif

#ifndef WADA_SALVIA_BLUE
#define WADA_SALVIA_BLUE vec3(0.588, 0.749, 0.902)
#endif
#ifndef SALVIA_BLUE
#define SALVIA_BLUE WADA_SALVIA_BLUE
#endif
#ifndef WADA_SALVIA_BLUE_CMYK
#define WADA_SALVIA_BLUE_CMYK vec4(0.410, 0.250, 0.100, 0.000)
#endif
#ifndef SALVIA_BLUE_CMYK
#define SALVIA_BLUE_CMYK WADA_SALVIA_BLUE_CMYK
#endif

#ifndef WADA_COBALT_GREEN
#define WADA_COBALT_GREEN vec3(0.580, 1.000, 0.580)
#endif
#ifndef COBALT_GREEN
#define COBALT_GREEN WADA_COBALT_GREEN
#endif
#ifndef WADA_COBALT_GREEN_CMYK
#define WADA_COBALT_GREEN_CMYK vec4(0.420, 0.000, 0.420, 0.000)
#endif
#ifndef COBALT_GREEN_CMYK
#define COBALT_GREEN_CMYK WADA_COBALT_GREEN_CMYK
#endif

#ifndef WADA_CALAMINE_BLUE
#define WADA_CALAMINE_BLUE vec3(0.502, 1.000, 0.800)
#endif
#ifndef CALAMINE_BLUE
#define CALAMINE_BLUE WADA_CALAMINE_BLUE
#endif
#ifndef WADA_CALAMINE_BLUE_CMYK
#define WADA_CALAMINE_BLUE_CMYK vec4(0.500, 0.000, 0.200, 0.000)
#endif
#ifndef CALAMINE_BLUE_CMYK
#define CALAMINE_BLUE_CMYK WADA_CALAMINE_BLUE_CMYK
#endif

#ifndef WADA_VENICE_GREEN
#define WADA_VENICE_GREEN vec3(0.420, 1.000, 0.702)
#endif
#ifndef VENICE_GREEN
#define VENICE_GREEN WADA_VENICE_GREEN
#endif
#ifndef WADA_VENICE_GREEN_CMYK
#define WADA_VENICE_GREEN_CMYK vec4(0.580, 0.000, 0.300, 0.000)
#endif
#ifndef VENICE_GREEN_CMYK
#define VENICE_GREEN_CMYK WADA_VENICE_GREEN_CMYK
#endif

#ifndef WADA_CERULIAN_BLUE
#define WADA_CERULIAN_BLUE vec3(0.161, 0.741, 0.678)
#endif
#ifndef CERULIAN_BLUE
#define CERULIAN_BLUE WADA_CERULIAN_BLUE
#endif
#ifndef WADA_CERULIAN_BLUE_CMYK
#define WADA_CERULIAN_BLUE_CMYK vec4(0.840, 0.260, 0.320, 0.000)
#endif
#ifndef CERULIAN_BLUE_CMYK
#define CERULIAN_BLUE_CMYK WADA_CERULIAN_BLUE_CMYK
#endif

#ifndef WADA_PEACOCK_BLUE
#define WADA_PEACOCK_BLUE vec3(0.000, 0.812, 0.569)
#endif
#ifndef PEACOCK_BLUE
#define PEACOCK_BLUE WADA_PEACOCK_BLUE
#endif
#ifndef WADA_PEACOCK_BLUE_CMYK
#define WADA_PEACOCK_BLUE_CMYK vec4(1.000, 0.190, 0.430, 0.000)
#endif
#ifndef PEACOCK_BLUE_CMYK
#define PEACOCK_BLUE_CMYK WADA_PEACOCK_BLUE_CMYK
#endif

#ifndef WADA_GREEN_BLUE
#define WADA_GREEN_BLUE vec3(0.176, 0.737, 0.580)
#endif
#ifndef GREEN_BLUE
#define GREEN_BLUE WADA_GREEN_BLUE
#endif
#ifndef WADA_GREEN_BLUE_CMYK
#define WADA_GREEN_BLUE_CMYK vec4(0.820, 0.240, 0.400, 0.030)
#endif
#ifndef GREEN_BLUE_CMYK
#define GREEN_BLUE_CMYK WADA_GREEN_BLUE_CMYK
#endif

#ifndef WADA_OLYMPIC_BLUE
#define WADA_OLYMPIC_BLUE vec3(0.310, 0.561, 0.902)
#endif
#ifndef OLYMPIC_BLUE
#define OLYMPIC_BLUE WADA_OLYMPIC_BLUE
#endif
#ifndef WADA_OLYMPIC_BLUE_CMYK
#define WADA_OLYMPIC_BLUE_CMYK vec4(0.690, 0.440, 0.100, 0.000)
#endif
#ifndef OLYMPIC_BLUE_CMYK
#define OLYMPIC_BLUE_CMYK WADA_OLYMPIC_BLUE_CMYK
#endif

#ifndef WADA_BLUE
#define WADA_BLUE vec3(0.051, 0.459, 1.000)
#endif
#ifndef BLUE
#define BLUE WADA_BLUE
#endif
#ifndef WADA_BLUE_CMYK
#define WADA_BLUE_CMYK vec4(0.950, 0.540, 0.000, 0.000)
#endif
#ifndef BLUE_CMYK
#define BLUE_CMYK WADA_BLUE_CMYK
#endif

#ifndef WADA_ANTWARP_BLUE
#define WADA_ANTWARP_BLUE vec3(0.000, 0.541, 0.631)
#endif
#ifndef ANTWARP_BLUE
#define ANTWARP_BLUE WADA_ANTWARP_BLUE
#endif
#ifndef WADA_ANTWARP_BLUE_CMYK
#define WADA_ANTWARP_BLUE_CMYK vec4(1.000, 0.400, 0.300, 0.100)
#endif
#ifndef ANTWARP_BLUE_CMYK
#define ANTWARP_BLUE_CMYK WADA_ANTWARP_BLUE_CMYK
#endif

#ifndef WADA_HELVETIA_BLUE
#define WADA_HELVETIA_BLUE vec3(0.000, 0.341, 0.729)
#endif
#ifndef HELVETIA_BLUE
#define HELVETIA_BLUE WADA_HELVETIA_BLUE
#endif
#ifndef WADA_HELVETIA_BLUE_CMYK
#define WADA_HELVETIA_BLUE_CMYK vec4(1.000, 0.620, 0.190, 0.100)
#endif
#ifndef HELVETIA_BLUE_CMYK
#define HELVETIA_BLUE_CMYK WADA_HELVETIA_BLUE_CMYK
#endif

#ifndef WADA_DARK_MEDICI_BLUE
#define WADA_DARK_MEDICI_BLUE vec3(0.255, 0.467, 0.467)
#endif
#ifndef DARK_MEDICI_BLUE
#define DARK_MEDICI_BLUE WADA_DARK_MEDICI_BLUE
#endif
#ifndef WADA_DARK_MEDICI_BLUE_CMYK
#define WADA_DARK_MEDICI_BLUE_CMYK vec4(0.700, 0.450, 0.450, 0.150)
#endif
#ifndef DARK_MEDICI_BLUE_CMYK
#define DARK_MEDICI_BLUE_CMYK WADA_DARK_MEDICI_BLUE_CMYK
#endif

#ifndef WADA_DUSKY_GREEN
#define WADA_DUSKY_GREEN vec3(0.000, 0.349, 0.180)
#endif
#ifndef DUSKY_GREEN
#define DUSKY_GREEN WADA_DUSKY_GREEN
#endif
#ifndef WADA_DUSKY_GREEN_CMYK
#define WADA_DUSKY_GREEN_CMYK vec4(1.000, 0.300, 0.640, 0.500)
#endif
#ifndef DUSKY_GREEN_CMYK
#define DUSKY_GREEN_CMYK WADA_DUSKY_GREEN_CMYK
#endif

#ifndef WADA_DEEP_LYONS_BLUE
#define WADA_DEEP_LYONS_BLUE vec3(0.000, 0.141, 0.800)
#endif
#ifndef DEEP_LYONS_BLUE
#define DEEP_LYONS_BLUE WADA_DEEP_LYONS_BLUE
#endif
#ifndef WADA_DEEP_LYONS_BLUE_CMYK
#define WADA_DEEP_LYONS_BLUE_CMYK vec4(1.000, 0.850, 0.150, 0.060)
#endif
#ifndef DEEP_LYONS_BLUE_CMYK
#define DEEP_LYONS_BLUE_CMYK WADA_DEEP_LYONS_BLUE_CMYK
#endif

#ifndef WADA_VIOLET_BLUE
#define WADA_VIOLET_BLUE vec3(0.125, 0.176, 0.522)
#endif
#ifndef VIOLET_BLUE
#define VIOLET_BLUE WADA_VIOLET_BLUE
#endif
#ifndef WADA_VIOLET_BLUE_CMYK
#define WADA_VIOLET_BLUE_CMYK vec4(0.850, 0.790, 0.380, 0.160)
#endif
#ifndef VIOLET_BLUE_CMYK
#define VIOLET_BLUE_CMYK WADA_VIOLET_BLUE_CMYK
#endif

#ifndef WADA_VANDAR_POELS_BLUE
#define WADA_VANDAR_POELS_BLUE vec3(0.000, 0.243, 0.514)
#endif
#ifndef VANDAR_POELS_BLUE
#define VANDAR_POELS_BLUE WADA_VANDAR_POELS_BLUE
#endif
#ifndef WADA_VANDAR_POELS_BLUE_CMYK
#define WADA_VANDAR_POELS_BLUE_CMYK vec4(1.000, 0.730, 0.430, 0.100)
#endif
#ifndef VANDAR_POELS_BLUE_CMYK
#define VANDAR_POELS_BLUE_CMYK WADA_VANDAR_POELS_BLUE_CMYK
#endif

#ifndef WADA_DARK_TYRIAN_BLUE
#define WADA_DARK_TYRIAN_BLUE vec3(0.051, 0.169, 0.322)
#endif
#ifndef DARK_TYRIAN_BLUE
#define DARK_TYRIAN_BLUE WADA_DARK_TYRIAN_BLUE
#endif
#ifndef WADA_DARK_TYRIAN_BLUE_CMYK
#define WADA_DARK_TYRIAN_BLUE_CMYK vec4(0.900, 0.660, 0.360, 0.500)
#endif
#ifndef DARK_TYRIAN_BLUE_CMYK
#define DARK_TYRIAN_BLUE_CMYK WADA_DARK_TYRIAN_BLUE_CMYK
#endif

#ifndef WADA_DULL_VIOLET_BLACK
#define WADA_DULL_VIOLET_BLACK vec3(0.024, 0.000, 0.310)
#endif
#ifndef DULL_VIOLET_BLACK
#define DULL_VIOLET_BLACK WADA_DULL_VIOLET_BLACK
#endif
#ifndef WADA_DULL_VIOLET_BLACK_CMYK
#define WADA_DULL_VIOLET_BLACK_CMYK vec4(0.950, 1.060, 0.380, 0.500)
#endif
#ifndef DULL_VIOLET_BLACK_CMYK
#define DULL_VIOLET_BLACK_CMYK WADA_DULL_VIOLET_BLACK_CMYK
#endif

#ifndef WADA_DEEP_INDIGO
#define WADA_DEEP_INDIGO vec3(0.000, 0.031, 0.192)
#endif
#ifndef DEEP_INDIGO
#define DEEP_INDIGO WADA_DEEP_INDIGO
#endif
#ifndef WADA_DEEP_INDIGO_CMYK
#define WADA_DEEP_INDIGO_CMYK vec4(1.000, 0.920, 0.520, 0.600)
#endif
#ifndef DEEP_INDIGO_CMYK
#define DEEP_INDIGO_CMYK WADA_DEEP_INDIGO_CMYK
#endif

#ifndef WADA_DEEP_SLATE_GREEN
#define WADA_DEEP_SLATE_GREEN vec3(0.059, 0.149, 0.122)
#endif
#ifndef DEEP_SLATE_GREEN
#define DEEP_SLATE_GREEN WADA_DEEP_SLATE_GREEN
#endif
#ifndef WADA_DEEP_SLATE_GREEN_CMYK
#define WADA_DEEP_SLATE_GREEN_CMYK vec4(0.800, 0.500, 0.600, 0.700)
#endif
#ifndef DEEP_SLATE_GREEN_CMYK
#define DEEP_SLATE_GREEN_CMYK WADA_DEEP_SLATE_GREEN_CMYK
#endif

#ifndef WADA_GRAYISH_LAVENDER_A
#define WADA_GRAYISH_LAVENDER_A vec3(0.722, 0.722, 1.000)
#endif
#ifndef GRAYISH_LAVENDER_A
#define GRAYISH_LAVENDER_A WADA_GRAYISH_LAVENDER_A
#endif
#ifndef WADA_GRAYISH_LAVENDER_A_CMYK
#define WADA_GRAYISH_LAVENDER_A_CMYK vec4(0.280, 0.280, 0.000, 0.000)
#endif
#ifndef GRAYISH_LAVENDER_A_CMYK
#define GRAYISH_LAVENDER_A_CMYK WADA_GRAYISH_LAVENDER_A_CMYK
#endif

#ifndef WADA_GRAYISH_LAVENDER_B
#define WADA_GRAYISH_LAVENDER_B vec3(0.749, 0.671, 0.800)
#endif
#ifndef GRAYISH_LAVENDER_B
#define GRAYISH_LAVENDER_B WADA_GRAYISH_LAVENDER_B
#endif
#ifndef WADA_GRAYISH_LAVENDER_B_CMYK
#define WADA_GRAYISH_LAVENDER_B_CMYK vec4(0.250, 0.330, 0.200, 0.000)
#endif
#ifndef GRAYISH_LAVENDER_B_CMYK
#define GRAYISH_LAVENDER_B_CMYK WADA_GRAYISH_LAVENDER_B_CMYK
#endif

#ifndef WADA_LAELIA_PINK
#define WADA_LAELIA_PINK vec3(0.800, 0.522, 0.820)
#endif
#ifndef LAELIA_PINK
#define LAELIA_PINK WADA_LAELIA_PINK
#endif
#ifndef WADA_LAELIA_PINK_CMYK
#define WADA_LAELIA_PINK_CMYK vec4(0.200, 0.480, 0.180, 0.000)
#endif
#ifndef LAELIA_PINK_CMYK
#define LAELIA_PINK_CMYK WADA_LAELIA_PINK_CMYK
#endif

#ifndef WADA_LILAC
#define WADA_LILAC vec3(0.722, 0.459, 0.922)
#endif
#ifndef LILAC
#define LILAC WADA_LILAC
#endif
#ifndef WADA_LILAC_CMYK
#define WADA_LILAC_CMYK vec4(0.280, 0.540, 0.080, 0.000)
#endif
#ifndef LILAC_CMYK
#define LILAC_CMYK WADA_LILAC_CMYK
#endif

#ifndef WADA_EUPATORIUM_PURPLE
#define WADA_EUPATORIUM_PURPLE vec3(0.749, 0.212, 0.878)
#endif
#ifndef EUPATORIUM_PURPLE
#define EUPATORIUM_PURPLE WADA_EUPATORIUM_PURPLE
#endif
#ifndef WADA_EUPATORIUM_PURPLE_CMYK
#define WADA_EUPATORIUM_PURPLE_CMYK vec4(0.250, 0.790, 0.120, 0.000)
#endif
#ifndef EUPATORIUM_PURPLE_CMYK
#define EUPATORIUM_PURPLE_CMYK WADA_EUPATORIUM_PURPLE_CMYK
#endif

#ifndef WADA_LIGHT_MAUVE
#define WADA_LIGHT_MAUVE vec3(0.569, 0.380, 0.949)
#endif
#ifndef LIGHT_MAUVE
#define LIGHT_MAUVE WADA_LIGHT_MAUVE
#endif
#ifndef WADA_LIGHT_MAUVE_CMYK
#define WADA_LIGHT_MAUVE_CMYK vec4(0.430, 0.620, 0.050, 0.000)
#endif
#ifndef LIGHT_MAUVE_CMYK
#define LIGHT_MAUVE_CMYK WADA_LIGHT_MAUVE_CMYK
#endif

#ifndef WADA_ACONITE_VIOLET
#define WADA_ACONITE_VIOLET vec3(0.612, 0.322, 0.949)
#endif
#ifndef ACONITE_VIOLET
#define ACONITE_VIOLET WADA_ACONITE_VIOLET
#endif
#ifndef WADA_ACONITE_VIOLET_CMYK
#define WADA_ACONITE_VIOLET_CMYK vec4(0.390, 0.680, 0.050, 0.000)
#endif
#ifndef ACONITE_VIOLET_CMYK
#define ACONITE_VIOLET_CMYK WADA_ACONITE_VIOLET_CMYK
#endif

#ifndef WADA_DULL_BLUE_VIOLET
#define WADA_DULL_BLUE_VIOLET vec3(0.431, 0.400, 0.831)
#endif
#ifndef DULL_BLUE_VIOLET
#define DULL_BLUE_VIOLET WADA_DULL_BLUE_VIOLET
#endif
#ifndef WADA_DULL_BLUE_VIOLET_CMYK
#define WADA_DULL_BLUE_VIOLET_CMYK vec4(0.570, 0.600, 0.170, 0.000)
#endif
#ifndef DULL_BLUE_VIOLET_CMYK
#define DULL_BLUE_VIOLET_CMYK WADA_DULL_BLUE_VIOLET_CMYK
#endif

#ifndef WADA_DARK_SOFT_VIOLET
#define WADA_DARK_SOFT_VIOLET vec3(0.302, 0.322, 0.871)
#endif
#ifndef DARK_SOFT_VIOLET
#define DARK_SOFT_VIOLET WADA_DARK_SOFT_VIOLET
#endif
#ifndef WADA_DARK_SOFT_VIOLET_CMYK
#define WADA_DARK_SOFT_VIOLET_CMYK vec4(0.700, 0.680, 0.130, 0.000)
#endif
#ifndef DARK_SOFT_VIOLET_CMYK
#define DARK_SOFT_VIOLET_CMYK WADA_DARK_SOFT_VIOLET_CMYK
#endif

#ifndef WADA_BLUE_VIOLET
#define WADA_BLUE_VIOLET vec3(0.278, 0.200, 1.000)
#endif
#ifndef BLUE_VIOLET
#define BLUE_VIOLET WADA_BLUE_VIOLET
#endif
#ifndef WADA_BLUE_VIOLET_CMYK
#define WADA_BLUE_VIOLET_CMYK vec4(0.720, 0.800, 0.000, 0.000)
#endif
#ifndef BLUE_VIOLET_CMYK
#define BLUE_VIOLET_CMYK WADA_BLUE_VIOLET_CMYK
#endif

#ifndef WADA_PURPLE_DRAB
#define WADA_PURPLE_DRAB vec3(0.459, 0.259, 0.376)
#endif
#ifndef PURPLE_DRAB
#define PURPLE_DRAB WADA_PURPLE_DRAB
#endif
#ifndef WADA_PURPLE_DRAB_CMYK
#define WADA_PURPLE_DRAB_CMYK vec4(0.380, 0.650, 0.490, 0.260)
#endif
#ifndef PURPLE_DRAB_CMYK
#define PURPLE_DRAB_CMYK WADA_PURPLE_DRAB_CMYK
#endif

#ifndef WADA_DEEP_VIOLET_PLUMBEOUS
#define WADA_DEEP_VIOLET_PLUMBEOUS vec3(0.361, 0.447, 0.529)
#endif
#ifndef DEEP_VIOLET_PLUMBEOUS
#define DEEP_VIOLET_PLUMBEOUS WADA_DEEP_VIOLET_PLUMBEOUS
#endif
#ifndef WADA_DEEP_VIOLET_PLUMBEOUS_CMYK
#define WADA_DEEP_VIOLET_PLUMBEOUS_CMYK vec4(0.610, 0.520, 0.430, 0.070)
#endif
#ifndef DEEP_VIOLET_PLUMBEOUS_CMYK
#define DEEP_VIOLET_PLUMBEOUS_CMYK WADA_DEEP_VIOLET_PLUMBEOUS_CMYK
#endif

#ifndef WADA_VERONIA_PURPLE
#define WADA_VERONIA_PURPLE vec3(0.494, 0.188, 0.459)
#endif
#ifndef VERONIA_PURPLE
#define VERONIA_PURPLE WADA_VERONIA_PURPLE
#endif
#ifndef WADA_VERONIA_PURPLE_CMYK
#define WADA_VERONIA_PURPLE_CMYK vec4(0.420, 0.780, 0.460, 0.150)
#endif
#ifndef VERONIA_PURPLE_CMYK
#define VERONIA_PURPLE_CMYK WADA_VERONIA_PURPLE_CMYK
#endif

#ifndef WADA_DARK_SLATE_PURPLE
#define WADA_DARK_SLATE_PURPLE vec3(0.325, 0.133, 0.361)
#endif
#ifndef DARK_SLATE_PURPLE
#define DARK_SLATE_PURPLE WADA_DARK_SLATE_PURPLE
#endif
#ifndef WADA_DARK_SLATE_PURPLE_CMYK
#define WADA_DARK_SLATE_PURPLE_CMYK vec4(0.640, 0.850, 0.600, 0.100)
#endif
#ifndef DARK_SLATE_PURPLE_CMYK
#define DARK_SLATE_PURPLE_CMYK WADA_DARK_SLATE_PURPLE_CMYK
#endif

#ifndef WADA_TAUPE_BROWN
#define WADA_TAUPE_BROWN vec3(0.420, 0.180, 0.388)
#endif
#ifndef TAUPE_BROWN
#define TAUPE_BROWN WADA_TAUPE_BROWN
#endif
#ifndef WADA_TAUPE_BROWN_CMYK
#define WADA_TAUPE_BROWN_CMYK vec4(0.300, 0.700, 0.350, 0.400)
#endif
#ifndef TAUPE_BROWN_CMYK
#define TAUPE_BROWN_CMYK WADA_TAUPE_BROWN_CMYK
#endif

#ifndef WADA_VIOLET_CARMINE
#define WADA_VIOLET_CARMINE vec3(0.325, 0.090, 0.271)
#endif
#ifndef VIOLET_CARMINE
#define VIOLET_CARMINE WADA_VIOLET_CARMINE
#endif
#ifndef WADA_VIOLET_CARMINE_CMYK
#define WADA_VIOLET_CARMINE_CMYK vec4(0.640, 0.900, 0.700, 0.100)
#endif
#ifndef VIOLET_CARMINE_CMYK
#define VIOLET_CARMINE_CMYK WADA_VIOLET_CARMINE_CMYK
#endif

#ifndef WADA_VIOLET
#define WADA_VIOLET vec3(0.149, 0.098, 0.820)
#endif
#ifndef VIOLET
#define VIOLET WADA_VIOLET
#endif
#ifndef WADA_VIOLET_CMYK
#define WADA_VIOLET_CMYK vec4(0.850, 0.900, 0.180, 0.000)
#endif
#ifndef VIOLET_CMYK
#define VIOLET_CMYK WADA_VIOLET_CMYK
#endif

#ifndef WADA_RED_VIOLET
#define WADA_RED_VIOLET vec3(0.204, 0.000, 0.639)
#endif
#ifndef RED_VIOLET
#define RED_VIOLET WADA_RED_VIOLET
#endif
#ifndef WADA_RED_VIOLET_CMYK
#define WADA_RED_VIOLET_CMYK vec4(0.760, 1.000, 0.250, 0.150)
#endif
#ifndef RED_VIOLET_CMYK
#define RED_VIOLET_CMYK WADA_RED_VIOLET_CMYK
#endif

#ifndef WADA_COTINGA_PURPLE
#define WADA_COTINGA_PURPLE vec3(0.204, 0.000, 0.349)
#endif
#ifndef COTINGA_PURPLE
#define COTINGA_PURPLE WADA_COTINGA_PURPLE
#endif
#ifndef WADA_COTINGA_PURPLE_CMYK
#define WADA_COTINGA_PURPLE_CMYK vec4(0.660, 1.000, 0.420, 0.400)
#endif
#ifndef COTINGA_PURPLE_CMYK
#define COTINGA_PURPLE_CMYK WADA_COTINGA_PURPLE_CMYK
#endif

#ifndef WADA_DUSKY_MADDER_VIOLET
#define WADA_DUSKY_MADDER_VIOLET vec3(0.176, 0.000, 0.376)
#endif
#ifndef DUSKY_MADDER_VIOLET
#define DUSKY_MADDER_VIOLET WADA_DUSKY_MADDER_VIOLET
#endif
#ifndef WADA_DUSKY_MADDER_VIOLET_CMYK
#define WADA_DUSKY_MADDER_VIOLET_CMYK vec4(0.750, 1.000, 0.460, 0.300)
#endif
#ifndef DUSKY_MADDER_VIOLET_CMYK
#define DUSKY_MADDER_VIOLET_CMYK WADA_DUSKY_MADDER_VIOLET_CMYK
#endif

#ifndef WADA_WHITE
#define WADA_WHITE vec3(1.000, 1.000, 1.000)
#endif
#ifndef WHITE
#define WHITE WADA_WHITE
#endif
#ifndef WADA_WHITE_CMYK
#define WADA_WHITE_CMYK vec4(0.000, 0.000, 0.000, 0.000)
#endif
#ifndef WHITE_CMYK
#define WHITE_CMYK WADA_WHITE_CMYK
#endif

#ifndef WADA_NEUTRAL_GRAY
#define WADA_NEUTRAL_GRAY vec3(0.710, 0.820, 0.800)
#endif
#ifndef NEUTRAL_GRAY
#define NEUTRAL_GRAY WADA_NEUTRAL_GRAY
#endif
#ifndef WADA_NEUTRAL_GRAY_CMYK
#define WADA_NEUTRAL_GRAY_CMYK vec4(0.290, 0.180, 0.200, 0.000)
#endif
#ifndef NEUTRAL_GRAY_CMYK
#define NEUTRAL_GRAY_CMYK WADA_NEUTRAL_GRAY_CMYK
#endif

#ifndef WADA_MINERAL_GRAY
#define WADA_MINERAL_GRAY vec3(0.624, 0.761, 0.698)
#endif
#ifndef MINERAL_GRAY
#define MINERAL_GRAY WADA_MINERAL_GRAY
#endif
#ifndef WADA_MINERAL_GRAY_CMYK
#define WADA_MINERAL_GRAY_CMYK vec4(0.330, 0.180, 0.250, 0.070)
#endif
#ifndef MINERAL_GRAY_CMYK
#define MINERAL_GRAY_CMYK WADA_MINERAL_GRAY_CMYK
#endif

#ifndef WADA_WARM_GRAY
#define WADA_WARM_GRAY vec3(0.612, 0.698, 0.620)
#endif
#ifndef WARM_GRAY
#define WARM_GRAY WADA_WARM_GRAY
#endif
#ifndef WADA_WARM_GRAY_CMYK
#define WADA_WARM_GRAY_CMYK vec4(0.370, 0.280, 0.360, 0.030)
#endif
#ifndef WARM_GRAY_CMYK
#define WARM_GRAY_CMYK WADA_WARM_GRAY_CMYK
#endif

#ifndef WADA_SLATE_COLOR
#define WADA_SLATE_COLOR vec3(0.106, 0.212, 0.267)
#endif
#ifndef SLATE_COLOR
#define SLATE_COLOR WADA_SLATE_COLOR
#endif
#ifndef WADA_SLATE_COLOR_CMYK
#define WADA_SLATE_COLOR_CMYK vec4(0.850, 0.700, 0.620, 0.300)
#endif
#ifndef SLATE_COLOR_CMYK
#define SLATE_COLOR_CMYK WADA_SLATE_COLOR_CMYK
#endif

#ifndef WADA_BLACK
#define WADA_BLACK vec3(0.000, 0.000, 0.000)
#endif
#ifndef BLACK
#define BLACK WADA_BLACK
#endif
#ifndef WADA_BLACK_CMYK
#define WADA_BLACK_CMYK vec4(0.200, 0.100, 0.150, 1.000)
#endif
#ifndef BLACK_CMYK
#define BLACK_CMYK WADA_BLACK_CMYK
#endif

#ifndef FNC_PALETTE_WADA
#define FNC_PALETTE_WADA
    
vec3 wada( const int index ) {
    vec3 colors[157];
    colors[0] = WADA_HERMOSA_PINK;
    colors[1] = WADA_CORINTHIAN_PINK;
    colors[2] = WADA_CAMEO_PINK;
    colors[3] = WADA_FAWN;
    colors[4] = WADA_LIGHT_BROWN_DRAB;
    colors[5] = WADA_CORAL_RED;
    colors[6] = WADA_FRESH_COLOR;
    colors[7] = WADA_GRENADINE_PINK;
    colors[8] = WADA_EOSINE_PINK;
    colors[9] = WADA_SPINEL_RED;
    colors[10] = WADA_OLD_ROSE;
    colors[11] = WADA_EUGENIA_RED_A;
    colors[12] = WADA_EUGENIA_RED_B;
    colors[13] = WADA_RAW_SIENNA;
    colors[14] = WADA_VINACEOUS_TAWNY;
    colors[15] = WADA_JASPER_RED;
    colors[16] = WADA_SPECTRUM_RED;
    colors[17] = WADA_RED_ORANGE;
    colors[18] = WADA_ETRUSCAN_RED;
    colors[19] = WADA_BURNT_SIENNA;
    colors[20] = WADA_OCHRE_RED;
    colors[21] = WADA_SCARLET;
    colors[22] = WADA_CARMINE;
    colors[23] = WADA_INDIAN_LAKE;
    colors[24] = WADA_ROSOLANC_PURPLE;
    colors[25] = WADA_POMEGRANITE_PURPLE;
    colors[26] = WADA_HYDRANGEA_RED;
    colors[27] = WADA_BRICK_RED;
    colors[28] = WADA_CARMINE_RED;
    colors[29] = WADA_POMPEIAN_RED;
    colors[30] = WADA_RED;
    colors[31] = WADA_BROWN;
    colors[32] = WADA_HAYS_RUSSET;
    colors[33] = WADA_VANDYKE_RED;
    colors[34] = WADA_PANSY_PURPLE;
    colors[35] = WADA_PALE_BURNT_LAKE;
    colors[36] = WADA_VIOLET_RED;
    colors[37] = WADA_VISTORIS_LAKE;
    colors[38] = WADA_SULPHER_YELLOW;
    colors[39] = WADA_PALE_LEMON_YELLOW;
    colors[40] = WADA_NAPLES_YELLOW;
    colors[41] = WADA_IVORY_BUFF;
    colors[42] = WADA_SEASHELL_PINK;
    colors[43] = WADA_LIGHT_PINKISH_CINNAMON;
    colors[44] = WADA_PINKISH_CINNAMON;
    colors[45] = WADA_CINNAMON_BUFF;
    colors[46] = WADA_CREAM_YELLOW;
    colors[47] = WADA_GOLDEN_YELLOW;
    colors[48] = WADA_VINACEOUS_CINNAMON;
    colors[49] = WADA_OCHRACEOUS_SALMON;
    colors[50] = WADA_ISABELLA_COLOR;
    colors[51] = WADA_MAPLE;
    colors[52] = WADA_OLIVE_BUFF;
    colors[53] = WADA_ECRU;
    colors[54] = WADA_YELLOW;
    colors[55] = WADA_LEMON_YELLOW;
    colors[56] = WADA_APRICOT_YELLOW;
    colors[57] = WADA_PYRITE_YELLOW;
    colors[58] = WADA_OLIVE_OCHER;
    colors[59] = WADA_YELLOW_OCHER;
    colors[60] = WADA_ORANGE_YELLOW;
    colors[61] = WADA_YELLOW_ORANGE;
    colors[62] = WADA_APRICOT_ORANGE;
    colors[63] = WADA_ORANGE;
    colors[64] = WADA_PEACH_RED;
    colors[65] = WADA_ENGLISH_RED;
    colors[66] = WADA_CINNAMON_RUFOUS;
    colors[67] = WADA_ORANGE_RUFOUS;
    colors[68] = WADA_SULPHINE_YELLOW;
    colors[69] = WADA_KHAKI;
    colors[70] = WADA_CITRON_YELLOW;
    colors[71] = WADA_BUFFY_CITRINE;
    colors[72] = WADA_DARK_CITRINE;
    colors[73] = WADA_LIGHT_GRAYISH_OLIVE;
    colors[74] = WADA_KRONGBERGS_GREEN;
    colors[75] = WADA_OLIVE;
    colors[76] = WADA_ORANGE_CITRINE;
    colors[77] = WADA_SUDAN_BROWN;
    colors[78] = WADA_OLIVE_GREEN;
    colors[79] = WADA_LIGHT_BROWNISH_OLIVE;
    colors[80] = WADA_DEEP_GRAYISH_OLIVE;
    colors[81] = WADA_PALE_RAW_UMBER;
    colors[82] = WADA_SEPIA;
    colors[83] = WADA_MADDER_BROWN;
    colors[84] = WADA_MARS_BROWN_TOBACCO;
    colors[85] = WADA_VANDYKE_BROWN;
    colors[86] = WADA_TURQUOISE_GREEN;
    colors[87] = WADA_GLAUCOUS_GREEN;
    colors[88] = WADA_DARK_GREENISH_GLAUCOUS;
    colors[89] = WADA_YELLOW_GREEN;
    colors[90] = WADA_LIGHT_GREEN_YELLOW;
    colors[91] = WADA_NIGHT_GREEN;
    colors[92] = WADA_OLIVE_YELLOW;
    colors[93] = WADA_ARTEMESIA_GREEN;
    colors[94] = WADA_ANDOVER_GREEN;
    colors[95] = WADA_RAINETTE_GREEN;
    colors[96] = WADA_PISTACHIO_GREEN;
    colors[97] = WADA_SEA_GREEN;
    colors[98] = WADA_BENZOL_GREEN;
    colors[99] = WADA_LIGHT_PORCELAIN_GREEN;
    colors[100] = WADA_GREEN;
    colors[101] = WADA_DULL_VIRIDIAN_GREEN;
    colors[102] = WADA_OIL_GREEN;
    colors[103] = WADA_DIAMINE_GREEN;
    colors[104] = WADA_COSSACK_GREEN;
    colors[105] = WADA_LINCOLN_GREEN;
    colors[106] = WADA_BLACKISH_OLIVE;
    colors[107] = WADA_DEEP_SLATE_OLIVE;
    colors[108] = WADA_NILE_BLUE;
    colors[109] = WADA_PALE_KINGS_BLUE;
    colors[110] = WADA_LIGHT_GLAUCOUS_BLUE;
    colors[111] = WADA_SALVIA_BLUE;
    colors[112] = WADA_COBALT_GREEN;
    colors[113] = WADA_CALAMINE_BLUE;
    colors[114] = WADA_VENICE_GREEN;
    colors[115] = WADA_CERULIAN_BLUE;
    colors[116] = WADA_PEACOCK_BLUE;
    colors[117] = WADA_GREEN_BLUE;
    colors[118] = WADA_OLYMPIC_BLUE;
    colors[119] = WADA_BLUE;
    colors[120] = WADA_ANTWARP_BLUE;
    colors[121] = WADA_HELVETIA_BLUE;
    colors[122] = WADA_DARK_MEDICI_BLUE;
    colors[123] = WADA_DUSKY_GREEN;
    colors[124] = WADA_DEEP_LYONS_BLUE;
    colors[125] = WADA_VIOLET_BLUE;
    colors[126] = WADA_VANDAR_POELS_BLUE;
    colors[127] = WADA_DARK_TYRIAN_BLUE;
    colors[128] = WADA_DULL_VIOLET_BLACK;
    colors[129] = WADA_DEEP_INDIGO;
    colors[130] = WADA_DEEP_SLATE_GREEN;
    colors[131] = WADA_GRAYISH_LAVENDER_A;
    colors[132] = WADA_GRAYISH_LAVENDER_B;
    colors[133] = WADA_LAELIA_PINK;
    colors[134] = WADA_LILAC;
    colors[135] = WADA_EUPATORIUM_PURPLE;
    colors[136] = WADA_LIGHT_MAUVE;
    colors[137] = WADA_ACONITE_VIOLET;
    colors[138] = WADA_DULL_BLUE_VIOLET;
    colors[139] = WADA_DARK_SOFT_VIOLET;
    colors[140] = WADA_BLUE_VIOLET;
    colors[141] = WADA_PURPLE_DRAB;
    colors[142] = WADA_DEEP_VIOLET_PLUMBEOUS;
    colors[143] = WADA_VERONIA_PURPLE;
    colors[144] = WADA_DARK_SLATE_PURPLE;
    colors[145] = WADA_TAUPE_BROWN;
    colors[146] = WADA_VIOLET_CARMINE;
    colors[147] = WADA_VIOLET;
    colors[148] = WADA_RED_VIOLET;
    colors[149] = WADA_COTINGA_PURPLE;
    colors[150] = WADA_DUSKY_MADDER_VIOLET;
    colors[151] = WADA_WHITE;
    colors[152] = WADA_NEUTRAL_GRAY;
    colors[153] = WADA_MINERAL_GRAY;
    colors[154] = WADA_WARM_GRAY;
    colors[155] = WADA_SLATE_COLOR;
    colors[156] = WADA_BLACK;

    #if defined(PLATFORM_WEBGL)
    for (int i = 0; i < WADA_TOTAL; i++)
        if (i == index) return colors[i];
    #else
    return colors[index];
    #endif
}

vec4 wadaCMYK( const int index ) {
    vec4 colors[157];
    colors[0] = WADA_HERMOSA_PINK_CMYK;
    colors[1] = WADA_CORINTHIAN_PINK_CMYK;
    colors[2] = WADA_CAMEO_PINK_CMYK;
    colors[3] = WADA_FAWN_CMYK;
    colors[4] = WADA_LIGHT_BROWN_DRAB_CMYK;
    colors[5] = WADA_CORAL_RED_CMYK;
    colors[6] = WADA_FRESH_COLOR_CMYK;
    colors[7] = WADA_GRENADINE_PINK_CMYK;
    colors[8] = WADA_EOSINE_PINK_CMYK;
    colors[9] = WADA_SPINEL_RED_CMYK;
    colors[10] = WADA_OLD_ROSE_CMYK;
    colors[11] = WADA_EUGENIA_RED_A_CMYK;
    colors[12] = WADA_EUGENIA_RED_B_CMYK;
    colors[13] = WADA_RAW_SIENNA_CMYK;
    colors[14] = WADA_VINACEOUS_TAWNY_CMYK;
    colors[15] = WADA_JASPER_RED_CMYK;
    colors[16] = WADA_SPECTRUM_RED_CMYK;
    colors[17] = WADA_RED_ORANGE_CMYK;
    colors[18] = WADA_ETRUSCAN_RED_CMYK;
    colors[19] = WADA_BURNT_SIENNA_CMYK;
    colors[20] = WADA_OCHRE_RED_CMYK;
    colors[21] = WADA_SCARLET_CMYK;
    colors[22] = WADA_CARMINE_CMYK;
    colors[23] = WADA_INDIAN_LAKE_CMYK;
    colors[24] = WADA_ROSOLANC_PURPLE_CMYK;
    colors[25] = WADA_POMEGRANITE_PURPLE_CMYK;
    colors[26] = WADA_HYDRANGEA_RED_CMYK;
    colors[27] = WADA_BRICK_RED_CMYK;
    colors[28] = WADA_CARMINE_RED_CMYK;
    colors[29] = WADA_POMPEIAN_RED_CMYK;
    colors[30] = WADA_RED_CMYK;
    colors[31] = WADA_BROWN_CMYK;
    colors[32] = WADA_HAYS_RUSSET_CMYK;
    colors[33] = WADA_VANDYKE_RED_CMYK;
    colors[34] = WADA_PANSY_PURPLE_CMYK;
    colors[35] = WADA_PALE_BURNT_LAKE_CMYK;
    colors[36] = WADA_VIOLET_RED_CMYK;
    colors[37] = WADA_VISTORIS_LAKE_CMYK;
    colors[38] = WADA_SULPHER_YELLOW_CMYK;
    colors[39] = WADA_PALE_LEMON_YELLOW_CMYK;
    colors[40] = WADA_NAPLES_YELLOW_CMYK;
    colors[41] = WADA_IVORY_BUFF_CMYK;
    colors[42] = WADA_SEASHELL_PINK_CMYK;
    colors[43] = WADA_LIGHT_PINKISH_CINNAMON_CMYK;
    colors[44] = WADA_PINKISH_CINNAMON_CMYK;
    colors[45] = WADA_CINNAMON_BUFF_CMYK;
    colors[46] = WADA_CREAM_YELLOW_CMYK;
    colors[47] = WADA_GOLDEN_YELLOW_CMYK;
    colors[48] = WADA_VINACEOUS_CINNAMON_CMYK;
    colors[49] = WADA_OCHRACEOUS_SALMON_CMYK;
    colors[50] = WADA_ISABELLA_COLOR_CMYK;
    colors[51] = WADA_MAPLE_CMYK;
    colors[52] = WADA_OLIVE_BUFF_CMYK;
    colors[53] = WADA_ECRU_CMYK;
    colors[54] = WADA_YELLOW_CMYK;
    colors[55] = WADA_LEMON_YELLOW_CMYK;
    colors[56] = WADA_APRICOT_YELLOW_CMYK;
    colors[57] = WADA_PYRITE_YELLOW_CMYK;
    colors[58] = WADA_OLIVE_OCHER_CMYK;
    colors[59] = WADA_YELLOW_OCHER_CMYK;
    colors[60] = WADA_ORANGE_YELLOW_CMYK;
    colors[61] = WADA_YELLOW_ORANGE_CMYK;
    colors[62] = WADA_APRICOT_ORANGE_CMYK;
    colors[63] = WADA_ORANGE_CMYK;
    colors[64] = WADA_PEACH_RED_CMYK;
    colors[65] = WADA_ENGLISH_RED_CMYK;
    colors[66] = WADA_CINNAMON_RUFOUS_CMYK;
    colors[67] = WADA_ORANGE_RUFOUS_CMYK;
    colors[68] = WADA_SULPHINE_YELLOW_CMYK;
    colors[69] = WADA_KHAKI_CMYK;
    colors[70] = WADA_CITRON_YELLOW_CMYK;
    colors[71] = WADA_BUFFY_CITRINE_CMYK;
    colors[72] = WADA_DARK_CITRINE_CMYK;
    colors[73] = WADA_LIGHT_GRAYISH_OLIVE_CMYK;
    colors[74] = WADA_KRONGBERGS_GREEN_CMYK;
    colors[75] = WADA_OLIVE_CMYK;
    colors[76] = WADA_ORANGE_CITRINE_CMYK;
    colors[77] = WADA_SUDAN_BROWN_CMYK;
    colors[78] = WADA_OLIVE_GREEN_CMYK;
    colors[79] = WADA_LIGHT_BROWNISH_OLIVE_CMYK;
    colors[80] = WADA_DEEP_GRAYISH_OLIVE_CMYK;
    colors[81] = WADA_PALE_RAW_UMBER_CMYK;
    colors[82] = WADA_SEPIA_CMYK;
    colors[83] = WADA_MADDER_BROWN_CMYK;
    colors[84] = WADA_MARS_BROWN_TOBACCO_CMYK;
    colors[85] = WADA_VANDYKE_BROWN_CMYK;
    colors[86] = WADA_TURQUOISE_GREEN_CMYK;
    colors[87] = WADA_GLAUCOUS_GREEN_CMYK;
    colors[88] = WADA_DARK_GREENISH_GLAUCOUS_CMYK;
    colors[89] = WADA_YELLOW_GREEN_CMYK;
    colors[90] = WADA_LIGHT_GREEN_YELLOW_CMYK;
    colors[91] = WADA_NIGHT_GREEN_CMYK;
    colors[92] = WADA_OLIVE_YELLOW_CMYK;
    colors[93] = WADA_ARTEMESIA_GREEN_CMYK;
    colors[94] = WADA_ANDOVER_GREEN_CMYK;
    colors[95] = WADA_RAINETTE_GREEN_CMYK;
    colors[96] = WADA_PISTACHIO_GREEN_CMYK;
    colors[97] = WADA_SEA_GREEN_CMYK;
    colors[98] = WADA_BENZOL_GREEN_CMYK;
    colors[99] = WADA_LIGHT_PORCELAIN_GREEN_CMYK;
    colors[100] = WADA_GREEN_CMYK;
    colors[101] = WADA_DULL_VIRIDIAN_GREEN_CMYK;
    colors[102] = WADA_OIL_GREEN_CMYK;
    colors[103] = WADA_DIAMINE_GREEN_CMYK;
    colors[104] = WADA_COSSACK_GREEN_CMYK;
    colors[105] = WADA_LINCOLN_GREEN_CMYK;
    colors[106] = WADA_BLACKISH_OLIVE_CMYK;
    colors[107] = WADA_DEEP_SLATE_OLIVE_CMYK;
    colors[108] = WADA_NILE_BLUE_CMYK;
    colors[109] = WADA_PALE_KINGS_BLUE_CMYK;
    colors[110] = WADA_LIGHT_GLAUCOUS_BLUE_CMYK;
    colors[111] = WADA_SALVIA_BLUE_CMYK;
    colors[112] = WADA_COBALT_GREEN_CMYK;
    colors[113] = WADA_CALAMINE_BLUE_CMYK;
    colors[114] = WADA_VENICE_GREEN_CMYK;
    colors[115] = WADA_CERULIAN_BLUE_CMYK;
    colors[116] = WADA_PEACOCK_BLUE_CMYK;
    colors[117] = WADA_GREEN_BLUE_CMYK;
    colors[118] = WADA_OLYMPIC_BLUE_CMYK;
    colors[119] = WADA_BLUE_CMYK;
    colors[120] = WADA_ANTWARP_BLUE_CMYK;
    colors[121] = WADA_HELVETIA_BLUE_CMYK;
    colors[122] = WADA_DARK_MEDICI_BLUE_CMYK;
    colors[123] = WADA_DUSKY_GREEN_CMYK;
    colors[124] = WADA_DEEP_LYONS_BLUE_CMYK;
    colors[125] = WADA_VIOLET_BLUE_CMYK;
    colors[126] = WADA_VANDAR_POELS_BLUE_CMYK;
    colors[127] = WADA_DARK_TYRIAN_BLUE_CMYK;
    colors[128] = WADA_DULL_VIOLET_BLACK_CMYK;
    colors[129] = WADA_DEEP_INDIGO_CMYK;
    colors[130] = WADA_DEEP_SLATE_GREEN_CMYK;
    colors[131] = WADA_GRAYISH_LAVENDER_A_CMYK;
    colors[132] = WADA_GRAYISH_LAVENDER_B_CMYK;
    colors[133] = WADA_LAELIA_PINK_CMYK;
    colors[134] = WADA_LILAC_CMYK;
    colors[135] = WADA_EUPATORIUM_PURPLE_CMYK;
    colors[136] = WADA_LIGHT_MAUVE_CMYK;
    colors[137] = WADA_ACONITE_VIOLET_CMYK;
    colors[138] = WADA_DULL_BLUE_VIOLET_CMYK;
    colors[139] = WADA_DARK_SOFT_VIOLET_CMYK;
    colors[140] = WADA_BLUE_VIOLET_CMYK;
    colors[141] = WADA_PURPLE_DRAB_CMYK;
    colors[142] = WADA_DEEP_VIOLET_PLUMBEOUS_CMYK;
    colors[143] = WADA_VERONIA_PURPLE_CMYK;
    colors[144] = WADA_DARK_SLATE_PURPLE_CMYK;
    colors[145] = WADA_TAUPE_BROWN_CMYK;
    colors[146] = WADA_VIOLET_CARMINE_CMYK;
    colors[147] = WADA_VIOLET_CMYK;
    colors[148] = WADA_RED_VIOLET_CMYK;
    colors[149] = WADA_COTINGA_PURPLE_CMYK;
    colors[150] = WADA_DUSKY_MADDER_VIOLET_CMYK;
    colors[151] = WADA_WHITE_CMYK;
    colors[152] = WADA_NEUTRAL_GRAY_CMYK;
    colors[153] = WADA_MINERAL_GRAY_CMYK;
    colors[154] = WADA_WARM_GRAY_CMYK;
    colors[155] = WADA_SLATE_COLOR_CMYK;
    colors[156] = WADA_BLACK_CMYK;

    #if defined(PLATFORM_WEBGL)
    for (int i = 0; i < WADA_TOTAL; i++)
        if (i == index) return colors[i];
    #else
    return colors[index];
    #endif
}
#endif
