/*
 * Decompiled with CFR 0.152.
 */
package io.raven.db;

import io.raven.db.UniMatrixException;
import java.util.function.Function;
import lombok.Generated;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class TransactionManager {
    private final SessionFactory sessionFactory;
    private final boolean readOnly;
    private Session session;

    public TransactionManager(SessionFactory sessionFactory, boolean readOnly) {
        this.sessionFactory = sessionFactory;
        this.readOnly = readOnly;
    }

    public void beforeStart() {
        this.session = this.sessionFactory.openSession();
        try {
            this.configureSession();
            ManagedSessionContext.bind((Session)this.session);
            this.session.beginTransaction();
        }
        catch (Exception t) {
            this.session.close();
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
            throw t;
        }
    }

    private void configureSession() {
        this.session.setDefaultReadOnly(this.readOnly);
        this.session.setCacheMode(CacheMode.NORMAL);
        this.session.setHibernateFlushMode(FlushMode.AUTO);
    }

    public void afterEnd() {
        if (this.session == null) {
            return;
        }
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            throw e;
        }
        finally {
            this.session.close();
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
        }
    }

    private void commitTransaction() {
        Transaction txn = this.session.getTransaction();
        if (txn != null && txn.getStatus() == TransactionStatus.ACTIVE) {
            txn.commit();
        }
    }

    private void rollbackTransaction() {
        Transaction txn = this.session.getTransaction();
        if (txn != null && txn.getStatus() == TransactionStatus.ACTIVE) {
            txn.rollback();
        }
    }

    public void onError(Exception e) {
        if (this.session == null) {
            return;
        }
        try {
            if (!(e instanceof ConstraintViolationException)) {
                this.rollbackTransaction();
            }
        }
        finally {
            this.session.close();
            this.session = null;
            ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
        }
    }

    public <T, U> T execute(Function<U, T> function, U arg) throws UniMatrixException {
        return (T)this.execute(function, arg, t -> t);
    }

    public <T, U, V> V execute(Function<U, T> function, U arg, Function<T, V> handler) throws UniMatrixException {
        return this.execute(function, arg, handler, true);
    }

    public <T, U, V> V execute(Function<U, T> function, U arg, Function<T, V> handler, boolean completeTransaction) throws UniMatrixException {
        if (completeTransaction) {
            this.beforeStart();
        }
        try {
            T result = function.apply(arg);
            V returnValue = handler.apply(result);
            if (completeTransaction) {
                this.afterEnd();
            }
            return returnValue;
        }
        catch (Exception e) {
            if (completeTransaction) {
                this.onError(e);
            }
            throw UniMatrixException.from().exception(e).build();
        }
    }

    @Generated
    public static TransactionManagerBuilder newTransaction() {
        return new TransactionManagerBuilder();
    }

    @Generated
    public Session getSession() {
        return this.session;
    }

    @Generated
    public static class TransactionManagerBuilder {
        @Generated
        private SessionFactory sessionFactory;
        @Generated
        private boolean readOnly;

        @Generated
        TransactionManagerBuilder() {
        }

        @Generated
        public TransactionManagerBuilder sessionFactory(SessionFactory sessionFactory) {
            this.sessionFactory = sessionFactory;
            return this;
        }

        @Generated
        public TransactionManagerBuilder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Generated
        public TransactionManager build() {
            return new TransactionManager(this.sessionFactory, this.readOnly);
        }

        @Generated
        public String toString() {
            return "TransactionManager.TransactionManagerBuilder(sessionFactory=" + this.sessionFactory + ", readOnly=" + this.readOnly + ")";
        }
    }
}

