/*
 * Decompiled with CFR 0.152.
 */
package io.raven.db;

import com.google.common.base.Strings;
import io.raven.db.UniMatrixConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;

public class UniMatrix {
    private SessionFactory sessionFactory;
    private final UniMatrixConfig config;
    private final List<Class<?>> entities;

    public UniMatrix(UniMatrixConfig uniMatrixConfig, List<Class<?>> entities) {
        this.config = uniMatrixConfig;
        this.entities = entities;
        this.init();
    }

    private void init() {
        this.sessionFactory = this.getOrCreateSessionFactory();
    }

    public void close() {
        if (Objects.nonNull(this.sessionFactory) && !this.sessionFactory.isClosed()) {
            this.sessionFactory.close();
        }
    }

    public synchronized SessionFactory getOrCreateSessionFactory() {
        if (!Objects.isNull(this.sessionFactory)) {
            return this.sessionFactory;
        }
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("hibernate.hbm2ddl.auto", this.config.isCreateSchema() ? "create-drop" : "none");
        settings.put("hibernate.show_sql", this.config.isShowSql());
        settings.put("hibernate.current_session_context_class", "managed");
        settings.put("hibernate.dialect", this.config.getDialect());
        settings.put("hibernate.connection.url", this.config.getUrl());
        if (!Strings.isNullOrEmpty((String)this.config.getUser())) {
            settings.put("hibernate.connection.username", this.config.getUser());
        }
        if (!Strings.isNullOrEmpty((String)this.config.getPassword())) {
            settings.put("hibernate.connection.password", this.config.getPassword());
        }
        settings.put("hibernate.connection.driver_class", this.config.getDriverClass());
        settings.put("hibernate.hikari.connectionTimeout", "20000");
        settings.put("hibernate.hikari.minimumIdle", String.valueOf(this.config.getMinPoolSize()));
        settings.put("hibernate.hikari.maximumPoolSize", String.valueOf(this.config.getMaxPoolSize()));
        settings.put("hibernate.hikari.idleTimeout", String.valueOf(this.config.getIdleTimeout()));
        settings.put("hibernate.hikari.connectionTestQuery", this.config.getTestQuery());
        settings.put("hibernate.hikari.autoCommit", "false");
        settings.put("hibernate.hikari.maxLifetime", String.valueOf(this.config.getMaxAge()));
        registryBuilder.applySettings(settings);
        StandardServiceRegistry registry = registryBuilder.build();
        MetadataSources sources = new MetadataSources((ServiceRegistry)registry);
        this.entities.forEach(arg_0 -> ((MetadataSources)sources).addAnnotatedClass(arg_0));
        Metadata metadata = sources.getMetadataBuilder().build();
        this.sessionFactory = metadata.getSessionFactoryBuilder().applyStatisticsSupport(false).build();
        return this.sessionFactory;
    }

    @Generated
    public static UniMatrixBuilder builder() {
        return new UniMatrixBuilder();
    }

    @Generated
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Generated
    public static class UniMatrixBuilder {
        @Generated
        private UniMatrixConfig uniMatrixConfig;
        @Generated
        private ArrayList<Class<?>> entities;

        @Generated
        UniMatrixBuilder() {
        }

        @Generated
        public UniMatrixBuilder uniMatrixConfig(UniMatrixConfig uniMatrixConfig) {
            this.uniMatrixConfig = uniMatrixConfig;
            return this;
        }

        @Generated
        public UniMatrixBuilder entity(Class<?> entity) {
            if (this.entities == null) {
                this.entities = new ArrayList();
            }
            this.entities.add(entity);
            return this;
        }

        @Generated
        public UniMatrixBuilder entities(Collection<? extends Class<?>> entities) {
            if (entities == null) {
                throw new NullPointerException("entities cannot be null");
            }
            if (this.entities == null) {
                this.entities = new ArrayList();
            }
            this.entities.addAll(entities);
            return this;
        }

        @Generated
        public UniMatrixBuilder clearEntities() {
            if (this.entities != null) {
                this.entities.clear();
            }
            return this;
        }

        @Generated
        public UniMatrix build() {
            List<Class<?>> entities;
            switch (this.entities == null ? 0 : this.entities.size()) {
                case 0: {
                    entities = Collections.emptyList();
                    break;
                }
                case 1: {
                    entities = Collections.singletonList(this.entities.get(0));
                    break;
                }
                default: {
                    entities = Collections.unmodifiableList(new ArrayList(this.entities));
                }
            }
            return new UniMatrix(this.uniMatrixConfig, entities);
        }

        @Generated
        public String toString() {
            return "UniMatrix.UniMatrixBuilder(uniMatrixConfig=" + this.uniMatrixConfig + ", entities=" + this.entities + ")";
        }
    }
}

