(ns sc.nrepl.impl
  (:require [sc.api]
            [clojure.string :as str]
            [rewrite-clj.node :as rwn]
            [rewrite-clj.parser :as rwp]))


(defonce current-ep-id (atom nil))

;; ------------------------------------------------------------------------------
;; nREPL middleware

(defn read-tl-forms
  [^String s]
  (let [res (->> (rwp/parse-string-all s)
                 :children
                 (map (fn [n]
                        (rwn/string n)))
                 (remove #(-> % str/trim empty?))
                 vec)]
    res))

(defn add-letsc
  [ep-id s]
  (if (some? ep-id)
    (let [forms (read-tl-forms s)]
      (->> forms
        (map (fn [s1]
               (str "(sc.api/letsc " (pr-str ep-id) " " s1 ")")))
        (apply str)))
    s))

(defn rewrite-args
  [ep-id args]
  (if
    (nil? ep-id)
    args
    (update args 0
      (fn [arg]
        (cond
          (and
            (-> arg :op (= "load-file"))
            (string? (:file arg)))
          (update arg :file #(add-letsc ep-id %))

          (and
            (-> arg :op (= "eval"))
            (string? (:code arg)))
          (update arg :code #(add-letsc ep-id %))

          :else
          arg)))))

(defn wrap-handle
  [handler args]
  ;(prn :nrepl args)
  ;(swap! a conj (-> args first (dissoc :transport)))
  (apply handler #_args (rewrite-args @current-ep-id args)))

(comment
  (reset! current-ep-id nil)

  (rewrite-args @current-ep-id
    [{:file "(in-ns 'bf.nrepl)\n\n\n\n\n\n\n\n\n(+ 1 2)", :file-name "nrepl.cljc", :file-path "/Users/val/projects/breakform/src/bf/nrepl.cljc", :id "65172bfb-6638-4b40-a8b7-85b9932d7c09", :op "load-file", :session "144d968e-5ccb-4f41-9f98-69c76ac73e7b", :transport nil}])

  (def s "(in-ns 'bf.nrepl)\n\n\n\n\n\n@a")

  (read-tl-forms "(in-ns 'bf.nrepl)\n\n\n\n\n\n@a")
  (read-tl-forms "(in-ns 'bf.nrepl)\n\n\n\n\n\n\n\n\n(+ 1 2)")

  )
