/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.nlpub.watset.graph.Clustering;

public interface ILEFormat {
    public static final String SEPARATOR = "\t";
    public static final String DELIMITER = ", ";

    public static void write(Path path, Clustering<String> clustering) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            AtomicInteger counter = new AtomicInteger(0);
            clustering.getClusters().stream().sorted((smaller, larger) -> Integer.compare(larger.size(), smaller.size())).forEach(cluster -> {
                try {
                    writer.write(String.format(Locale.ROOT, "%d%s%d%s%s%n", counter.incrementAndGet(), SEPARATOR, cluster.size(), SEPARATOR, String.join((CharSequence)DELIMITER, cluster)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

