/*
 * Decompiled with CFR 0.152.
 */
package io.github.shamsimam;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.net.CookieManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CookieStoreInterceptor
implements ClientInterceptor {
    private static final Logger logger = Logger.getLogger(CookieStoreInterceptor.class.getName());
    private static final Metadata.Key<String> SET_COOKIE_KEY = CookieStoreInterceptor.createMetadataKey("set-cookie");
    private static final Metadata.Key<String> SET_COOKIE2_KEY = CookieStoreInterceptor.createMetadataKey("set-cookie2");
    protected static final List<Metadata.Key<String>> SET_COOKIE_KEYS = Arrays.asList(SET_COOKIE_KEY, SET_COOKIE2_KEY);
    private final CookieManager cookieManager;
    private final boolean usePlainText;

    private static Metadata.Key<String> createMetadataKey(String headerKey) {
        return Metadata.Key.of((String)headerKey, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    }

    public CookieStoreInterceptor() {
        this(new CookieManager());
    }

    public CookieStoreInterceptor(CookieManager cookieManager) {
        this(false, cookieManager);
    }

    public CookieStoreInterceptor(boolean usePlainText, CookieManager cookieManager) {
        this.usePlainText = usePlainText;
        this.cookieManager = cookieManager;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> methodDescriptor, final CallOptions callOptions, final Channel nextChannel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(nextChannel.newCall(methodDescriptor, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata requestHeaders) {
                String authority = CookieStoreInterceptor.this.retrieveAuthority(callOptions, nextChannel);
                String fullMethodName = methodDescriptor.getFullMethodName();
                final URI callPathUri = CookieStoreInterceptor.this.createUri(authority, fullMethodName);
                CookieStoreInterceptor.this.addRequestCookies(callPathUri, requestHeaders);
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata responseHeaders) {
                        CookieStoreInterceptor.this.processResponseCookies(callPathUri, responseHeaders);
                        super.onHeaders(responseHeaders);
                    }
                }, requestHeaders);
            }
        };
    }

    protected String retrieveAuthority(CallOptions callOptions, Channel channel) {
        String callOptionsAuthority = callOptions.getAuthority();
        if (callOptionsAuthority != null) {
            return callOptionsAuthority;
        }
        String channelAuthority = channel.authority();
        if (channelAuthority != null) {
            return channelAuthority;
        }
        throw new IllegalStateException("authority cannot be determined for request!");
    }

    protected void addRequestCookies(URI callPathUri, Metadata requestHeaders) {
        Map<String, List<String>> httpCookies = this.getCookies(callPathUri, requestHeaders);
        if (!httpCookies.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : httpCookies.entrySet()) {
                String headerKey = entry.getKey();
                List<String> headerValues = entry.getValue();
                if (headerValues == null) continue;
                Metadata.Key<String> metadataKey = CookieStoreInterceptor.createMetadataKey(headerKey);
                for (String headerValue : headerValues) {
                    requestHeaders.put(metadataKey, (Object)headerValue);
                }
            }
        }
    }

    protected void processResponseCookies(URI callPathUri, Metadata responseHeaders) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(SET_COOKIE_KEYS.size());
        for (Metadata.Key<String> headerKey : SET_COOKIE_KEYS) {
            if (!responseHeaders.containsKey(headerKey)) continue;
            String headerValue = String.valueOf(responseHeaders.get(headerKey));
            headers.put(headerKey.originalName(), Collections.singletonList(headerValue));
        }
        if (!headers.isEmpty()) {
            try {
                this.cookieManager.put(callPathUri, headers);
            }
            catch (Throwable th) {
                logger.log(Level.SEVERE, "error is parsing cookies", th);
            }
        }
    }

    private URI createUri(String authority, String fullMethodName) {
        String url = (this.usePlainText ? "http://" : "https://") + authority + "/" + fullMethodName;
        return URI.create(url);
    }

    private Map<String, List<String>> getCookies(URI callPathUri, Metadata requestMetadata) {
        try {
            Set requestMetadataKeys = requestMetadata.keys();
            HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>(requestMetadataKeys.size());
            for (String key : requestMetadataKeys) {
                Metadata.Key<String> metadataKey = CookieStoreInterceptor.createMetadataKey(key);
                Iterable metadataValues = requestMetadata.getAll(metadataKey);
                if (metadataValues == null) continue;
                ArrayList<String> headerValues = new ArrayList<String>();
                for (String metadataValue : metadataValues) {
                    if (metadataValue == null) continue;
                    headerValues.add(metadataValue);
                }
                requestHeaders.put(key, headerValues);
            }
            return this.cookieManager.get(callPathUri, requestHeaders);
        }
        catch (Throwable th) {
            logger.log(Level.SEVERE, "error in retrieving cookies", th);
            return Collections.emptyMap();
        }
    }
}

