goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__12678 = arguments.length;
switch (G__12678) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12680 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12680 = (function (f,blockable,meta12681){
this.f = f;
this.blockable = blockable;
this.meta12681 = meta12681;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12680.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12682,meta12681__$1){
var self__ = this;
var _12682__$1 = this;
return (new cljs.core.async.t_cljs$core$async12680(self__.f,self__.blockable,meta12681__$1));
}));

(cljs.core.async.t_cljs$core$async12680.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12682){
var self__ = this;
var _12682__$1 = this;
return self__.meta12681;
}));

(cljs.core.async.t_cljs$core$async12680.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12680.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12680.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async12680.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async12680.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta12681","meta12681",-1856194023,null)], null);
}));

(cljs.core.async.t_cljs$core$async12680.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12680.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12680");

(cljs.core.async.t_cljs$core$async12680.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async12680");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12680.
 */
cljs.core.async.__GT_t_cljs$core$async12680 = (function cljs$core$async$__GT_t_cljs$core$async12680(f__$1,blockable__$1,meta12681){
return (new cljs.core.async.t_cljs$core$async12680(f__$1,blockable__$1,meta12681));
});

}

return (new cljs.core.async.t_cljs$core$async12680(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__12686 = arguments.length;
switch (G__12686) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__12688 = arguments.length;
switch (G__12688) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__12690 = arguments.length;
switch (G__12690) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_14184 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14184) : fn1.call(null,val_14184));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14184) : fn1.call(null,val_14184));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__12692 = arguments.length;
switch (G__12692) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4695__auto___14188 = n;
var x_14189 = (0);
while(true){
if((x_14189 < n__4695__auto___14188)){
(a[x_14189] = x_14189);

var G__14190 = (x_14189 + (1));
x_14189 = G__14190;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12693 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12693 = (function (flag,meta12694){
this.flag = flag;
this.meta12694 = meta12694;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12693.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12695,meta12694__$1){
var self__ = this;
var _12695__$1 = this;
return (new cljs.core.async.t_cljs$core$async12693(self__.flag,meta12694__$1));
}));

(cljs.core.async.t_cljs$core$async12693.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12695){
var self__ = this;
var _12695__$1 = this;
return self__.meta12694;
}));

(cljs.core.async.t_cljs$core$async12693.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12693.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12693.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12693.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async12693.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta12694","meta12694",-1346535304,null)], null);
}));

(cljs.core.async.t_cljs$core$async12693.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12693.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12693");

(cljs.core.async.t_cljs$core$async12693.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async12693");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12693.
 */
cljs.core.async.__GT_t_cljs$core$async12693 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async12693(flag__$1,meta12694){
return (new cljs.core.async.t_cljs$core$async12693(flag__$1,meta12694));
});

}

return (new cljs.core.async.t_cljs$core$async12693(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12696 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12696 = (function (flag,cb,meta12697){
this.flag = flag;
this.cb = cb;
this.meta12697 = meta12697;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12696.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12698,meta12697__$1){
var self__ = this;
var _12698__$1 = this;
return (new cljs.core.async.t_cljs$core$async12696(self__.flag,self__.cb,meta12697__$1));
}));

(cljs.core.async.t_cljs$core$async12696.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12698){
var self__ = this;
var _12698__$1 = this;
return self__.meta12697;
}));

(cljs.core.async.t_cljs$core$async12696.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12696.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12696.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12696.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async12696.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta12697","meta12697",960383517,null)], null);
}));

(cljs.core.async.t_cljs$core$async12696.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12696.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12696");

(cljs.core.async.t_cljs$core$async12696.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async12696");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12696.
 */
cljs.core.async.__GT_t_cljs$core$async12696 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async12696(flag__$1,cb__$1,meta12697){
return (new cljs.core.async.t_cljs$core$async12696(flag__$1,cb__$1,meta12697));
});

}

return (new cljs.core.async.t_cljs$core$async12696(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12699_SHARP_){
var G__12701 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12699_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12701) : fret.call(null,G__12701));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12700_SHARP_){
var G__12702 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12700_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12702) : fret.call(null,G__12702));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4212__auto__ = wport;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14191 = (i + (1));
i = G__14191;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4212__auto__ = ret;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4210__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4210__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___14192 = arguments.length;
var i__4819__auto___14193 = (0);
while(true){
if((i__4819__auto___14193 < len__4818__auto___14192)){
args__4824__auto__.push((arguments[i__4819__auto___14193]));

var G__14194 = (i__4819__auto___14193 + (1));
i__4819__auto___14193 = G__14194;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12705){
var map__12706 = p__12705;
var map__12706__$1 = cljs.core.__destructure_map(map__12706);
var opts = map__12706__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12703){
var G__12704 = cljs.core.first(seq12703);
var seq12703__$1 = cljs.core.next(seq12703);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12704,seq12703__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__12708 = arguments.length;
switch (G__12708) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12619__auto___14197 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_12732){
var state_val_12733 = (state_12732[(1)]);
if((state_val_12733 === (7))){
var inst_12728 = (state_12732[(2)]);
var state_12732__$1 = state_12732;
var statearr_12734_14198 = state_12732__$1;
(statearr_12734_14198[(2)] = inst_12728);

(statearr_12734_14198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (1))){
var state_12732__$1 = state_12732;
var statearr_12735_14199 = state_12732__$1;
(statearr_12735_14199[(2)] = null);

(statearr_12735_14199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (4))){
var inst_12711 = (state_12732[(7)]);
var inst_12711__$1 = (state_12732[(2)]);
var inst_12712 = (inst_12711__$1 == null);
var state_12732__$1 = (function (){var statearr_12736 = state_12732;
(statearr_12736[(7)] = inst_12711__$1);

return statearr_12736;
})();
if(cljs.core.truth_(inst_12712)){
var statearr_12737_14201 = state_12732__$1;
(statearr_12737_14201[(1)] = (5));

} else {
var statearr_12738_14202 = state_12732__$1;
(statearr_12738_14202[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (13))){
var state_12732__$1 = state_12732;
var statearr_12739_14203 = state_12732__$1;
(statearr_12739_14203[(2)] = null);

(statearr_12739_14203[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (6))){
var inst_12711 = (state_12732[(7)]);
var state_12732__$1 = state_12732;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12732__$1,(11),to,inst_12711);
} else {
if((state_val_12733 === (3))){
var inst_12730 = (state_12732[(2)]);
var state_12732__$1 = state_12732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12732__$1,inst_12730);
} else {
if((state_val_12733 === (12))){
var state_12732__$1 = state_12732;
var statearr_12742_14205 = state_12732__$1;
(statearr_12742_14205[(2)] = null);

(statearr_12742_14205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (2))){
var state_12732__$1 = state_12732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12732__$1,(4),from);
} else {
if((state_val_12733 === (11))){
var inst_12721 = (state_12732[(2)]);
var state_12732__$1 = state_12732;
if(cljs.core.truth_(inst_12721)){
var statearr_12743_14206 = state_12732__$1;
(statearr_12743_14206[(1)] = (12));

} else {
var statearr_12744_14207 = state_12732__$1;
(statearr_12744_14207[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (9))){
var state_12732__$1 = state_12732;
var statearr_12745_14208 = state_12732__$1;
(statearr_12745_14208[(2)] = null);

(statearr_12745_14208[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (5))){
var state_12732__$1 = state_12732;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12746_14209 = state_12732__$1;
(statearr_12746_14209[(1)] = (8));

} else {
var statearr_12747_14210 = state_12732__$1;
(statearr_12747_14210[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (14))){
var inst_12726 = (state_12732[(2)]);
var state_12732__$1 = state_12732;
var statearr_12748_14211 = state_12732__$1;
(statearr_12748_14211[(2)] = inst_12726);

(statearr_12748_14211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (10))){
var inst_12718 = (state_12732[(2)]);
var state_12732__$1 = state_12732;
var statearr_12749_14212 = state_12732__$1;
(statearr_12749_14212[(2)] = inst_12718);

(statearr_12749_14212[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12733 === (8))){
var inst_12715 = cljs.core.async.close_BANG_(to);
var state_12732__$1 = state_12732;
var statearr_12750_14214 = state_12732__$1;
(statearr_12750_14214[(2)] = inst_12715);

(statearr_12750_14214[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_12751 = [null,null,null,null,null,null,null,null];
(statearr_12751[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_12751[(1)] = (1));

return statearr_12751;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_12732){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_12732);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e12752){var ex__12587__auto__ = e12752;
var statearr_12753_14216 = state_12732;
(statearr_12753_14216[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_12732[(4)]))){
var statearr_12754_14217 = state_12732;
(statearr_12754_14217[(1)] = cljs.core.first((state_12732[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14218 = state_12732;
state_12732 = G__14218;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_12732){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_12732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_12755 = f__12620__auto__();
(statearr_12755[(6)] = c__12619__auto___14197);

return statearr_12755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__12756){
var vec__12757 = p__12756;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12757,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12757,(1),null);
var job = vec__12757;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12619__auto___14219 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_12764){
var state_val_12765 = (state_12764[(1)]);
if((state_val_12765 === (1))){
var state_12764__$1 = state_12764;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12764__$1,(2),res,v);
} else {
if((state_val_12765 === (2))){
var inst_12761 = (state_12764[(2)]);
var inst_12762 = cljs.core.async.close_BANG_(res);
var state_12764__$1 = (function (){var statearr_12766 = state_12764;
(statearr_12766[(7)] = inst_12761);

return statearr_12766;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_12764__$1,inst_12762);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0 = (function (){
var statearr_12767 = [null,null,null,null,null,null,null,null];
(statearr_12767[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__);

(statearr_12767[(1)] = (1));

return statearr_12767;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1 = (function (state_12764){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_12764);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e12768){var ex__12587__auto__ = e12768;
var statearr_12769_14222 = state_12764;
(statearr_12769_14222[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_12764[(4)]))){
var statearr_12770_14223 = state_12764;
(statearr_12770_14223[(1)] = cljs.core.first((state_12764[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14224 = state_12764;
state_12764 = G__14224;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = function(state_12764){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1.call(this,state_12764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_12771 = f__12620__auto__();
(statearr_12771[(6)] = c__12619__auto___14219);

return statearr_12771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__12772){
var vec__12773 = p__12772;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12773,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12773,(1),null);
var job = vec__12773;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4695__auto___14225 = n;
var __14226 = (0);
while(true){
if((__14226 < n__4695__auto___14225)){
var G__12776_14227 = type;
var G__12776_14228__$1 = (((G__12776_14227 instanceof cljs.core.Keyword))?G__12776_14227.fqn:null);
switch (G__12776_14228__$1) {
case "compute":
var c__12619__auto___14230 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__14226,c__12619__auto___14230,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async){
return (function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = ((function (__14226,c__12619__auto___14230,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async){
return (function (state_12789){
var state_val_12790 = (state_12789[(1)]);
if((state_val_12790 === (1))){
var state_12789__$1 = state_12789;
var statearr_12791_14232 = state_12789__$1;
(statearr_12791_14232[(2)] = null);

(statearr_12791_14232[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12790 === (2))){
var state_12789__$1 = state_12789;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12789__$1,(4),jobs);
} else {
if((state_val_12790 === (3))){
var inst_12787 = (state_12789[(2)]);
var state_12789__$1 = state_12789;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12789__$1,inst_12787);
} else {
if((state_val_12790 === (4))){
var inst_12779 = (state_12789[(2)]);
var inst_12780 = process(inst_12779);
var state_12789__$1 = state_12789;
if(cljs.core.truth_(inst_12780)){
var statearr_12792_14234 = state_12789__$1;
(statearr_12792_14234[(1)] = (5));

} else {
var statearr_12793_14235 = state_12789__$1;
(statearr_12793_14235[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12790 === (5))){
var state_12789__$1 = state_12789;
var statearr_12794_14236 = state_12789__$1;
(statearr_12794_14236[(2)] = null);

(statearr_12794_14236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12790 === (6))){
var state_12789__$1 = state_12789;
var statearr_12795_14237 = state_12789__$1;
(statearr_12795_14237[(2)] = null);

(statearr_12795_14237[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12790 === (7))){
var inst_12785 = (state_12789[(2)]);
var state_12789__$1 = state_12789;
var statearr_12796_14238 = state_12789__$1;
(statearr_12796_14238[(2)] = inst_12785);

(statearr_12796_14238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14226,c__12619__auto___14230,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async))
;
return ((function (__14226,switch__12583__auto__,c__12619__auto___14230,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0 = (function (){
var statearr_12797 = [null,null,null,null,null,null,null];
(statearr_12797[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__);

(statearr_12797[(1)] = (1));

return statearr_12797;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1 = (function (state_12789){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_12789);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e12798){var ex__12587__auto__ = e12798;
var statearr_12799_14239 = state_12789;
(statearr_12799_14239[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_12789[(4)]))){
var statearr_12800_14240 = state_12789;
(statearr_12800_14240[(1)] = cljs.core.first((state_12789[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14241 = state_12789;
state_12789 = G__14241;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = function(state_12789){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1.call(this,state_12789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__;
})()
;})(__14226,switch__12583__auto__,c__12619__auto___14230,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async))
})();
var state__12621__auto__ = (function (){var statearr_12801 = f__12620__auto__();
(statearr_12801[(6)] = c__12619__auto___14230);

return statearr_12801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
});})(__14226,c__12619__auto___14230,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async))
);


break;
case "async":
var c__12619__auto___14242 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__14226,c__12619__auto___14242,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async){
return (function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = ((function (__14226,c__12619__auto___14242,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async){
return (function (state_12814){
var state_val_12815 = (state_12814[(1)]);
if((state_val_12815 === (1))){
var state_12814__$1 = state_12814;
var statearr_12816_14243 = state_12814__$1;
(statearr_12816_14243[(2)] = null);

(statearr_12816_14243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12815 === (2))){
var state_12814__$1 = state_12814;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12814__$1,(4),jobs);
} else {
if((state_val_12815 === (3))){
var inst_12812 = (state_12814[(2)]);
var state_12814__$1 = state_12814;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12814__$1,inst_12812);
} else {
if((state_val_12815 === (4))){
var inst_12804 = (state_12814[(2)]);
var inst_12805 = async(inst_12804);
var state_12814__$1 = state_12814;
if(cljs.core.truth_(inst_12805)){
var statearr_12817_14245 = state_12814__$1;
(statearr_12817_14245[(1)] = (5));

} else {
var statearr_12818_14247 = state_12814__$1;
(statearr_12818_14247[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12815 === (5))){
var state_12814__$1 = state_12814;
var statearr_12819_14248 = state_12814__$1;
(statearr_12819_14248[(2)] = null);

(statearr_12819_14248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12815 === (6))){
var state_12814__$1 = state_12814;
var statearr_12820_14249 = state_12814__$1;
(statearr_12820_14249[(2)] = null);

(statearr_12820_14249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12815 === (7))){
var inst_12810 = (state_12814[(2)]);
var state_12814__$1 = state_12814;
var statearr_12821_14250 = state_12814__$1;
(statearr_12821_14250[(2)] = inst_12810);

(statearr_12821_14250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14226,c__12619__auto___14242,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async))
;
return ((function (__14226,switch__12583__auto__,c__12619__auto___14242,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0 = (function (){
var statearr_12822 = [null,null,null,null,null,null,null];
(statearr_12822[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__);

(statearr_12822[(1)] = (1));

return statearr_12822;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1 = (function (state_12814){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_12814);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e12823){var ex__12587__auto__ = e12823;
var statearr_12824_14251 = state_12814;
(statearr_12824_14251[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_12814[(4)]))){
var statearr_12825_14252 = state_12814;
(statearr_12825_14252[(1)] = cljs.core.first((state_12814[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14253 = state_12814;
state_12814 = G__14253;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = function(state_12814){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1.call(this,state_12814);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__;
})()
;})(__14226,switch__12583__auto__,c__12619__auto___14242,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async))
})();
var state__12621__auto__ = (function (){var statearr_12826 = f__12620__auto__();
(statearr_12826[(6)] = c__12619__auto___14242);

return statearr_12826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
});})(__14226,c__12619__auto___14242,G__12776_14227,G__12776_14228__$1,n__4695__auto___14225,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__12776_14228__$1)].join('')));

}

var G__14254 = (__14226 + (1));
__14226 = G__14254;
continue;
} else {
}
break;
}

var c__12619__auto___14255 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_12848){
var state_val_12849 = (state_12848[(1)]);
if((state_val_12849 === (7))){
var inst_12844 = (state_12848[(2)]);
var state_12848__$1 = state_12848;
var statearr_12850_14256 = state_12848__$1;
(statearr_12850_14256[(2)] = inst_12844);

(statearr_12850_14256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12849 === (1))){
var state_12848__$1 = state_12848;
var statearr_12851_14257 = state_12848__$1;
(statearr_12851_14257[(2)] = null);

(statearr_12851_14257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12849 === (4))){
var inst_12829 = (state_12848[(7)]);
var inst_12829__$1 = (state_12848[(2)]);
var inst_12830 = (inst_12829__$1 == null);
var state_12848__$1 = (function (){var statearr_12852 = state_12848;
(statearr_12852[(7)] = inst_12829__$1);

return statearr_12852;
})();
if(cljs.core.truth_(inst_12830)){
var statearr_12853_14258 = state_12848__$1;
(statearr_12853_14258[(1)] = (5));

} else {
var statearr_12854_14259 = state_12848__$1;
(statearr_12854_14259[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12849 === (6))){
var inst_12834 = (state_12848[(8)]);
var inst_12829 = (state_12848[(7)]);
var inst_12834__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_12835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12836 = [inst_12829,inst_12834__$1];
var inst_12837 = (new cljs.core.PersistentVector(null,2,(5),inst_12835,inst_12836,null));
var state_12848__$1 = (function (){var statearr_12855 = state_12848;
(statearr_12855[(8)] = inst_12834__$1);

return statearr_12855;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12848__$1,(8),jobs,inst_12837);
} else {
if((state_val_12849 === (3))){
var inst_12846 = (state_12848[(2)]);
var state_12848__$1 = state_12848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12848__$1,inst_12846);
} else {
if((state_val_12849 === (2))){
var state_12848__$1 = state_12848;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12848__$1,(4),from);
} else {
if((state_val_12849 === (9))){
var inst_12841 = (state_12848[(2)]);
var state_12848__$1 = (function (){var statearr_12856 = state_12848;
(statearr_12856[(9)] = inst_12841);

return statearr_12856;
})();
var statearr_12857_14261 = state_12848__$1;
(statearr_12857_14261[(2)] = null);

(statearr_12857_14261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12849 === (5))){
var inst_12832 = cljs.core.async.close_BANG_(jobs);
var state_12848__$1 = state_12848;
var statearr_12858_14263 = state_12848__$1;
(statearr_12858_14263[(2)] = inst_12832);

(statearr_12858_14263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12849 === (8))){
var inst_12834 = (state_12848[(8)]);
var inst_12839 = (state_12848[(2)]);
var state_12848__$1 = (function (){var statearr_12859 = state_12848;
(statearr_12859[(10)] = inst_12839);

return statearr_12859;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12848__$1,(9),results,inst_12834);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0 = (function (){
var statearr_12860 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12860[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__);

(statearr_12860[(1)] = (1));

return statearr_12860;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1 = (function (state_12848){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_12848);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e12861){var ex__12587__auto__ = e12861;
var statearr_12862_14264 = state_12848;
(statearr_12862_14264[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_12848[(4)]))){
var statearr_12863_14265 = state_12848;
(statearr_12863_14265[(1)] = cljs.core.first((state_12848[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14266 = state_12848;
state_12848 = G__14266;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = function(state_12848){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1.call(this,state_12848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_12864 = f__12620__auto__();
(statearr_12864[(6)] = c__12619__auto___14255);

return statearr_12864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


var c__12619__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_12905){
var state_val_12907 = (state_12905[(1)]);
if((state_val_12907 === (7))){
var inst_12900 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12910_14267 = state_12905__$1;
(statearr_12910_14267[(2)] = inst_12900);

(statearr_12910_14267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (20))){
var state_12905__$1 = state_12905;
var statearr_12911_14268 = state_12905__$1;
(statearr_12911_14268[(2)] = null);

(statearr_12911_14268[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (1))){
var state_12905__$1 = state_12905;
var statearr_12913_14269 = state_12905__$1;
(statearr_12913_14269[(2)] = null);

(statearr_12913_14269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (4))){
var inst_12867 = (state_12905[(7)]);
var inst_12867__$1 = (state_12905[(2)]);
var inst_12868 = (inst_12867__$1 == null);
var state_12905__$1 = (function (){var statearr_12917 = state_12905;
(statearr_12917[(7)] = inst_12867__$1);

return statearr_12917;
})();
if(cljs.core.truth_(inst_12868)){
var statearr_12918_14270 = state_12905__$1;
(statearr_12918_14270[(1)] = (5));

} else {
var statearr_12919_14271 = state_12905__$1;
(statearr_12919_14271[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (15))){
var inst_12880 = (state_12905[(8)]);
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12905__$1,(18),to,inst_12880);
} else {
if((state_val_12907 === (21))){
var inst_12895 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12921_14273 = state_12905__$1;
(statearr_12921_14273[(2)] = inst_12895);

(statearr_12921_14273[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (13))){
var inst_12897 = (state_12905[(2)]);
var state_12905__$1 = (function (){var statearr_12926 = state_12905;
(statearr_12926[(9)] = inst_12897);

return statearr_12926;
})();
var statearr_12927_14274 = state_12905__$1;
(statearr_12927_14274[(2)] = null);

(statearr_12927_14274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (6))){
var inst_12867 = (state_12905[(7)]);
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12905__$1,(11),inst_12867);
} else {
if((state_val_12907 === (17))){
var inst_12889 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
if(cljs.core.truth_(inst_12889)){
var statearr_12928_14275 = state_12905__$1;
(statearr_12928_14275[(1)] = (19));

} else {
var statearr_12929_14276 = state_12905__$1;
(statearr_12929_14276[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (3))){
var inst_12902 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12905__$1,inst_12902);
} else {
if((state_val_12907 === (12))){
var inst_12877 = (state_12905[(10)]);
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12905__$1,(14),inst_12877);
} else {
if((state_val_12907 === (2))){
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12905__$1,(4),results);
} else {
if((state_val_12907 === (19))){
var state_12905__$1 = state_12905;
var statearr_12930_14277 = state_12905__$1;
(statearr_12930_14277[(2)] = null);

(statearr_12930_14277[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (11))){
var inst_12877 = (state_12905[(2)]);
var state_12905__$1 = (function (){var statearr_12931 = state_12905;
(statearr_12931[(10)] = inst_12877);

return statearr_12931;
})();
var statearr_12932_14278 = state_12905__$1;
(statearr_12932_14278[(2)] = null);

(statearr_12932_14278[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (9))){
var state_12905__$1 = state_12905;
var statearr_12933_14279 = state_12905__$1;
(statearr_12933_14279[(2)] = null);

(statearr_12933_14279[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (5))){
var state_12905__$1 = state_12905;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12934_14280 = state_12905__$1;
(statearr_12934_14280[(1)] = (8));

} else {
var statearr_12935_14281 = state_12905__$1;
(statearr_12935_14281[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (14))){
var inst_12882 = (state_12905[(11)]);
var inst_12880 = (state_12905[(8)]);
var inst_12880__$1 = (state_12905[(2)]);
var inst_12881 = (inst_12880__$1 == null);
var inst_12882__$1 = cljs.core.not(inst_12881);
var state_12905__$1 = (function (){var statearr_12936 = state_12905;
(statearr_12936[(11)] = inst_12882__$1);

(statearr_12936[(8)] = inst_12880__$1);

return statearr_12936;
})();
if(inst_12882__$1){
var statearr_12937_14282 = state_12905__$1;
(statearr_12937_14282[(1)] = (15));

} else {
var statearr_12938_14283 = state_12905__$1;
(statearr_12938_14283[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (16))){
var inst_12882 = (state_12905[(11)]);
var state_12905__$1 = state_12905;
var statearr_12939_14288 = state_12905__$1;
(statearr_12939_14288[(2)] = inst_12882);

(statearr_12939_14288[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (10))){
var inst_12874 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12940_14289 = state_12905__$1;
(statearr_12940_14289[(2)] = inst_12874);

(statearr_12940_14289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (18))){
var inst_12886 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12941_14290 = state_12905__$1;
(statearr_12941_14290[(2)] = inst_12886);

(statearr_12941_14290[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12907 === (8))){
var inst_12871 = cljs.core.async.close_BANG_(to);
var state_12905__$1 = state_12905;
var statearr_12942_14291 = state_12905__$1;
(statearr_12942_14291[(2)] = inst_12871);

(statearr_12942_14291[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0 = (function (){
var statearr_12943 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12943[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__);

(statearr_12943[(1)] = (1));

return statearr_12943;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1 = (function (state_12905){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_12905);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e12944){var ex__12587__auto__ = e12944;
var statearr_12945_14292 = state_12905;
(statearr_12945_14292[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_12905[(4)]))){
var statearr_12946_14293 = state_12905;
(statearr_12946_14293[(1)] = cljs.core.first((state_12905[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14294 = state_12905;
state_12905 = G__14294;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__ = function(state_12905){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1.call(this,state_12905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12584__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_12947 = f__12620__auto__();
(statearr_12947[(6)] = c__12619__auto__);

return statearr_12947;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));

return c__12619__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__12952 = arguments.length;
switch (G__12952) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__12957 = arguments.length;
switch (G__12957) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__12962 = arguments.length;
switch (G__12962) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12619__auto___14298 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_12992){
var state_val_12993 = (state_12992[(1)]);
if((state_val_12993 === (7))){
var inst_12988 = (state_12992[(2)]);
var state_12992__$1 = state_12992;
var statearr_12994_14299 = state_12992__$1;
(statearr_12994_14299[(2)] = inst_12988);

(statearr_12994_14299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (1))){
var state_12992__$1 = state_12992;
var statearr_12996_14301 = state_12992__$1;
(statearr_12996_14301[(2)] = null);

(statearr_12996_14301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (4))){
var inst_12969 = (state_12992[(7)]);
var inst_12969__$1 = (state_12992[(2)]);
var inst_12970 = (inst_12969__$1 == null);
var state_12992__$1 = (function (){var statearr_12998 = state_12992;
(statearr_12998[(7)] = inst_12969__$1);

return statearr_12998;
})();
if(cljs.core.truth_(inst_12970)){
var statearr_12999_14303 = state_12992__$1;
(statearr_12999_14303[(1)] = (5));

} else {
var statearr_13000_14304 = state_12992__$1;
(statearr_13000_14304[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (13))){
var state_12992__$1 = state_12992;
var statearr_13001_14305 = state_12992__$1;
(statearr_13001_14305[(2)] = null);

(statearr_13001_14305[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (6))){
var inst_12969 = (state_12992[(7)]);
var inst_12975 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_12969) : p.call(null,inst_12969));
var state_12992__$1 = state_12992;
if(cljs.core.truth_(inst_12975)){
var statearr_13002_14306 = state_12992__$1;
(statearr_13002_14306[(1)] = (9));

} else {
var statearr_13003_14307 = state_12992__$1;
(statearr_13003_14307[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (3))){
var inst_12990 = (state_12992[(2)]);
var state_12992__$1 = state_12992;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12992__$1,inst_12990);
} else {
if((state_val_12993 === (12))){
var state_12992__$1 = state_12992;
var statearr_13004_14308 = state_12992__$1;
(statearr_13004_14308[(2)] = null);

(statearr_13004_14308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (2))){
var state_12992__$1 = state_12992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12992__$1,(4),ch);
} else {
if((state_val_12993 === (11))){
var inst_12969 = (state_12992[(7)]);
var inst_12979 = (state_12992[(2)]);
var state_12992__$1 = state_12992;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12992__$1,(8),inst_12979,inst_12969);
} else {
if((state_val_12993 === (9))){
var state_12992__$1 = state_12992;
var statearr_13007_14309 = state_12992__$1;
(statearr_13007_14309[(2)] = tc);

(statearr_13007_14309[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (5))){
var inst_12972 = cljs.core.async.close_BANG_(tc);
var inst_12973 = cljs.core.async.close_BANG_(fc);
var state_12992__$1 = (function (){var statearr_13008 = state_12992;
(statearr_13008[(8)] = inst_12972);

return statearr_13008;
})();
var statearr_13009_14310 = state_12992__$1;
(statearr_13009_14310[(2)] = inst_12973);

(statearr_13009_14310[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (14))){
var inst_12986 = (state_12992[(2)]);
var state_12992__$1 = state_12992;
var statearr_13010_14311 = state_12992__$1;
(statearr_13010_14311[(2)] = inst_12986);

(statearr_13010_14311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (10))){
var state_12992__$1 = state_12992;
var statearr_13011_14312 = state_12992__$1;
(statearr_13011_14312[(2)] = fc);

(statearr_13011_14312[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12993 === (8))){
var inst_12981 = (state_12992[(2)]);
var state_12992__$1 = state_12992;
if(cljs.core.truth_(inst_12981)){
var statearr_13012_14313 = state_12992__$1;
(statearr_13012_14313[(1)] = (12));

} else {
var statearr_13013_14314 = state_12992__$1;
(statearr_13013_14314[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_13014 = [null,null,null,null,null,null,null,null,null];
(statearr_13014[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_13014[(1)] = (1));

return statearr_13014;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_12992){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_12992);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13015){var ex__12587__auto__ = e13015;
var statearr_13016_14315 = state_12992;
(statearr_13016_14315[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_12992[(4)]))){
var statearr_13017_14320 = state_12992;
(statearr_13017_14320[(1)] = cljs.core.first((state_12992[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14321 = state_12992;
state_12992 = G__14321;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_12992){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_12992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13018 = f__12620__auto__();
(statearr_13018[(6)] = c__12619__auto___14298);

return statearr_13018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12619__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13042){
var state_val_13043 = (state_13042[(1)]);
if((state_val_13043 === (7))){
var inst_13038 = (state_13042[(2)]);
var state_13042__$1 = state_13042;
var statearr_13044_14325 = state_13042__$1;
(statearr_13044_14325[(2)] = inst_13038);

(statearr_13044_14325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13043 === (1))){
var inst_13021 = init;
var inst_13022 = inst_13021;
var state_13042__$1 = (function (){var statearr_13045 = state_13042;
(statearr_13045[(7)] = inst_13022);

return statearr_13045;
})();
var statearr_13047_14326 = state_13042__$1;
(statearr_13047_14326[(2)] = null);

(statearr_13047_14326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13043 === (4))){
var inst_13025 = (state_13042[(8)]);
var inst_13025__$1 = (state_13042[(2)]);
var inst_13026 = (inst_13025__$1 == null);
var state_13042__$1 = (function (){var statearr_13049 = state_13042;
(statearr_13049[(8)] = inst_13025__$1);

return statearr_13049;
})();
if(cljs.core.truth_(inst_13026)){
var statearr_13050_14330 = state_13042__$1;
(statearr_13050_14330[(1)] = (5));

} else {
var statearr_13051_14331 = state_13042__$1;
(statearr_13051_14331[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13043 === (6))){
var inst_13025 = (state_13042[(8)]);
var inst_13029 = (state_13042[(9)]);
var inst_13022 = (state_13042[(7)]);
var inst_13029__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_13022,inst_13025) : f.call(null,inst_13022,inst_13025));
var inst_13030 = cljs.core.reduced_QMARK_(inst_13029__$1);
var state_13042__$1 = (function (){var statearr_13052 = state_13042;
(statearr_13052[(9)] = inst_13029__$1);

return statearr_13052;
})();
if(inst_13030){
var statearr_13053_14332 = state_13042__$1;
(statearr_13053_14332[(1)] = (8));

} else {
var statearr_13054_14333 = state_13042__$1;
(statearr_13054_14333[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13043 === (3))){
var inst_13040 = (state_13042[(2)]);
var state_13042__$1 = state_13042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13042__$1,inst_13040);
} else {
if((state_val_13043 === (2))){
var state_13042__$1 = state_13042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13042__$1,(4),ch);
} else {
if((state_val_13043 === (9))){
var inst_13029 = (state_13042[(9)]);
var inst_13022 = inst_13029;
var state_13042__$1 = (function (){var statearr_13055 = state_13042;
(statearr_13055[(7)] = inst_13022);

return statearr_13055;
})();
var statearr_13056_14337 = state_13042__$1;
(statearr_13056_14337[(2)] = null);

(statearr_13056_14337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13043 === (5))){
var inst_13022 = (state_13042[(7)]);
var state_13042__$1 = state_13042;
var statearr_13057_14338 = state_13042__$1;
(statearr_13057_14338[(2)] = inst_13022);

(statearr_13057_14338[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13043 === (10))){
var inst_13036 = (state_13042[(2)]);
var state_13042__$1 = state_13042;
var statearr_13059_14339 = state_13042__$1;
(statearr_13059_14339[(2)] = inst_13036);

(statearr_13059_14339[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13043 === (8))){
var inst_13029 = (state_13042[(9)]);
var inst_13032 = cljs.core.deref(inst_13029);
var state_13042__$1 = state_13042;
var statearr_13060_14343 = state_13042__$1;
(statearr_13060_14343[(2)] = inst_13032);

(statearr_13060_14343[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__12584__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12584__auto____0 = (function (){
var statearr_13061 = [null,null,null,null,null,null,null,null,null,null];
(statearr_13061[(0)] = cljs$core$async$reduce_$_state_machine__12584__auto__);

(statearr_13061[(1)] = (1));

return statearr_13061;
});
var cljs$core$async$reduce_$_state_machine__12584__auto____1 = (function (state_13042){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13042);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13063){var ex__12587__auto__ = e13063;
var statearr_13064_14344 = state_13042;
(statearr_13064_14344[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13042[(4)]))){
var statearr_13066_14345 = state_13042;
(statearr_13066_14345[(1)] = cljs.core.first((state_13042[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14346 = state_13042;
state_13042 = G__14346;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12584__auto__ = function(state_13042){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12584__auto____1.call(this,state_13042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12584__auto____0;
cljs$core$async$reduce_$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12584__auto____1;
return cljs$core$async$reduce_$_state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13067 = f__12620__auto__();
(statearr_13067[(6)] = c__12619__auto__);

return statearr_13067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));

return c__12619__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12619__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13073){
var state_val_13074 = (state_13073[(1)]);
if((state_val_13074 === (1))){
var inst_13068 = cljs.core.async.reduce(f__$1,init,ch);
var state_13073__$1 = state_13073;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13073__$1,(2),inst_13068);
} else {
if((state_val_13074 === (2))){
var inst_13070 = (state_13073[(2)]);
var inst_13071 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_13070) : f__$1.call(null,inst_13070));
var state_13073__$1 = state_13073;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13073__$1,inst_13071);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__12584__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12584__auto____0 = (function (){
var statearr_13075 = [null,null,null,null,null,null,null];
(statearr_13075[(0)] = cljs$core$async$transduce_$_state_machine__12584__auto__);

(statearr_13075[(1)] = (1));

return statearr_13075;
});
var cljs$core$async$transduce_$_state_machine__12584__auto____1 = (function (state_13073){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13073);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13076){var ex__12587__auto__ = e13076;
var statearr_13077_14354 = state_13073;
(statearr_13077_14354[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13073[(4)]))){
var statearr_13078_14355 = state_13073;
(statearr_13078_14355[(1)] = cljs.core.first((state_13073[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14359 = state_13073;
state_13073 = G__14359;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12584__auto__ = function(state_13073){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12584__auto____1.call(this,state_13073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12584__auto____0;
cljs$core$async$transduce_$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12584__auto____1;
return cljs$core$async$transduce_$_state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13079 = f__12620__auto__();
(statearr_13079[(6)] = c__12619__auto__);

return statearr_13079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));

return c__12619__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__13081 = arguments.length;
switch (G__13081) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12619__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13106){
var state_val_13107 = (state_13106[(1)]);
if((state_val_13107 === (7))){
var inst_13088 = (state_13106[(2)]);
var state_13106__$1 = state_13106;
var statearr_13108_14364 = state_13106__$1;
(statearr_13108_14364[(2)] = inst_13088);

(statearr_13108_14364[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (1))){
var inst_13082 = cljs.core.seq(coll);
var inst_13083 = inst_13082;
var state_13106__$1 = (function (){var statearr_13111 = state_13106;
(statearr_13111[(7)] = inst_13083);

return statearr_13111;
})();
var statearr_13112_14365 = state_13106__$1;
(statearr_13112_14365[(2)] = null);

(statearr_13112_14365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (4))){
var inst_13083 = (state_13106[(7)]);
var inst_13086 = cljs.core.first(inst_13083);
var state_13106__$1 = state_13106;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13106__$1,(7),ch,inst_13086);
} else {
if((state_val_13107 === (13))){
var inst_13100 = (state_13106[(2)]);
var state_13106__$1 = state_13106;
var statearr_13113_14366 = state_13106__$1;
(statearr_13113_14366[(2)] = inst_13100);

(statearr_13113_14366[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (6))){
var inst_13091 = (state_13106[(2)]);
var state_13106__$1 = state_13106;
if(cljs.core.truth_(inst_13091)){
var statearr_13114_14370 = state_13106__$1;
(statearr_13114_14370[(1)] = (8));

} else {
var statearr_13115_14371 = state_13106__$1;
(statearr_13115_14371[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (3))){
var inst_13104 = (state_13106[(2)]);
var state_13106__$1 = state_13106;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13106__$1,inst_13104);
} else {
if((state_val_13107 === (12))){
var state_13106__$1 = state_13106;
var statearr_13116_14372 = state_13106__$1;
(statearr_13116_14372[(2)] = null);

(statearr_13116_14372[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (2))){
var inst_13083 = (state_13106[(7)]);
var state_13106__$1 = state_13106;
if(cljs.core.truth_(inst_13083)){
var statearr_13117_14373 = state_13106__$1;
(statearr_13117_14373[(1)] = (4));

} else {
var statearr_13118_14374 = state_13106__$1;
(statearr_13118_14374[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (11))){
var inst_13097 = cljs.core.async.close_BANG_(ch);
var state_13106__$1 = state_13106;
var statearr_13119_14375 = state_13106__$1;
(statearr_13119_14375[(2)] = inst_13097);

(statearr_13119_14375[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (9))){
var state_13106__$1 = state_13106;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13120_14376 = state_13106__$1;
(statearr_13120_14376[(1)] = (11));

} else {
var statearr_13121_14377 = state_13106__$1;
(statearr_13121_14377[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (5))){
var inst_13083 = (state_13106[(7)]);
var state_13106__$1 = state_13106;
var statearr_13122_14378 = state_13106__$1;
(statearr_13122_14378[(2)] = inst_13083);

(statearr_13122_14378[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (10))){
var inst_13102 = (state_13106[(2)]);
var state_13106__$1 = state_13106;
var statearr_13123_14379 = state_13106__$1;
(statearr_13123_14379[(2)] = inst_13102);

(statearr_13123_14379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13107 === (8))){
var inst_13083 = (state_13106[(7)]);
var inst_13093 = cljs.core.next(inst_13083);
var inst_13083__$1 = inst_13093;
var state_13106__$1 = (function (){var statearr_13124 = state_13106;
(statearr_13124[(7)] = inst_13083__$1);

return statearr_13124;
})();
var statearr_13125_14381 = state_13106__$1;
(statearr_13125_14381[(2)] = null);

(statearr_13125_14381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_13126 = [null,null,null,null,null,null,null,null];
(statearr_13126[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_13126[(1)] = (1));

return statearr_13126;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_13106){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13106);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13127){var ex__12587__auto__ = e13127;
var statearr_13128_14382 = state_13106;
(statearr_13128_14382[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13106[(4)]))){
var statearr_13129_14383 = state_13106;
(statearr_13129_14383[(1)] = cljs.core.first((state_13106[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14384 = state_13106;
state_13106 = G__14384;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_13106){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_13106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13130 = f__12620__auto__();
(statearr_13130[(6)] = c__12619__auto__);

return statearr_13130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));

return c__12619__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__13132 = arguments.length;
switch (G__13132) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_14386 = (function (_){
var x__4509__auto__ = (((_ == null))?null:_);
var m__4510__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4510__auto__.call(null,_));
} else {
var m__4508__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4508__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_14386(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_14387 = (function (m,ch,close_QMARK_){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4510__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4508__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_14387(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_14388 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_14388(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_14389 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_14389(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13135 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13135 = (function (ch,cs,meta13136){
this.ch = ch;
this.cs = cs;
this.meta13136 = meta13136;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13135.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13137,meta13136__$1){
var self__ = this;
var _13137__$1 = this;
return (new cljs.core.async.t_cljs$core$async13135(self__.ch,self__.cs,meta13136__$1));
}));

(cljs.core.async.t_cljs$core$async13135.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13137){
var self__ = this;
var _13137__$1 = this;
return self__.meta13136;
}));

(cljs.core.async.t_cljs$core$async13135.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13135.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13135.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13135.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async13135.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async13135.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async13135.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta13136","meta13136",-1848997984,null)], null);
}));

(cljs.core.async.t_cljs$core$async13135.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13135.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13135");

(cljs.core.async.t_cljs$core$async13135.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13135");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13135.
 */
cljs.core.async.__GT_t_cljs$core$async13135 = (function cljs$core$async$mult_$___GT_t_cljs$core$async13135(ch__$1,cs__$1,meta13136){
return (new cljs.core.async.t_cljs$core$async13135(ch__$1,cs__$1,meta13136));
});

}

return (new cljs.core.async.t_cljs$core$async13135(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__12619__auto___14390 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13279){
var state_val_13280 = (state_13279[(1)]);
if((state_val_13280 === (7))){
var inst_13273 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
var statearr_13282_14391 = state_13279__$1;
(statearr_13282_14391[(2)] = inst_13273);

(statearr_13282_14391[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (20))){
var inst_13171 = (state_13279[(7)]);
var inst_13183 = cljs.core.first(inst_13171);
var inst_13184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13183,(0),null);
var inst_13185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13183,(1),null);
var state_13279__$1 = (function (){var statearr_13283 = state_13279;
(statearr_13283[(8)] = inst_13184);

return statearr_13283;
})();
if(cljs.core.truth_(inst_13185)){
var statearr_13286_14392 = state_13279__$1;
(statearr_13286_14392[(1)] = (22));

} else {
var statearr_13287_14393 = state_13279__$1;
(statearr_13287_14393[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (27))){
var inst_13140 = (state_13279[(9)]);
var inst_13222 = (state_13279[(10)]);
var inst_13215 = (state_13279[(11)]);
var inst_13217 = (state_13279[(12)]);
var inst_13222__$1 = cljs.core._nth(inst_13215,inst_13217);
var inst_13223 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13222__$1,inst_13140,done);
var state_13279__$1 = (function (){var statearr_13291 = state_13279;
(statearr_13291[(10)] = inst_13222__$1);

return statearr_13291;
})();
if(cljs.core.truth_(inst_13223)){
var statearr_13292_14396 = state_13279__$1;
(statearr_13292_14396[(1)] = (30));

} else {
var statearr_13293_14397 = state_13279__$1;
(statearr_13293_14397[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (1))){
var state_13279__$1 = state_13279;
var statearr_13294_14401 = state_13279__$1;
(statearr_13294_14401[(2)] = null);

(statearr_13294_14401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (24))){
var inst_13171 = (state_13279[(7)]);
var inst_13190 = (state_13279[(2)]);
var inst_13191 = cljs.core.next(inst_13171);
var inst_13149 = inst_13191;
var inst_13150 = null;
var inst_13151 = (0);
var inst_13152 = (0);
var state_13279__$1 = (function (){var statearr_13295 = state_13279;
(statearr_13295[(13)] = inst_13152);

(statearr_13295[(14)] = inst_13151);

(statearr_13295[(15)] = inst_13190);

(statearr_13295[(16)] = inst_13150);

(statearr_13295[(17)] = inst_13149);

return statearr_13295;
})();
var statearr_13296_14402 = state_13279__$1;
(statearr_13296_14402[(2)] = null);

(statearr_13296_14402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (39))){
var state_13279__$1 = state_13279;
var statearr_13300_14404 = state_13279__$1;
(statearr_13300_14404[(2)] = null);

(statearr_13300_14404[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (4))){
var inst_13140 = (state_13279[(9)]);
var inst_13140__$1 = (state_13279[(2)]);
var inst_13141 = (inst_13140__$1 == null);
var state_13279__$1 = (function (){var statearr_13301 = state_13279;
(statearr_13301[(9)] = inst_13140__$1);

return statearr_13301;
})();
if(cljs.core.truth_(inst_13141)){
var statearr_13302_14405 = state_13279__$1;
(statearr_13302_14405[(1)] = (5));

} else {
var statearr_13303_14406 = state_13279__$1;
(statearr_13303_14406[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (15))){
var inst_13152 = (state_13279[(13)]);
var inst_13151 = (state_13279[(14)]);
var inst_13150 = (state_13279[(16)]);
var inst_13149 = (state_13279[(17)]);
var inst_13167 = (state_13279[(2)]);
var inst_13168 = (inst_13152 + (1));
var tmp13297 = inst_13151;
var tmp13298 = inst_13150;
var tmp13299 = inst_13149;
var inst_13149__$1 = tmp13299;
var inst_13150__$1 = tmp13298;
var inst_13151__$1 = tmp13297;
var inst_13152__$1 = inst_13168;
var state_13279__$1 = (function (){var statearr_13304 = state_13279;
(statearr_13304[(13)] = inst_13152__$1);

(statearr_13304[(14)] = inst_13151__$1);

(statearr_13304[(18)] = inst_13167);

(statearr_13304[(16)] = inst_13150__$1);

(statearr_13304[(17)] = inst_13149__$1);

return statearr_13304;
})();
var statearr_13305_14409 = state_13279__$1;
(statearr_13305_14409[(2)] = null);

(statearr_13305_14409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (21))){
var inst_13194 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
var statearr_13309_14410 = state_13279__$1;
(statearr_13309_14410[(2)] = inst_13194);

(statearr_13309_14410[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (31))){
var inst_13222 = (state_13279[(10)]);
var inst_13226 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13222);
var state_13279__$1 = state_13279;
var statearr_13310_14411 = state_13279__$1;
(statearr_13310_14411[(2)] = inst_13226);

(statearr_13310_14411[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (32))){
var inst_13216 = (state_13279[(19)]);
var inst_13215 = (state_13279[(11)]);
var inst_13217 = (state_13279[(12)]);
var inst_13214 = (state_13279[(20)]);
var inst_13228 = (state_13279[(2)]);
var inst_13229 = (inst_13217 + (1));
var tmp13306 = inst_13216;
var tmp13307 = inst_13215;
var tmp13308 = inst_13214;
var inst_13214__$1 = tmp13308;
var inst_13215__$1 = tmp13307;
var inst_13216__$1 = tmp13306;
var inst_13217__$1 = inst_13229;
var state_13279__$1 = (function (){var statearr_13311 = state_13279;
(statearr_13311[(19)] = inst_13216__$1);

(statearr_13311[(11)] = inst_13215__$1);

(statearr_13311[(12)] = inst_13217__$1);

(statearr_13311[(20)] = inst_13214__$1);

(statearr_13311[(21)] = inst_13228);

return statearr_13311;
})();
var statearr_13312_14412 = state_13279__$1;
(statearr_13312_14412[(2)] = null);

(statearr_13312_14412[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (40))){
var inst_13241 = (state_13279[(22)]);
var inst_13250 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13241);
var state_13279__$1 = state_13279;
var statearr_13313_14413 = state_13279__$1;
(statearr_13313_14413[(2)] = inst_13250);

(statearr_13313_14413[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (33))){
var inst_13232 = (state_13279[(23)]);
var inst_13234 = cljs.core.chunked_seq_QMARK_(inst_13232);
var state_13279__$1 = state_13279;
if(inst_13234){
var statearr_13314_14414 = state_13279__$1;
(statearr_13314_14414[(1)] = (36));

} else {
var statearr_13315_14415 = state_13279__$1;
(statearr_13315_14415[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (13))){
var inst_13161 = (state_13279[(24)]);
var inst_13164 = cljs.core.async.close_BANG_(inst_13161);
var state_13279__$1 = state_13279;
var statearr_13316_14416 = state_13279__$1;
(statearr_13316_14416[(2)] = inst_13164);

(statearr_13316_14416[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (22))){
var inst_13184 = (state_13279[(8)]);
var inst_13187 = cljs.core.async.close_BANG_(inst_13184);
var state_13279__$1 = state_13279;
var statearr_13317_14417 = state_13279__$1;
(statearr_13317_14417[(2)] = inst_13187);

(statearr_13317_14417[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (36))){
var inst_13232 = (state_13279[(23)]);
var inst_13236 = cljs.core.chunk_first(inst_13232);
var inst_13237 = cljs.core.chunk_rest(inst_13232);
var inst_13238 = cljs.core.count(inst_13236);
var inst_13214 = inst_13237;
var inst_13215 = inst_13236;
var inst_13216 = inst_13238;
var inst_13217 = (0);
var state_13279__$1 = (function (){var statearr_13318 = state_13279;
(statearr_13318[(19)] = inst_13216);

(statearr_13318[(11)] = inst_13215);

(statearr_13318[(12)] = inst_13217);

(statearr_13318[(20)] = inst_13214);

return statearr_13318;
})();
var statearr_13319_14419 = state_13279__$1;
(statearr_13319_14419[(2)] = null);

(statearr_13319_14419[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (41))){
var inst_13232 = (state_13279[(23)]);
var inst_13252 = (state_13279[(2)]);
var inst_13253 = cljs.core.next(inst_13232);
var inst_13214 = inst_13253;
var inst_13215 = null;
var inst_13216 = (0);
var inst_13217 = (0);
var state_13279__$1 = (function (){var statearr_13320 = state_13279;
(statearr_13320[(19)] = inst_13216);

(statearr_13320[(25)] = inst_13252);

(statearr_13320[(11)] = inst_13215);

(statearr_13320[(12)] = inst_13217);

(statearr_13320[(20)] = inst_13214);

return statearr_13320;
})();
var statearr_13321_14423 = state_13279__$1;
(statearr_13321_14423[(2)] = null);

(statearr_13321_14423[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (43))){
var state_13279__$1 = state_13279;
var statearr_13322_14424 = state_13279__$1;
(statearr_13322_14424[(2)] = null);

(statearr_13322_14424[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (29))){
var inst_13261 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
var statearr_13323_14425 = state_13279__$1;
(statearr_13323_14425[(2)] = inst_13261);

(statearr_13323_14425[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (44))){
var inst_13270 = (state_13279[(2)]);
var state_13279__$1 = (function (){var statearr_13324 = state_13279;
(statearr_13324[(26)] = inst_13270);

return statearr_13324;
})();
var statearr_13325_14428 = state_13279__$1;
(statearr_13325_14428[(2)] = null);

(statearr_13325_14428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (6))){
var inst_13206 = (state_13279[(27)]);
var inst_13205 = cljs.core.deref(cs);
var inst_13206__$1 = cljs.core.keys(inst_13205);
var inst_13207 = cljs.core.count(inst_13206__$1);
var inst_13208 = cljs.core.reset_BANG_(dctr,inst_13207);
var inst_13213 = cljs.core.seq(inst_13206__$1);
var inst_13214 = inst_13213;
var inst_13215 = null;
var inst_13216 = (0);
var inst_13217 = (0);
var state_13279__$1 = (function (){var statearr_13326 = state_13279;
(statearr_13326[(19)] = inst_13216);

(statearr_13326[(28)] = inst_13208);

(statearr_13326[(27)] = inst_13206__$1);

(statearr_13326[(11)] = inst_13215);

(statearr_13326[(12)] = inst_13217);

(statearr_13326[(20)] = inst_13214);

return statearr_13326;
})();
var statearr_13327_14431 = state_13279__$1;
(statearr_13327_14431[(2)] = null);

(statearr_13327_14431[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (28))){
var inst_13232 = (state_13279[(23)]);
var inst_13214 = (state_13279[(20)]);
var inst_13232__$1 = cljs.core.seq(inst_13214);
var state_13279__$1 = (function (){var statearr_13328 = state_13279;
(statearr_13328[(23)] = inst_13232__$1);

return statearr_13328;
})();
if(inst_13232__$1){
var statearr_13329_14432 = state_13279__$1;
(statearr_13329_14432[(1)] = (33));

} else {
var statearr_13330_14433 = state_13279__$1;
(statearr_13330_14433[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (25))){
var inst_13216 = (state_13279[(19)]);
var inst_13217 = (state_13279[(12)]);
var inst_13219 = (inst_13217 < inst_13216);
var inst_13220 = inst_13219;
var state_13279__$1 = state_13279;
if(cljs.core.truth_(inst_13220)){
var statearr_13331_14437 = state_13279__$1;
(statearr_13331_14437[(1)] = (27));

} else {
var statearr_13332_14438 = state_13279__$1;
(statearr_13332_14438[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (34))){
var state_13279__$1 = state_13279;
var statearr_13333_14443 = state_13279__$1;
(statearr_13333_14443[(2)] = null);

(statearr_13333_14443[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (17))){
var state_13279__$1 = state_13279;
var statearr_13334_14444 = state_13279__$1;
(statearr_13334_14444[(2)] = null);

(statearr_13334_14444[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (3))){
var inst_13275 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13279__$1,inst_13275);
} else {
if((state_val_13280 === (12))){
var inst_13199 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
var statearr_13335_14451 = state_13279__$1;
(statearr_13335_14451[(2)] = inst_13199);

(statearr_13335_14451[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (2))){
var state_13279__$1 = state_13279;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13279__$1,(4),ch);
} else {
if((state_val_13280 === (23))){
var state_13279__$1 = state_13279;
var statearr_13336_14452 = state_13279__$1;
(statearr_13336_14452[(2)] = null);

(statearr_13336_14452[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (35))){
var inst_13259 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
var statearr_13337_14453 = state_13279__$1;
(statearr_13337_14453[(2)] = inst_13259);

(statearr_13337_14453[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (19))){
var inst_13171 = (state_13279[(7)]);
var inst_13175 = cljs.core.chunk_first(inst_13171);
var inst_13176 = cljs.core.chunk_rest(inst_13171);
var inst_13177 = cljs.core.count(inst_13175);
var inst_13149 = inst_13176;
var inst_13150 = inst_13175;
var inst_13151 = inst_13177;
var inst_13152 = (0);
var state_13279__$1 = (function (){var statearr_13338 = state_13279;
(statearr_13338[(13)] = inst_13152);

(statearr_13338[(14)] = inst_13151);

(statearr_13338[(16)] = inst_13150);

(statearr_13338[(17)] = inst_13149);

return statearr_13338;
})();
var statearr_13339_14454 = state_13279__$1;
(statearr_13339_14454[(2)] = null);

(statearr_13339_14454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (11))){
var inst_13149 = (state_13279[(17)]);
var inst_13171 = (state_13279[(7)]);
var inst_13171__$1 = cljs.core.seq(inst_13149);
var state_13279__$1 = (function (){var statearr_13340 = state_13279;
(statearr_13340[(7)] = inst_13171__$1);

return statearr_13340;
})();
if(inst_13171__$1){
var statearr_13341_14455 = state_13279__$1;
(statearr_13341_14455[(1)] = (16));

} else {
var statearr_13342_14456 = state_13279__$1;
(statearr_13342_14456[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (9))){
var inst_13201 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
var statearr_13343_14457 = state_13279__$1;
(statearr_13343_14457[(2)] = inst_13201);

(statearr_13343_14457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (5))){
var inst_13147 = cljs.core.deref(cs);
var inst_13148 = cljs.core.seq(inst_13147);
var inst_13149 = inst_13148;
var inst_13150 = null;
var inst_13151 = (0);
var inst_13152 = (0);
var state_13279__$1 = (function (){var statearr_13344 = state_13279;
(statearr_13344[(13)] = inst_13152);

(statearr_13344[(14)] = inst_13151);

(statearr_13344[(16)] = inst_13150);

(statearr_13344[(17)] = inst_13149);

return statearr_13344;
})();
var statearr_13345_14458 = state_13279__$1;
(statearr_13345_14458[(2)] = null);

(statearr_13345_14458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (14))){
var state_13279__$1 = state_13279;
var statearr_13346_14459 = state_13279__$1;
(statearr_13346_14459[(2)] = null);

(statearr_13346_14459[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (45))){
var inst_13267 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
var statearr_13347_14460 = state_13279__$1;
(statearr_13347_14460[(2)] = inst_13267);

(statearr_13347_14460[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (26))){
var inst_13206 = (state_13279[(27)]);
var inst_13263 = (state_13279[(2)]);
var inst_13264 = cljs.core.seq(inst_13206);
var state_13279__$1 = (function (){var statearr_13348 = state_13279;
(statearr_13348[(29)] = inst_13263);

return statearr_13348;
})();
if(inst_13264){
var statearr_13349_14461 = state_13279__$1;
(statearr_13349_14461[(1)] = (42));

} else {
var statearr_13350_14462 = state_13279__$1;
(statearr_13350_14462[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (16))){
var inst_13171 = (state_13279[(7)]);
var inst_13173 = cljs.core.chunked_seq_QMARK_(inst_13171);
var state_13279__$1 = state_13279;
if(inst_13173){
var statearr_13351_14463 = state_13279__$1;
(statearr_13351_14463[(1)] = (19));

} else {
var statearr_13352_14464 = state_13279__$1;
(statearr_13352_14464[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (38))){
var inst_13256 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
var statearr_13353_14465 = state_13279__$1;
(statearr_13353_14465[(2)] = inst_13256);

(statearr_13353_14465[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (30))){
var state_13279__$1 = state_13279;
var statearr_13354_14466 = state_13279__$1;
(statearr_13354_14466[(2)] = null);

(statearr_13354_14466[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (10))){
var inst_13152 = (state_13279[(13)]);
var inst_13150 = (state_13279[(16)]);
var inst_13160 = cljs.core._nth(inst_13150,inst_13152);
var inst_13161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13160,(0),null);
var inst_13162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13160,(1),null);
var state_13279__$1 = (function (){var statearr_13355 = state_13279;
(statearr_13355[(24)] = inst_13161);

return statearr_13355;
})();
if(cljs.core.truth_(inst_13162)){
var statearr_13356_14473 = state_13279__$1;
(statearr_13356_14473[(1)] = (13));

} else {
var statearr_13357_14474 = state_13279__$1;
(statearr_13357_14474[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (18))){
var inst_13197 = (state_13279[(2)]);
var state_13279__$1 = state_13279;
var statearr_13358_14475 = state_13279__$1;
(statearr_13358_14475[(2)] = inst_13197);

(statearr_13358_14475[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (42))){
var state_13279__$1 = state_13279;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13279__$1,(45),dchan);
} else {
if((state_val_13280 === (37))){
var inst_13241 = (state_13279[(22)]);
var inst_13232 = (state_13279[(23)]);
var inst_13140 = (state_13279[(9)]);
var inst_13241__$1 = cljs.core.first(inst_13232);
var inst_13246 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13241__$1,inst_13140,done);
var state_13279__$1 = (function (){var statearr_13359 = state_13279;
(statearr_13359[(22)] = inst_13241__$1);

return statearr_13359;
})();
if(cljs.core.truth_(inst_13246)){
var statearr_13360_14476 = state_13279__$1;
(statearr_13360_14476[(1)] = (39));

} else {
var statearr_13361_14477 = state_13279__$1;
(statearr_13361_14477[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13280 === (8))){
var inst_13152 = (state_13279[(13)]);
var inst_13151 = (state_13279[(14)]);
var inst_13154 = (inst_13152 < inst_13151);
var inst_13155 = inst_13154;
var state_13279__$1 = state_13279;
if(cljs.core.truth_(inst_13155)){
var statearr_13362_14478 = state_13279__$1;
(statearr_13362_14478[(1)] = (10));

} else {
var statearr_13363_14479 = state_13279__$1;
(statearr_13363_14479[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__12584__auto__ = null;
var cljs$core$async$mult_$_state_machine__12584__auto____0 = (function (){
var statearr_13364 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13364[(0)] = cljs$core$async$mult_$_state_machine__12584__auto__);

(statearr_13364[(1)] = (1));

return statearr_13364;
});
var cljs$core$async$mult_$_state_machine__12584__auto____1 = (function (state_13279){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13279);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13365){var ex__12587__auto__ = e13365;
var statearr_13366_14480 = state_13279;
(statearr_13366_14480[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13279[(4)]))){
var statearr_13367_14481 = state_13279;
(statearr_13367_14481[(1)] = cljs.core.first((state_13279[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14482 = state_13279;
state_13279 = G__14482;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12584__auto__ = function(state_13279){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12584__auto____1.call(this,state_13279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12584__auto____0;
cljs$core$async$mult_$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12584__auto____1;
return cljs$core$async$mult_$_state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13368 = f__12620__auto__();
(statearr_13368[(6)] = c__12619__auto___14390);

return statearr_13368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__13370 = arguments.length;
switch (G__13370) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_14484 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_14484(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_14491 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_14491(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_14492 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_14492(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_14493 = (function (m,state_map){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4510__auto__.call(null,m,state_map));
} else {
var m__4508__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4508__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_14493(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_14494 = (function (m,mode){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4510__auto__.call(null,m,mode));
} else {
var m__4508__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4508__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_14494(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___14495 = arguments.length;
var i__4819__auto___14496 = (0);
while(true){
if((i__4819__auto___14496 < len__4818__auto___14495)){
args__4824__auto__.push((arguments[i__4819__auto___14496]));

var G__14497 = (i__4819__auto___14496 + (1));
i__4819__auto___14496 = G__14497;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((3) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4825__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13375){
var map__13376 = p__13375;
var map__13376__$1 = cljs.core.__destructure_map(map__13376);
var opts = map__13376__$1;
var statearr_13377_14498 = state;
(statearr_13377_14498[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_13378_14499 = state;
(statearr_13378_14499[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_13379_14506 = state;
(statearr_13379_14506[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13371){
var G__13372 = cljs.core.first(seq13371);
var seq13371__$1 = cljs.core.next(seq13371);
var G__13373 = cljs.core.first(seq13371__$1);
var seq13371__$2 = cljs.core.next(seq13371__$1);
var G__13374 = cljs.core.first(seq13371__$2);
var seq13371__$3 = cljs.core.next(seq13371__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13372,G__13373,G__13374,seq13371__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13380 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13380 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13381){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13381 = meta13381;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13382,meta13381__$1){
var self__ = this;
var _13382__$1 = this;
return (new cljs.core.async.t_cljs$core$async13380(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13381__$1));
}));

(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13382){
var self__ = this;
var _13382__$1 = this;
return self__.meta13381;
}));

(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13380.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13380.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13381","meta13381",1876241020,null)], null);
}));

(cljs.core.async.t_cljs$core$async13380.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13380.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13380");

(cljs.core.async.t_cljs$core$async13380.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13380");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13380.
 */
cljs.core.async.__GT_t_cljs$core$async13380 = (function cljs$core$async$mix_$___GT_t_cljs$core$async13380(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13381){
return (new cljs.core.async.t_cljs$core$async13380(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13381));
});

}

return (new cljs.core.async.t_cljs$core$async13380(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12619__auto___14507 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13450){
var state_val_13451 = (state_13450[(1)]);
if((state_val_13451 === (7))){
var inst_13410 = (state_13450[(2)]);
var state_13450__$1 = state_13450;
if(cljs.core.truth_(inst_13410)){
var statearr_13452_14508 = state_13450__$1;
(statearr_13452_14508[(1)] = (8));

} else {
var statearr_13453_14509 = state_13450__$1;
(statearr_13453_14509[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (20))){
var inst_13403 = (state_13450[(7)]);
var state_13450__$1 = state_13450;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13450__$1,(23),out,inst_13403);
} else {
if((state_val_13451 === (1))){
var inst_13386 = calc_state();
var inst_13387 = cljs.core.__destructure_map(inst_13386);
var inst_13388 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13387,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13389 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13387,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13390 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13387,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13391 = inst_13386;
var state_13450__$1 = (function (){var statearr_13454 = state_13450;
(statearr_13454[(8)] = inst_13391);

(statearr_13454[(9)] = inst_13388);

(statearr_13454[(10)] = inst_13390);

(statearr_13454[(11)] = inst_13389);

return statearr_13454;
})();
var statearr_13455_14510 = state_13450__$1;
(statearr_13455_14510[(2)] = null);

(statearr_13455_14510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (24))){
var inst_13394 = (state_13450[(12)]);
var inst_13391 = inst_13394;
var state_13450__$1 = (function (){var statearr_13456 = state_13450;
(statearr_13456[(8)] = inst_13391);

return statearr_13456;
})();
var statearr_13457_14511 = state_13450__$1;
(statearr_13457_14511[(2)] = null);

(statearr_13457_14511[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (4))){
var inst_13403 = (state_13450[(7)]);
var inst_13405 = (state_13450[(13)]);
var inst_13402 = (state_13450[(2)]);
var inst_13403__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13402,(0),null);
var inst_13404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13402,(1),null);
var inst_13405__$1 = (inst_13403__$1 == null);
var state_13450__$1 = (function (){var statearr_13458 = state_13450;
(statearr_13458[(7)] = inst_13403__$1);

(statearr_13458[(14)] = inst_13404);

(statearr_13458[(13)] = inst_13405__$1);

return statearr_13458;
})();
if(cljs.core.truth_(inst_13405__$1)){
var statearr_13459_14512 = state_13450__$1;
(statearr_13459_14512[(1)] = (5));

} else {
var statearr_13460_14513 = state_13450__$1;
(statearr_13460_14513[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (15))){
var inst_13395 = (state_13450[(15)]);
var inst_13424 = (state_13450[(16)]);
var inst_13424__$1 = cljs.core.empty_QMARK_(inst_13395);
var state_13450__$1 = (function (){var statearr_13461 = state_13450;
(statearr_13461[(16)] = inst_13424__$1);

return statearr_13461;
})();
if(inst_13424__$1){
var statearr_13462_14514 = state_13450__$1;
(statearr_13462_14514[(1)] = (17));

} else {
var statearr_13463_14515 = state_13450__$1;
(statearr_13463_14515[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (21))){
var inst_13394 = (state_13450[(12)]);
var inst_13391 = inst_13394;
var state_13450__$1 = (function (){var statearr_13464 = state_13450;
(statearr_13464[(8)] = inst_13391);

return statearr_13464;
})();
var statearr_13465_14517 = state_13450__$1;
(statearr_13465_14517[(2)] = null);

(statearr_13465_14517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (13))){
var inst_13417 = (state_13450[(2)]);
var inst_13418 = calc_state();
var inst_13391 = inst_13418;
var state_13450__$1 = (function (){var statearr_13466 = state_13450;
(statearr_13466[(8)] = inst_13391);

(statearr_13466[(17)] = inst_13417);

return statearr_13466;
})();
var statearr_13467_14518 = state_13450__$1;
(statearr_13467_14518[(2)] = null);

(statearr_13467_14518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (22))){
var inst_13444 = (state_13450[(2)]);
var state_13450__$1 = state_13450;
var statearr_13468_14523 = state_13450__$1;
(statearr_13468_14523[(2)] = inst_13444);

(statearr_13468_14523[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (6))){
var inst_13404 = (state_13450[(14)]);
var inst_13408 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13404,change);
var state_13450__$1 = state_13450;
var statearr_13469_14524 = state_13450__$1;
(statearr_13469_14524[(2)] = inst_13408);

(statearr_13469_14524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (25))){
var state_13450__$1 = state_13450;
var statearr_13470_14525 = state_13450__$1;
(statearr_13470_14525[(2)] = null);

(statearr_13470_14525[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (17))){
var inst_13396 = (state_13450[(18)]);
var inst_13404 = (state_13450[(14)]);
var inst_13426 = (inst_13396.cljs$core$IFn$_invoke$arity$1 ? inst_13396.cljs$core$IFn$_invoke$arity$1(inst_13404) : inst_13396.call(null,inst_13404));
var inst_13427 = cljs.core.not(inst_13426);
var state_13450__$1 = state_13450;
var statearr_13471_14526 = state_13450__$1;
(statearr_13471_14526[(2)] = inst_13427);

(statearr_13471_14526[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (3))){
var inst_13448 = (state_13450[(2)]);
var state_13450__$1 = state_13450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13450__$1,inst_13448);
} else {
if((state_val_13451 === (12))){
var state_13450__$1 = state_13450;
var statearr_13472_14527 = state_13450__$1;
(statearr_13472_14527[(2)] = null);

(statearr_13472_14527[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (2))){
var inst_13394 = (state_13450[(12)]);
var inst_13391 = (state_13450[(8)]);
var inst_13394__$1 = cljs.core.__destructure_map(inst_13391);
var inst_13395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13394__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13394__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13397 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13394__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_13450__$1 = (function (){var statearr_13473 = state_13450;
(statearr_13473[(12)] = inst_13394__$1);

(statearr_13473[(15)] = inst_13395);

(statearr_13473[(18)] = inst_13396);

return statearr_13473;
})();
return cljs.core.async.ioc_alts_BANG_(state_13450__$1,(4),inst_13397);
} else {
if((state_val_13451 === (23))){
var inst_13435 = (state_13450[(2)]);
var state_13450__$1 = state_13450;
if(cljs.core.truth_(inst_13435)){
var statearr_13474_14528 = state_13450__$1;
(statearr_13474_14528[(1)] = (24));

} else {
var statearr_13475_14529 = state_13450__$1;
(statearr_13475_14529[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (19))){
var inst_13430 = (state_13450[(2)]);
var state_13450__$1 = state_13450;
var statearr_13476_14530 = state_13450__$1;
(statearr_13476_14530[(2)] = inst_13430);

(statearr_13476_14530[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (11))){
var inst_13404 = (state_13450[(14)]);
var inst_13414 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_13404);
var state_13450__$1 = state_13450;
var statearr_13477_14531 = state_13450__$1;
(statearr_13477_14531[(2)] = inst_13414);

(statearr_13477_14531[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (9))){
var inst_13395 = (state_13450[(15)]);
var inst_13421 = (state_13450[(19)]);
var inst_13404 = (state_13450[(14)]);
var inst_13421__$1 = (inst_13395.cljs$core$IFn$_invoke$arity$1 ? inst_13395.cljs$core$IFn$_invoke$arity$1(inst_13404) : inst_13395.call(null,inst_13404));
var state_13450__$1 = (function (){var statearr_13478 = state_13450;
(statearr_13478[(19)] = inst_13421__$1);

return statearr_13478;
})();
if(cljs.core.truth_(inst_13421__$1)){
var statearr_13479_14532 = state_13450__$1;
(statearr_13479_14532[(1)] = (14));

} else {
var statearr_13480_14533 = state_13450__$1;
(statearr_13480_14533[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (5))){
var inst_13405 = (state_13450[(13)]);
var state_13450__$1 = state_13450;
var statearr_13481_14534 = state_13450__$1;
(statearr_13481_14534[(2)] = inst_13405);

(statearr_13481_14534[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (14))){
var inst_13421 = (state_13450[(19)]);
var state_13450__$1 = state_13450;
var statearr_13482_14535 = state_13450__$1;
(statearr_13482_14535[(2)] = inst_13421);

(statearr_13482_14535[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (26))){
var inst_13440 = (state_13450[(2)]);
var state_13450__$1 = state_13450;
var statearr_13483_14536 = state_13450__$1;
(statearr_13483_14536[(2)] = inst_13440);

(statearr_13483_14536[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (16))){
var inst_13432 = (state_13450[(2)]);
var state_13450__$1 = state_13450;
if(cljs.core.truth_(inst_13432)){
var statearr_13484_14538 = state_13450__$1;
(statearr_13484_14538[(1)] = (20));

} else {
var statearr_13485_14539 = state_13450__$1;
(statearr_13485_14539[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (10))){
var inst_13446 = (state_13450[(2)]);
var state_13450__$1 = state_13450;
var statearr_13486_14541 = state_13450__$1;
(statearr_13486_14541[(2)] = inst_13446);

(statearr_13486_14541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (18))){
var inst_13424 = (state_13450[(16)]);
var state_13450__$1 = state_13450;
var statearr_13487_14542 = state_13450__$1;
(statearr_13487_14542[(2)] = inst_13424);

(statearr_13487_14542[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13451 === (8))){
var inst_13403 = (state_13450[(7)]);
var inst_13412 = (inst_13403 == null);
var state_13450__$1 = state_13450;
if(cljs.core.truth_(inst_13412)){
var statearr_13488_14543 = state_13450__$1;
(statearr_13488_14543[(1)] = (11));

} else {
var statearr_13489_14544 = state_13450__$1;
(statearr_13489_14544[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__12584__auto__ = null;
var cljs$core$async$mix_$_state_machine__12584__auto____0 = (function (){
var statearr_13490 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13490[(0)] = cljs$core$async$mix_$_state_machine__12584__auto__);

(statearr_13490[(1)] = (1));

return statearr_13490;
});
var cljs$core$async$mix_$_state_machine__12584__auto____1 = (function (state_13450){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13450);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13491){var ex__12587__auto__ = e13491;
var statearr_13492_14545 = state_13450;
(statearr_13492_14545[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13450[(4)]))){
var statearr_13493_14546 = state_13450;
(statearr_13493_14546[(1)] = cljs.core.first((state_13450[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14547 = state_13450;
state_13450 = G__14547;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12584__auto__ = function(state_13450){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12584__auto____1.call(this,state_13450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12584__auto____0;
cljs$core$async$mix_$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12584__auto____1;
return cljs$core$async$mix_$_state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13494 = f__12620__auto__();
(statearr_13494[(6)] = c__12619__auto___14507);

return statearr_13494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_14550 = (function (p,v,ch,close_QMARK_){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4510__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4508__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_14550(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_14551 = (function (p,v,ch){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4510__auto__.call(null,p,v,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4508__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_14551(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_14552 = (function() {
var G__14553 = null;
var G__14553__1 = (function (p){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4510__auto__.call(null,p));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4508__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__14553__2 = (function (p,v){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4510__auto__.call(null,p,v));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4508__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__14553 = function(p,v){
switch(arguments.length){
case 1:
return G__14553__1.call(this,p);
case 2:
return G__14553__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__14553.cljs$core$IFn$_invoke$arity$1 = G__14553__1;
G__14553.cljs$core$IFn$_invoke$arity$2 = G__14553__2;
return G__14553;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__13496 = arguments.length;
switch (G__13496) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_14552(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_14552(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__13499 = arguments.length;
switch (G__13499) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__13497_SHARP_){
if(cljs.core.truth_((p1__13497_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__13497_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__13497_SHARP_.call(null,topic)))){
return p1__13497_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__13497_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13500 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13500 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta13501){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta13501 = meta13501;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13500.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13502,meta13501__$1){
var self__ = this;
var _13502__$1 = this;
return (new cljs.core.async.t_cljs$core$async13500(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta13501__$1));
}));

(cljs.core.async.t_cljs$core$async13500.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13502){
var self__ = this;
var _13502__$1 = this;
return self__.meta13501;
}));

(cljs.core.async.t_cljs$core$async13500.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13500.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13500.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13500.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async13500.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async13500.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async13500.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async13500.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta13501","meta13501",-215698073,null)], null);
}));

(cljs.core.async.t_cljs$core$async13500.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13500.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13500");

(cljs.core.async.t_cljs$core$async13500.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13500");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13500.
 */
cljs.core.async.__GT_t_cljs$core$async13500 = (function cljs$core$async$__GT_t_cljs$core$async13500(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13501){
return (new cljs.core.async.t_cljs$core$async13500(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13501));
});

}

return (new cljs.core.async.t_cljs$core$async13500(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12619__auto___14558 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13574){
var state_val_13575 = (state_13574[(1)]);
if((state_val_13575 === (7))){
var inst_13570 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13576_14559 = state_13574__$1;
(statearr_13576_14559[(2)] = inst_13570);

(statearr_13576_14559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (20))){
var state_13574__$1 = state_13574;
var statearr_13577_14560 = state_13574__$1;
(statearr_13577_14560[(2)] = null);

(statearr_13577_14560[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (1))){
var state_13574__$1 = state_13574;
var statearr_13578_14561 = state_13574__$1;
(statearr_13578_14561[(2)] = null);

(statearr_13578_14561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (24))){
var inst_13553 = (state_13574[(7)]);
var inst_13562 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_13553);
var state_13574__$1 = state_13574;
var statearr_13579_14562 = state_13574__$1;
(statearr_13579_14562[(2)] = inst_13562);

(statearr_13579_14562[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (4))){
var inst_13505 = (state_13574[(8)]);
var inst_13505__$1 = (state_13574[(2)]);
var inst_13506 = (inst_13505__$1 == null);
var state_13574__$1 = (function (){var statearr_13580 = state_13574;
(statearr_13580[(8)] = inst_13505__$1);

return statearr_13580;
})();
if(cljs.core.truth_(inst_13506)){
var statearr_13581_14563 = state_13574__$1;
(statearr_13581_14563[(1)] = (5));

} else {
var statearr_13582_14564 = state_13574__$1;
(statearr_13582_14564[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (15))){
var inst_13547 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13583_14565 = state_13574__$1;
(statearr_13583_14565[(2)] = inst_13547);

(statearr_13583_14565[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (21))){
var inst_13567 = (state_13574[(2)]);
var state_13574__$1 = (function (){var statearr_13584 = state_13574;
(statearr_13584[(9)] = inst_13567);

return statearr_13584;
})();
var statearr_13585_14566 = state_13574__$1;
(statearr_13585_14566[(2)] = null);

(statearr_13585_14566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (13))){
var inst_13529 = (state_13574[(10)]);
var inst_13531 = cljs.core.chunked_seq_QMARK_(inst_13529);
var state_13574__$1 = state_13574;
if(inst_13531){
var statearr_13586_14568 = state_13574__$1;
(statearr_13586_14568[(1)] = (16));

} else {
var statearr_13587_14569 = state_13574__$1;
(statearr_13587_14569[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (22))){
var inst_13559 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
if(cljs.core.truth_(inst_13559)){
var statearr_13588_14570 = state_13574__$1;
(statearr_13588_14570[(1)] = (23));

} else {
var statearr_13589_14571 = state_13574__$1;
(statearr_13589_14571[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (6))){
var inst_13553 = (state_13574[(7)]);
var inst_13505 = (state_13574[(8)]);
var inst_13555 = (state_13574[(11)]);
var inst_13553__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_13505) : topic_fn.call(null,inst_13505));
var inst_13554 = cljs.core.deref(mults);
var inst_13555__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13554,inst_13553__$1);
var state_13574__$1 = (function (){var statearr_13590 = state_13574;
(statearr_13590[(7)] = inst_13553__$1);

(statearr_13590[(11)] = inst_13555__$1);

return statearr_13590;
})();
if(cljs.core.truth_(inst_13555__$1)){
var statearr_13591_14572 = state_13574__$1;
(statearr_13591_14572[(1)] = (19));

} else {
var statearr_13592_14573 = state_13574__$1;
(statearr_13592_14573[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (25))){
var inst_13564 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13593_14574 = state_13574__$1;
(statearr_13593_14574[(2)] = inst_13564);

(statearr_13593_14574[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (17))){
var inst_13529 = (state_13574[(10)]);
var inst_13538 = cljs.core.first(inst_13529);
var inst_13539 = cljs.core.async.muxch_STAR_(inst_13538);
var inst_13540 = cljs.core.async.close_BANG_(inst_13539);
var inst_13541 = cljs.core.next(inst_13529);
var inst_13515 = inst_13541;
var inst_13516 = null;
var inst_13517 = (0);
var inst_13518 = (0);
var state_13574__$1 = (function (){var statearr_13594 = state_13574;
(statearr_13594[(12)] = inst_13540);

(statearr_13594[(13)] = inst_13517);

(statearr_13594[(14)] = inst_13515);

(statearr_13594[(15)] = inst_13518);

(statearr_13594[(16)] = inst_13516);

return statearr_13594;
})();
var statearr_13595_14579 = state_13574__$1;
(statearr_13595_14579[(2)] = null);

(statearr_13595_14579[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (3))){
var inst_13572 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13574__$1,inst_13572);
} else {
if((state_val_13575 === (12))){
var inst_13549 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13596_14580 = state_13574__$1;
(statearr_13596_14580[(2)] = inst_13549);

(statearr_13596_14580[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (2))){
var state_13574__$1 = state_13574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13574__$1,(4),ch);
} else {
if((state_val_13575 === (23))){
var state_13574__$1 = state_13574;
var statearr_13597_14581 = state_13574__$1;
(statearr_13597_14581[(2)] = null);

(statearr_13597_14581[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (19))){
var inst_13505 = (state_13574[(8)]);
var inst_13555 = (state_13574[(11)]);
var inst_13557 = cljs.core.async.muxch_STAR_(inst_13555);
var state_13574__$1 = state_13574;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13574__$1,(22),inst_13557,inst_13505);
} else {
if((state_val_13575 === (11))){
var inst_13515 = (state_13574[(14)]);
var inst_13529 = (state_13574[(10)]);
var inst_13529__$1 = cljs.core.seq(inst_13515);
var state_13574__$1 = (function (){var statearr_13598 = state_13574;
(statearr_13598[(10)] = inst_13529__$1);

return statearr_13598;
})();
if(inst_13529__$1){
var statearr_13599_14582 = state_13574__$1;
(statearr_13599_14582[(1)] = (13));

} else {
var statearr_13600_14583 = state_13574__$1;
(statearr_13600_14583[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (9))){
var inst_13551 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13601_14584 = state_13574__$1;
(statearr_13601_14584[(2)] = inst_13551);

(statearr_13601_14584[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (5))){
var inst_13512 = cljs.core.deref(mults);
var inst_13513 = cljs.core.vals(inst_13512);
var inst_13514 = cljs.core.seq(inst_13513);
var inst_13515 = inst_13514;
var inst_13516 = null;
var inst_13517 = (0);
var inst_13518 = (0);
var state_13574__$1 = (function (){var statearr_13602 = state_13574;
(statearr_13602[(13)] = inst_13517);

(statearr_13602[(14)] = inst_13515);

(statearr_13602[(15)] = inst_13518);

(statearr_13602[(16)] = inst_13516);

return statearr_13602;
})();
var statearr_13603_14585 = state_13574__$1;
(statearr_13603_14585[(2)] = null);

(statearr_13603_14585[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (14))){
var state_13574__$1 = state_13574;
var statearr_13607_14586 = state_13574__$1;
(statearr_13607_14586[(2)] = null);

(statearr_13607_14586[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (16))){
var inst_13529 = (state_13574[(10)]);
var inst_13533 = cljs.core.chunk_first(inst_13529);
var inst_13534 = cljs.core.chunk_rest(inst_13529);
var inst_13535 = cljs.core.count(inst_13533);
var inst_13515 = inst_13534;
var inst_13516 = inst_13533;
var inst_13517 = inst_13535;
var inst_13518 = (0);
var state_13574__$1 = (function (){var statearr_13608 = state_13574;
(statearr_13608[(13)] = inst_13517);

(statearr_13608[(14)] = inst_13515);

(statearr_13608[(15)] = inst_13518);

(statearr_13608[(16)] = inst_13516);

return statearr_13608;
})();
var statearr_13609_14587 = state_13574__$1;
(statearr_13609_14587[(2)] = null);

(statearr_13609_14587[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (10))){
var inst_13517 = (state_13574[(13)]);
var inst_13515 = (state_13574[(14)]);
var inst_13518 = (state_13574[(15)]);
var inst_13516 = (state_13574[(16)]);
var inst_13523 = cljs.core._nth(inst_13516,inst_13518);
var inst_13524 = cljs.core.async.muxch_STAR_(inst_13523);
var inst_13525 = cljs.core.async.close_BANG_(inst_13524);
var inst_13526 = (inst_13518 + (1));
var tmp13604 = inst_13517;
var tmp13605 = inst_13515;
var tmp13606 = inst_13516;
var inst_13515__$1 = tmp13605;
var inst_13516__$1 = tmp13606;
var inst_13517__$1 = tmp13604;
var inst_13518__$1 = inst_13526;
var state_13574__$1 = (function (){var statearr_13610 = state_13574;
(statearr_13610[(13)] = inst_13517__$1);

(statearr_13610[(17)] = inst_13525);

(statearr_13610[(14)] = inst_13515__$1);

(statearr_13610[(15)] = inst_13518__$1);

(statearr_13610[(16)] = inst_13516__$1);

return statearr_13610;
})();
var statearr_13611_14592 = state_13574__$1;
(statearr_13611_14592[(2)] = null);

(statearr_13611_14592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (18))){
var inst_13544 = (state_13574[(2)]);
var state_13574__$1 = state_13574;
var statearr_13612_14593 = state_13574__$1;
(statearr_13612_14593[(2)] = inst_13544);

(statearr_13612_14593[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13575 === (8))){
var inst_13517 = (state_13574[(13)]);
var inst_13518 = (state_13574[(15)]);
var inst_13520 = (inst_13518 < inst_13517);
var inst_13521 = inst_13520;
var state_13574__$1 = state_13574;
if(cljs.core.truth_(inst_13521)){
var statearr_13613_14597 = state_13574__$1;
(statearr_13613_14597[(1)] = (10));

} else {
var statearr_13614_14598 = state_13574__$1;
(statearr_13614_14598[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_13615 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13615[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_13615[(1)] = (1));

return statearr_13615;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_13574){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13574);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13616){var ex__12587__auto__ = e13616;
var statearr_13617_14599 = state_13574;
(statearr_13617_14599[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13574[(4)]))){
var statearr_13618_14603 = state_13574;
(statearr_13618_14603[(1)] = cljs.core.first((state_13574[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14604 = state_13574;
state_13574 = G__14604;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_13574){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_13574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13619 = f__12620__auto__();
(statearr_13619[(6)] = c__12619__auto___14558);

return statearr_13619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__13621 = arguments.length;
switch (G__13621) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__13623 = arguments.length;
switch (G__13623) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__13625 = arguments.length;
switch (G__13625) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__12619__auto___14618 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13668){
var state_val_13669 = (state_13668[(1)]);
if((state_val_13669 === (7))){
var state_13668__$1 = state_13668;
var statearr_13670_14619 = state_13668__$1;
(statearr_13670_14619[(2)] = null);

(statearr_13670_14619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (1))){
var state_13668__$1 = state_13668;
var statearr_13671_14620 = state_13668__$1;
(statearr_13671_14620[(2)] = null);

(statearr_13671_14620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (4))){
var inst_13628 = (state_13668[(7)]);
var inst_13629 = (state_13668[(8)]);
var inst_13631 = (inst_13629 < inst_13628);
var state_13668__$1 = state_13668;
if(cljs.core.truth_(inst_13631)){
var statearr_13672_14621 = state_13668__$1;
(statearr_13672_14621[(1)] = (6));

} else {
var statearr_13673_14622 = state_13668__$1;
(statearr_13673_14622[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (15))){
var inst_13654 = (state_13668[(9)]);
var inst_13659 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_13654);
var state_13668__$1 = state_13668;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13668__$1,(17),out,inst_13659);
} else {
if((state_val_13669 === (13))){
var inst_13654 = (state_13668[(9)]);
var inst_13654__$1 = (state_13668[(2)]);
var inst_13655 = cljs.core.some(cljs.core.nil_QMARK_,inst_13654__$1);
var state_13668__$1 = (function (){var statearr_13674 = state_13668;
(statearr_13674[(9)] = inst_13654__$1);

return statearr_13674;
})();
if(cljs.core.truth_(inst_13655)){
var statearr_13675_14623 = state_13668__$1;
(statearr_13675_14623[(1)] = (14));

} else {
var statearr_13676_14624 = state_13668__$1;
(statearr_13676_14624[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (6))){
var state_13668__$1 = state_13668;
var statearr_13677_14625 = state_13668__$1;
(statearr_13677_14625[(2)] = null);

(statearr_13677_14625[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (17))){
var inst_13661 = (state_13668[(2)]);
var state_13668__$1 = (function (){var statearr_13679 = state_13668;
(statearr_13679[(10)] = inst_13661);

return statearr_13679;
})();
var statearr_13680_14626 = state_13668__$1;
(statearr_13680_14626[(2)] = null);

(statearr_13680_14626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (3))){
var inst_13666 = (state_13668[(2)]);
var state_13668__$1 = state_13668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13668__$1,inst_13666);
} else {
if((state_val_13669 === (12))){
var _ = (function (){var statearr_13681 = state_13668;
(statearr_13681[(4)] = cljs.core.rest((state_13668[(4)])));

return statearr_13681;
})();
var state_13668__$1 = state_13668;
var ex13678 = (state_13668__$1[(2)]);
var statearr_13682_14628 = state_13668__$1;
(statearr_13682_14628[(5)] = ex13678);


if((ex13678 instanceof Object)){
var statearr_13683_14629 = state_13668__$1;
(statearr_13683_14629[(1)] = (11));

(statearr_13683_14629[(5)] = null);

} else {
throw ex13678;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (2))){
var inst_13627 = cljs.core.reset_BANG_(dctr,cnt);
var inst_13628 = cnt;
var inst_13629 = (0);
var state_13668__$1 = (function (){var statearr_13684 = state_13668;
(statearr_13684[(7)] = inst_13628);

(statearr_13684[(8)] = inst_13629);

(statearr_13684[(11)] = inst_13627);

return statearr_13684;
})();
var statearr_13685_14631 = state_13668__$1;
(statearr_13685_14631[(2)] = null);

(statearr_13685_14631[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (11))){
var inst_13633 = (state_13668[(2)]);
var inst_13634 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_13668__$1 = (function (){var statearr_13686 = state_13668;
(statearr_13686[(12)] = inst_13633);

return statearr_13686;
})();
var statearr_13687_14632 = state_13668__$1;
(statearr_13687_14632[(2)] = inst_13634);

(statearr_13687_14632[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (9))){
var inst_13629 = (state_13668[(8)]);
var _ = (function (){var statearr_13688 = state_13668;
(statearr_13688[(4)] = cljs.core.cons((12),(state_13668[(4)])));

return statearr_13688;
})();
var inst_13640 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_13629) : chs__$1.call(null,inst_13629));
var inst_13641 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_13629) : done.call(null,inst_13629));
var inst_13642 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_13640,inst_13641);
var ___$1 = (function (){var statearr_13689 = state_13668;
(statearr_13689[(4)] = cljs.core.rest((state_13668[(4)])));

return statearr_13689;
})();
var state_13668__$1 = state_13668;
var statearr_13690_14633 = state_13668__$1;
(statearr_13690_14633[(2)] = inst_13642);

(statearr_13690_14633[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (5))){
var inst_13652 = (state_13668[(2)]);
var state_13668__$1 = (function (){var statearr_13691 = state_13668;
(statearr_13691[(13)] = inst_13652);

return statearr_13691;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13668__$1,(13),dchan);
} else {
if((state_val_13669 === (14))){
var inst_13657 = cljs.core.async.close_BANG_(out);
var state_13668__$1 = state_13668;
var statearr_13692_14634 = state_13668__$1;
(statearr_13692_14634[(2)] = inst_13657);

(statearr_13692_14634[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (16))){
var inst_13664 = (state_13668[(2)]);
var state_13668__$1 = state_13668;
var statearr_13693_14635 = state_13668__$1;
(statearr_13693_14635[(2)] = inst_13664);

(statearr_13693_14635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (10))){
var inst_13629 = (state_13668[(8)]);
var inst_13645 = (state_13668[(2)]);
var inst_13646 = (inst_13629 + (1));
var inst_13629__$1 = inst_13646;
var state_13668__$1 = (function (){var statearr_13694 = state_13668;
(statearr_13694[(14)] = inst_13645);

(statearr_13694[(8)] = inst_13629__$1);

return statearr_13694;
})();
var statearr_13695_14636 = state_13668__$1;
(statearr_13695_14636[(2)] = null);

(statearr_13695_14636[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13669 === (8))){
var inst_13650 = (state_13668[(2)]);
var state_13668__$1 = state_13668;
var statearr_13696_14637 = state_13668__$1;
(statearr_13696_14637[(2)] = inst_13650);

(statearr_13696_14637[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_13697 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13697[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_13697[(1)] = (1));

return statearr_13697;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_13668){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13668);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13698){var ex__12587__auto__ = e13698;
var statearr_13699_14638 = state_13668;
(statearr_13699_14638[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13668[(4)]))){
var statearr_13700_14639 = state_13668;
(statearr_13700_14639[(1)] = cljs.core.first((state_13668[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14640 = state_13668;
state_13668 = G__14640;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_13668){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_13668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13701 = f__12620__auto__();
(statearr_13701[(6)] = c__12619__auto___14618);

return statearr_13701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__13704 = arguments.length;
switch (G__13704) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12619__auto___14642 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13736){
var state_val_13737 = (state_13736[(1)]);
if((state_val_13737 === (7))){
var inst_13715 = (state_13736[(7)]);
var inst_13716 = (state_13736[(8)]);
var inst_13715__$1 = (state_13736[(2)]);
var inst_13716__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13715__$1,(0),null);
var inst_13717 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13715__$1,(1),null);
var inst_13718 = (inst_13716__$1 == null);
var state_13736__$1 = (function (){var statearr_13738 = state_13736;
(statearr_13738[(9)] = inst_13717);

(statearr_13738[(7)] = inst_13715__$1);

(statearr_13738[(8)] = inst_13716__$1);

return statearr_13738;
})();
if(cljs.core.truth_(inst_13718)){
var statearr_13739_14643 = state_13736__$1;
(statearr_13739_14643[(1)] = (8));

} else {
var statearr_13740_14644 = state_13736__$1;
(statearr_13740_14644[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13737 === (1))){
var inst_13705 = cljs.core.vec(chs);
var inst_13706 = inst_13705;
var state_13736__$1 = (function (){var statearr_13741 = state_13736;
(statearr_13741[(10)] = inst_13706);

return statearr_13741;
})();
var statearr_13742_14645 = state_13736__$1;
(statearr_13742_14645[(2)] = null);

(statearr_13742_14645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13737 === (4))){
var inst_13706 = (state_13736[(10)]);
var state_13736__$1 = state_13736;
return cljs.core.async.ioc_alts_BANG_(state_13736__$1,(7),inst_13706);
} else {
if((state_val_13737 === (6))){
var inst_13732 = (state_13736[(2)]);
var state_13736__$1 = state_13736;
var statearr_13743_14650 = state_13736__$1;
(statearr_13743_14650[(2)] = inst_13732);

(statearr_13743_14650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13737 === (3))){
var inst_13734 = (state_13736[(2)]);
var state_13736__$1 = state_13736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13736__$1,inst_13734);
} else {
if((state_val_13737 === (2))){
var inst_13706 = (state_13736[(10)]);
var inst_13708 = cljs.core.count(inst_13706);
var inst_13709 = (inst_13708 > (0));
var state_13736__$1 = state_13736;
if(cljs.core.truth_(inst_13709)){
var statearr_13745_14651 = state_13736__$1;
(statearr_13745_14651[(1)] = (4));

} else {
var statearr_13746_14652 = state_13736__$1;
(statearr_13746_14652[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13737 === (11))){
var inst_13706 = (state_13736[(10)]);
var inst_13725 = (state_13736[(2)]);
var tmp13744 = inst_13706;
var inst_13706__$1 = tmp13744;
var state_13736__$1 = (function (){var statearr_13747 = state_13736;
(statearr_13747[(10)] = inst_13706__$1);

(statearr_13747[(11)] = inst_13725);

return statearr_13747;
})();
var statearr_13748_14653 = state_13736__$1;
(statearr_13748_14653[(2)] = null);

(statearr_13748_14653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13737 === (9))){
var inst_13716 = (state_13736[(8)]);
var state_13736__$1 = state_13736;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13736__$1,(11),out,inst_13716);
} else {
if((state_val_13737 === (5))){
var inst_13730 = cljs.core.async.close_BANG_(out);
var state_13736__$1 = state_13736;
var statearr_13749_14654 = state_13736__$1;
(statearr_13749_14654[(2)] = inst_13730);

(statearr_13749_14654[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13737 === (10))){
var inst_13728 = (state_13736[(2)]);
var state_13736__$1 = state_13736;
var statearr_13750_14655 = state_13736__$1;
(statearr_13750_14655[(2)] = inst_13728);

(statearr_13750_14655[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13737 === (8))){
var inst_13717 = (state_13736[(9)]);
var inst_13706 = (state_13736[(10)]);
var inst_13715 = (state_13736[(7)]);
var inst_13716 = (state_13736[(8)]);
var inst_13720 = (function (){var cs = inst_13706;
var vec__13711 = inst_13715;
var v = inst_13716;
var c = inst_13717;
return (function (p1__13702_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__13702_SHARP_);
});
})();
var inst_13721 = cljs.core.filterv(inst_13720,inst_13706);
var inst_13706__$1 = inst_13721;
var state_13736__$1 = (function (){var statearr_13751 = state_13736;
(statearr_13751[(10)] = inst_13706__$1);

return statearr_13751;
})();
var statearr_13752_14656 = state_13736__$1;
(statearr_13752_14656[(2)] = null);

(statearr_13752_14656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_13753 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13753[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_13753[(1)] = (1));

return statearr_13753;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_13736){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13736);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13754){var ex__12587__auto__ = e13754;
var statearr_13755_14657 = state_13736;
(statearr_13755_14657[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13736[(4)]))){
var statearr_13756_14662 = state_13736;
(statearr_13756_14662[(1)] = cljs.core.first((state_13736[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14663 = state_13736;
state_13736 = G__14663;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_13736){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_13736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13757 = f__12620__auto__();
(statearr_13757[(6)] = c__12619__auto___14642);

return statearr_13757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__13759 = arguments.length;
switch (G__13759) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12619__auto___14666 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13783){
var state_val_13784 = (state_13783[(1)]);
if((state_val_13784 === (7))){
var inst_13765 = (state_13783[(7)]);
var inst_13765__$1 = (state_13783[(2)]);
var inst_13766 = (inst_13765__$1 == null);
var inst_13767 = cljs.core.not(inst_13766);
var state_13783__$1 = (function (){var statearr_13785 = state_13783;
(statearr_13785[(7)] = inst_13765__$1);

return statearr_13785;
})();
if(inst_13767){
var statearr_13786_14667 = state_13783__$1;
(statearr_13786_14667[(1)] = (8));

} else {
var statearr_13787_14668 = state_13783__$1;
(statearr_13787_14668[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13784 === (1))){
var inst_13760 = (0);
var state_13783__$1 = (function (){var statearr_13788 = state_13783;
(statearr_13788[(8)] = inst_13760);

return statearr_13788;
})();
var statearr_13789_14670 = state_13783__$1;
(statearr_13789_14670[(2)] = null);

(statearr_13789_14670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13784 === (4))){
var state_13783__$1 = state_13783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13783__$1,(7),ch);
} else {
if((state_val_13784 === (6))){
var inst_13778 = (state_13783[(2)]);
var state_13783__$1 = state_13783;
var statearr_13790_14671 = state_13783__$1;
(statearr_13790_14671[(2)] = inst_13778);

(statearr_13790_14671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13784 === (3))){
var inst_13780 = (state_13783[(2)]);
var inst_13781 = cljs.core.async.close_BANG_(out);
var state_13783__$1 = (function (){var statearr_13791 = state_13783;
(statearr_13791[(9)] = inst_13780);

return statearr_13791;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13783__$1,inst_13781);
} else {
if((state_val_13784 === (2))){
var inst_13760 = (state_13783[(8)]);
var inst_13762 = (inst_13760 < n);
var state_13783__$1 = state_13783;
if(cljs.core.truth_(inst_13762)){
var statearr_13792_14672 = state_13783__$1;
(statearr_13792_14672[(1)] = (4));

} else {
var statearr_13793_14673 = state_13783__$1;
(statearr_13793_14673[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13784 === (11))){
var inst_13760 = (state_13783[(8)]);
var inst_13770 = (state_13783[(2)]);
var inst_13771 = (inst_13760 + (1));
var inst_13760__$1 = inst_13771;
var state_13783__$1 = (function (){var statearr_13794 = state_13783;
(statearr_13794[(8)] = inst_13760__$1);

(statearr_13794[(10)] = inst_13770);

return statearr_13794;
})();
var statearr_13795_14678 = state_13783__$1;
(statearr_13795_14678[(2)] = null);

(statearr_13795_14678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13784 === (9))){
var state_13783__$1 = state_13783;
var statearr_13796_14679 = state_13783__$1;
(statearr_13796_14679[(2)] = null);

(statearr_13796_14679[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13784 === (5))){
var state_13783__$1 = state_13783;
var statearr_13797_14680 = state_13783__$1;
(statearr_13797_14680[(2)] = null);

(statearr_13797_14680[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13784 === (10))){
var inst_13775 = (state_13783[(2)]);
var state_13783__$1 = state_13783;
var statearr_13798_14681 = state_13783__$1;
(statearr_13798_14681[(2)] = inst_13775);

(statearr_13798_14681[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13784 === (8))){
var inst_13765 = (state_13783[(7)]);
var state_13783__$1 = state_13783;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13783__$1,(11),out,inst_13765);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_13799 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13799[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_13799[(1)] = (1));

return statearr_13799;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_13783){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13783);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13800){var ex__12587__auto__ = e13800;
var statearr_13801_14682 = state_13783;
(statearr_13801_14682[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13783[(4)]))){
var statearr_13802_14683 = state_13783;
(statearr_13802_14683[(1)] = cljs.core.first((state_13783[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14684 = state_13783;
state_13783 = G__14684;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_13783){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_13783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13803 = f__12620__auto__();
(statearr_13803[(6)] = c__12619__auto___14666);

return statearr_13803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13805 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13805 = (function (f,ch,meta13806){
this.f = f;
this.ch = ch;
this.meta13806 = meta13806;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13805.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13807,meta13806__$1){
var self__ = this;
var _13807__$1 = this;
return (new cljs.core.async.t_cljs$core$async13805(self__.f,self__.ch,meta13806__$1));
}));

(cljs.core.async.t_cljs$core$async13805.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13807){
var self__ = this;
var _13807__$1 = this;
return self__.meta13806;
}));

(cljs.core.async.t_cljs$core$async13805.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13805.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13805.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13805.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13805.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13808 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13808 = (function (f,ch,meta13806,_,fn1,meta13809){
this.f = f;
this.ch = ch;
this.meta13806 = meta13806;
this._ = _;
this.fn1 = fn1;
this.meta13809 = meta13809;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13808.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13810,meta13809__$1){
var self__ = this;
var _13810__$1 = this;
return (new cljs.core.async.t_cljs$core$async13808(self__.f,self__.ch,self__.meta13806,self__._,self__.fn1,meta13809__$1));
}));

(cljs.core.async.t_cljs$core$async13808.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13810){
var self__ = this;
var _13810__$1 = this;
return self__.meta13809;
}));

(cljs.core.async.t_cljs$core$async13808.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13808.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async13808.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13808.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__13804_SHARP_){
var G__13811 = (((p1__13804_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__13804_SHARP_) : self__.f.call(null,p1__13804_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__13811) : f1.call(null,G__13811));
});
}));

(cljs.core.async.t_cljs$core$async13808.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13806","meta13806",1180112744,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13805","cljs.core.async/t_cljs$core$async13805",1624183764,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13809","meta13809",-984582610,null)], null);
}));

(cljs.core.async.t_cljs$core$async13808.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13808.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13808");

(cljs.core.async.t_cljs$core$async13808.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13808");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13808.
 */
cljs.core.async.__GT_t_cljs$core$async13808 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13808(f__$1,ch__$1,meta13806__$1,___$2,fn1__$1,meta13809){
return (new cljs.core.async.t_cljs$core$async13808(f__$1,ch__$1,meta13806__$1,___$2,fn1__$1,meta13809));
});

}

return (new cljs.core.async.t_cljs$core$async13808(self__.f,self__.ch,self__.meta13806,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4210__auto__ = ret;
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4210__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__13812 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__13812) : self__.f.call(null,G__13812));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async13805.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13805.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async13805.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13806","meta13806",1180112744,null)], null);
}));

(cljs.core.async.t_cljs$core$async13805.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13805.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13805");

(cljs.core.async.t_cljs$core$async13805.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13805");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13805.
 */
cljs.core.async.__GT_t_cljs$core$async13805 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13805(f__$1,ch__$1,meta13806){
return (new cljs.core.async.t_cljs$core$async13805(f__$1,ch__$1,meta13806));
});

}

return (new cljs.core.async.t_cljs$core$async13805(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13813 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13813 = (function (f,ch,meta13814){
this.f = f;
this.ch = ch;
this.meta13814 = meta13814;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13813.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13815,meta13814__$1){
var self__ = this;
var _13815__$1 = this;
return (new cljs.core.async.t_cljs$core$async13813(self__.f,self__.ch,meta13814__$1));
}));

(cljs.core.async.t_cljs$core$async13813.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13815){
var self__ = this;
var _13815__$1 = this;
return self__.meta13814;
}));

(cljs.core.async.t_cljs$core$async13813.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13813.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13813.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13813.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async13813.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13813.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async13813.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13814","meta13814",1050296719,null)], null);
}));

(cljs.core.async.t_cljs$core$async13813.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13813.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13813");

(cljs.core.async.t_cljs$core$async13813.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13813");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13813.
 */
cljs.core.async.__GT_t_cljs$core$async13813 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13813(f__$1,ch__$1,meta13814){
return (new cljs.core.async.t_cljs$core$async13813(f__$1,ch__$1,meta13814));
});

}

return (new cljs.core.async.t_cljs$core$async13813(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13816 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13816 = (function (p,ch,meta13817){
this.p = p;
this.ch = ch;
this.meta13817 = meta13817;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13818,meta13817__$1){
var self__ = this;
var _13818__$1 = this;
return (new cljs.core.async.t_cljs$core$async13816(self__.p,self__.ch,meta13817__$1));
}));

(cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13818){
var self__ = this;
var _13818__$1 = this;
return self__.meta13817;
}));

(cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13816.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async13816.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13817","meta13817",-786396258,null)], null);
}));

(cljs.core.async.t_cljs$core$async13816.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13816.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13816");

(cljs.core.async.t_cljs$core$async13816.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13816");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13816.
 */
cljs.core.async.__GT_t_cljs$core$async13816 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13816(p__$1,ch__$1,meta13817){
return (new cljs.core.async.t_cljs$core$async13816(p__$1,ch__$1,meta13817));
});

}

return (new cljs.core.async.t_cljs$core$async13816(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__13820 = arguments.length;
switch (G__13820) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12619__auto___14690 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13841){
var state_val_13842 = (state_13841[(1)]);
if((state_val_13842 === (7))){
var inst_13837 = (state_13841[(2)]);
var state_13841__$1 = state_13841;
var statearr_13843_14691 = state_13841__$1;
(statearr_13843_14691[(2)] = inst_13837);

(statearr_13843_14691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (1))){
var state_13841__$1 = state_13841;
var statearr_13844_14692 = state_13841__$1;
(statearr_13844_14692[(2)] = null);

(statearr_13844_14692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (4))){
var inst_13823 = (state_13841[(7)]);
var inst_13823__$1 = (state_13841[(2)]);
var inst_13824 = (inst_13823__$1 == null);
var state_13841__$1 = (function (){var statearr_13845 = state_13841;
(statearr_13845[(7)] = inst_13823__$1);

return statearr_13845;
})();
if(cljs.core.truth_(inst_13824)){
var statearr_13846_14693 = state_13841__$1;
(statearr_13846_14693[(1)] = (5));

} else {
var statearr_13847_14694 = state_13841__$1;
(statearr_13847_14694[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (6))){
var inst_13823 = (state_13841[(7)]);
var inst_13828 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_13823) : p.call(null,inst_13823));
var state_13841__$1 = state_13841;
if(cljs.core.truth_(inst_13828)){
var statearr_13848_14696 = state_13841__$1;
(statearr_13848_14696[(1)] = (8));

} else {
var statearr_13849_14697 = state_13841__$1;
(statearr_13849_14697[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (3))){
var inst_13839 = (state_13841[(2)]);
var state_13841__$1 = state_13841;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13841__$1,inst_13839);
} else {
if((state_val_13842 === (2))){
var state_13841__$1 = state_13841;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13841__$1,(4),ch);
} else {
if((state_val_13842 === (11))){
var inst_13831 = (state_13841[(2)]);
var state_13841__$1 = state_13841;
var statearr_13850_14698 = state_13841__$1;
(statearr_13850_14698[(2)] = inst_13831);

(statearr_13850_14698[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (9))){
var state_13841__$1 = state_13841;
var statearr_13851_14699 = state_13841__$1;
(statearr_13851_14699[(2)] = null);

(statearr_13851_14699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (5))){
var inst_13826 = cljs.core.async.close_BANG_(out);
var state_13841__$1 = state_13841;
var statearr_13852_14700 = state_13841__$1;
(statearr_13852_14700[(2)] = inst_13826);

(statearr_13852_14700[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (10))){
var inst_13834 = (state_13841[(2)]);
var state_13841__$1 = (function (){var statearr_13853 = state_13841;
(statearr_13853[(8)] = inst_13834);

return statearr_13853;
})();
var statearr_13854_14701 = state_13841__$1;
(statearr_13854_14701[(2)] = null);

(statearr_13854_14701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13842 === (8))){
var inst_13823 = (state_13841[(7)]);
var state_13841__$1 = state_13841;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13841__$1,(11),out,inst_13823);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_13855 = [null,null,null,null,null,null,null,null,null];
(statearr_13855[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_13855[(1)] = (1));

return statearr_13855;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_13841){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13841);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13856){var ex__12587__auto__ = e13856;
var statearr_13857_14702 = state_13841;
(statearr_13857_14702[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13841[(4)]))){
var statearr_13858_14703 = state_13841;
(statearr_13858_14703[(1)] = cljs.core.first((state_13841[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14704 = state_13841;
state_13841 = G__14704;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_13841){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_13841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13859 = f__12620__auto__();
(statearr_13859[(6)] = c__12619__auto___14690);

return statearr_13859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__13861 = arguments.length;
switch (G__13861) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12619__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13923){
var state_val_13924 = (state_13923[(1)]);
if((state_val_13924 === (7))){
var inst_13919 = (state_13923[(2)]);
var state_13923__$1 = state_13923;
var statearr_13925_14711 = state_13923__$1;
(statearr_13925_14711[(2)] = inst_13919);

(statearr_13925_14711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (20))){
var inst_13889 = (state_13923[(7)]);
var inst_13900 = (state_13923[(2)]);
var inst_13901 = cljs.core.next(inst_13889);
var inst_13875 = inst_13901;
var inst_13876 = null;
var inst_13877 = (0);
var inst_13878 = (0);
var state_13923__$1 = (function (){var statearr_13926 = state_13923;
(statearr_13926[(8)] = inst_13877);

(statearr_13926[(9)] = inst_13900);

(statearr_13926[(10)] = inst_13878);

(statearr_13926[(11)] = inst_13875);

(statearr_13926[(12)] = inst_13876);

return statearr_13926;
})();
var statearr_13927_14712 = state_13923__$1;
(statearr_13927_14712[(2)] = null);

(statearr_13927_14712[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (1))){
var state_13923__$1 = state_13923;
var statearr_13928_14713 = state_13923__$1;
(statearr_13928_14713[(2)] = null);

(statearr_13928_14713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (4))){
var inst_13864 = (state_13923[(13)]);
var inst_13864__$1 = (state_13923[(2)]);
var inst_13865 = (inst_13864__$1 == null);
var state_13923__$1 = (function (){var statearr_13929 = state_13923;
(statearr_13929[(13)] = inst_13864__$1);

return statearr_13929;
})();
if(cljs.core.truth_(inst_13865)){
var statearr_13930_14714 = state_13923__$1;
(statearr_13930_14714[(1)] = (5));

} else {
var statearr_13931_14715 = state_13923__$1;
(statearr_13931_14715[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (15))){
var state_13923__$1 = state_13923;
var statearr_13935_14717 = state_13923__$1;
(statearr_13935_14717[(2)] = null);

(statearr_13935_14717[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (21))){
var state_13923__$1 = state_13923;
var statearr_13936_14718 = state_13923__$1;
(statearr_13936_14718[(2)] = null);

(statearr_13936_14718[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (13))){
var inst_13877 = (state_13923[(8)]);
var inst_13878 = (state_13923[(10)]);
var inst_13875 = (state_13923[(11)]);
var inst_13876 = (state_13923[(12)]);
var inst_13885 = (state_13923[(2)]);
var inst_13886 = (inst_13878 + (1));
var tmp13932 = inst_13877;
var tmp13933 = inst_13875;
var tmp13934 = inst_13876;
var inst_13875__$1 = tmp13933;
var inst_13876__$1 = tmp13934;
var inst_13877__$1 = tmp13932;
var inst_13878__$1 = inst_13886;
var state_13923__$1 = (function (){var statearr_13937 = state_13923;
(statearr_13937[(14)] = inst_13885);

(statearr_13937[(8)] = inst_13877__$1);

(statearr_13937[(10)] = inst_13878__$1);

(statearr_13937[(11)] = inst_13875__$1);

(statearr_13937[(12)] = inst_13876__$1);

return statearr_13937;
})();
var statearr_13938_14720 = state_13923__$1;
(statearr_13938_14720[(2)] = null);

(statearr_13938_14720[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (22))){
var state_13923__$1 = state_13923;
var statearr_13939_14724 = state_13923__$1;
(statearr_13939_14724[(2)] = null);

(statearr_13939_14724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (6))){
var inst_13864 = (state_13923[(13)]);
var inst_13873 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13864) : f.call(null,inst_13864));
var inst_13874 = cljs.core.seq(inst_13873);
var inst_13875 = inst_13874;
var inst_13876 = null;
var inst_13877 = (0);
var inst_13878 = (0);
var state_13923__$1 = (function (){var statearr_13940 = state_13923;
(statearr_13940[(8)] = inst_13877);

(statearr_13940[(10)] = inst_13878);

(statearr_13940[(11)] = inst_13875);

(statearr_13940[(12)] = inst_13876);

return statearr_13940;
})();
var statearr_13941_14725 = state_13923__$1;
(statearr_13941_14725[(2)] = null);

(statearr_13941_14725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (17))){
var inst_13889 = (state_13923[(7)]);
var inst_13893 = cljs.core.chunk_first(inst_13889);
var inst_13894 = cljs.core.chunk_rest(inst_13889);
var inst_13895 = cljs.core.count(inst_13893);
var inst_13875 = inst_13894;
var inst_13876 = inst_13893;
var inst_13877 = inst_13895;
var inst_13878 = (0);
var state_13923__$1 = (function (){var statearr_13942 = state_13923;
(statearr_13942[(8)] = inst_13877);

(statearr_13942[(10)] = inst_13878);

(statearr_13942[(11)] = inst_13875);

(statearr_13942[(12)] = inst_13876);

return statearr_13942;
})();
var statearr_13943_14726 = state_13923__$1;
(statearr_13943_14726[(2)] = null);

(statearr_13943_14726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (3))){
var inst_13921 = (state_13923[(2)]);
var state_13923__$1 = state_13923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13923__$1,inst_13921);
} else {
if((state_val_13924 === (12))){
var inst_13909 = (state_13923[(2)]);
var state_13923__$1 = state_13923;
var statearr_13944_14727 = state_13923__$1;
(statearr_13944_14727[(2)] = inst_13909);

(statearr_13944_14727[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (2))){
var state_13923__$1 = state_13923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13923__$1,(4),in$);
} else {
if((state_val_13924 === (23))){
var inst_13917 = (state_13923[(2)]);
var state_13923__$1 = state_13923;
var statearr_13945_14728 = state_13923__$1;
(statearr_13945_14728[(2)] = inst_13917);

(statearr_13945_14728[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (19))){
var inst_13904 = (state_13923[(2)]);
var state_13923__$1 = state_13923;
var statearr_13946_14729 = state_13923__$1;
(statearr_13946_14729[(2)] = inst_13904);

(statearr_13946_14729[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (11))){
var inst_13889 = (state_13923[(7)]);
var inst_13875 = (state_13923[(11)]);
var inst_13889__$1 = cljs.core.seq(inst_13875);
var state_13923__$1 = (function (){var statearr_13947 = state_13923;
(statearr_13947[(7)] = inst_13889__$1);

return statearr_13947;
})();
if(inst_13889__$1){
var statearr_13948_14730 = state_13923__$1;
(statearr_13948_14730[(1)] = (14));

} else {
var statearr_13949_14731 = state_13923__$1;
(statearr_13949_14731[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (9))){
var inst_13911 = (state_13923[(2)]);
var inst_13912 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_13923__$1 = (function (){var statearr_13950 = state_13923;
(statearr_13950[(15)] = inst_13911);

return statearr_13950;
})();
if(cljs.core.truth_(inst_13912)){
var statearr_13951_14732 = state_13923__$1;
(statearr_13951_14732[(1)] = (21));

} else {
var statearr_13952_14733 = state_13923__$1;
(statearr_13952_14733[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (5))){
var inst_13867 = cljs.core.async.close_BANG_(out);
var state_13923__$1 = state_13923;
var statearr_13953_14734 = state_13923__$1;
(statearr_13953_14734[(2)] = inst_13867);

(statearr_13953_14734[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (14))){
var inst_13889 = (state_13923[(7)]);
var inst_13891 = cljs.core.chunked_seq_QMARK_(inst_13889);
var state_13923__$1 = state_13923;
if(inst_13891){
var statearr_13954_14735 = state_13923__$1;
(statearr_13954_14735[(1)] = (17));

} else {
var statearr_13955_14736 = state_13923__$1;
(statearr_13955_14736[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (16))){
var inst_13907 = (state_13923[(2)]);
var state_13923__$1 = state_13923;
var statearr_13956_14737 = state_13923__$1;
(statearr_13956_14737[(2)] = inst_13907);

(statearr_13956_14737[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13924 === (10))){
var inst_13878 = (state_13923[(10)]);
var inst_13876 = (state_13923[(12)]);
var inst_13883 = cljs.core._nth(inst_13876,inst_13878);
var state_13923__$1 = state_13923;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13923__$1,(13),out,inst_13883);
} else {
if((state_val_13924 === (18))){
var inst_13889 = (state_13923[(7)]);
var inst_13898 = cljs.core.first(inst_13889);
var state_13923__$1 = state_13923;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13923__$1,(20),out,inst_13898);
} else {
if((state_val_13924 === (8))){
var inst_13877 = (state_13923[(8)]);
var inst_13878 = (state_13923[(10)]);
var inst_13880 = (inst_13878 < inst_13877);
var inst_13881 = inst_13880;
var state_13923__$1 = state_13923;
if(cljs.core.truth_(inst_13881)){
var statearr_13957_14738 = state_13923__$1;
(statearr_13957_14738[(1)] = (10));

} else {
var statearr_13958_14739 = state_13923__$1;
(statearr_13958_14739[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12584__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12584__auto____0 = (function (){
var statearr_13959 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13959[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12584__auto__);

(statearr_13959[(1)] = (1));

return statearr_13959;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12584__auto____1 = (function (state_13923){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13923);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e13960){var ex__12587__auto__ = e13960;
var statearr_13961_14740 = state_13923;
(statearr_13961_14740[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13923[(4)]))){
var statearr_13962_14741 = state_13923;
(statearr_13962_14741[(1)] = cljs.core.first((state_13923[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14742 = state_13923;
state_13923 = G__14742;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12584__auto__ = function(state_13923){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12584__auto____1.call(this,state_13923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12584__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12584__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_13963 = f__12620__auto__();
(statearr_13963[(6)] = c__12619__auto__);

return statearr_13963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));

return c__12619__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__13965 = arguments.length;
switch (G__13965) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__13967 = arguments.length;
switch (G__13967) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__13969 = arguments.length;
switch (G__13969) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12619__auto___14750 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_13993){
var state_val_13994 = (state_13993[(1)]);
if((state_val_13994 === (7))){
var inst_13988 = (state_13993[(2)]);
var state_13993__$1 = state_13993;
var statearr_13995_14751 = state_13993__$1;
(statearr_13995_14751[(2)] = inst_13988);

(statearr_13995_14751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (1))){
var inst_13970 = null;
var state_13993__$1 = (function (){var statearr_13996 = state_13993;
(statearr_13996[(7)] = inst_13970);

return statearr_13996;
})();
var statearr_13997_14752 = state_13993__$1;
(statearr_13997_14752[(2)] = null);

(statearr_13997_14752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (4))){
var inst_13973 = (state_13993[(8)]);
var inst_13973__$1 = (state_13993[(2)]);
var inst_13974 = (inst_13973__$1 == null);
var inst_13975 = cljs.core.not(inst_13974);
var state_13993__$1 = (function (){var statearr_13998 = state_13993;
(statearr_13998[(8)] = inst_13973__$1);

return statearr_13998;
})();
if(inst_13975){
var statearr_13999_14753 = state_13993__$1;
(statearr_13999_14753[(1)] = (5));

} else {
var statearr_14000_14754 = state_13993__$1;
(statearr_14000_14754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (6))){
var state_13993__$1 = state_13993;
var statearr_14001_14755 = state_13993__$1;
(statearr_14001_14755[(2)] = null);

(statearr_14001_14755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (3))){
var inst_13990 = (state_13993[(2)]);
var inst_13991 = cljs.core.async.close_BANG_(out);
var state_13993__$1 = (function (){var statearr_14002 = state_13993;
(statearr_14002[(9)] = inst_13990);

return statearr_14002;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13993__$1,inst_13991);
} else {
if((state_val_13994 === (2))){
var state_13993__$1 = state_13993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13993__$1,(4),ch);
} else {
if((state_val_13994 === (11))){
var inst_13973 = (state_13993[(8)]);
var inst_13982 = (state_13993[(2)]);
var inst_13970 = inst_13973;
var state_13993__$1 = (function (){var statearr_14003 = state_13993;
(statearr_14003[(7)] = inst_13970);

(statearr_14003[(10)] = inst_13982);

return statearr_14003;
})();
var statearr_14004_14756 = state_13993__$1;
(statearr_14004_14756[(2)] = null);

(statearr_14004_14756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (9))){
var inst_13973 = (state_13993[(8)]);
var state_13993__$1 = state_13993;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13993__$1,(11),out,inst_13973);
} else {
if((state_val_13994 === (5))){
var inst_13973 = (state_13993[(8)]);
var inst_13970 = (state_13993[(7)]);
var inst_13977 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13973,inst_13970);
var state_13993__$1 = state_13993;
if(inst_13977){
var statearr_14006_14757 = state_13993__$1;
(statearr_14006_14757[(1)] = (8));

} else {
var statearr_14007_14758 = state_13993__$1;
(statearr_14007_14758[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (10))){
var inst_13985 = (state_13993[(2)]);
var state_13993__$1 = state_13993;
var statearr_14008_14759 = state_13993__$1;
(statearr_14008_14759[(2)] = inst_13985);

(statearr_14008_14759[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13994 === (8))){
var inst_13970 = (state_13993[(7)]);
var tmp14005 = inst_13970;
var inst_13970__$1 = tmp14005;
var state_13993__$1 = (function (){var statearr_14009 = state_13993;
(statearr_14009[(7)] = inst_13970__$1);

return statearr_14009;
})();
var statearr_14010_14761 = state_13993__$1;
(statearr_14010_14761[(2)] = null);

(statearr_14010_14761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_14011 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14011[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_14011[(1)] = (1));

return statearr_14011;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_13993){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_13993);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e14012){var ex__12587__auto__ = e14012;
var statearr_14013_14762 = state_13993;
(statearr_14013_14762[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_13993[(4)]))){
var statearr_14014_14763 = state_13993;
(statearr_14014_14763[(1)] = cljs.core.first((state_13993[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14764 = state_13993;
state_13993 = G__14764;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_13993){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_13993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_14015 = f__12620__auto__();
(statearr_14015[(6)] = c__12619__auto___14750);

return statearr_14015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__14017 = arguments.length;
switch (G__14017) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12619__auto___14766 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_14055){
var state_val_14056 = (state_14055[(1)]);
if((state_val_14056 === (7))){
var inst_14051 = (state_14055[(2)]);
var state_14055__$1 = state_14055;
var statearr_14057_14767 = state_14055__$1;
(statearr_14057_14767[(2)] = inst_14051);

(statearr_14057_14767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (1))){
var inst_14018 = (new Array(n));
var inst_14019 = inst_14018;
var inst_14020 = (0);
var state_14055__$1 = (function (){var statearr_14058 = state_14055;
(statearr_14058[(7)] = inst_14019);

(statearr_14058[(8)] = inst_14020);

return statearr_14058;
})();
var statearr_14059_14768 = state_14055__$1;
(statearr_14059_14768[(2)] = null);

(statearr_14059_14768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (4))){
var inst_14023 = (state_14055[(9)]);
var inst_14023__$1 = (state_14055[(2)]);
var inst_14024 = (inst_14023__$1 == null);
var inst_14025 = cljs.core.not(inst_14024);
var state_14055__$1 = (function (){var statearr_14060 = state_14055;
(statearr_14060[(9)] = inst_14023__$1);

return statearr_14060;
})();
if(inst_14025){
var statearr_14061_14769 = state_14055__$1;
(statearr_14061_14769[(1)] = (5));

} else {
var statearr_14062_14770 = state_14055__$1;
(statearr_14062_14770[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (15))){
var inst_14045 = (state_14055[(2)]);
var state_14055__$1 = state_14055;
var statearr_14063_14771 = state_14055__$1;
(statearr_14063_14771[(2)] = inst_14045);

(statearr_14063_14771[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (13))){
var state_14055__$1 = state_14055;
var statearr_14064_14772 = state_14055__$1;
(statearr_14064_14772[(2)] = null);

(statearr_14064_14772[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (6))){
var inst_14020 = (state_14055[(8)]);
var inst_14041 = (inst_14020 > (0));
var state_14055__$1 = state_14055;
if(cljs.core.truth_(inst_14041)){
var statearr_14065_14773 = state_14055__$1;
(statearr_14065_14773[(1)] = (12));

} else {
var statearr_14066_14774 = state_14055__$1;
(statearr_14066_14774[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (3))){
var inst_14053 = (state_14055[(2)]);
var state_14055__$1 = state_14055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14055__$1,inst_14053);
} else {
if((state_val_14056 === (12))){
var inst_14019 = (state_14055[(7)]);
var inst_14043 = cljs.core.vec(inst_14019);
var state_14055__$1 = state_14055;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14055__$1,(15),out,inst_14043);
} else {
if((state_val_14056 === (2))){
var state_14055__$1 = state_14055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14055__$1,(4),ch);
} else {
if((state_val_14056 === (11))){
var inst_14035 = (state_14055[(2)]);
var inst_14036 = (new Array(n));
var inst_14019 = inst_14036;
var inst_14020 = (0);
var state_14055__$1 = (function (){var statearr_14067 = state_14055;
(statearr_14067[(10)] = inst_14035);

(statearr_14067[(7)] = inst_14019);

(statearr_14067[(8)] = inst_14020);

return statearr_14067;
})();
var statearr_14068_14775 = state_14055__$1;
(statearr_14068_14775[(2)] = null);

(statearr_14068_14775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (9))){
var inst_14019 = (state_14055[(7)]);
var inst_14033 = cljs.core.vec(inst_14019);
var state_14055__$1 = state_14055;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14055__$1,(11),out,inst_14033);
} else {
if((state_val_14056 === (5))){
var inst_14019 = (state_14055[(7)]);
var inst_14023 = (state_14055[(9)]);
var inst_14028 = (state_14055[(11)]);
var inst_14020 = (state_14055[(8)]);
var inst_14027 = (inst_14019[inst_14020] = inst_14023);
var inst_14028__$1 = (inst_14020 + (1));
var inst_14029 = (inst_14028__$1 < n);
var state_14055__$1 = (function (){var statearr_14069 = state_14055;
(statearr_14069[(12)] = inst_14027);

(statearr_14069[(11)] = inst_14028__$1);

return statearr_14069;
})();
if(cljs.core.truth_(inst_14029)){
var statearr_14070_14776 = state_14055__$1;
(statearr_14070_14776[(1)] = (8));

} else {
var statearr_14071_14777 = state_14055__$1;
(statearr_14071_14777[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (14))){
var inst_14048 = (state_14055[(2)]);
var inst_14049 = cljs.core.async.close_BANG_(out);
var state_14055__$1 = (function (){var statearr_14073 = state_14055;
(statearr_14073[(13)] = inst_14048);

return statearr_14073;
})();
var statearr_14074_14782 = state_14055__$1;
(statearr_14074_14782[(2)] = inst_14049);

(statearr_14074_14782[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (10))){
var inst_14039 = (state_14055[(2)]);
var state_14055__$1 = state_14055;
var statearr_14075_14783 = state_14055__$1;
(statearr_14075_14783[(2)] = inst_14039);

(statearr_14075_14783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14056 === (8))){
var inst_14019 = (state_14055[(7)]);
var inst_14028 = (state_14055[(11)]);
var tmp14072 = inst_14019;
var inst_14019__$1 = tmp14072;
var inst_14020 = inst_14028;
var state_14055__$1 = (function (){var statearr_14076 = state_14055;
(statearr_14076[(7)] = inst_14019__$1);

(statearr_14076[(8)] = inst_14020);

return statearr_14076;
})();
var statearr_14077_14784 = state_14055__$1;
(statearr_14077_14784[(2)] = null);

(statearr_14077_14784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_14078 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14078[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_14078[(1)] = (1));

return statearr_14078;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_14055){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_14055);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e14079){var ex__12587__auto__ = e14079;
var statearr_14080_14789 = state_14055;
(statearr_14080_14789[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_14055[(4)]))){
var statearr_14081_14790 = state_14055;
(statearr_14081_14790[(1)] = cljs.core.first((state_14055[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14791 = state_14055;
state_14055 = G__14791;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_14055){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_14055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_14082 = f__12620__auto__();
(statearr_14082[(6)] = c__12619__auto___14766);

return statearr_14082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__14084 = arguments.length;
switch (G__14084) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12619__auto___14795 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12620__auto__ = (function (){var switch__12583__auto__ = (function (state_14129){
var state_val_14130 = (state_14129[(1)]);
if((state_val_14130 === (7))){
var inst_14125 = (state_14129[(2)]);
var state_14129__$1 = state_14129;
var statearr_14131_14796 = state_14129__$1;
(statearr_14131_14796[(2)] = inst_14125);

(statearr_14131_14796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (1))){
var inst_14085 = [];
var inst_14086 = inst_14085;
var inst_14087 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14129__$1 = (function (){var statearr_14132 = state_14129;
(statearr_14132[(7)] = inst_14086);

(statearr_14132[(8)] = inst_14087);

return statearr_14132;
})();
var statearr_14133_14797 = state_14129__$1;
(statearr_14133_14797[(2)] = null);

(statearr_14133_14797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (4))){
var inst_14090 = (state_14129[(9)]);
var inst_14090__$1 = (state_14129[(2)]);
var inst_14091 = (inst_14090__$1 == null);
var inst_14092 = cljs.core.not(inst_14091);
var state_14129__$1 = (function (){var statearr_14134 = state_14129;
(statearr_14134[(9)] = inst_14090__$1);

return statearr_14134;
})();
if(inst_14092){
var statearr_14135_14798 = state_14129__$1;
(statearr_14135_14798[(1)] = (5));

} else {
var statearr_14136_14799 = state_14129__$1;
(statearr_14136_14799[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (15))){
var inst_14086 = (state_14129[(7)]);
var inst_14117 = cljs.core.vec(inst_14086);
var state_14129__$1 = state_14129;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14129__$1,(18),out,inst_14117);
} else {
if((state_val_14130 === (13))){
var inst_14112 = (state_14129[(2)]);
var state_14129__$1 = state_14129;
var statearr_14137_14800 = state_14129__$1;
(statearr_14137_14800[(2)] = inst_14112);

(statearr_14137_14800[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (6))){
var inst_14086 = (state_14129[(7)]);
var inst_14114 = inst_14086.length;
var inst_14115 = (inst_14114 > (0));
var state_14129__$1 = state_14129;
if(cljs.core.truth_(inst_14115)){
var statearr_14138_14801 = state_14129__$1;
(statearr_14138_14801[(1)] = (15));

} else {
var statearr_14139_14802 = state_14129__$1;
(statearr_14139_14802[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (17))){
var inst_14122 = (state_14129[(2)]);
var inst_14123 = cljs.core.async.close_BANG_(out);
var state_14129__$1 = (function (){var statearr_14140 = state_14129;
(statearr_14140[(10)] = inst_14122);

return statearr_14140;
})();
var statearr_14141_14803 = state_14129__$1;
(statearr_14141_14803[(2)] = inst_14123);

(statearr_14141_14803[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (3))){
var inst_14127 = (state_14129[(2)]);
var state_14129__$1 = state_14129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14129__$1,inst_14127);
} else {
if((state_val_14130 === (12))){
var inst_14086 = (state_14129[(7)]);
var inst_14105 = cljs.core.vec(inst_14086);
var state_14129__$1 = state_14129;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14129__$1,(14),out,inst_14105);
} else {
if((state_val_14130 === (2))){
var state_14129__$1 = state_14129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14129__$1,(4),ch);
} else {
if((state_val_14130 === (11))){
var inst_14086 = (state_14129[(7)]);
var inst_14090 = (state_14129[(9)]);
var inst_14094 = (state_14129[(11)]);
var inst_14102 = inst_14086.push(inst_14090);
var tmp14142 = inst_14086;
var inst_14086__$1 = tmp14142;
var inst_14087 = inst_14094;
var state_14129__$1 = (function (){var statearr_14143 = state_14129;
(statearr_14143[(12)] = inst_14102);

(statearr_14143[(7)] = inst_14086__$1);

(statearr_14143[(8)] = inst_14087);

return statearr_14143;
})();
var statearr_14144_14804 = state_14129__$1;
(statearr_14144_14804[(2)] = null);

(statearr_14144_14804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (9))){
var inst_14087 = (state_14129[(8)]);
var inst_14098 = cljs.core.keyword_identical_QMARK_(inst_14087,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_14129__$1 = state_14129;
var statearr_14145_14805 = state_14129__$1;
(statearr_14145_14805[(2)] = inst_14098);

(statearr_14145_14805[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (5))){
var inst_14095 = (state_14129[(13)]);
var inst_14090 = (state_14129[(9)]);
var inst_14087 = (state_14129[(8)]);
var inst_14094 = (state_14129[(11)]);
var inst_14094__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_14090) : f.call(null,inst_14090));
var inst_14095__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14094__$1,inst_14087);
var state_14129__$1 = (function (){var statearr_14146 = state_14129;
(statearr_14146[(13)] = inst_14095__$1);

(statearr_14146[(11)] = inst_14094__$1);

return statearr_14146;
})();
if(inst_14095__$1){
var statearr_14147_14806 = state_14129__$1;
(statearr_14147_14806[(1)] = (8));

} else {
var statearr_14148_14807 = state_14129__$1;
(statearr_14148_14807[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (14))){
var inst_14090 = (state_14129[(9)]);
var inst_14094 = (state_14129[(11)]);
var inst_14107 = (state_14129[(2)]);
var inst_14108 = [];
var inst_14109 = inst_14108.push(inst_14090);
var inst_14086 = inst_14108;
var inst_14087 = inst_14094;
var state_14129__$1 = (function (){var statearr_14149 = state_14129;
(statearr_14149[(7)] = inst_14086);

(statearr_14149[(14)] = inst_14107);

(statearr_14149[(15)] = inst_14109);

(statearr_14149[(8)] = inst_14087);

return statearr_14149;
})();
var statearr_14150_14808 = state_14129__$1;
(statearr_14150_14808[(2)] = null);

(statearr_14150_14808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (16))){
var state_14129__$1 = state_14129;
var statearr_14151_14809 = state_14129__$1;
(statearr_14151_14809[(2)] = null);

(statearr_14151_14809[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (10))){
var inst_14100 = (state_14129[(2)]);
var state_14129__$1 = state_14129;
if(cljs.core.truth_(inst_14100)){
var statearr_14152_14810 = state_14129__$1;
(statearr_14152_14810[(1)] = (11));

} else {
var statearr_14153_14811 = state_14129__$1;
(statearr_14153_14811[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (18))){
var inst_14119 = (state_14129[(2)]);
var state_14129__$1 = state_14129;
var statearr_14154_14812 = state_14129__$1;
(statearr_14154_14812[(2)] = inst_14119);

(statearr_14154_14812[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (8))){
var inst_14095 = (state_14129[(13)]);
var state_14129__$1 = state_14129;
var statearr_14155_14813 = state_14129__$1;
(statearr_14155_14813[(2)] = inst_14095);

(statearr_14155_14813[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12584__auto__ = null;
var cljs$core$async$state_machine__12584__auto____0 = (function (){
var statearr_14156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14156[(0)] = cljs$core$async$state_machine__12584__auto__);

(statearr_14156[(1)] = (1));

return statearr_14156;
});
var cljs$core$async$state_machine__12584__auto____1 = (function (state_14129){
while(true){
var ret_value__12585__auto__ = (function (){try{while(true){
var result__12586__auto__ = switch__12583__auto__(state_14129);
if(cljs.core.keyword_identical_QMARK_(result__12586__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12586__auto__;
}
break;
}
}catch (e14157){var ex__12587__auto__ = e14157;
var statearr_14158_14814 = state_14129;
(statearr_14158_14814[(2)] = ex__12587__auto__);


if(cljs.core.seq((state_14129[(4)]))){
var statearr_14159_14815 = state_14129;
(statearr_14159_14815[(1)] = cljs.core.first((state_14129[(4)])));

} else {
throw ex__12587__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12585__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14816 = state_14129;
state_14129 = G__14816;
continue;
} else {
return ret_value__12585__auto__;
}
break;
}
});
cljs$core$async$state_machine__12584__auto__ = function(state_14129){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12584__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12584__auto____1.call(this,state_14129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12584__auto____0;
cljs$core$async$state_machine__12584__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12584__auto____1;
return cljs$core$async$state_machine__12584__auto__;
})()
})();
var state__12621__auto__ = (function (){var statearr_14160 = f__12620__auto__();
(statearr_14160[(6)] = c__12619__auto___14795);

return statearr_14160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12621__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
