goog.provide('uniformity.internals.rand_js');
uniformity.internals.rand_js.random_bytes = (function uniformity$internals$rand_js$random_bytes(n){
var bs = (new Uint8Array(n));
window.crypto.getRandomValues(bs);

return bs;
});
if((typeof uniformity !== 'undefined') && (typeof uniformity.internals !== 'undefined') && (typeof uniformity.internals.rand_js !== 'undefined') && (typeof uniformity.internals.rand_js.rand_max !== 'undefined')){
} else {
uniformity.internals.rand_js.rand_max = (281474976710655);
}
uniformity.internals.rand_js.random_uint48be = (function uniformity$internals$rand_js$random_uint48be(){
var bytes = uniformity.internals.rand_js.random_bytes((6));
return (((((((bytes[(0)]) * Math.pow((2),(8))) + ((bytes[(1)]) * Math.pow((2),(32)))) + ((bytes[(2)]) * Math.pow((2),(24)))) + ((bytes[(3)]) * Math.pow((2),(16)))) + ((bytes[(4)]) * Math.pow((2),(8)))) + (bytes[(5)]));
});
uniformity.internals.rand_js.random_int32 = (function uniformity$internals$rand_js$random_int32(var_args){
var G__8190 = arguments.length;
switch (G__8190) {
case 0:
return uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$0 = (function (){
return uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$2((0),Math.pow((2),(31)));
}));

(uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$1 = (function (max){
return uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$2((0),max);
}));

(uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$2 = (function (min,max){
if((max > min)){
} else {
throw (new Error("Assert failed: (> max min)"));
}

if(((max - min) <= uniformity.internals.rand_js.rand_max)){
} else {
throw (new Error("Assert failed: (<= (- max min) rand-max)"));
}

if(cljs.core.truth_(Number.isSafeInteger(min))){
} else {
throw (new Error("Assert failed: (.isSafeInteger js/Number min)"));
}

if(cljs.core.truth_(Number.isSafeInteger(max))){
} else {
throw (new Error("Assert failed: (.isSafeInteger js/Number max)"));
}

var range = (max - min);
var rand_limit = (uniformity.internals.rand_js.rand_max - cljs.core.mod(uniformity.internals.rand_js.rand_max,range));
var x = uniformity.internals.rand_js.random_uint48be();
if((x < rand_limit)){
return (cljs.core.mod(x,range) + min);
} else {
return uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$2(min,max);
}
}));

(uniformity.internals.rand_js.random_int32.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=uniformity.internals.rand_js.js.map
