goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__12628 = arguments.length;
switch (G__12628) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12631 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12631 = (function (f,blockable,meta12632){
this.f = f;
this.blockable = blockable;
this.meta12632 = meta12632;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12633,meta12632__$1){
var self__ = this;
var _12633__$1 = this;
return (new cljs.core.async.t_cljs$core$async12631(self__.f,self__.blockable,meta12632__$1));
}));

(cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12633){
var self__ = this;
var _12633__$1 = this;
return self__.meta12632;
}));

(cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async12631.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async12631.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta12632","meta12632",1874867183,null)], null);
}));

(cljs.core.async.t_cljs$core$async12631.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12631.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12631");

(cljs.core.async.t_cljs$core$async12631.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async12631");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12631.
 */
cljs.core.async.__GT_t_cljs$core$async12631 = (function cljs$core$async$__GT_t_cljs$core$async12631(f__$1,blockable__$1,meta12632){
return (new cljs.core.async.t_cljs$core$async12631(f__$1,blockable__$1,meta12632));
});

}

return (new cljs.core.async.t_cljs$core$async12631(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__12636 = arguments.length;
switch (G__12636) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__12638 = arguments.length;
switch (G__12638) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__12642 = arguments.length;
switch (G__12642) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_14134 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14134) : fn1.call(null,val_14134));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14134) : fn1.call(null,val_14134));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__12644 = arguments.length;
switch (G__12644) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4695__auto___14136 = n;
var x_14137 = (0);
while(true){
if((x_14137 < n__4695__auto___14136)){
(a[x_14137] = x_14137);

var G__14138 = (x_14137 + (1));
x_14137 = G__14138;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12645 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12645 = (function (flag,meta12646){
this.flag = flag;
this.meta12646 = meta12646;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12645.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12647,meta12646__$1){
var self__ = this;
var _12647__$1 = this;
return (new cljs.core.async.t_cljs$core$async12645(self__.flag,meta12646__$1));
}));

(cljs.core.async.t_cljs$core$async12645.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12647){
var self__ = this;
var _12647__$1 = this;
return self__.meta12646;
}));

(cljs.core.async.t_cljs$core$async12645.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12645.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12645.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12645.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async12645.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta12646","meta12646",806154400,null)], null);
}));

(cljs.core.async.t_cljs$core$async12645.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12645.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12645");

(cljs.core.async.t_cljs$core$async12645.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async12645");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12645.
 */
cljs.core.async.__GT_t_cljs$core$async12645 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async12645(flag__$1,meta12646){
return (new cljs.core.async.t_cljs$core$async12645(flag__$1,meta12646));
});

}

return (new cljs.core.async.t_cljs$core$async12645(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12663 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12663 = (function (flag,cb,meta12664){
this.flag = flag;
this.cb = cb;
this.meta12664 = meta12664;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12663.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12665,meta12664__$1){
var self__ = this;
var _12665__$1 = this;
return (new cljs.core.async.t_cljs$core$async12663(self__.flag,self__.cb,meta12664__$1));
}));

(cljs.core.async.t_cljs$core$async12663.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12665){
var self__ = this;
var _12665__$1 = this;
return self__.meta12664;
}));

(cljs.core.async.t_cljs$core$async12663.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12663.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async12663.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12663.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async12663.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta12664","meta12664",870267532,null)], null);
}));

(cljs.core.async.t_cljs$core$async12663.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12663.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12663");

(cljs.core.async.t_cljs$core$async12663.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async12663");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12663.
 */
cljs.core.async.__GT_t_cljs$core$async12663 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async12663(flag__$1,cb__$1,meta12664){
return (new cljs.core.async.t_cljs$core$async12663(flag__$1,cb__$1,meta12664));
});

}

return (new cljs.core.async.t_cljs$core$async12663(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12666_SHARP_){
var G__12674 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12666_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12674) : fret.call(null,G__12674));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__12667_SHARP_){
var G__12675 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__12667_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__12675) : fret.call(null,G__12675));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4212__auto__ = wport;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14139 = (i + (1));
i = G__14139;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4212__auto__ = ret;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4210__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4210__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___14140 = arguments.length;
var i__4819__auto___14141 = (0);
while(true){
if((i__4819__auto___14141 < len__4818__auto___14140)){
args__4824__auto__.push((arguments[i__4819__auto___14141]));

var G__14142 = (i__4819__auto___14141 + (1));
i__4819__auto___14141 = G__14142;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__12678){
var map__12679 = p__12678;
var map__12679__$1 = cljs.core.__destructure_map(map__12679);
var opts = map__12679__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq12676){
var G__12677 = cljs.core.first(seq12676);
var seq12676__$1 = cljs.core.next(seq12676);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12677,seq12676__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__12685 = arguments.length;
switch (G__12685) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__12569__auto___14144 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_12716){
var state_val_12717 = (state_12716[(1)]);
if((state_val_12717 === (7))){
var inst_12712 = (state_12716[(2)]);
var state_12716__$1 = state_12716;
var statearr_12718_14145 = state_12716__$1;
(statearr_12718_14145[(2)] = inst_12712);

(statearr_12718_14145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (1))){
var state_12716__$1 = state_12716;
var statearr_12719_14146 = state_12716__$1;
(statearr_12719_14146[(2)] = null);

(statearr_12719_14146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (4))){
var inst_12695 = (state_12716[(7)]);
var inst_12695__$1 = (state_12716[(2)]);
var inst_12696 = (inst_12695__$1 == null);
var state_12716__$1 = (function (){var statearr_12720 = state_12716;
(statearr_12720[(7)] = inst_12695__$1);

return statearr_12720;
})();
if(cljs.core.truth_(inst_12696)){
var statearr_12723_14147 = state_12716__$1;
(statearr_12723_14147[(1)] = (5));

} else {
var statearr_12724_14148 = state_12716__$1;
(statearr_12724_14148[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (13))){
var state_12716__$1 = state_12716;
var statearr_12725_14149 = state_12716__$1;
(statearr_12725_14149[(2)] = null);

(statearr_12725_14149[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (6))){
var inst_12695 = (state_12716[(7)]);
var state_12716__$1 = state_12716;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12716__$1,(11),to,inst_12695);
} else {
if((state_val_12717 === (3))){
var inst_12714 = (state_12716[(2)]);
var state_12716__$1 = state_12716;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12716__$1,inst_12714);
} else {
if((state_val_12717 === (12))){
var state_12716__$1 = state_12716;
var statearr_12726_14150 = state_12716__$1;
(statearr_12726_14150[(2)] = null);

(statearr_12726_14150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (2))){
var state_12716__$1 = state_12716;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12716__$1,(4),from);
} else {
if((state_val_12717 === (11))){
var inst_12705 = (state_12716[(2)]);
var state_12716__$1 = state_12716;
if(cljs.core.truth_(inst_12705)){
var statearr_12732_14151 = state_12716__$1;
(statearr_12732_14151[(1)] = (12));

} else {
var statearr_12733_14152 = state_12716__$1;
(statearr_12733_14152[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (9))){
var state_12716__$1 = state_12716;
var statearr_12734_14153 = state_12716__$1;
(statearr_12734_14153[(2)] = null);

(statearr_12734_14153[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (5))){
var state_12716__$1 = state_12716;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12735_14154 = state_12716__$1;
(statearr_12735_14154[(1)] = (8));

} else {
var statearr_12736_14155 = state_12716__$1;
(statearr_12736_14155[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (14))){
var inst_12710 = (state_12716[(2)]);
var state_12716__$1 = state_12716;
var statearr_12737_14156 = state_12716__$1;
(statearr_12737_14156[(2)] = inst_12710);

(statearr_12737_14156[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (10))){
var inst_12702 = (state_12716[(2)]);
var state_12716__$1 = state_12716;
var statearr_12738_14157 = state_12716__$1;
(statearr_12738_14157[(2)] = inst_12702);

(statearr_12738_14157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12717 === (8))){
var inst_12699 = cljs.core.async.close_BANG_(to);
var state_12716__$1 = state_12716;
var statearr_12739_14158 = state_12716__$1;
(statearr_12739_14158[(2)] = inst_12699);

(statearr_12739_14158[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_12740 = [null,null,null,null,null,null,null,null];
(statearr_12740[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_12740[(1)] = (1));

return statearr_12740;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_12716){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_12716);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e12741){var ex__12537__auto__ = e12741;
var statearr_12742_14159 = state_12716;
(statearr_12742_14159[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_12716[(4)]))){
var statearr_12743_14160 = state_12716;
(statearr_12743_14160[(1)] = cljs.core.first((state_12716[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14161 = state_12716;
state_12716 = G__14161;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_12716){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_12716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_12744 = f__12570__auto__();
(statearr_12744[(6)] = c__12569__auto___14144);

return statearr_12744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__12747){
var vec__12748 = p__12747;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12748,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12748,(1),null);
var job = vec__12748;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__12569__auto___14162 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_12755){
var state_val_12756 = (state_12755[(1)]);
if((state_val_12756 === (1))){
var state_12755__$1 = state_12755;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12755__$1,(2),res,v);
} else {
if((state_val_12756 === (2))){
var inst_12752 = (state_12755[(2)]);
var inst_12753 = cljs.core.async.close_BANG_(res);
var state_12755__$1 = (function (){var statearr_12757 = state_12755;
(statearr_12757[(7)] = inst_12752);

return statearr_12757;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_12755__$1,inst_12753);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0 = (function (){
var statearr_12758 = [null,null,null,null,null,null,null,null];
(statearr_12758[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__);

(statearr_12758[(1)] = (1));

return statearr_12758;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1 = (function (state_12755){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_12755);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e12759){var ex__12537__auto__ = e12759;
var statearr_12760_14163 = state_12755;
(statearr_12760_14163[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_12755[(4)]))){
var statearr_12763_14164 = state_12755;
(statearr_12763_14164[(1)] = cljs.core.first((state_12755[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14165 = state_12755;
state_12755 = G__14165;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = function(state_12755){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1.call(this,state_12755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_12764 = f__12570__auto__();
(statearr_12764[(6)] = c__12569__auto___14162);

return statearr_12764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__12765){
var vec__12766 = p__12765;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12766,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12766,(1),null);
var job = vec__12766;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4695__auto___14166 = n;
var __14167 = (0);
while(true){
if((__14167 < n__4695__auto___14166)){
var G__12769_14168 = type;
var G__12769_14169__$1 = (((G__12769_14168 instanceof cljs.core.Keyword))?G__12769_14168.fqn:null);
switch (G__12769_14169__$1) {
case "compute":
var c__12569__auto___14171 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__14167,c__12569__auto___14171,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async){
return (function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = ((function (__14167,c__12569__auto___14171,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async){
return (function (state_12782){
var state_val_12783 = (state_12782[(1)]);
if((state_val_12783 === (1))){
var state_12782__$1 = state_12782;
var statearr_12784_14172 = state_12782__$1;
(statearr_12784_14172[(2)] = null);

(statearr_12784_14172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12783 === (2))){
var state_12782__$1 = state_12782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12782__$1,(4),jobs);
} else {
if((state_val_12783 === (3))){
var inst_12780 = (state_12782[(2)]);
var state_12782__$1 = state_12782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12782__$1,inst_12780);
} else {
if((state_val_12783 === (4))){
var inst_12772 = (state_12782[(2)]);
var inst_12773 = process(inst_12772);
var state_12782__$1 = state_12782;
if(cljs.core.truth_(inst_12773)){
var statearr_12785_14173 = state_12782__$1;
(statearr_12785_14173[(1)] = (5));

} else {
var statearr_12786_14174 = state_12782__$1;
(statearr_12786_14174[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12783 === (5))){
var state_12782__$1 = state_12782;
var statearr_12787_14177 = state_12782__$1;
(statearr_12787_14177[(2)] = null);

(statearr_12787_14177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12783 === (6))){
var state_12782__$1 = state_12782;
var statearr_12788_14178 = state_12782__$1;
(statearr_12788_14178[(2)] = null);

(statearr_12788_14178[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12783 === (7))){
var inst_12778 = (state_12782[(2)]);
var state_12782__$1 = state_12782;
var statearr_12791_14179 = state_12782__$1;
(statearr_12791_14179[(2)] = inst_12778);

(statearr_12791_14179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14167,c__12569__auto___14171,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async))
;
return ((function (__14167,switch__12533__auto__,c__12569__auto___14171,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0 = (function (){
var statearr_12792 = [null,null,null,null,null,null,null];
(statearr_12792[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__);

(statearr_12792[(1)] = (1));

return statearr_12792;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1 = (function (state_12782){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_12782);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e12793){var ex__12537__auto__ = e12793;
var statearr_12794_14180 = state_12782;
(statearr_12794_14180[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_12782[(4)]))){
var statearr_12795_14181 = state_12782;
(statearr_12795_14181[(1)] = cljs.core.first((state_12782[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14182 = state_12782;
state_12782 = G__14182;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = function(state_12782){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1.call(this,state_12782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__;
})()
;})(__14167,switch__12533__auto__,c__12569__auto___14171,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async))
})();
var state__12571__auto__ = (function (){var statearr_12796 = f__12570__auto__();
(statearr_12796[(6)] = c__12569__auto___14171);

return statearr_12796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
});})(__14167,c__12569__auto___14171,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async))
);


break;
case "async":
var c__12569__auto___14183 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__14167,c__12569__auto___14183,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async){
return (function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = ((function (__14167,c__12569__auto___14183,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async){
return (function (state_12809){
var state_val_12810 = (state_12809[(1)]);
if((state_val_12810 === (1))){
var state_12809__$1 = state_12809;
var statearr_12811_14184 = state_12809__$1;
(statearr_12811_14184[(2)] = null);

(statearr_12811_14184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12810 === (2))){
var state_12809__$1 = state_12809;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12809__$1,(4),jobs);
} else {
if((state_val_12810 === (3))){
var inst_12807 = (state_12809[(2)]);
var state_12809__$1 = state_12809;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12809__$1,inst_12807);
} else {
if((state_val_12810 === (4))){
var inst_12799 = (state_12809[(2)]);
var inst_12800 = async(inst_12799);
var state_12809__$1 = state_12809;
if(cljs.core.truth_(inst_12800)){
var statearr_12812_14185 = state_12809__$1;
(statearr_12812_14185[(1)] = (5));

} else {
var statearr_12813_14186 = state_12809__$1;
(statearr_12813_14186[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12810 === (5))){
var state_12809__$1 = state_12809;
var statearr_12814_14187 = state_12809__$1;
(statearr_12814_14187[(2)] = null);

(statearr_12814_14187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12810 === (6))){
var state_12809__$1 = state_12809;
var statearr_12816_14188 = state_12809__$1;
(statearr_12816_14188[(2)] = null);

(statearr_12816_14188[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12810 === (7))){
var inst_12805 = (state_12809[(2)]);
var state_12809__$1 = state_12809;
var statearr_12817_14189 = state_12809__$1;
(statearr_12817_14189[(2)] = inst_12805);

(statearr_12817_14189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__14167,c__12569__auto___14183,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async))
;
return ((function (__14167,switch__12533__auto__,c__12569__auto___14183,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0 = (function (){
var statearr_12818 = [null,null,null,null,null,null,null];
(statearr_12818[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__);

(statearr_12818[(1)] = (1));

return statearr_12818;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1 = (function (state_12809){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_12809);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e12819){var ex__12537__auto__ = e12819;
var statearr_12820_14190 = state_12809;
(statearr_12820_14190[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_12809[(4)]))){
var statearr_12821_14191 = state_12809;
(statearr_12821_14191[(1)] = cljs.core.first((state_12809[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14192 = state_12809;
state_12809 = G__14192;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = function(state_12809){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1.call(this,state_12809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__;
})()
;})(__14167,switch__12533__auto__,c__12569__auto___14183,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async))
})();
var state__12571__auto__ = (function (){var statearr_12822 = f__12570__auto__();
(statearr_12822[(6)] = c__12569__auto___14183);

return statearr_12822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
});})(__14167,c__12569__auto___14183,G__12769_14168,G__12769_14169__$1,n__4695__auto___14166,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__12769_14169__$1)].join('')));

}

var G__14193 = (__14167 + (1));
__14167 = G__14193;
continue;
} else {
}
break;
}

var c__12569__auto___14194 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_12844){
var state_val_12845 = (state_12844[(1)]);
if((state_val_12845 === (7))){
var inst_12840 = (state_12844[(2)]);
var state_12844__$1 = state_12844;
var statearr_12853_14195 = state_12844__$1;
(statearr_12853_14195[(2)] = inst_12840);

(statearr_12853_14195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (1))){
var state_12844__$1 = state_12844;
var statearr_12854_14196 = state_12844__$1;
(statearr_12854_14196[(2)] = null);

(statearr_12854_14196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (4))){
var inst_12825 = (state_12844[(7)]);
var inst_12825__$1 = (state_12844[(2)]);
var inst_12826 = (inst_12825__$1 == null);
var state_12844__$1 = (function (){var statearr_12855 = state_12844;
(statearr_12855[(7)] = inst_12825__$1);

return statearr_12855;
})();
if(cljs.core.truth_(inst_12826)){
var statearr_12856_14197 = state_12844__$1;
(statearr_12856_14197[(1)] = (5));

} else {
var statearr_12857_14198 = state_12844__$1;
(statearr_12857_14198[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (6))){
var inst_12825 = (state_12844[(7)]);
var inst_12830 = (state_12844[(8)]);
var inst_12830__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_12831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12832 = [inst_12825,inst_12830__$1];
var inst_12833 = (new cljs.core.PersistentVector(null,2,(5),inst_12831,inst_12832,null));
var state_12844__$1 = (function (){var statearr_12858 = state_12844;
(statearr_12858[(8)] = inst_12830__$1);

return statearr_12858;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12844__$1,(8),jobs,inst_12833);
} else {
if((state_val_12845 === (3))){
var inst_12842 = (state_12844[(2)]);
var state_12844__$1 = state_12844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12844__$1,inst_12842);
} else {
if((state_val_12845 === (2))){
var state_12844__$1 = state_12844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12844__$1,(4),from);
} else {
if((state_val_12845 === (9))){
var inst_12837 = (state_12844[(2)]);
var state_12844__$1 = (function (){var statearr_12859 = state_12844;
(statearr_12859[(9)] = inst_12837);

return statearr_12859;
})();
var statearr_12860_14199 = state_12844__$1;
(statearr_12860_14199[(2)] = null);

(statearr_12860_14199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (5))){
var inst_12828 = cljs.core.async.close_BANG_(jobs);
var state_12844__$1 = state_12844;
var statearr_12861_14200 = state_12844__$1;
(statearr_12861_14200[(2)] = inst_12828);

(statearr_12861_14200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12845 === (8))){
var inst_12830 = (state_12844[(8)]);
var inst_12835 = (state_12844[(2)]);
var state_12844__$1 = (function (){var statearr_12862 = state_12844;
(statearr_12862[(10)] = inst_12835);

return statearr_12862;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12844__$1,(9),results,inst_12830);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0 = (function (){
var statearr_12863 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12863[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__);

(statearr_12863[(1)] = (1));

return statearr_12863;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1 = (function (state_12844){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_12844);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e12864){var ex__12537__auto__ = e12864;
var statearr_12865_14201 = state_12844;
(statearr_12865_14201[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_12844[(4)]))){
var statearr_12866_14202 = state_12844;
(statearr_12866_14202[(1)] = cljs.core.first((state_12844[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14203 = state_12844;
state_12844 = G__14203;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = function(state_12844){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1.call(this,state_12844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_12867 = f__12570__auto__();
(statearr_12867[(6)] = c__12569__auto___14194);

return statearr_12867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


var c__12569__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_12905){
var state_val_12906 = (state_12905[(1)]);
if((state_val_12906 === (7))){
var inst_12901 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12907_14204 = state_12905__$1;
(statearr_12907_14204[(2)] = inst_12901);

(statearr_12907_14204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (20))){
var state_12905__$1 = state_12905;
var statearr_12908_14205 = state_12905__$1;
(statearr_12908_14205[(2)] = null);

(statearr_12908_14205[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (1))){
var state_12905__$1 = state_12905;
var statearr_12914_14206 = state_12905__$1;
(statearr_12914_14206[(2)] = null);

(statearr_12914_14206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (4))){
var inst_12870 = (state_12905[(7)]);
var inst_12870__$1 = (state_12905[(2)]);
var inst_12871 = (inst_12870__$1 == null);
var state_12905__$1 = (function (){var statearr_12915 = state_12905;
(statearr_12915[(7)] = inst_12870__$1);

return statearr_12915;
})();
if(cljs.core.truth_(inst_12871)){
var statearr_12916_14207 = state_12905__$1;
(statearr_12916_14207[(1)] = (5));

} else {
var statearr_12917_14208 = state_12905__$1;
(statearr_12917_14208[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (15))){
var inst_12883 = (state_12905[(8)]);
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12905__$1,(18),to,inst_12883);
} else {
if((state_val_12906 === (21))){
var inst_12896 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12918_14209 = state_12905__$1;
(statearr_12918_14209[(2)] = inst_12896);

(statearr_12918_14209[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (13))){
var inst_12898 = (state_12905[(2)]);
var state_12905__$1 = (function (){var statearr_12919 = state_12905;
(statearr_12919[(9)] = inst_12898);

return statearr_12919;
})();
var statearr_12920_14210 = state_12905__$1;
(statearr_12920_14210[(2)] = null);

(statearr_12920_14210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (6))){
var inst_12870 = (state_12905[(7)]);
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12905__$1,(11),inst_12870);
} else {
if((state_val_12906 === (17))){
var inst_12891 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
if(cljs.core.truth_(inst_12891)){
var statearr_12921_14211 = state_12905__$1;
(statearr_12921_14211[(1)] = (19));

} else {
var statearr_12922_14212 = state_12905__$1;
(statearr_12922_14212[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (3))){
var inst_12903 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12905__$1,inst_12903);
} else {
if((state_val_12906 === (12))){
var inst_12880 = (state_12905[(10)]);
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12905__$1,(14),inst_12880);
} else {
if((state_val_12906 === (2))){
var state_12905__$1 = state_12905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12905__$1,(4),results);
} else {
if((state_val_12906 === (19))){
var state_12905__$1 = state_12905;
var statearr_12923_14213 = state_12905__$1;
(statearr_12923_14213[(2)] = null);

(statearr_12923_14213[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (11))){
var inst_12880 = (state_12905[(2)]);
var state_12905__$1 = (function (){var statearr_12924 = state_12905;
(statearr_12924[(10)] = inst_12880);

return statearr_12924;
})();
var statearr_12925_14214 = state_12905__$1;
(statearr_12925_14214[(2)] = null);

(statearr_12925_14214[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (9))){
var state_12905__$1 = state_12905;
var statearr_12926_14215 = state_12905__$1;
(statearr_12926_14215[(2)] = null);

(statearr_12926_14215[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (5))){
var state_12905__$1 = state_12905;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12927_14216 = state_12905__$1;
(statearr_12927_14216[(1)] = (8));

} else {
var statearr_12928_14217 = state_12905__$1;
(statearr_12928_14217[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (14))){
var inst_12883 = (state_12905[(8)]);
var inst_12885 = (state_12905[(11)]);
var inst_12883__$1 = (state_12905[(2)]);
var inst_12884 = (inst_12883__$1 == null);
var inst_12885__$1 = cljs.core.not(inst_12884);
var state_12905__$1 = (function (){var statearr_12929 = state_12905;
(statearr_12929[(8)] = inst_12883__$1);

(statearr_12929[(11)] = inst_12885__$1);

return statearr_12929;
})();
if(inst_12885__$1){
var statearr_12930_14218 = state_12905__$1;
(statearr_12930_14218[(1)] = (15));

} else {
var statearr_12931_14219 = state_12905__$1;
(statearr_12931_14219[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (16))){
var inst_12885 = (state_12905[(11)]);
var state_12905__$1 = state_12905;
var statearr_12932_14220 = state_12905__$1;
(statearr_12932_14220[(2)] = inst_12885);

(statearr_12932_14220[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (10))){
var inst_12877 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12933_14221 = state_12905__$1;
(statearr_12933_14221[(2)] = inst_12877);

(statearr_12933_14221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (18))){
var inst_12888 = (state_12905[(2)]);
var state_12905__$1 = state_12905;
var statearr_12934_14222 = state_12905__$1;
(statearr_12934_14222[(2)] = inst_12888);

(statearr_12934_14222[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12906 === (8))){
var inst_12874 = cljs.core.async.close_BANG_(to);
var state_12905__$1 = state_12905;
var statearr_12935_14223 = state_12905__$1;
(statearr_12935_14223[(2)] = inst_12874);

(statearr_12935_14223[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0 = (function (){
var statearr_12936 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12936[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__);

(statearr_12936[(1)] = (1));

return statearr_12936;
});
var cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1 = (function (state_12905){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_12905);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e12937){var ex__12537__auto__ = e12937;
var statearr_12938_14224 = state_12905;
(statearr_12938_14224[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_12905[(4)]))){
var statearr_12939_14225 = state_12905;
(statearr_12939_14225[(1)] = cljs.core.first((state_12905[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14226 = state_12905;
state_12905 = G__14226;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__ = function(state_12905){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1.call(this,state_12905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__12534__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_12940 = f__12570__auto__();
(statearr_12940[(6)] = c__12569__auto__);

return statearr_12940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));

return c__12569__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__12942 = arguments.length;
switch (G__12942) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__12944 = arguments.length;
switch (G__12944) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__12946 = arguments.length;
switch (G__12946) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__12569__auto___14233 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_12972){
var state_val_12973 = (state_12972[(1)]);
if((state_val_12973 === (7))){
var inst_12968 = (state_12972[(2)]);
var state_12972__$1 = state_12972;
var statearr_12974_14234 = state_12972__$1;
(statearr_12974_14234[(2)] = inst_12968);

(statearr_12974_14234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (1))){
var state_12972__$1 = state_12972;
var statearr_12975_14235 = state_12972__$1;
(statearr_12975_14235[(2)] = null);

(statearr_12975_14235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (4))){
var inst_12949 = (state_12972[(7)]);
var inst_12949__$1 = (state_12972[(2)]);
var inst_12950 = (inst_12949__$1 == null);
var state_12972__$1 = (function (){var statearr_12976 = state_12972;
(statearr_12976[(7)] = inst_12949__$1);

return statearr_12976;
})();
if(cljs.core.truth_(inst_12950)){
var statearr_12977_14236 = state_12972__$1;
(statearr_12977_14236[(1)] = (5));

} else {
var statearr_12978_14237 = state_12972__$1;
(statearr_12978_14237[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (13))){
var state_12972__$1 = state_12972;
var statearr_12979_14238 = state_12972__$1;
(statearr_12979_14238[(2)] = null);

(statearr_12979_14238[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (6))){
var inst_12949 = (state_12972[(7)]);
var inst_12955 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_12949) : p.call(null,inst_12949));
var state_12972__$1 = state_12972;
if(cljs.core.truth_(inst_12955)){
var statearr_12980_14240 = state_12972__$1;
(statearr_12980_14240[(1)] = (9));

} else {
var statearr_12981_14242 = state_12972__$1;
(statearr_12981_14242[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (3))){
var inst_12970 = (state_12972[(2)]);
var state_12972__$1 = state_12972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_12972__$1,inst_12970);
} else {
if((state_val_12973 === (12))){
var state_12972__$1 = state_12972;
var statearr_12982_14243 = state_12972__$1;
(statearr_12982_14243[(2)] = null);

(statearr_12982_14243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (2))){
var state_12972__$1 = state_12972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_12972__$1,(4),ch);
} else {
if((state_val_12973 === (11))){
var inst_12949 = (state_12972[(7)]);
var inst_12959 = (state_12972[(2)]);
var state_12972__$1 = state_12972;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_12972__$1,(8),inst_12959,inst_12949);
} else {
if((state_val_12973 === (9))){
var state_12972__$1 = state_12972;
var statearr_12983_14244 = state_12972__$1;
(statearr_12983_14244[(2)] = tc);

(statearr_12983_14244[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (5))){
var inst_12952 = cljs.core.async.close_BANG_(tc);
var inst_12953 = cljs.core.async.close_BANG_(fc);
var state_12972__$1 = (function (){var statearr_12984 = state_12972;
(statearr_12984[(8)] = inst_12952);

return statearr_12984;
})();
var statearr_12985_14245 = state_12972__$1;
(statearr_12985_14245[(2)] = inst_12953);

(statearr_12985_14245[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (14))){
var inst_12966 = (state_12972[(2)]);
var state_12972__$1 = state_12972;
var statearr_12986_14246 = state_12972__$1;
(statearr_12986_14246[(2)] = inst_12966);

(statearr_12986_14246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (10))){
var state_12972__$1 = state_12972;
var statearr_12987_14247 = state_12972__$1;
(statearr_12987_14247[(2)] = fc);

(statearr_12987_14247[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12973 === (8))){
var inst_12961 = (state_12972[(2)]);
var state_12972__$1 = state_12972;
if(cljs.core.truth_(inst_12961)){
var statearr_12988_14249 = state_12972__$1;
(statearr_12988_14249[(1)] = (12));

} else {
var statearr_12989_14250 = state_12972__$1;
(statearr_12989_14250[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_12990 = [null,null,null,null,null,null,null,null,null];
(statearr_12990[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_12990[(1)] = (1));

return statearr_12990;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_12972){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_12972);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e12991){var ex__12537__auto__ = e12991;
var statearr_12992_14252 = state_12972;
(statearr_12992_14252[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_12972[(4)]))){
var statearr_12993_14253 = state_12972;
(statearr_12993_14253[(1)] = cljs.core.first((state_12972[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14254 = state_12972;
state_12972 = G__14254;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_12972){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_12972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_12994 = f__12570__auto__();
(statearr_12994[(6)] = c__12569__auto___14233);

return statearr_12994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__12569__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13016){
var state_val_13017 = (state_13016[(1)]);
if((state_val_13017 === (7))){
var inst_13012 = (state_13016[(2)]);
var state_13016__$1 = state_13016;
var statearr_13018_14255 = state_13016__$1;
(statearr_13018_14255[(2)] = inst_13012);

(statearr_13018_14255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13017 === (1))){
var inst_12995 = init;
var inst_12996 = inst_12995;
var state_13016__$1 = (function (){var statearr_13019 = state_13016;
(statearr_13019[(7)] = inst_12996);

return statearr_13019;
})();
var statearr_13020_14256 = state_13016__$1;
(statearr_13020_14256[(2)] = null);

(statearr_13020_14256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13017 === (4))){
var inst_12999 = (state_13016[(8)]);
var inst_12999__$1 = (state_13016[(2)]);
var inst_13000 = (inst_12999__$1 == null);
var state_13016__$1 = (function (){var statearr_13021 = state_13016;
(statearr_13021[(8)] = inst_12999__$1);

return statearr_13021;
})();
if(cljs.core.truth_(inst_13000)){
var statearr_13022_14258 = state_13016__$1;
(statearr_13022_14258[(1)] = (5));

} else {
var statearr_13023_14259 = state_13016__$1;
(statearr_13023_14259[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13017 === (6))){
var inst_13003 = (state_13016[(9)]);
var inst_12999 = (state_13016[(8)]);
var inst_12996 = (state_13016[(7)]);
var inst_13003__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_12996,inst_12999) : f.call(null,inst_12996,inst_12999));
var inst_13004 = cljs.core.reduced_QMARK_(inst_13003__$1);
var state_13016__$1 = (function (){var statearr_13024 = state_13016;
(statearr_13024[(9)] = inst_13003__$1);

return statearr_13024;
})();
if(inst_13004){
var statearr_13025_14261 = state_13016__$1;
(statearr_13025_14261[(1)] = (8));

} else {
var statearr_13026_14262 = state_13016__$1;
(statearr_13026_14262[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13017 === (3))){
var inst_13014 = (state_13016[(2)]);
var state_13016__$1 = state_13016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13016__$1,inst_13014);
} else {
if((state_val_13017 === (2))){
var state_13016__$1 = state_13016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13016__$1,(4),ch);
} else {
if((state_val_13017 === (9))){
var inst_13003 = (state_13016[(9)]);
var inst_12996 = inst_13003;
var state_13016__$1 = (function (){var statearr_13027 = state_13016;
(statearr_13027[(7)] = inst_12996);

return statearr_13027;
})();
var statearr_13028_14263 = state_13016__$1;
(statearr_13028_14263[(2)] = null);

(statearr_13028_14263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13017 === (5))){
var inst_12996 = (state_13016[(7)]);
var state_13016__$1 = state_13016;
var statearr_13029_14264 = state_13016__$1;
(statearr_13029_14264[(2)] = inst_12996);

(statearr_13029_14264[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13017 === (10))){
var inst_13010 = (state_13016[(2)]);
var state_13016__$1 = state_13016;
var statearr_13030_14265 = state_13016__$1;
(statearr_13030_14265[(2)] = inst_13010);

(statearr_13030_14265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13017 === (8))){
var inst_13003 = (state_13016[(9)]);
var inst_13006 = cljs.core.deref(inst_13003);
var state_13016__$1 = state_13016;
var statearr_13031_14266 = state_13016__$1;
(statearr_13031_14266[(2)] = inst_13006);

(statearr_13031_14266[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__12534__auto__ = null;
var cljs$core$async$reduce_$_state_machine__12534__auto____0 = (function (){
var statearr_13032 = [null,null,null,null,null,null,null,null,null,null];
(statearr_13032[(0)] = cljs$core$async$reduce_$_state_machine__12534__auto__);

(statearr_13032[(1)] = (1));

return statearr_13032;
});
var cljs$core$async$reduce_$_state_machine__12534__auto____1 = (function (state_13016){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13016);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13033){var ex__12537__auto__ = e13033;
var statearr_13034_14267 = state_13016;
(statearr_13034_14267[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13016[(4)]))){
var statearr_13035_14268 = state_13016;
(statearr_13035_14268[(1)] = cljs.core.first((state_13016[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14269 = state_13016;
state_13016 = G__14269;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__12534__auto__ = function(state_13016){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__12534__auto____1.call(this,state_13016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__12534__auto____0;
cljs$core$async$reduce_$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__12534__auto____1;
return cljs$core$async$reduce_$_state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13036 = f__12570__auto__();
(statearr_13036[(6)] = c__12569__auto__);

return statearr_13036;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));

return c__12569__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__12569__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13042){
var state_val_13043 = (state_13042[(1)]);
if((state_val_13043 === (1))){
var inst_13037 = cljs.core.async.reduce(f__$1,init,ch);
var state_13042__$1 = state_13042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13042__$1,(2),inst_13037);
} else {
if((state_val_13043 === (2))){
var inst_13039 = (state_13042[(2)]);
var inst_13040 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_13039) : f__$1.call(null,inst_13039));
var state_13042__$1 = state_13042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13042__$1,inst_13040);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__12534__auto__ = null;
var cljs$core$async$transduce_$_state_machine__12534__auto____0 = (function (){
var statearr_13044 = [null,null,null,null,null,null,null];
(statearr_13044[(0)] = cljs$core$async$transduce_$_state_machine__12534__auto__);

(statearr_13044[(1)] = (1));

return statearr_13044;
});
var cljs$core$async$transduce_$_state_machine__12534__auto____1 = (function (state_13042){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13042);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13045){var ex__12537__auto__ = e13045;
var statearr_13046_14272 = state_13042;
(statearr_13046_14272[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13042[(4)]))){
var statearr_13047_14273 = state_13042;
(statearr_13047_14273[(1)] = cljs.core.first((state_13042[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14274 = state_13042;
state_13042 = G__14274;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__12534__auto__ = function(state_13042){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__12534__auto____1.call(this,state_13042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__12534__auto____0;
cljs$core$async$transduce_$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__12534__auto____1;
return cljs$core$async$transduce_$_state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13048 = f__12570__auto__();
(statearr_13048[(6)] = c__12569__auto__);

return statearr_13048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));

return c__12569__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__13050 = arguments.length;
switch (G__13050) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__12569__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13075){
var state_val_13076 = (state_13075[(1)]);
if((state_val_13076 === (7))){
var inst_13057 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13077_14276 = state_13075__$1;
(statearr_13077_14276[(2)] = inst_13057);

(statearr_13077_14276[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (1))){
var inst_13051 = cljs.core.seq(coll);
var inst_13052 = inst_13051;
var state_13075__$1 = (function (){var statearr_13078 = state_13075;
(statearr_13078[(7)] = inst_13052);

return statearr_13078;
})();
var statearr_13079_14277 = state_13075__$1;
(statearr_13079_14277[(2)] = null);

(statearr_13079_14277[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (4))){
var inst_13052 = (state_13075[(7)]);
var inst_13055 = cljs.core.first(inst_13052);
var state_13075__$1 = state_13075;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13075__$1,(7),ch,inst_13055);
} else {
if((state_val_13076 === (13))){
var inst_13069 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13080_14278 = state_13075__$1;
(statearr_13080_14278[(2)] = inst_13069);

(statearr_13080_14278[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (6))){
var inst_13060 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
if(cljs.core.truth_(inst_13060)){
var statearr_13081_14279 = state_13075__$1;
(statearr_13081_14279[(1)] = (8));

} else {
var statearr_13082_14281 = state_13075__$1;
(statearr_13082_14281[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (3))){
var inst_13073 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13075__$1,inst_13073);
} else {
if((state_val_13076 === (12))){
var state_13075__$1 = state_13075;
var statearr_13083_14283 = state_13075__$1;
(statearr_13083_14283[(2)] = null);

(statearr_13083_14283[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (2))){
var inst_13052 = (state_13075[(7)]);
var state_13075__$1 = state_13075;
if(cljs.core.truth_(inst_13052)){
var statearr_13084_14284 = state_13075__$1;
(statearr_13084_14284[(1)] = (4));

} else {
var statearr_13085_14285 = state_13075__$1;
(statearr_13085_14285[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (11))){
var inst_13066 = cljs.core.async.close_BANG_(ch);
var state_13075__$1 = state_13075;
var statearr_13086_14286 = state_13075__$1;
(statearr_13086_14286[(2)] = inst_13066);

(statearr_13086_14286[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (9))){
var state_13075__$1 = state_13075;
if(cljs.core.truth_(close_QMARK_)){
var statearr_13087_14287 = state_13075__$1;
(statearr_13087_14287[(1)] = (11));

} else {
var statearr_13088_14288 = state_13075__$1;
(statearr_13088_14288[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (5))){
var inst_13052 = (state_13075[(7)]);
var state_13075__$1 = state_13075;
var statearr_13089_14289 = state_13075__$1;
(statearr_13089_14289[(2)] = inst_13052);

(statearr_13089_14289[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (10))){
var inst_13071 = (state_13075[(2)]);
var state_13075__$1 = state_13075;
var statearr_13090_14290 = state_13075__$1;
(statearr_13090_14290[(2)] = inst_13071);

(statearr_13090_14290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13076 === (8))){
var inst_13052 = (state_13075[(7)]);
var inst_13062 = cljs.core.next(inst_13052);
var inst_13052__$1 = inst_13062;
var state_13075__$1 = (function (){var statearr_13091 = state_13075;
(statearr_13091[(7)] = inst_13052__$1);

return statearr_13091;
})();
var statearr_13092_14291 = state_13075__$1;
(statearr_13092_14291[(2)] = null);

(statearr_13092_14291[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_13093 = [null,null,null,null,null,null,null,null];
(statearr_13093[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_13093[(1)] = (1));

return statearr_13093;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_13075){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13075);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13094){var ex__12537__auto__ = e13094;
var statearr_13095_14292 = state_13075;
(statearr_13095_14292[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13075[(4)]))){
var statearr_13096_14293 = state_13075;
(statearr_13096_14293[(1)] = cljs.core.first((state_13075[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14294 = state_13075;
state_13075 = G__14294;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_13075){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_13075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13097 = f__12570__auto__();
(statearr_13097[(6)] = c__12569__auto__);

return statearr_13097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));

return c__12569__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__13099 = arguments.length;
switch (G__13099) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_14297 = (function (_){
var x__4509__auto__ = (((_ == null))?null:_);
var m__4510__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4510__auto__.call(null,_));
} else {
var m__4508__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4508__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_14297(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_14298 = (function (m,ch,close_QMARK_){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4510__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4508__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_14298(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_14299 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_14299(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_14304 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_14304(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13100 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13100 = (function (ch,cs,meta13101){
this.ch = ch;
this.cs = cs;
this.meta13101 = meta13101;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13100.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13102,meta13101__$1){
var self__ = this;
var _13102__$1 = this;
return (new cljs.core.async.t_cljs$core$async13100(self__.ch,self__.cs,meta13101__$1));
}));

(cljs.core.async.t_cljs$core$async13100.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13102){
var self__ = this;
var _13102__$1 = this;
return self__.meta13101;
}));

(cljs.core.async.t_cljs$core$async13100.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13100.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13100.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13100.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async13100.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async13100.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async13100.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta13101","meta13101",1118338283,null)], null);
}));

(cljs.core.async.t_cljs$core$async13100.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13100.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13100");

(cljs.core.async.t_cljs$core$async13100.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13100");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13100.
 */
cljs.core.async.__GT_t_cljs$core$async13100 = (function cljs$core$async$mult_$___GT_t_cljs$core$async13100(ch__$1,cs__$1,meta13101){
return (new cljs.core.async.t_cljs$core$async13100(ch__$1,cs__$1,meta13101));
});

}

return (new cljs.core.async.t_cljs$core$async13100(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__12569__auto___14305 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13235){
var state_val_13236 = (state_13235[(1)]);
if((state_val_13236 === (7))){
var inst_13231 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
var statearr_13237_14306 = state_13235__$1;
(statearr_13237_14306[(2)] = inst_13231);

(statearr_13237_14306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (20))){
var inst_13136 = (state_13235[(7)]);
var inst_13148 = cljs.core.first(inst_13136);
var inst_13149 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13148,(0),null);
var inst_13150 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13148,(1),null);
var state_13235__$1 = (function (){var statearr_13238 = state_13235;
(statearr_13238[(8)] = inst_13149);

return statearr_13238;
})();
if(cljs.core.truth_(inst_13150)){
var statearr_13239_14307 = state_13235__$1;
(statearr_13239_14307[(1)] = (22));

} else {
var statearr_13240_14308 = state_13235__$1;
(statearr_13240_14308[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (27))){
var inst_13185 = (state_13235[(9)]);
var inst_13180 = (state_13235[(10)]);
var inst_13105 = (state_13235[(11)]);
var inst_13178 = (state_13235[(12)]);
var inst_13185__$1 = cljs.core._nth(inst_13178,inst_13180);
var inst_13186 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13185__$1,inst_13105,done);
var state_13235__$1 = (function (){var statearr_13241 = state_13235;
(statearr_13241[(9)] = inst_13185__$1);

return statearr_13241;
})();
if(cljs.core.truth_(inst_13186)){
var statearr_13242_14309 = state_13235__$1;
(statearr_13242_14309[(1)] = (30));

} else {
var statearr_13243_14311 = state_13235__$1;
(statearr_13243_14311[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (1))){
var state_13235__$1 = state_13235;
var statearr_13244_14312 = state_13235__$1;
(statearr_13244_14312[(2)] = null);

(statearr_13244_14312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (24))){
var inst_13136 = (state_13235[(7)]);
var inst_13155 = (state_13235[(2)]);
var inst_13156 = cljs.core.next(inst_13136);
var inst_13114 = inst_13156;
var inst_13115 = null;
var inst_13116 = (0);
var inst_13117 = (0);
var state_13235__$1 = (function (){var statearr_13245 = state_13235;
(statearr_13245[(13)] = inst_13115);

(statearr_13245[(14)] = inst_13117);

(statearr_13245[(15)] = inst_13116);

(statearr_13245[(16)] = inst_13155);

(statearr_13245[(17)] = inst_13114);

return statearr_13245;
})();
var statearr_13246_14314 = state_13235__$1;
(statearr_13246_14314[(2)] = null);

(statearr_13246_14314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (39))){
var state_13235__$1 = state_13235;
var statearr_13250_14315 = state_13235__$1;
(statearr_13250_14315[(2)] = null);

(statearr_13250_14315[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (4))){
var inst_13105 = (state_13235[(11)]);
var inst_13105__$1 = (state_13235[(2)]);
var inst_13106 = (inst_13105__$1 == null);
var state_13235__$1 = (function (){var statearr_13251 = state_13235;
(statearr_13251[(11)] = inst_13105__$1);

return statearr_13251;
})();
if(cljs.core.truth_(inst_13106)){
var statearr_13252_14316 = state_13235__$1;
(statearr_13252_14316[(1)] = (5));

} else {
var statearr_13253_14317 = state_13235__$1;
(statearr_13253_14317[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (15))){
var inst_13115 = (state_13235[(13)]);
var inst_13117 = (state_13235[(14)]);
var inst_13116 = (state_13235[(15)]);
var inst_13114 = (state_13235[(17)]);
var inst_13132 = (state_13235[(2)]);
var inst_13133 = (inst_13117 + (1));
var tmp13247 = inst_13115;
var tmp13248 = inst_13116;
var tmp13249 = inst_13114;
var inst_13114__$1 = tmp13249;
var inst_13115__$1 = tmp13247;
var inst_13116__$1 = tmp13248;
var inst_13117__$1 = inst_13133;
var state_13235__$1 = (function (){var statearr_13254 = state_13235;
(statearr_13254[(13)] = inst_13115__$1);

(statearr_13254[(14)] = inst_13117__$1);

(statearr_13254[(15)] = inst_13116__$1);

(statearr_13254[(18)] = inst_13132);

(statearr_13254[(17)] = inst_13114__$1);

return statearr_13254;
})();
var statearr_13255_14318 = state_13235__$1;
(statearr_13255_14318[(2)] = null);

(statearr_13255_14318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (21))){
var inst_13159 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
var statearr_13259_14319 = state_13235__$1;
(statearr_13259_14319[(2)] = inst_13159);

(statearr_13259_14319[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (31))){
var inst_13185 = (state_13235[(9)]);
var inst_13189 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13185);
var state_13235__$1 = state_13235;
var statearr_13260_14320 = state_13235__$1;
(statearr_13260_14320[(2)] = inst_13189);

(statearr_13260_14320[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (32))){
var inst_13179 = (state_13235[(19)]);
var inst_13180 = (state_13235[(10)]);
var inst_13178 = (state_13235[(12)]);
var inst_13177 = (state_13235[(20)]);
var inst_13191 = (state_13235[(2)]);
var inst_13192 = (inst_13180 + (1));
var tmp13256 = inst_13179;
var tmp13257 = inst_13178;
var tmp13258 = inst_13177;
var inst_13177__$1 = tmp13258;
var inst_13178__$1 = tmp13257;
var inst_13179__$1 = tmp13256;
var inst_13180__$1 = inst_13192;
var state_13235__$1 = (function (){var statearr_13261 = state_13235;
(statearr_13261[(21)] = inst_13191);

(statearr_13261[(19)] = inst_13179__$1);

(statearr_13261[(10)] = inst_13180__$1);

(statearr_13261[(12)] = inst_13178__$1);

(statearr_13261[(20)] = inst_13177__$1);

return statearr_13261;
})();
var statearr_13262_14321 = state_13235__$1;
(statearr_13262_14321[(2)] = null);

(statearr_13262_14321[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (40))){
var inst_13204 = (state_13235[(22)]);
var inst_13208 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_13204);
var state_13235__$1 = state_13235;
var statearr_13263_14322 = state_13235__$1;
(statearr_13263_14322[(2)] = inst_13208);

(statearr_13263_14322[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (33))){
var inst_13195 = (state_13235[(23)]);
var inst_13197 = cljs.core.chunked_seq_QMARK_(inst_13195);
var state_13235__$1 = state_13235;
if(inst_13197){
var statearr_13264_14327 = state_13235__$1;
(statearr_13264_14327[(1)] = (36));

} else {
var statearr_13265_14328 = state_13235__$1;
(statearr_13265_14328[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (13))){
var inst_13126 = (state_13235[(24)]);
var inst_13129 = cljs.core.async.close_BANG_(inst_13126);
var state_13235__$1 = state_13235;
var statearr_13266_14329 = state_13235__$1;
(statearr_13266_14329[(2)] = inst_13129);

(statearr_13266_14329[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (22))){
var inst_13149 = (state_13235[(8)]);
var inst_13152 = cljs.core.async.close_BANG_(inst_13149);
var state_13235__$1 = state_13235;
var statearr_13267_14333 = state_13235__$1;
(statearr_13267_14333[(2)] = inst_13152);

(statearr_13267_14333[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (36))){
var inst_13195 = (state_13235[(23)]);
var inst_13199 = cljs.core.chunk_first(inst_13195);
var inst_13200 = cljs.core.chunk_rest(inst_13195);
var inst_13201 = cljs.core.count(inst_13199);
var inst_13177 = inst_13200;
var inst_13178 = inst_13199;
var inst_13179 = inst_13201;
var inst_13180 = (0);
var state_13235__$1 = (function (){var statearr_13268 = state_13235;
(statearr_13268[(19)] = inst_13179);

(statearr_13268[(10)] = inst_13180);

(statearr_13268[(12)] = inst_13178);

(statearr_13268[(20)] = inst_13177);

return statearr_13268;
})();
var statearr_13269_14334 = state_13235__$1;
(statearr_13269_14334[(2)] = null);

(statearr_13269_14334[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (41))){
var inst_13195 = (state_13235[(23)]);
var inst_13210 = (state_13235[(2)]);
var inst_13211 = cljs.core.next(inst_13195);
var inst_13177 = inst_13211;
var inst_13178 = null;
var inst_13179 = (0);
var inst_13180 = (0);
var state_13235__$1 = (function (){var statearr_13270 = state_13235;
(statearr_13270[(19)] = inst_13179);

(statearr_13270[(10)] = inst_13180);

(statearr_13270[(25)] = inst_13210);

(statearr_13270[(12)] = inst_13178);

(statearr_13270[(20)] = inst_13177);

return statearr_13270;
})();
var statearr_13271_14338 = state_13235__$1;
(statearr_13271_14338[(2)] = null);

(statearr_13271_14338[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (43))){
var state_13235__$1 = state_13235;
var statearr_13272_14339 = state_13235__$1;
(statearr_13272_14339[(2)] = null);

(statearr_13272_14339[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (29))){
var inst_13219 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
var statearr_13273_14340 = state_13235__$1;
(statearr_13273_14340[(2)] = inst_13219);

(statearr_13273_14340[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (44))){
var inst_13228 = (state_13235[(2)]);
var state_13235__$1 = (function (){var statearr_13274 = state_13235;
(statearr_13274[(26)] = inst_13228);

return statearr_13274;
})();
var statearr_13275_14341 = state_13235__$1;
(statearr_13275_14341[(2)] = null);

(statearr_13275_14341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (6))){
var inst_13169 = (state_13235[(27)]);
var inst_13168 = cljs.core.deref(cs);
var inst_13169__$1 = cljs.core.keys(inst_13168);
var inst_13170 = cljs.core.count(inst_13169__$1);
var inst_13171 = cljs.core.reset_BANG_(dctr,inst_13170);
var inst_13176 = cljs.core.seq(inst_13169__$1);
var inst_13177 = inst_13176;
var inst_13178 = null;
var inst_13179 = (0);
var inst_13180 = (0);
var state_13235__$1 = (function (){var statearr_13276 = state_13235;
(statearr_13276[(19)] = inst_13179);

(statearr_13276[(10)] = inst_13180);

(statearr_13276[(27)] = inst_13169__$1);

(statearr_13276[(12)] = inst_13178);

(statearr_13276[(20)] = inst_13177);

(statearr_13276[(28)] = inst_13171);

return statearr_13276;
})();
var statearr_13277_14342 = state_13235__$1;
(statearr_13277_14342[(2)] = null);

(statearr_13277_14342[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (28))){
var inst_13195 = (state_13235[(23)]);
var inst_13177 = (state_13235[(20)]);
var inst_13195__$1 = cljs.core.seq(inst_13177);
var state_13235__$1 = (function (){var statearr_13278 = state_13235;
(statearr_13278[(23)] = inst_13195__$1);

return statearr_13278;
})();
if(inst_13195__$1){
var statearr_13279_14343 = state_13235__$1;
(statearr_13279_14343[(1)] = (33));

} else {
var statearr_13280_14344 = state_13235__$1;
(statearr_13280_14344[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (25))){
var inst_13179 = (state_13235[(19)]);
var inst_13180 = (state_13235[(10)]);
var inst_13182 = (inst_13180 < inst_13179);
var inst_13183 = inst_13182;
var state_13235__$1 = state_13235;
if(cljs.core.truth_(inst_13183)){
var statearr_13281_14368 = state_13235__$1;
(statearr_13281_14368[(1)] = (27));

} else {
var statearr_13282_14369 = state_13235__$1;
(statearr_13282_14369[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (34))){
var state_13235__$1 = state_13235;
var statearr_13283_14370 = state_13235__$1;
(statearr_13283_14370[(2)] = null);

(statearr_13283_14370[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (17))){
var state_13235__$1 = state_13235;
var statearr_13284_14371 = state_13235__$1;
(statearr_13284_14371[(2)] = null);

(statearr_13284_14371[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (3))){
var inst_13233 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13235__$1,inst_13233);
} else {
if((state_val_13236 === (12))){
var inst_13164 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
var statearr_13285_14372 = state_13235__$1;
(statearr_13285_14372[(2)] = inst_13164);

(statearr_13285_14372[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (2))){
var state_13235__$1 = state_13235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13235__$1,(4),ch);
} else {
if((state_val_13236 === (23))){
var state_13235__$1 = state_13235;
var statearr_13286_14373 = state_13235__$1;
(statearr_13286_14373[(2)] = null);

(statearr_13286_14373[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (35))){
var inst_13217 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
var statearr_13287_14374 = state_13235__$1;
(statearr_13287_14374[(2)] = inst_13217);

(statearr_13287_14374[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (19))){
var inst_13136 = (state_13235[(7)]);
var inst_13140 = cljs.core.chunk_first(inst_13136);
var inst_13141 = cljs.core.chunk_rest(inst_13136);
var inst_13142 = cljs.core.count(inst_13140);
var inst_13114 = inst_13141;
var inst_13115 = inst_13140;
var inst_13116 = inst_13142;
var inst_13117 = (0);
var state_13235__$1 = (function (){var statearr_13288 = state_13235;
(statearr_13288[(13)] = inst_13115);

(statearr_13288[(14)] = inst_13117);

(statearr_13288[(15)] = inst_13116);

(statearr_13288[(17)] = inst_13114);

return statearr_13288;
})();
var statearr_13289_14375 = state_13235__$1;
(statearr_13289_14375[(2)] = null);

(statearr_13289_14375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (11))){
var inst_13136 = (state_13235[(7)]);
var inst_13114 = (state_13235[(17)]);
var inst_13136__$1 = cljs.core.seq(inst_13114);
var state_13235__$1 = (function (){var statearr_13290 = state_13235;
(statearr_13290[(7)] = inst_13136__$1);

return statearr_13290;
})();
if(inst_13136__$1){
var statearr_13291_14376 = state_13235__$1;
(statearr_13291_14376[(1)] = (16));

} else {
var statearr_13292_14377 = state_13235__$1;
(statearr_13292_14377[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (9))){
var inst_13166 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
var statearr_13293_14378 = state_13235__$1;
(statearr_13293_14378[(2)] = inst_13166);

(statearr_13293_14378[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (5))){
var inst_13112 = cljs.core.deref(cs);
var inst_13113 = cljs.core.seq(inst_13112);
var inst_13114 = inst_13113;
var inst_13115 = null;
var inst_13116 = (0);
var inst_13117 = (0);
var state_13235__$1 = (function (){var statearr_13294 = state_13235;
(statearr_13294[(13)] = inst_13115);

(statearr_13294[(14)] = inst_13117);

(statearr_13294[(15)] = inst_13116);

(statearr_13294[(17)] = inst_13114);

return statearr_13294;
})();
var statearr_13295_14379 = state_13235__$1;
(statearr_13295_14379[(2)] = null);

(statearr_13295_14379[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (14))){
var state_13235__$1 = state_13235;
var statearr_13296_14380 = state_13235__$1;
(statearr_13296_14380[(2)] = null);

(statearr_13296_14380[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (45))){
var inst_13225 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
var statearr_13297_14381 = state_13235__$1;
(statearr_13297_14381[(2)] = inst_13225);

(statearr_13297_14381[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (26))){
var inst_13169 = (state_13235[(27)]);
var inst_13221 = (state_13235[(2)]);
var inst_13222 = cljs.core.seq(inst_13169);
var state_13235__$1 = (function (){var statearr_13298 = state_13235;
(statearr_13298[(29)] = inst_13221);

return statearr_13298;
})();
if(inst_13222){
var statearr_13299_14382 = state_13235__$1;
(statearr_13299_14382[(1)] = (42));

} else {
var statearr_13300_14383 = state_13235__$1;
(statearr_13300_14383[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (16))){
var inst_13136 = (state_13235[(7)]);
var inst_13138 = cljs.core.chunked_seq_QMARK_(inst_13136);
var state_13235__$1 = state_13235;
if(inst_13138){
var statearr_13301_14384 = state_13235__$1;
(statearr_13301_14384[(1)] = (19));

} else {
var statearr_13302_14385 = state_13235__$1;
(statearr_13302_14385[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (38))){
var inst_13214 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
var statearr_13303_14386 = state_13235__$1;
(statearr_13303_14386[(2)] = inst_13214);

(statearr_13303_14386[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (30))){
var state_13235__$1 = state_13235;
var statearr_13304_14387 = state_13235__$1;
(statearr_13304_14387[(2)] = null);

(statearr_13304_14387[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (10))){
var inst_13115 = (state_13235[(13)]);
var inst_13117 = (state_13235[(14)]);
var inst_13125 = cljs.core._nth(inst_13115,inst_13117);
var inst_13126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13125,(0),null);
var inst_13127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13125,(1),null);
var state_13235__$1 = (function (){var statearr_13305 = state_13235;
(statearr_13305[(24)] = inst_13126);

return statearr_13305;
})();
if(cljs.core.truth_(inst_13127)){
var statearr_13306_14388 = state_13235__$1;
(statearr_13306_14388[(1)] = (13));

} else {
var statearr_13307_14389 = state_13235__$1;
(statearr_13307_14389[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (18))){
var inst_13162 = (state_13235[(2)]);
var state_13235__$1 = state_13235;
var statearr_13308_14390 = state_13235__$1;
(statearr_13308_14390[(2)] = inst_13162);

(statearr_13308_14390[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (42))){
var state_13235__$1 = state_13235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13235__$1,(45),dchan);
} else {
if((state_val_13236 === (37))){
var inst_13204 = (state_13235[(22)]);
var inst_13195 = (state_13235[(23)]);
var inst_13105 = (state_13235[(11)]);
var inst_13204__$1 = cljs.core.first(inst_13195);
var inst_13205 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_13204__$1,inst_13105,done);
var state_13235__$1 = (function (){var statearr_13309 = state_13235;
(statearr_13309[(22)] = inst_13204__$1);

return statearr_13309;
})();
if(cljs.core.truth_(inst_13205)){
var statearr_13310_14391 = state_13235__$1;
(statearr_13310_14391[(1)] = (39));

} else {
var statearr_13311_14392 = state_13235__$1;
(statearr_13311_14392[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13236 === (8))){
var inst_13117 = (state_13235[(14)]);
var inst_13116 = (state_13235[(15)]);
var inst_13119 = (inst_13117 < inst_13116);
var inst_13120 = inst_13119;
var state_13235__$1 = state_13235;
if(cljs.core.truth_(inst_13120)){
var statearr_13312_14393 = state_13235__$1;
(statearr_13312_14393[(1)] = (10));

} else {
var statearr_13313_14394 = state_13235__$1;
(statearr_13313_14394[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__12534__auto__ = null;
var cljs$core$async$mult_$_state_machine__12534__auto____0 = (function (){
var statearr_13314 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13314[(0)] = cljs$core$async$mult_$_state_machine__12534__auto__);

(statearr_13314[(1)] = (1));

return statearr_13314;
});
var cljs$core$async$mult_$_state_machine__12534__auto____1 = (function (state_13235){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13235);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13315){var ex__12537__auto__ = e13315;
var statearr_13316_14397 = state_13235;
(statearr_13316_14397[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13235[(4)]))){
var statearr_13317_14403 = state_13235;
(statearr_13317_14403[(1)] = cljs.core.first((state_13235[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14405 = state_13235;
state_13235 = G__14405;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__12534__auto__ = function(state_13235){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__12534__auto____1.call(this,state_13235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__12534__auto____0;
cljs$core$async$mult_$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__12534__auto____1;
return cljs$core$async$mult_$_state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13318 = f__12570__auto__();
(statearr_13318[(6)] = c__12569__auto___14305);

return statearr_13318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__13320 = arguments.length;
switch (G__13320) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_14407 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_14407(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_14408 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_14408(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_14410 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_14410(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_14414 = (function (m,state_map){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4510__auto__.call(null,m,state_map));
} else {
var m__4508__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4508__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_14414(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_14419 = (function (m,mode){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4510__auto__.call(null,m,mode));
} else {
var m__4508__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4508__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_14419(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___14422 = arguments.length;
var i__4819__auto___14424 = (0);
while(true){
if((i__4819__auto___14424 < len__4818__auto___14422)){
args__4824__auto__.push((arguments[i__4819__auto___14424]));

var G__14425 = (i__4819__auto___14424 + (1));
i__4819__auto___14424 = G__14425;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((3) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4825__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13325){
var map__13326 = p__13325;
var map__13326__$1 = cljs.core.__destructure_map(map__13326);
var opts = map__13326__$1;
var statearr_13327_14430 = state;
(statearr_13327_14430[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_13328_14431 = state;
(statearr_13328_14431[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_13329_14438 = state;
(statearr_13329_14438[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13321){
var G__13322 = cljs.core.first(seq13321);
var seq13321__$1 = cljs.core.next(seq13321);
var G__13323 = cljs.core.first(seq13321__$1);
var seq13321__$2 = cljs.core.next(seq13321__$1);
var G__13324 = cljs.core.first(seq13321__$2);
var seq13321__$3 = cljs.core.next(seq13321__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13322,G__13323,G__13324,seq13321__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13330 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13330 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta13331){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta13331 = meta13331;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13332,meta13331__$1){
var self__ = this;
var _13332__$1 = this;
return (new cljs.core.async.t_cljs$core$async13330(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta13331__$1));
}));

(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13332){
var self__ = this;
var _13332__$1 = this;
return self__.meta13331;
}));

(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13330.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async13330.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta13331","meta13331",1277565643,null)], null);
}));

(cljs.core.async.t_cljs$core$async13330.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13330.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13330");

(cljs.core.async.t_cljs$core$async13330.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13330");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13330.
 */
cljs.core.async.__GT_t_cljs$core$async13330 = (function cljs$core$async$mix_$___GT_t_cljs$core$async13330(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13331){
return (new cljs.core.async.t_cljs$core$async13330(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta13331));
});

}

return (new cljs.core.async.t_cljs$core$async13330(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12569__auto___14445 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13400){
var state_val_13401 = (state_13400[(1)]);
if((state_val_13401 === (7))){
var inst_13360 = (state_13400[(2)]);
var state_13400__$1 = state_13400;
if(cljs.core.truth_(inst_13360)){
var statearr_13402_14446 = state_13400__$1;
(statearr_13402_14446[(1)] = (8));

} else {
var statearr_13403_14447 = state_13400__$1;
(statearr_13403_14447[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (20))){
var inst_13353 = (state_13400[(7)]);
var state_13400__$1 = state_13400;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13400__$1,(23),out,inst_13353);
} else {
if((state_val_13401 === (1))){
var inst_13336 = calc_state();
var inst_13337 = cljs.core.__destructure_map(inst_13336);
var inst_13338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13337,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13337,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13337,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13341 = inst_13336;
var state_13400__$1 = (function (){var statearr_13404 = state_13400;
(statearr_13404[(8)] = inst_13340);

(statearr_13404[(9)] = inst_13338);

(statearr_13404[(10)] = inst_13341);

(statearr_13404[(11)] = inst_13339);

return statearr_13404;
})();
var statearr_13405_14448 = state_13400__$1;
(statearr_13405_14448[(2)] = null);

(statearr_13405_14448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (24))){
var inst_13344 = (state_13400[(12)]);
var inst_13341 = inst_13344;
var state_13400__$1 = (function (){var statearr_13406 = state_13400;
(statearr_13406[(10)] = inst_13341);

return statearr_13406;
})();
var statearr_13407_14449 = state_13400__$1;
(statearr_13407_14449[(2)] = null);

(statearr_13407_14449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (4))){
var inst_13353 = (state_13400[(7)]);
var inst_13355 = (state_13400[(13)]);
var inst_13352 = (state_13400[(2)]);
var inst_13353__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13352,(0),null);
var inst_13354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13352,(1),null);
var inst_13355__$1 = (inst_13353__$1 == null);
var state_13400__$1 = (function (){var statearr_13408 = state_13400;
(statearr_13408[(14)] = inst_13354);

(statearr_13408[(7)] = inst_13353__$1);

(statearr_13408[(13)] = inst_13355__$1);

return statearr_13408;
})();
if(cljs.core.truth_(inst_13355__$1)){
var statearr_13409_14450 = state_13400__$1;
(statearr_13409_14450[(1)] = (5));

} else {
var statearr_13410_14451 = state_13400__$1;
(statearr_13410_14451[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (15))){
var inst_13374 = (state_13400[(15)]);
var inst_13345 = (state_13400[(16)]);
var inst_13374__$1 = cljs.core.empty_QMARK_(inst_13345);
var state_13400__$1 = (function (){var statearr_13411 = state_13400;
(statearr_13411[(15)] = inst_13374__$1);

return statearr_13411;
})();
if(inst_13374__$1){
var statearr_13412_14458 = state_13400__$1;
(statearr_13412_14458[(1)] = (17));

} else {
var statearr_13413_14459 = state_13400__$1;
(statearr_13413_14459[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (21))){
var inst_13344 = (state_13400[(12)]);
var inst_13341 = inst_13344;
var state_13400__$1 = (function (){var statearr_13414 = state_13400;
(statearr_13414[(10)] = inst_13341);

return statearr_13414;
})();
var statearr_13415_14460 = state_13400__$1;
(statearr_13415_14460[(2)] = null);

(statearr_13415_14460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (13))){
var inst_13367 = (state_13400[(2)]);
var inst_13368 = calc_state();
var inst_13341 = inst_13368;
var state_13400__$1 = (function (){var statearr_13416 = state_13400;
(statearr_13416[(10)] = inst_13341);

(statearr_13416[(17)] = inst_13367);

return statearr_13416;
})();
var statearr_13417_14461 = state_13400__$1;
(statearr_13417_14461[(2)] = null);

(statearr_13417_14461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (22))){
var inst_13394 = (state_13400[(2)]);
var state_13400__$1 = state_13400;
var statearr_13418_14462 = state_13400__$1;
(statearr_13418_14462[(2)] = inst_13394);

(statearr_13418_14462[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (6))){
var inst_13354 = (state_13400[(14)]);
var inst_13358 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13354,change);
var state_13400__$1 = state_13400;
var statearr_13419_14463 = state_13400__$1;
(statearr_13419_14463[(2)] = inst_13358);

(statearr_13419_14463[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (25))){
var state_13400__$1 = state_13400;
var statearr_13420_14464 = state_13400__$1;
(statearr_13420_14464[(2)] = null);

(statearr_13420_14464[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (17))){
var inst_13354 = (state_13400[(14)]);
var inst_13346 = (state_13400[(18)]);
var inst_13376 = (inst_13346.cljs$core$IFn$_invoke$arity$1 ? inst_13346.cljs$core$IFn$_invoke$arity$1(inst_13354) : inst_13346.call(null,inst_13354));
var inst_13377 = cljs.core.not(inst_13376);
var state_13400__$1 = state_13400;
var statearr_13421_14465 = state_13400__$1;
(statearr_13421_14465[(2)] = inst_13377);

(statearr_13421_14465[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (3))){
var inst_13398 = (state_13400[(2)]);
var state_13400__$1 = state_13400;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13400__$1,inst_13398);
} else {
if((state_val_13401 === (12))){
var state_13400__$1 = state_13400;
var statearr_13422_14466 = state_13400__$1;
(statearr_13422_14466[(2)] = null);

(statearr_13422_14466[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (2))){
var inst_13341 = (state_13400[(10)]);
var inst_13344 = (state_13400[(12)]);
var inst_13344__$1 = cljs.core.__destructure_map(inst_13341);
var inst_13345 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13344__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13346 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13344__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13344__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_13400__$1 = (function (){var statearr_13423 = state_13400;
(statearr_13423[(12)] = inst_13344__$1);

(statearr_13423[(18)] = inst_13346);

(statearr_13423[(16)] = inst_13345);

return statearr_13423;
})();
return cljs.core.async.ioc_alts_BANG_(state_13400__$1,(4),inst_13347);
} else {
if((state_val_13401 === (23))){
var inst_13385 = (state_13400[(2)]);
var state_13400__$1 = state_13400;
if(cljs.core.truth_(inst_13385)){
var statearr_13424_14467 = state_13400__$1;
(statearr_13424_14467[(1)] = (24));

} else {
var statearr_13425_14468 = state_13400__$1;
(statearr_13425_14468[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (19))){
var inst_13380 = (state_13400[(2)]);
var state_13400__$1 = state_13400;
var statearr_13426_14469 = state_13400__$1;
(statearr_13426_14469[(2)] = inst_13380);

(statearr_13426_14469[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (11))){
var inst_13354 = (state_13400[(14)]);
var inst_13364 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_13354);
var state_13400__$1 = state_13400;
var statearr_13427_14470 = state_13400__$1;
(statearr_13427_14470[(2)] = inst_13364);

(statearr_13427_14470[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (9))){
var inst_13354 = (state_13400[(14)]);
var inst_13345 = (state_13400[(16)]);
var inst_13371 = (state_13400[(19)]);
var inst_13371__$1 = (inst_13345.cljs$core$IFn$_invoke$arity$1 ? inst_13345.cljs$core$IFn$_invoke$arity$1(inst_13354) : inst_13345.call(null,inst_13354));
var state_13400__$1 = (function (){var statearr_13428 = state_13400;
(statearr_13428[(19)] = inst_13371__$1);

return statearr_13428;
})();
if(cljs.core.truth_(inst_13371__$1)){
var statearr_13429_14471 = state_13400__$1;
(statearr_13429_14471[(1)] = (14));

} else {
var statearr_13430_14472 = state_13400__$1;
(statearr_13430_14472[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (5))){
var inst_13355 = (state_13400[(13)]);
var state_13400__$1 = state_13400;
var statearr_13431_14479 = state_13400__$1;
(statearr_13431_14479[(2)] = inst_13355);

(statearr_13431_14479[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (14))){
var inst_13371 = (state_13400[(19)]);
var state_13400__$1 = state_13400;
var statearr_13432_14480 = state_13400__$1;
(statearr_13432_14480[(2)] = inst_13371);

(statearr_13432_14480[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (26))){
var inst_13390 = (state_13400[(2)]);
var state_13400__$1 = state_13400;
var statearr_13433_14481 = state_13400__$1;
(statearr_13433_14481[(2)] = inst_13390);

(statearr_13433_14481[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (16))){
var inst_13382 = (state_13400[(2)]);
var state_13400__$1 = state_13400;
if(cljs.core.truth_(inst_13382)){
var statearr_13434_14482 = state_13400__$1;
(statearr_13434_14482[(1)] = (20));

} else {
var statearr_13435_14483 = state_13400__$1;
(statearr_13435_14483[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (10))){
var inst_13396 = (state_13400[(2)]);
var state_13400__$1 = state_13400;
var statearr_13436_14484 = state_13400__$1;
(statearr_13436_14484[(2)] = inst_13396);

(statearr_13436_14484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (18))){
var inst_13374 = (state_13400[(15)]);
var state_13400__$1 = state_13400;
var statearr_13437_14485 = state_13400__$1;
(statearr_13437_14485[(2)] = inst_13374);

(statearr_13437_14485[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13401 === (8))){
var inst_13353 = (state_13400[(7)]);
var inst_13362 = (inst_13353 == null);
var state_13400__$1 = state_13400;
if(cljs.core.truth_(inst_13362)){
var statearr_13438_14486 = state_13400__$1;
(statearr_13438_14486[(1)] = (11));

} else {
var statearr_13439_14487 = state_13400__$1;
(statearr_13439_14487[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__12534__auto__ = null;
var cljs$core$async$mix_$_state_machine__12534__auto____0 = (function (){
var statearr_13440 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13440[(0)] = cljs$core$async$mix_$_state_machine__12534__auto__);

(statearr_13440[(1)] = (1));

return statearr_13440;
});
var cljs$core$async$mix_$_state_machine__12534__auto____1 = (function (state_13400){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13400);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13441){var ex__12537__auto__ = e13441;
var statearr_13442_14488 = state_13400;
(statearr_13442_14488[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13400[(4)]))){
var statearr_13443_14489 = state_13400;
(statearr_13443_14489[(1)] = cljs.core.first((state_13400[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14490 = state_13400;
state_13400 = G__14490;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__12534__auto__ = function(state_13400){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__12534__auto____1.call(this,state_13400);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__12534__auto____0;
cljs$core$async$mix_$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__12534__auto____1;
return cljs$core$async$mix_$_state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13444 = f__12570__auto__();
(statearr_13444[(6)] = c__12569__auto___14445);

return statearr_13444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_14491 = (function (p,v,ch,close_QMARK_){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4510__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4508__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_14491(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_14492 = (function (p,v,ch){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4510__auto__.call(null,p,v,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4508__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_14492(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_14493 = (function() {
var G__14494 = null;
var G__14494__1 = (function (p){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4510__auto__.call(null,p));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4508__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__14494__2 = (function (p,v){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4510__auto__.call(null,p,v));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4508__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__14494 = function(p,v){
switch(arguments.length){
case 1:
return G__14494__1.call(this,p);
case 2:
return G__14494__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__14494.cljs$core$IFn$_invoke$arity$1 = G__14494__1;
G__14494.cljs$core$IFn$_invoke$arity$2 = G__14494__2;
return G__14494;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__13446 = arguments.length;
switch (G__13446) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_14493(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_14493(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__13449 = arguments.length;
switch (G__13449) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__13447_SHARP_){
if(cljs.core.truth_((p1__13447_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__13447_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__13447_SHARP_.call(null,topic)))){
return p1__13447_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__13447_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13450 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13450 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta13451){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta13451 = meta13451;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13450.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13452,meta13451__$1){
var self__ = this;
var _13452__$1 = this;
return (new cljs.core.async.t_cljs$core$async13450(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta13451__$1));
}));

(cljs.core.async.t_cljs$core$async13450.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13452){
var self__ = this;
var _13452__$1 = this;
return self__.meta13451;
}));

(cljs.core.async.t_cljs$core$async13450.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13450.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async13450.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13450.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async13450.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async13450.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async13450.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async13450.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta13451","meta13451",-273849900,null)], null);
}));

(cljs.core.async.t_cljs$core$async13450.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13450.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13450");

(cljs.core.async.t_cljs$core$async13450.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13450");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13450.
 */
cljs.core.async.__GT_t_cljs$core$async13450 = (function cljs$core$async$__GT_t_cljs$core$async13450(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13451){
return (new cljs.core.async.t_cljs$core$async13450(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13451));
});

}

return (new cljs.core.async.t_cljs$core$async13450(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__12569__auto___14502 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13524){
var state_val_13525 = (state_13524[(1)]);
if((state_val_13525 === (7))){
var inst_13520 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13526_14503 = state_13524__$1;
(statearr_13526_14503[(2)] = inst_13520);

(statearr_13526_14503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (20))){
var state_13524__$1 = state_13524;
var statearr_13527_14504 = state_13524__$1;
(statearr_13527_14504[(2)] = null);

(statearr_13527_14504[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (1))){
var state_13524__$1 = state_13524;
var statearr_13528_14505 = state_13524__$1;
(statearr_13528_14505[(2)] = null);

(statearr_13528_14505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (24))){
var inst_13503 = (state_13524[(7)]);
var inst_13512 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_13503);
var state_13524__$1 = state_13524;
var statearr_13529_14506 = state_13524__$1;
(statearr_13529_14506[(2)] = inst_13512);

(statearr_13529_14506[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (4))){
var inst_13455 = (state_13524[(8)]);
var inst_13455__$1 = (state_13524[(2)]);
var inst_13456 = (inst_13455__$1 == null);
var state_13524__$1 = (function (){var statearr_13530 = state_13524;
(statearr_13530[(8)] = inst_13455__$1);

return statearr_13530;
})();
if(cljs.core.truth_(inst_13456)){
var statearr_13531_14507 = state_13524__$1;
(statearr_13531_14507[(1)] = (5));

} else {
var statearr_13532_14508 = state_13524__$1;
(statearr_13532_14508[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (15))){
var inst_13497 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13533_14510 = state_13524__$1;
(statearr_13533_14510[(2)] = inst_13497);

(statearr_13533_14510[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (21))){
var inst_13517 = (state_13524[(2)]);
var state_13524__$1 = (function (){var statearr_13534 = state_13524;
(statearr_13534[(9)] = inst_13517);

return statearr_13534;
})();
var statearr_13535_14512 = state_13524__$1;
(statearr_13535_14512[(2)] = null);

(statearr_13535_14512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (13))){
var inst_13479 = (state_13524[(10)]);
var inst_13481 = cljs.core.chunked_seq_QMARK_(inst_13479);
var state_13524__$1 = state_13524;
if(inst_13481){
var statearr_13536_14513 = state_13524__$1;
(statearr_13536_14513[(1)] = (16));

} else {
var statearr_13537_14514 = state_13524__$1;
(statearr_13537_14514[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (22))){
var inst_13509 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
if(cljs.core.truth_(inst_13509)){
var statearr_13538_14515 = state_13524__$1;
(statearr_13538_14515[(1)] = (23));

} else {
var statearr_13539_14516 = state_13524__$1;
(statearr_13539_14516[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (6))){
var inst_13505 = (state_13524[(11)]);
var inst_13455 = (state_13524[(8)]);
var inst_13503 = (state_13524[(7)]);
var inst_13503__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_13455) : topic_fn.call(null,inst_13455));
var inst_13504 = cljs.core.deref(mults);
var inst_13505__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_13504,inst_13503__$1);
var state_13524__$1 = (function (){var statearr_13540 = state_13524;
(statearr_13540[(11)] = inst_13505__$1);

(statearr_13540[(7)] = inst_13503__$1);

return statearr_13540;
})();
if(cljs.core.truth_(inst_13505__$1)){
var statearr_13541_14517 = state_13524__$1;
(statearr_13541_14517[(1)] = (19));

} else {
var statearr_13542_14518 = state_13524__$1;
(statearr_13542_14518[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (25))){
var inst_13514 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13543_14519 = state_13524__$1;
(statearr_13543_14519[(2)] = inst_13514);

(statearr_13543_14519[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (17))){
var inst_13479 = (state_13524[(10)]);
var inst_13488 = cljs.core.first(inst_13479);
var inst_13489 = cljs.core.async.muxch_STAR_(inst_13488);
var inst_13490 = cljs.core.async.close_BANG_(inst_13489);
var inst_13491 = cljs.core.next(inst_13479);
var inst_13465 = inst_13491;
var inst_13466 = null;
var inst_13467 = (0);
var inst_13468 = (0);
var state_13524__$1 = (function (){var statearr_13544 = state_13524;
(statearr_13544[(12)] = inst_13465);

(statearr_13544[(13)] = inst_13490);

(statearr_13544[(14)] = inst_13468);

(statearr_13544[(15)] = inst_13467);

(statearr_13544[(16)] = inst_13466);

return statearr_13544;
})();
var statearr_13545_14522 = state_13524__$1;
(statearr_13545_14522[(2)] = null);

(statearr_13545_14522[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (3))){
var inst_13522 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13524__$1,inst_13522);
} else {
if((state_val_13525 === (12))){
var inst_13499 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13546_14523 = state_13524__$1;
(statearr_13546_14523[(2)] = inst_13499);

(statearr_13546_14523[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (2))){
var state_13524__$1 = state_13524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13524__$1,(4),ch);
} else {
if((state_val_13525 === (23))){
var state_13524__$1 = state_13524;
var statearr_13547_14524 = state_13524__$1;
(statearr_13547_14524[(2)] = null);

(statearr_13547_14524[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (19))){
var inst_13505 = (state_13524[(11)]);
var inst_13455 = (state_13524[(8)]);
var inst_13507 = cljs.core.async.muxch_STAR_(inst_13505);
var state_13524__$1 = state_13524;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13524__$1,(22),inst_13507,inst_13455);
} else {
if((state_val_13525 === (11))){
var inst_13465 = (state_13524[(12)]);
var inst_13479 = (state_13524[(10)]);
var inst_13479__$1 = cljs.core.seq(inst_13465);
var state_13524__$1 = (function (){var statearr_13548 = state_13524;
(statearr_13548[(10)] = inst_13479__$1);

return statearr_13548;
})();
if(inst_13479__$1){
var statearr_13549_14525 = state_13524__$1;
(statearr_13549_14525[(1)] = (13));

} else {
var statearr_13550_14526 = state_13524__$1;
(statearr_13550_14526[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (9))){
var inst_13501 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13551_14527 = state_13524__$1;
(statearr_13551_14527[(2)] = inst_13501);

(statearr_13551_14527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (5))){
var inst_13462 = cljs.core.deref(mults);
var inst_13463 = cljs.core.vals(inst_13462);
var inst_13464 = cljs.core.seq(inst_13463);
var inst_13465 = inst_13464;
var inst_13466 = null;
var inst_13467 = (0);
var inst_13468 = (0);
var state_13524__$1 = (function (){var statearr_13552 = state_13524;
(statearr_13552[(12)] = inst_13465);

(statearr_13552[(14)] = inst_13468);

(statearr_13552[(15)] = inst_13467);

(statearr_13552[(16)] = inst_13466);

return statearr_13552;
})();
var statearr_13553_14528 = state_13524__$1;
(statearr_13553_14528[(2)] = null);

(statearr_13553_14528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (14))){
var state_13524__$1 = state_13524;
var statearr_13557_14529 = state_13524__$1;
(statearr_13557_14529[(2)] = null);

(statearr_13557_14529[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (16))){
var inst_13479 = (state_13524[(10)]);
var inst_13483 = cljs.core.chunk_first(inst_13479);
var inst_13484 = cljs.core.chunk_rest(inst_13479);
var inst_13485 = cljs.core.count(inst_13483);
var inst_13465 = inst_13484;
var inst_13466 = inst_13483;
var inst_13467 = inst_13485;
var inst_13468 = (0);
var state_13524__$1 = (function (){var statearr_13558 = state_13524;
(statearr_13558[(12)] = inst_13465);

(statearr_13558[(14)] = inst_13468);

(statearr_13558[(15)] = inst_13467);

(statearr_13558[(16)] = inst_13466);

return statearr_13558;
})();
var statearr_13559_14530 = state_13524__$1;
(statearr_13559_14530[(2)] = null);

(statearr_13559_14530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (10))){
var inst_13465 = (state_13524[(12)]);
var inst_13468 = (state_13524[(14)]);
var inst_13467 = (state_13524[(15)]);
var inst_13466 = (state_13524[(16)]);
var inst_13473 = cljs.core._nth(inst_13466,inst_13468);
var inst_13474 = cljs.core.async.muxch_STAR_(inst_13473);
var inst_13475 = cljs.core.async.close_BANG_(inst_13474);
var inst_13476 = (inst_13468 + (1));
var tmp13554 = inst_13465;
var tmp13555 = inst_13467;
var tmp13556 = inst_13466;
var inst_13465__$1 = tmp13554;
var inst_13466__$1 = tmp13556;
var inst_13467__$1 = tmp13555;
var inst_13468__$1 = inst_13476;
var state_13524__$1 = (function (){var statearr_13560 = state_13524;
(statearr_13560[(12)] = inst_13465__$1);

(statearr_13560[(14)] = inst_13468__$1);

(statearr_13560[(15)] = inst_13467__$1);

(statearr_13560[(17)] = inst_13475);

(statearr_13560[(16)] = inst_13466__$1);

return statearr_13560;
})();
var statearr_13561_14532 = state_13524__$1;
(statearr_13561_14532[(2)] = null);

(statearr_13561_14532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (18))){
var inst_13494 = (state_13524[(2)]);
var state_13524__$1 = state_13524;
var statearr_13562_14534 = state_13524__$1;
(statearr_13562_14534[(2)] = inst_13494);

(statearr_13562_14534[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13525 === (8))){
var inst_13468 = (state_13524[(14)]);
var inst_13467 = (state_13524[(15)]);
var inst_13470 = (inst_13468 < inst_13467);
var inst_13471 = inst_13470;
var state_13524__$1 = state_13524;
if(cljs.core.truth_(inst_13471)){
var statearr_13563_14535 = state_13524__$1;
(statearr_13563_14535[(1)] = (10));

} else {
var statearr_13564_14536 = state_13524__$1;
(statearr_13564_14536[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_13565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13565[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_13565[(1)] = (1));

return statearr_13565;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_13524){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13524);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13566){var ex__12537__auto__ = e13566;
var statearr_13567_14537 = state_13524;
(statearr_13567_14537[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13524[(4)]))){
var statearr_13568_14538 = state_13524;
(statearr_13568_14538[(1)] = cljs.core.first((state_13524[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14539 = state_13524;
state_13524 = G__14539;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_13524){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_13524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13569 = f__12570__auto__();
(statearr_13569[(6)] = c__12569__auto___14502);

return statearr_13569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__13571 = arguments.length;
switch (G__13571) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__13573 = arguments.length;
switch (G__13573) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__13575 = arguments.length;
switch (G__13575) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__12569__auto___14543 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13618){
var state_val_13619 = (state_13618[(1)]);
if((state_val_13619 === (7))){
var state_13618__$1 = state_13618;
var statearr_13620_14544 = state_13618__$1;
(statearr_13620_14544[(2)] = null);

(statearr_13620_14544[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (1))){
var state_13618__$1 = state_13618;
var statearr_13621_14545 = state_13618__$1;
(statearr_13621_14545[(2)] = null);

(statearr_13621_14545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (4))){
var inst_13579 = (state_13618[(7)]);
var inst_13578 = (state_13618[(8)]);
var inst_13581 = (inst_13579 < inst_13578);
var state_13618__$1 = state_13618;
if(cljs.core.truth_(inst_13581)){
var statearr_13622_14546 = state_13618__$1;
(statearr_13622_14546[(1)] = (6));

} else {
var statearr_13623_14548 = state_13618__$1;
(statearr_13623_14548[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (15))){
var inst_13604 = (state_13618[(9)]);
var inst_13609 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_13604);
var state_13618__$1 = state_13618;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13618__$1,(17),out,inst_13609);
} else {
if((state_val_13619 === (13))){
var inst_13604 = (state_13618[(9)]);
var inst_13604__$1 = (state_13618[(2)]);
var inst_13605 = cljs.core.some(cljs.core.nil_QMARK_,inst_13604__$1);
var state_13618__$1 = (function (){var statearr_13624 = state_13618;
(statearr_13624[(9)] = inst_13604__$1);

return statearr_13624;
})();
if(cljs.core.truth_(inst_13605)){
var statearr_13625_14549 = state_13618__$1;
(statearr_13625_14549[(1)] = (14));

} else {
var statearr_13626_14550 = state_13618__$1;
(statearr_13626_14550[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (6))){
var state_13618__$1 = state_13618;
var statearr_13627_14551 = state_13618__$1;
(statearr_13627_14551[(2)] = null);

(statearr_13627_14551[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (17))){
var inst_13611 = (state_13618[(2)]);
var state_13618__$1 = (function (){var statearr_13629 = state_13618;
(statearr_13629[(10)] = inst_13611);

return statearr_13629;
})();
var statearr_13630_14552 = state_13618__$1;
(statearr_13630_14552[(2)] = null);

(statearr_13630_14552[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (3))){
var inst_13616 = (state_13618[(2)]);
var state_13618__$1 = state_13618;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13618__$1,inst_13616);
} else {
if((state_val_13619 === (12))){
var _ = (function (){var statearr_13631 = state_13618;
(statearr_13631[(4)] = cljs.core.rest((state_13618[(4)])));

return statearr_13631;
})();
var state_13618__$1 = state_13618;
var ex13628 = (state_13618__$1[(2)]);
var statearr_13632_14557 = state_13618__$1;
(statearr_13632_14557[(5)] = ex13628);


if((ex13628 instanceof Object)){
var statearr_13633_14558 = state_13618__$1;
(statearr_13633_14558[(1)] = (11));

(statearr_13633_14558[(5)] = null);

} else {
throw ex13628;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (2))){
var inst_13577 = cljs.core.reset_BANG_(dctr,cnt);
var inst_13578 = cnt;
var inst_13579 = (0);
var state_13618__$1 = (function (){var statearr_13634 = state_13618;
(statearr_13634[(11)] = inst_13577);

(statearr_13634[(7)] = inst_13579);

(statearr_13634[(8)] = inst_13578);

return statearr_13634;
})();
var statearr_13635_14559 = state_13618__$1;
(statearr_13635_14559[(2)] = null);

(statearr_13635_14559[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (11))){
var inst_13583 = (state_13618[(2)]);
var inst_13584 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_13618__$1 = (function (){var statearr_13636 = state_13618;
(statearr_13636[(12)] = inst_13583);

return statearr_13636;
})();
var statearr_13637_14560 = state_13618__$1;
(statearr_13637_14560[(2)] = inst_13584);

(statearr_13637_14560[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (9))){
var inst_13579 = (state_13618[(7)]);
var _ = (function (){var statearr_13638 = state_13618;
(statearr_13638[(4)] = cljs.core.cons((12),(state_13618[(4)])));

return statearr_13638;
})();
var inst_13590 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_13579) : chs__$1.call(null,inst_13579));
var inst_13591 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_13579) : done.call(null,inst_13579));
var inst_13592 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_13590,inst_13591);
var ___$1 = (function (){var statearr_13639 = state_13618;
(statearr_13639[(4)] = cljs.core.rest((state_13618[(4)])));

return statearr_13639;
})();
var state_13618__$1 = state_13618;
var statearr_13640_14561 = state_13618__$1;
(statearr_13640_14561[(2)] = inst_13592);

(statearr_13640_14561[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (5))){
var inst_13602 = (state_13618[(2)]);
var state_13618__$1 = (function (){var statearr_13641 = state_13618;
(statearr_13641[(13)] = inst_13602);

return statearr_13641;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13618__$1,(13),dchan);
} else {
if((state_val_13619 === (14))){
var inst_13607 = cljs.core.async.close_BANG_(out);
var state_13618__$1 = state_13618;
var statearr_13642_14562 = state_13618__$1;
(statearr_13642_14562[(2)] = inst_13607);

(statearr_13642_14562[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (16))){
var inst_13614 = (state_13618[(2)]);
var state_13618__$1 = state_13618;
var statearr_13643_14563 = state_13618__$1;
(statearr_13643_14563[(2)] = inst_13614);

(statearr_13643_14563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (10))){
var inst_13579 = (state_13618[(7)]);
var inst_13595 = (state_13618[(2)]);
var inst_13596 = (inst_13579 + (1));
var inst_13579__$1 = inst_13596;
var state_13618__$1 = (function (){var statearr_13644 = state_13618;
(statearr_13644[(14)] = inst_13595);

(statearr_13644[(7)] = inst_13579__$1);

return statearr_13644;
})();
var statearr_13645_14564 = state_13618__$1;
(statearr_13645_14564[(2)] = null);

(statearr_13645_14564[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13619 === (8))){
var inst_13600 = (state_13618[(2)]);
var state_13618__$1 = state_13618;
var statearr_13646_14565 = state_13618__$1;
(statearr_13646_14565[(2)] = inst_13600);

(statearr_13646_14565[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_13647 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13647[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_13647[(1)] = (1));

return statearr_13647;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_13618){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13618);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13648){var ex__12537__auto__ = e13648;
var statearr_13649_14566 = state_13618;
(statearr_13649_14566[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13618[(4)]))){
var statearr_13650_14567 = state_13618;
(statearr_13650_14567[(1)] = cljs.core.first((state_13618[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14568 = state_13618;
state_13618 = G__14568;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_13618){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_13618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13651 = f__12570__auto__();
(statearr_13651[(6)] = c__12569__auto___14543);

return statearr_13651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__13654 = arguments.length;
switch (G__13654) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12569__auto___14577 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13686){
var state_val_13687 = (state_13686[(1)]);
if((state_val_13687 === (7))){
var inst_13665 = (state_13686[(7)]);
var inst_13666 = (state_13686[(8)]);
var inst_13665__$1 = (state_13686[(2)]);
var inst_13666__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13665__$1,(0),null);
var inst_13667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13665__$1,(1),null);
var inst_13668 = (inst_13666__$1 == null);
var state_13686__$1 = (function (){var statearr_13688 = state_13686;
(statearr_13688[(7)] = inst_13665__$1);

(statearr_13688[(9)] = inst_13667);

(statearr_13688[(8)] = inst_13666__$1);

return statearr_13688;
})();
if(cljs.core.truth_(inst_13668)){
var statearr_13689_14578 = state_13686__$1;
(statearr_13689_14578[(1)] = (8));

} else {
var statearr_13690_14579 = state_13686__$1;
(statearr_13690_14579[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13687 === (1))){
var inst_13655 = cljs.core.vec(chs);
var inst_13656 = inst_13655;
var state_13686__$1 = (function (){var statearr_13691 = state_13686;
(statearr_13691[(10)] = inst_13656);

return statearr_13691;
})();
var statearr_13692_14583 = state_13686__$1;
(statearr_13692_14583[(2)] = null);

(statearr_13692_14583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13687 === (4))){
var inst_13656 = (state_13686[(10)]);
var state_13686__$1 = state_13686;
return cljs.core.async.ioc_alts_BANG_(state_13686__$1,(7),inst_13656);
} else {
if((state_val_13687 === (6))){
var inst_13682 = (state_13686[(2)]);
var state_13686__$1 = state_13686;
var statearr_13693_14587 = state_13686__$1;
(statearr_13693_14587[(2)] = inst_13682);

(statearr_13693_14587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13687 === (3))){
var inst_13684 = (state_13686[(2)]);
var state_13686__$1 = state_13686;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13686__$1,inst_13684);
} else {
if((state_val_13687 === (2))){
var inst_13656 = (state_13686[(10)]);
var inst_13658 = cljs.core.count(inst_13656);
var inst_13659 = (inst_13658 > (0));
var state_13686__$1 = state_13686;
if(cljs.core.truth_(inst_13659)){
var statearr_13695_14588 = state_13686__$1;
(statearr_13695_14588[(1)] = (4));

} else {
var statearr_13696_14589 = state_13686__$1;
(statearr_13696_14589[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13687 === (11))){
var inst_13656 = (state_13686[(10)]);
var inst_13675 = (state_13686[(2)]);
var tmp13694 = inst_13656;
var inst_13656__$1 = tmp13694;
var state_13686__$1 = (function (){var statearr_13697 = state_13686;
(statearr_13697[(10)] = inst_13656__$1);

(statearr_13697[(11)] = inst_13675);

return statearr_13697;
})();
var statearr_13698_14590 = state_13686__$1;
(statearr_13698_14590[(2)] = null);

(statearr_13698_14590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13687 === (9))){
var inst_13666 = (state_13686[(8)]);
var state_13686__$1 = state_13686;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13686__$1,(11),out,inst_13666);
} else {
if((state_val_13687 === (5))){
var inst_13680 = cljs.core.async.close_BANG_(out);
var state_13686__$1 = state_13686;
var statearr_13699_14594 = state_13686__$1;
(statearr_13699_14594[(2)] = inst_13680);

(statearr_13699_14594[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13687 === (10))){
var inst_13678 = (state_13686[(2)]);
var state_13686__$1 = state_13686;
var statearr_13700_14595 = state_13686__$1;
(statearr_13700_14595[(2)] = inst_13678);

(statearr_13700_14595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13687 === (8))){
var inst_13656 = (state_13686[(10)]);
var inst_13665 = (state_13686[(7)]);
var inst_13667 = (state_13686[(9)]);
var inst_13666 = (state_13686[(8)]);
var inst_13670 = (function (){var cs = inst_13656;
var vec__13661 = inst_13665;
var v = inst_13666;
var c = inst_13667;
return (function (p1__13652_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__13652_SHARP_);
});
})();
var inst_13671 = cljs.core.filterv(inst_13670,inst_13656);
var inst_13656__$1 = inst_13671;
var state_13686__$1 = (function (){var statearr_13701 = state_13686;
(statearr_13701[(10)] = inst_13656__$1);

return statearr_13701;
})();
var statearr_13702_14600 = state_13686__$1;
(statearr_13702_14600[(2)] = null);

(statearr_13702_14600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_13703 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13703[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_13703[(1)] = (1));

return statearr_13703;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_13686){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13686);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13704){var ex__12537__auto__ = e13704;
var statearr_13705_14601 = state_13686;
(statearr_13705_14601[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13686[(4)]))){
var statearr_13706_14602 = state_13686;
(statearr_13706_14602[(1)] = cljs.core.first((state_13686[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14603 = state_13686;
state_13686 = G__14603;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_13686){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_13686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13707 = f__12570__auto__();
(statearr_13707[(6)] = c__12569__auto___14577);

return statearr_13707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__13709 = arguments.length;
switch (G__13709) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12569__auto___14605 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13733){
var state_val_13734 = (state_13733[(1)]);
if((state_val_13734 === (7))){
var inst_13715 = (state_13733[(7)]);
var inst_13715__$1 = (state_13733[(2)]);
var inst_13716 = (inst_13715__$1 == null);
var inst_13717 = cljs.core.not(inst_13716);
var state_13733__$1 = (function (){var statearr_13735 = state_13733;
(statearr_13735[(7)] = inst_13715__$1);

return statearr_13735;
})();
if(inst_13717){
var statearr_13736_14607 = state_13733__$1;
(statearr_13736_14607[(1)] = (8));

} else {
var statearr_13737_14609 = state_13733__$1;
(statearr_13737_14609[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13734 === (1))){
var inst_13710 = (0);
var state_13733__$1 = (function (){var statearr_13738 = state_13733;
(statearr_13738[(8)] = inst_13710);

return statearr_13738;
})();
var statearr_13739_14610 = state_13733__$1;
(statearr_13739_14610[(2)] = null);

(statearr_13739_14610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13734 === (4))){
var state_13733__$1 = state_13733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13733__$1,(7),ch);
} else {
if((state_val_13734 === (6))){
var inst_13728 = (state_13733[(2)]);
var state_13733__$1 = state_13733;
var statearr_13740_14611 = state_13733__$1;
(statearr_13740_14611[(2)] = inst_13728);

(statearr_13740_14611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13734 === (3))){
var inst_13730 = (state_13733[(2)]);
var inst_13731 = cljs.core.async.close_BANG_(out);
var state_13733__$1 = (function (){var statearr_13741 = state_13733;
(statearr_13741[(9)] = inst_13730);

return statearr_13741;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13733__$1,inst_13731);
} else {
if((state_val_13734 === (2))){
var inst_13710 = (state_13733[(8)]);
var inst_13712 = (inst_13710 < n);
var state_13733__$1 = state_13733;
if(cljs.core.truth_(inst_13712)){
var statearr_13742_14612 = state_13733__$1;
(statearr_13742_14612[(1)] = (4));

} else {
var statearr_13743_14613 = state_13733__$1;
(statearr_13743_14613[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13734 === (11))){
var inst_13710 = (state_13733[(8)]);
var inst_13720 = (state_13733[(2)]);
var inst_13721 = (inst_13710 + (1));
var inst_13710__$1 = inst_13721;
var state_13733__$1 = (function (){var statearr_13744 = state_13733;
(statearr_13744[(10)] = inst_13720);

(statearr_13744[(8)] = inst_13710__$1);

return statearr_13744;
})();
var statearr_13745_14614 = state_13733__$1;
(statearr_13745_14614[(2)] = null);

(statearr_13745_14614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13734 === (9))){
var state_13733__$1 = state_13733;
var statearr_13746_14615 = state_13733__$1;
(statearr_13746_14615[(2)] = null);

(statearr_13746_14615[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13734 === (5))){
var state_13733__$1 = state_13733;
var statearr_13747_14616 = state_13733__$1;
(statearr_13747_14616[(2)] = null);

(statearr_13747_14616[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13734 === (10))){
var inst_13725 = (state_13733[(2)]);
var state_13733__$1 = state_13733;
var statearr_13748_14617 = state_13733__$1;
(statearr_13748_14617[(2)] = inst_13725);

(statearr_13748_14617[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13734 === (8))){
var inst_13715 = (state_13733[(7)]);
var state_13733__$1 = state_13733;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13733__$1,(11),out,inst_13715);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_13749 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13749[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_13749[(1)] = (1));

return statearr_13749;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_13733){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13733);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13750){var ex__12537__auto__ = e13750;
var statearr_13751_14618 = state_13733;
(statearr_13751_14618[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13733[(4)]))){
var statearr_13752_14619 = state_13733;
(statearr_13752_14619[(1)] = cljs.core.first((state_13733[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14620 = state_13733;
state_13733 = G__14620;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_13733){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_13733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13753 = f__12570__auto__();
(statearr_13753[(6)] = c__12569__auto___14605);

return statearr_13753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13755 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13755 = (function (f,ch,meta13756){
this.f = f;
this.ch = ch;
this.meta13756 = meta13756;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13755.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13757,meta13756__$1){
var self__ = this;
var _13757__$1 = this;
return (new cljs.core.async.t_cljs$core$async13755(self__.f,self__.ch,meta13756__$1));
}));

(cljs.core.async.t_cljs$core$async13755.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13757){
var self__ = this;
var _13757__$1 = this;
return self__.meta13756;
}));

(cljs.core.async.t_cljs$core$async13755.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13755.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13755.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13755.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13755.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13758 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13758 = (function (f,ch,meta13756,_,fn1,meta13759){
this.f = f;
this.ch = ch;
this.meta13756 = meta13756;
this._ = _;
this.fn1 = fn1;
this.meta13759 = meta13759;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13758.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13760,meta13759__$1){
var self__ = this;
var _13760__$1 = this;
return (new cljs.core.async.t_cljs$core$async13758(self__.f,self__.ch,self__.meta13756,self__._,self__.fn1,meta13759__$1));
}));

(cljs.core.async.t_cljs$core$async13758.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13760){
var self__ = this;
var _13760__$1 = this;
return self__.meta13759;
}));

(cljs.core.async.t_cljs$core$async13758.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13758.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async13758.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13758.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__13754_SHARP_){
var G__13761 = (((p1__13754_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__13754_SHARP_) : self__.f.call(null,p1__13754_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__13761) : f1.call(null,G__13761));
});
}));

(cljs.core.async.t_cljs$core$async13758.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13756","meta13756",-1428053231,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13755","cljs.core.async/t_cljs$core$async13755",2120592613,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13759","meta13759",-334239849,null)], null);
}));

(cljs.core.async.t_cljs$core$async13758.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13758.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13758");

(cljs.core.async.t_cljs$core$async13758.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13758");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13758.
 */
cljs.core.async.__GT_t_cljs$core$async13758 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13758(f__$1,ch__$1,meta13756__$1,___$2,fn1__$1,meta13759){
return (new cljs.core.async.t_cljs$core$async13758(f__$1,ch__$1,meta13756__$1,___$2,fn1__$1,meta13759));
});

}

return (new cljs.core.async.t_cljs$core$async13758(self__.f,self__.ch,self__.meta13756,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4210__auto__ = ret;
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4210__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__13762 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__13762) : self__.f.call(null,G__13762));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async13755.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13755.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async13755.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13756","meta13756",-1428053231,null)], null);
}));

(cljs.core.async.t_cljs$core$async13755.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13755.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13755");

(cljs.core.async.t_cljs$core$async13755.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13755");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13755.
 */
cljs.core.async.__GT_t_cljs$core$async13755 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13755(f__$1,ch__$1,meta13756){
return (new cljs.core.async.t_cljs$core$async13755(f__$1,ch__$1,meta13756));
});

}

return (new cljs.core.async.t_cljs$core$async13755(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13763 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13763 = (function (f,ch,meta13764){
this.f = f;
this.ch = ch;
this.meta13764 = meta13764;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13763.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13765,meta13764__$1){
var self__ = this;
var _13765__$1 = this;
return (new cljs.core.async.t_cljs$core$async13763(self__.f,self__.ch,meta13764__$1));
}));

(cljs.core.async.t_cljs$core$async13763.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13765){
var self__ = this;
var _13765__$1 = this;
return self__.meta13764;
}));

(cljs.core.async.t_cljs$core$async13763.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13763.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13763.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13763.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async13763.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13763.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async13763.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13764","meta13764",-750410628,null)], null);
}));

(cljs.core.async.t_cljs$core$async13763.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13763.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13763");

(cljs.core.async.t_cljs$core$async13763.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13763");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13763.
 */
cljs.core.async.__GT_t_cljs$core$async13763 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13763(f__$1,ch__$1,meta13764){
return (new cljs.core.async.t_cljs$core$async13763(f__$1,ch__$1,meta13764));
});

}

return (new cljs.core.async.t_cljs$core$async13763(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13766 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13766 = (function (p,ch,meta13767){
this.p = p;
this.ch = ch;
this.meta13767 = meta13767;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13766.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13768,meta13767__$1){
var self__ = this;
var _13768__$1 = this;
return (new cljs.core.async.t_cljs$core$async13766(self__.p,self__.ch,meta13767__$1));
}));

(cljs.core.async.t_cljs$core$async13766.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13768){
var self__ = this;
var _13768__$1 = this;
return self__.meta13767;
}));

(cljs.core.async.t_cljs$core$async13766.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13766.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13766.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async13766.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13766.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async13766.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13766.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async13766.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13767","meta13767",-1679713825,null)], null);
}));

(cljs.core.async.t_cljs$core$async13766.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13766.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13766");

(cljs.core.async.t_cljs$core$async13766.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async13766");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13766.
 */
cljs.core.async.__GT_t_cljs$core$async13766 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13766(p__$1,ch__$1,meta13767){
return (new cljs.core.async.t_cljs$core$async13766(p__$1,ch__$1,meta13767));
});

}

return (new cljs.core.async.t_cljs$core$async13766(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__13770 = arguments.length;
switch (G__13770) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12569__auto___14632 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13791){
var state_val_13792 = (state_13791[(1)]);
if((state_val_13792 === (7))){
var inst_13787 = (state_13791[(2)]);
var state_13791__$1 = state_13791;
var statearr_13793_14633 = state_13791__$1;
(statearr_13793_14633[(2)] = inst_13787);

(statearr_13793_14633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13792 === (1))){
var state_13791__$1 = state_13791;
var statearr_13794_14634 = state_13791__$1;
(statearr_13794_14634[(2)] = null);

(statearr_13794_14634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13792 === (4))){
var inst_13773 = (state_13791[(7)]);
var inst_13773__$1 = (state_13791[(2)]);
var inst_13774 = (inst_13773__$1 == null);
var state_13791__$1 = (function (){var statearr_13795 = state_13791;
(statearr_13795[(7)] = inst_13773__$1);

return statearr_13795;
})();
if(cljs.core.truth_(inst_13774)){
var statearr_13796_14635 = state_13791__$1;
(statearr_13796_14635[(1)] = (5));

} else {
var statearr_13797_14636 = state_13791__$1;
(statearr_13797_14636[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13792 === (6))){
var inst_13773 = (state_13791[(7)]);
var inst_13778 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_13773) : p.call(null,inst_13773));
var state_13791__$1 = state_13791;
if(cljs.core.truth_(inst_13778)){
var statearr_13798_14637 = state_13791__$1;
(statearr_13798_14637[(1)] = (8));

} else {
var statearr_13799_14638 = state_13791__$1;
(statearr_13799_14638[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13792 === (3))){
var inst_13789 = (state_13791[(2)]);
var state_13791__$1 = state_13791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13791__$1,inst_13789);
} else {
if((state_val_13792 === (2))){
var state_13791__$1 = state_13791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13791__$1,(4),ch);
} else {
if((state_val_13792 === (11))){
var inst_13781 = (state_13791[(2)]);
var state_13791__$1 = state_13791;
var statearr_13800_14639 = state_13791__$1;
(statearr_13800_14639[(2)] = inst_13781);

(statearr_13800_14639[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13792 === (9))){
var state_13791__$1 = state_13791;
var statearr_13801_14640 = state_13791__$1;
(statearr_13801_14640[(2)] = null);

(statearr_13801_14640[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13792 === (5))){
var inst_13776 = cljs.core.async.close_BANG_(out);
var state_13791__$1 = state_13791;
var statearr_13802_14642 = state_13791__$1;
(statearr_13802_14642[(2)] = inst_13776);

(statearr_13802_14642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13792 === (10))){
var inst_13784 = (state_13791[(2)]);
var state_13791__$1 = (function (){var statearr_13803 = state_13791;
(statearr_13803[(8)] = inst_13784);

return statearr_13803;
})();
var statearr_13804_14646 = state_13791__$1;
(statearr_13804_14646[(2)] = null);

(statearr_13804_14646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13792 === (8))){
var inst_13773 = (state_13791[(7)]);
var state_13791__$1 = state_13791;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13791__$1,(11),out,inst_13773);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_13805 = [null,null,null,null,null,null,null,null,null];
(statearr_13805[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_13805[(1)] = (1));

return statearr_13805;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_13791){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13791);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13806){var ex__12537__auto__ = e13806;
var statearr_13807_14647 = state_13791;
(statearr_13807_14647[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13791[(4)]))){
var statearr_13808_14648 = state_13791;
(statearr_13808_14648[(1)] = cljs.core.first((state_13791[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14649 = state_13791;
state_13791 = G__14649;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_13791){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_13791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13809 = f__12570__auto__();
(statearr_13809[(6)] = c__12569__auto___14632);

return statearr_13809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__13811 = arguments.length;
switch (G__13811) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__12569__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13873){
var state_val_13874 = (state_13873[(1)]);
if((state_val_13874 === (7))){
var inst_13869 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
var statearr_13875_14651 = state_13873__$1;
(statearr_13875_14651[(2)] = inst_13869);

(statearr_13875_14651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (20))){
var inst_13839 = (state_13873[(7)]);
var inst_13850 = (state_13873[(2)]);
var inst_13851 = cljs.core.next(inst_13839);
var inst_13825 = inst_13851;
var inst_13826 = null;
var inst_13827 = (0);
var inst_13828 = (0);
var state_13873__$1 = (function (){var statearr_13876 = state_13873;
(statearr_13876[(8)] = inst_13850);

(statearr_13876[(9)] = inst_13827);

(statearr_13876[(10)] = inst_13825);

(statearr_13876[(11)] = inst_13828);

(statearr_13876[(12)] = inst_13826);

return statearr_13876;
})();
var statearr_13877_14652 = state_13873__$1;
(statearr_13877_14652[(2)] = null);

(statearr_13877_14652[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (1))){
var state_13873__$1 = state_13873;
var statearr_13878_14653 = state_13873__$1;
(statearr_13878_14653[(2)] = null);

(statearr_13878_14653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (4))){
var inst_13814 = (state_13873[(13)]);
var inst_13814__$1 = (state_13873[(2)]);
var inst_13815 = (inst_13814__$1 == null);
var state_13873__$1 = (function (){var statearr_13879 = state_13873;
(statearr_13879[(13)] = inst_13814__$1);

return statearr_13879;
})();
if(cljs.core.truth_(inst_13815)){
var statearr_13880_14654 = state_13873__$1;
(statearr_13880_14654[(1)] = (5));

} else {
var statearr_13881_14655 = state_13873__$1;
(statearr_13881_14655[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (15))){
var state_13873__$1 = state_13873;
var statearr_13885_14656 = state_13873__$1;
(statearr_13885_14656[(2)] = null);

(statearr_13885_14656[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (21))){
var state_13873__$1 = state_13873;
var statearr_13886_14657 = state_13873__$1;
(statearr_13886_14657[(2)] = null);

(statearr_13886_14657[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (13))){
var inst_13827 = (state_13873[(9)]);
var inst_13825 = (state_13873[(10)]);
var inst_13828 = (state_13873[(11)]);
var inst_13826 = (state_13873[(12)]);
var inst_13835 = (state_13873[(2)]);
var inst_13836 = (inst_13828 + (1));
var tmp13882 = inst_13827;
var tmp13883 = inst_13825;
var tmp13884 = inst_13826;
var inst_13825__$1 = tmp13883;
var inst_13826__$1 = tmp13884;
var inst_13827__$1 = tmp13882;
var inst_13828__$1 = inst_13836;
var state_13873__$1 = (function (){var statearr_13887 = state_13873;
(statearr_13887[(9)] = inst_13827__$1);

(statearr_13887[(10)] = inst_13825__$1);

(statearr_13887[(11)] = inst_13828__$1);

(statearr_13887[(14)] = inst_13835);

(statearr_13887[(12)] = inst_13826__$1);

return statearr_13887;
})();
var statearr_13888_14658 = state_13873__$1;
(statearr_13888_14658[(2)] = null);

(statearr_13888_14658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (22))){
var state_13873__$1 = state_13873;
var statearr_13889_14659 = state_13873__$1;
(statearr_13889_14659[(2)] = null);

(statearr_13889_14659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (6))){
var inst_13814 = (state_13873[(13)]);
var inst_13823 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_13814) : f.call(null,inst_13814));
var inst_13824 = cljs.core.seq(inst_13823);
var inst_13825 = inst_13824;
var inst_13826 = null;
var inst_13827 = (0);
var inst_13828 = (0);
var state_13873__$1 = (function (){var statearr_13890 = state_13873;
(statearr_13890[(9)] = inst_13827);

(statearr_13890[(10)] = inst_13825);

(statearr_13890[(11)] = inst_13828);

(statearr_13890[(12)] = inst_13826);

return statearr_13890;
})();
var statearr_13891_14660 = state_13873__$1;
(statearr_13891_14660[(2)] = null);

(statearr_13891_14660[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (17))){
var inst_13839 = (state_13873[(7)]);
var inst_13843 = cljs.core.chunk_first(inst_13839);
var inst_13844 = cljs.core.chunk_rest(inst_13839);
var inst_13845 = cljs.core.count(inst_13843);
var inst_13825 = inst_13844;
var inst_13826 = inst_13843;
var inst_13827 = inst_13845;
var inst_13828 = (0);
var state_13873__$1 = (function (){var statearr_13892 = state_13873;
(statearr_13892[(9)] = inst_13827);

(statearr_13892[(10)] = inst_13825);

(statearr_13892[(11)] = inst_13828);

(statearr_13892[(12)] = inst_13826);

return statearr_13892;
})();
var statearr_13893_14661 = state_13873__$1;
(statearr_13893_14661[(2)] = null);

(statearr_13893_14661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (3))){
var inst_13871 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13873__$1,inst_13871);
} else {
if((state_val_13874 === (12))){
var inst_13859 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
var statearr_13894_14662 = state_13873__$1;
(statearr_13894_14662[(2)] = inst_13859);

(statearr_13894_14662[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (2))){
var state_13873__$1 = state_13873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13873__$1,(4),in$);
} else {
if((state_val_13874 === (23))){
var inst_13867 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
var statearr_13895_14663 = state_13873__$1;
(statearr_13895_14663[(2)] = inst_13867);

(statearr_13895_14663[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (19))){
var inst_13854 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
var statearr_13896_14664 = state_13873__$1;
(statearr_13896_14664[(2)] = inst_13854);

(statearr_13896_14664[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (11))){
var inst_13825 = (state_13873[(10)]);
var inst_13839 = (state_13873[(7)]);
var inst_13839__$1 = cljs.core.seq(inst_13825);
var state_13873__$1 = (function (){var statearr_13897 = state_13873;
(statearr_13897[(7)] = inst_13839__$1);

return statearr_13897;
})();
if(inst_13839__$1){
var statearr_13898_14665 = state_13873__$1;
(statearr_13898_14665[(1)] = (14));

} else {
var statearr_13899_14666 = state_13873__$1;
(statearr_13899_14666[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (9))){
var inst_13861 = (state_13873[(2)]);
var inst_13862 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_13873__$1 = (function (){var statearr_13900 = state_13873;
(statearr_13900[(15)] = inst_13861);

return statearr_13900;
})();
if(cljs.core.truth_(inst_13862)){
var statearr_13901_14667 = state_13873__$1;
(statearr_13901_14667[(1)] = (21));

} else {
var statearr_13902_14668 = state_13873__$1;
(statearr_13902_14668[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (5))){
var inst_13817 = cljs.core.async.close_BANG_(out);
var state_13873__$1 = state_13873;
var statearr_13903_14669 = state_13873__$1;
(statearr_13903_14669[(2)] = inst_13817);

(statearr_13903_14669[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (14))){
var inst_13839 = (state_13873[(7)]);
var inst_13841 = cljs.core.chunked_seq_QMARK_(inst_13839);
var state_13873__$1 = state_13873;
if(inst_13841){
var statearr_13904_14670 = state_13873__$1;
(statearr_13904_14670[(1)] = (17));

} else {
var statearr_13905_14671 = state_13873__$1;
(statearr_13905_14671[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (16))){
var inst_13857 = (state_13873[(2)]);
var state_13873__$1 = state_13873;
var statearr_13906_14672 = state_13873__$1;
(statearr_13906_14672[(2)] = inst_13857);

(statearr_13906_14672[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13874 === (10))){
var inst_13828 = (state_13873[(11)]);
var inst_13826 = (state_13873[(12)]);
var inst_13833 = cljs.core._nth(inst_13826,inst_13828);
var state_13873__$1 = state_13873;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13873__$1,(13),out,inst_13833);
} else {
if((state_val_13874 === (18))){
var inst_13839 = (state_13873[(7)]);
var inst_13848 = cljs.core.first(inst_13839);
var state_13873__$1 = state_13873;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13873__$1,(20),out,inst_13848);
} else {
if((state_val_13874 === (8))){
var inst_13827 = (state_13873[(9)]);
var inst_13828 = (state_13873[(11)]);
var inst_13830 = (inst_13828 < inst_13827);
var inst_13831 = inst_13830;
var state_13873__$1 = state_13873;
if(cljs.core.truth_(inst_13831)){
var statearr_13907_14674 = state_13873__$1;
(statearr_13907_14674[(1)] = (10));

} else {
var statearr_13908_14675 = state_13873__$1;
(statearr_13908_14675[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__12534__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__12534__auto____0 = (function (){
var statearr_13909 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13909[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__12534__auto__);

(statearr_13909[(1)] = (1));

return statearr_13909;
});
var cljs$core$async$mapcat_STAR__$_state_machine__12534__auto____1 = (function (state_13873){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13873);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13910){var ex__12537__auto__ = e13910;
var statearr_13911_14679 = state_13873;
(statearr_13911_14679[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13873[(4)]))){
var statearr_13912_14680 = state_13873;
(statearr_13912_14680[(1)] = cljs.core.first((state_13873[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14681 = state_13873;
state_13873 = G__14681;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__12534__auto__ = function(state_13873){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__12534__auto____1.call(this,state_13873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__12534__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__12534__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13913 = f__12570__auto__();
(statearr_13913[(6)] = c__12569__auto__);

return statearr_13913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));

return c__12569__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__13915 = arguments.length;
switch (G__13915) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__13917 = arguments.length;
switch (G__13917) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__13919 = arguments.length;
switch (G__13919) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12569__auto___14685 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_13943){
var state_val_13944 = (state_13943[(1)]);
if((state_val_13944 === (7))){
var inst_13938 = (state_13943[(2)]);
var state_13943__$1 = state_13943;
var statearr_13945_14686 = state_13943__$1;
(statearr_13945_14686[(2)] = inst_13938);

(statearr_13945_14686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13944 === (1))){
var inst_13920 = null;
var state_13943__$1 = (function (){var statearr_13946 = state_13943;
(statearr_13946[(7)] = inst_13920);

return statearr_13946;
})();
var statearr_13947_14687 = state_13943__$1;
(statearr_13947_14687[(2)] = null);

(statearr_13947_14687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13944 === (4))){
var inst_13923 = (state_13943[(8)]);
var inst_13923__$1 = (state_13943[(2)]);
var inst_13924 = (inst_13923__$1 == null);
var inst_13925 = cljs.core.not(inst_13924);
var state_13943__$1 = (function (){var statearr_13948 = state_13943;
(statearr_13948[(8)] = inst_13923__$1);

return statearr_13948;
})();
if(inst_13925){
var statearr_13949_14689 = state_13943__$1;
(statearr_13949_14689[(1)] = (5));

} else {
var statearr_13950_14690 = state_13943__$1;
(statearr_13950_14690[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13944 === (6))){
var state_13943__$1 = state_13943;
var statearr_13951_14691 = state_13943__$1;
(statearr_13951_14691[(2)] = null);

(statearr_13951_14691[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13944 === (3))){
var inst_13940 = (state_13943[(2)]);
var inst_13941 = cljs.core.async.close_BANG_(out);
var state_13943__$1 = (function (){var statearr_13952 = state_13943;
(statearr_13952[(9)] = inst_13940);

return statearr_13952;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_13943__$1,inst_13941);
} else {
if((state_val_13944 === (2))){
var state_13943__$1 = state_13943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13943__$1,(4),ch);
} else {
if((state_val_13944 === (11))){
var inst_13923 = (state_13943[(8)]);
var inst_13932 = (state_13943[(2)]);
var inst_13920 = inst_13923;
var state_13943__$1 = (function (){var statearr_13953 = state_13943;
(statearr_13953[(10)] = inst_13932);

(statearr_13953[(7)] = inst_13920);

return statearr_13953;
})();
var statearr_13954_14692 = state_13943__$1;
(statearr_13954_14692[(2)] = null);

(statearr_13954_14692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13944 === (9))){
var inst_13923 = (state_13943[(8)]);
var state_13943__$1 = state_13943;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_13943__$1,(11),out,inst_13923);
} else {
if((state_val_13944 === (5))){
var inst_13923 = (state_13943[(8)]);
var inst_13920 = (state_13943[(7)]);
var inst_13927 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_13923,inst_13920);
var state_13943__$1 = state_13943;
if(inst_13927){
var statearr_13956_14693 = state_13943__$1;
(statearr_13956_14693[(1)] = (8));

} else {
var statearr_13957_14694 = state_13943__$1;
(statearr_13957_14694[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13944 === (10))){
var inst_13935 = (state_13943[(2)]);
var state_13943__$1 = state_13943;
var statearr_13958_14695 = state_13943__$1;
(statearr_13958_14695[(2)] = inst_13935);

(statearr_13958_14695[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13944 === (8))){
var inst_13920 = (state_13943[(7)]);
var tmp13955 = inst_13920;
var inst_13920__$1 = tmp13955;
var state_13943__$1 = (function (){var statearr_13959 = state_13943;
(statearr_13959[(7)] = inst_13920__$1);

return statearr_13959;
})();
var statearr_13960_14696 = state_13943__$1;
(statearr_13960_14696[(2)] = null);

(statearr_13960_14696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_13961 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13961[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_13961[(1)] = (1));

return statearr_13961;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_13943){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_13943);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e13962){var ex__12537__auto__ = e13962;
var statearr_13963_14697 = state_13943;
(statearr_13963_14697[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_13943[(4)]))){
var statearr_13964_14698 = state_13943;
(statearr_13964_14698[(1)] = cljs.core.first((state_13943[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14699 = state_13943;
state_13943 = G__14699;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_13943){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_13943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_13965 = f__12570__auto__();
(statearr_13965[(6)] = c__12569__auto___14685);

return statearr_13965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__13967 = arguments.length;
switch (G__13967) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12569__auto___14706 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_14005){
var state_val_14006 = (state_14005[(1)]);
if((state_val_14006 === (7))){
var inst_14001 = (state_14005[(2)]);
var state_14005__$1 = state_14005;
var statearr_14007_14707 = state_14005__$1;
(statearr_14007_14707[(2)] = inst_14001);

(statearr_14007_14707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (1))){
var inst_13968 = (new Array(n));
var inst_13969 = inst_13968;
var inst_13970 = (0);
var state_14005__$1 = (function (){var statearr_14008 = state_14005;
(statearr_14008[(7)] = inst_13970);

(statearr_14008[(8)] = inst_13969);

return statearr_14008;
})();
var statearr_14009_14708 = state_14005__$1;
(statearr_14009_14708[(2)] = null);

(statearr_14009_14708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (4))){
var inst_13973 = (state_14005[(9)]);
var inst_13973__$1 = (state_14005[(2)]);
var inst_13974 = (inst_13973__$1 == null);
var inst_13975 = cljs.core.not(inst_13974);
var state_14005__$1 = (function (){var statearr_14010 = state_14005;
(statearr_14010[(9)] = inst_13973__$1);

return statearr_14010;
})();
if(inst_13975){
var statearr_14011_14709 = state_14005__$1;
(statearr_14011_14709[(1)] = (5));

} else {
var statearr_14012_14710 = state_14005__$1;
(statearr_14012_14710[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (15))){
var inst_13995 = (state_14005[(2)]);
var state_14005__$1 = state_14005;
var statearr_14013_14712 = state_14005__$1;
(statearr_14013_14712[(2)] = inst_13995);

(statearr_14013_14712[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (13))){
var state_14005__$1 = state_14005;
var statearr_14014_14713 = state_14005__$1;
(statearr_14014_14713[(2)] = null);

(statearr_14014_14713[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (6))){
var inst_13970 = (state_14005[(7)]);
var inst_13991 = (inst_13970 > (0));
var state_14005__$1 = state_14005;
if(cljs.core.truth_(inst_13991)){
var statearr_14015_14714 = state_14005__$1;
(statearr_14015_14714[(1)] = (12));

} else {
var statearr_14016_14715 = state_14005__$1;
(statearr_14016_14715[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (3))){
var inst_14003 = (state_14005[(2)]);
var state_14005__$1 = state_14005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14005__$1,inst_14003);
} else {
if((state_val_14006 === (12))){
var inst_13969 = (state_14005[(8)]);
var inst_13993 = cljs.core.vec(inst_13969);
var state_14005__$1 = state_14005;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14005__$1,(15),out,inst_13993);
} else {
if((state_val_14006 === (2))){
var state_14005__$1 = state_14005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14005__$1,(4),ch);
} else {
if((state_val_14006 === (11))){
var inst_13985 = (state_14005[(2)]);
var inst_13986 = (new Array(n));
var inst_13969 = inst_13986;
var inst_13970 = (0);
var state_14005__$1 = (function (){var statearr_14017 = state_14005;
(statearr_14017[(7)] = inst_13970);

(statearr_14017[(8)] = inst_13969);

(statearr_14017[(10)] = inst_13985);

return statearr_14017;
})();
var statearr_14018_14720 = state_14005__$1;
(statearr_14018_14720[(2)] = null);

(statearr_14018_14720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (9))){
var inst_13969 = (state_14005[(8)]);
var inst_13983 = cljs.core.vec(inst_13969);
var state_14005__$1 = state_14005;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14005__$1,(11),out,inst_13983);
} else {
if((state_val_14006 === (5))){
var inst_13973 = (state_14005[(9)]);
var inst_13970 = (state_14005[(7)]);
var inst_13978 = (state_14005[(11)]);
var inst_13969 = (state_14005[(8)]);
var inst_13977 = (inst_13969[inst_13970] = inst_13973);
var inst_13978__$1 = (inst_13970 + (1));
var inst_13979 = (inst_13978__$1 < n);
var state_14005__$1 = (function (){var statearr_14019 = state_14005;
(statearr_14019[(12)] = inst_13977);

(statearr_14019[(11)] = inst_13978__$1);

return statearr_14019;
})();
if(cljs.core.truth_(inst_13979)){
var statearr_14020_14721 = state_14005__$1;
(statearr_14020_14721[(1)] = (8));

} else {
var statearr_14021_14722 = state_14005__$1;
(statearr_14021_14722[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (14))){
var inst_13998 = (state_14005[(2)]);
var inst_13999 = cljs.core.async.close_BANG_(out);
var state_14005__$1 = (function (){var statearr_14023 = state_14005;
(statearr_14023[(13)] = inst_13998);

return statearr_14023;
})();
var statearr_14024_14723 = state_14005__$1;
(statearr_14024_14723[(2)] = inst_13999);

(statearr_14024_14723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (10))){
var inst_13989 = (state_14005[(2)]);
var state_14005__$1 = state_14005;
var statearr_14025_14724 = state_14005__$1;
(statearr_14025_14724[(2)] = inst_13989);

(statearr_14025_14724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14006 === (8))){
var inst_13978 = (state_14005[(11)]);
var inst_13969 = (state_14005[(8)]);
var tmp14022 = inst_13969;
var inst_13969__$1 = tmp14022;
var inst_13970 = inst_13978;
var state_14005__$1 = (function (){var statearr_14026 = state_14005;
(statearr_14026[(7)] = inst_13970);

(statearr_14026[(8)] = inst_13969__$1);

return statearr_14026;
})();
var statearr_14027_14725 = state_14005__$1;
(statearr_14027_14725[(2)] = null);

(statearr_14027_14725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_14028 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14028[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_14028[(1)] = (1));

return statearr_14028;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_14005){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_14005);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e14029){var ex__12537__auto__ = e14029;
var statearr_14030_14726 = state_14005;
(statearr_14030_14726[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_14005[(4)]))){
var statearr_14031_14727 = state_14005;
(statearr_14031_14727[(1)] = cljs.core.first((state_14005[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14728 = state_14005;
state_14005 = G__14728;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_14005){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_14005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_14032 = f__12570__auto__();
(statearr_14032[(6)] = c__12569__auto___14706);

return statearr_14032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__14034 = arguments.length;
switch (G__14034) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__12569__auto___14730 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_14079){
var state_val_14080 = (state_14079[(1)]);
if((state_val_14080 === (7))){
var inst_14075 = (state_14079[(2)]);
var state_14079__$1 = state_14079;
var statearr_14081_14731 = state_14079__$1;
(statearr_14081_14731[(2)] = inst_14075);

(statearr_14081_14731[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (1))){
var inst_14035 = [];
var inst_14036 = inst_14035;
var inst_14037 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14079__$1 = (function (){var statearr_14082 = state_14079;
(statearr_14082[(7)] = inst_14036);

(statearr_14082[(8)] = inst_14037);

return statearr_14082;
})();
var statearr_14083_14732 = state_14079__$1;
(statearr_14083_14732[(2)] = null);

(statearr_14083_14732[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (4))){
var inst_14040 = (state_14079[(9)]);
var inst_14040__$1 = (state_14079[(2)]);
var inst_14041 = (inst_14040__$1 == null);
var inst_14042 = cljs.core.not(inst_14041);
var state_14079__$1 = (function (){var statearr_14084 = state_14079;
(statearr_14084[(9)] = inst_14040__$1);

return statearr_14084;
})();
if(inst_14042){
var statearr_14085_14733 = state_14079__$1;
(statearr_14085_14733[(1)] = (5));

} else {
var statearr_14086_14734 = state_14079__$1;
(statearr_14086_14734[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (15))){
var inst_14036 = (state_14079[(7)]);
var inst_14067 = cljs.core.vec(inst_14036);
var state_14079__$1 = state_14079;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14079__$1,(18),out,inst_14067);
} else {
if((state_val_14080 === (13))){
var inst_14062 = (state_14079[(2)]);
var state_14079__$1 = state_14079;
var statearr_14087_14735 = state_14079__$1;
(statearr_14087_14735[(2)] = inst_14062);

(statearr_14087_14735[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (6))){
var inst_14036 = (state_14079[(7)]);
var inst_14064 = inst_14036.length;
var inst_14065 = (inst_14064 > (0));
var state_14079__$1 = state_14079;
if(cljs.core.truth_(inst_14065)){
var statearr_14088_14736 = state_14079__$1;
(statearr_14088_14736[(1)] = (15));

} else {
var statearr_14089_14737 = state_14079__$1;
(statearr_14089_14737[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (17))){
var inst_14072 = (state_14079[(2)]);
var inst_14073 = cljs.core.async.close_BANG_(out);
var state_14079__$1 = (function (){var statearr_14090 = state_14079;
(statearr_14090[(10)] = inst_14072);

return statearr_14090;
})();
var statearr_14091_14738 = state_14079__$1;
(statearr_14091_14738[(2)] = inst_14073);

(statearr_14091_14738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (3))){
var inst_14077 = (state_14079[(2)]);
var state_14079__$1 = state_14079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14079__$1,inst_14077);
} else {
if((state_val_14080 === (12))){
var inst_14036 = (state_14079[(7)]);
var inst_14055 = cljs.core.vec(inst_14036);
var state_14079__$1 = state_14079;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14079__$1,(14),out,inst_14055);
} else {
if((state_val_14080 === (2))){
var state_14079__$1 = state_14079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14079__$1,(4),ch);
} else {
if((state_val_14080 === (11))){
var inst_14044 = (state_14079[(11)]);
var inst_14036 = (state_14079[(7)]);
var inst_14040 = (state_14079[(9)]);
var inst_14052 = inst_14036.push(inst_14040);
var tmp14092 = inst_14036;
var inst_14036__$1 = tmp14092;
var inst_14037 = inst_14044;
var state_14079__$1 = (function (){var statearr_14093 = state_14079;
(statearr_14093[(7)] = inst_14036__$1);

(statearr_14093[(12)] = inst_14052);

(statearr_14093[(8)] = inst_14037);

return statearr_14093;
})();
var statearr_14094_14740 = state_14079__$1;
(statearr_14094_14740[(2)] = null);

(statearr_14094_14740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (9))){
var inst_14037 = (state_14079[(8)]);
var inst_14048 = cljs.core.keyword_identical_QMARK_(inst_14037,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_14079__$1 = state_14079;
var statearr_14095_14741 = state_14079__$1;
(statearr_14095_14741[(2)] = inst_14048);

(statearr_14095_14741[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (5))){
var inst_14045 = (state_14079[(13)]);
var inst_14044 = (state_14079[(11)]);
var inst_14040 = (state_14079[(9)]);
var inst_14037 = (state_14079[(8)]);
var inst_14044__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_14040) : f.call(null,inst_14040));
var inst_14045__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14044__$1,inst_14037);
var state_14079__$1 = (function (){var statearr_14096 = state_14079;
(statearr_14096[(13)] = inst_14045__$1);

(statearr_14096[(11)] = inst_14044__$1);

return statearr_14096;
})();
if(inst_14045__$1){
var statearr_14097_14745 = state_14079__$1;
(statearr_14097_14745[(1)] = (8));

} else {
var statearr_14098_14746 = state_14079__$1;
(statearr_14098_14746[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (14))){
var inst_14044 = (state_14079[(11)]);
var inst_14040 = (state_14079[(9)]);
var inst_14057 = (state_14079[(2)]);
var inst_14058 = [];
var inst_14059 = inst_14058.push(inst_14040);
var inst_14036 = inst_14058;
var inst_14037 = inst_14044;
var state_14079__$1 = (function (){var statearr_14099 = state_14079;
(statearr_14099[(7)] = inst_14036);

(statearr_14099[(14)] = inst_14059);

(statearr_14099[(15)] = inst_14057);

(statearr_14099[(8)] = inst_14037);

return statearr_14099;
})();
var statearr_14100_14747 = state_14079__$1;
(statearr_14100_14747[(2)] = null);

(statearr_14100_14747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (16))){
var state_14079__$1 = state_14079;
var statearr_14101_14748 = state_14079__$1;
(statearr_14101_14748[(2)] = null);

(statearr_14101_14748[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (10))){
var inst_14050 = (state_14079[(2)]);
var state_14079__$1 = state_14079;
if(cljs.core.truth_(inst_14050)){
var statearr_14102_14749 = state_14079__$1;
(statearr_14102_14749[(1)] = (11));

} else {
var statearr_14103_14750 = state_14079__$1;
(statearr_14103_14750[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (18))){
var inst_14069 = (state_14079[(2)]);
var state_14079__$1 = state_14079;
var statearr_14104_14751 = state_14079__$1;
(statearr_14104_14751[(2)] = inst_14069);

(statearr_14104_14751[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14080 === (8))){
var inst_14045 = (state_14079[(13)]);
var state_14079__$1 = state_14079;
var statearr_14105_14752 = state_14079__$1;
(statearr_14105_14752[(2)] = inst_14045);

(statearr_14105_14752[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__12534__auto__ = null;
var cljs$core$async$state_machine__12534__auto____0 = (function (){
var statearr_14106 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14106[(0)] = cljs$core$async$state_machine__12534__auto__);

(statearr_14106[(1)] = (1));

return statearr_14106;
});
var cljs$core$async$state_machine__12534__auto____1 = (function (state_14079){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_14079);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e14107){var ex__12537__auto__ = e14107;
var statearr_14108_14753 = state_14079;
(statearr_14108_14753[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_14079[(4)]))){
var statearr_14109_14754 = state_14079;
(statearr_14109_14754[(1)] = cljs.core.first((state_14079[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14755 = state_14079;
state_14079 = G__14755;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
cljs$core$async$state_machine__12534__auto__ = function(state_14079){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__12534__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__12534__auto____1.call(this,state_14079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__12534__auto____0;
cljs$core$async$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__12534__auto____1;
return cljs$core$async$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_14110 = f__12570__auto__();
(statearr_14110[(6)] = c__12569__auto___14730);

return statearr_14110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
