goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__10231){
var vec__10232 = p__10231;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10232,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10232,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__10235 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__10235__$1 = (((G__10235 instanceof cljs.core.Keyword))?G__10235.fqn:null);
switch (G__10235__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__10239 = (function (){
var seq__10240 = cljs.core.seq(vars__$1);
var chunk__10241 = null;
var count__10242 = (0);
var i__10243 = (0);
while(true){
if((i__10243 < count__10242)){
var v = chunk__10241.cljs$core$IIndexed$_nth$arity$2(null,i__10243);
var temp__5753__auto___10489 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___10489)){
var t_10491 = temp__5753__auto___10489;
var G__10250_10492 = ((function (seq__10240,chunk__10241,count__10242,i__10243,t_10491,temp__5753__auto___10489,v,each_fixture_fn,G__10235,G__10235__$1,env,once_fixtures,each_fixtures,vec__10232,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_10491)));
});})(seq__10240,chunk__10241,count__10242,i__10243,t_10491,temp__5753__auto___10489,v,each_fixture_fn,G__10235,G__10235__$1,env,once_fixtures,each_fixtures,vec__10232,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__10250_10492) : each_fixture_fn.call(null,G__10250_10492));
} else {
}


var G__10493 = seq__10240;
var G__10494 = chunk__10241;
var G__10495 = count__10242;
var G__10496 = (i__10243 + (1));
seq__10240 = G__10493;
chunk__10241 = G__10494;
count__10242 = G__10495;
i__10243 = G__10496;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10240);
if(temp__5753__auto__){
var seq__10240__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10240__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__10240__$1);
var G__10497 = cljs.core.chunk_rest(seq__10240__$1);
var G__10498 = c__4638__auto__;
var G__10499 = cljs.core.count(c__4638__auto__);
var G__10500 = (0);
seq__10240 = G__10497;
chunk__10241 = G__10498;
count__10242 = G__10499;
i__10243 = G__10500;
continue;
} else {
var v = cljs.core.first(seq__10240__$1);
var temp__5753__auto___10501__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___10501__$1)){
var t_10502 = temp__5753__auto___10501__$1;
var G__10253_10503 = ((function (seq__10240,chunk__10241,count__10242,i__10243,t_10502,temp__5753__auto___10501__$1,v,seq__10240__$1,temp__5753__auto__,each_fixture_fn,G__10235,G__10235__$1,env,once_fixtures,each_fixtures,vec__10232,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_10502)));
});})(seq__10240,chunk__10241,count__10242,i__10243,t_10502,temp__5753__auto___10501__$1,v,seq__10240__$1,temp__5753__auto__,each_fixture_fn,G__10235,G__10235__$1,env,once_fixtures,each_fixtures,vec__10232,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__10253_10503) : each_fixture_fn.call(null,G__10253_10503));
} else {
}


var G__10504 = cljs.core.next(seq__10240__$1);
var G__10505 = null;
var G__10506 = (0);
var G__10507 = (0);
seq__10240 = G__10504;
chunk__10241 = G__10505;
count__10242 = G__10506;
i__10243 = G__10507;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__10238 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__10238.cljs$core$IFn$_invoke$arity$1 ? fexpr__10238.cljs$core$IFn$_invoke$arity$1(G__10239) : fexpr__10238.call(null,G__10239));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__10235__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__10230_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__10230_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__10256 = shadow.test.env.get_test_ns_info(ns);
var map__10256__$1 = cljs.core.__destructure_map(map__10256);
var test_ns = map__10256__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10256__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__10262,vars){
var map__10263 = p__10262;
var map__10263__$1 = cljs.core.__destructure_map(map__10263);
var env = map__10263__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10263__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__10266_10517 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__10268_10518 = null;
var count__10269_10519 = (0);
var i__10270_10520 = (0);
while(true){
if((i__10270_10520 < count__10269_10519)){
var vec__10283_10521 = chunk__10268_10518.cljs$core$IIndexed$_nth$arity$2(null,i__10270_10520);
var test_ns_10522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10283_10521,(0),null);
var ns_info_10523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10283_10521,(1),null);
var map__10286_10524 = ns_info_10523;
var map__10286_10525__$1 = cljs.core.__destructure_map(map__10286_10524);
var fixtures_10526 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10286_10525__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___10527 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_10526);
if(cljs.core.truth_(temp__5753__auto___10527)){
var fix_10528 = temp__5753__auto___10527;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_10522,fix_10528], 0));
} else {
}

var temp__5753__auto___10529 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_10526);
if(cljs.core.truth_(temp__5753__auto___10529)){
var fix_10530 = temp__5753__auto___10529;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_10522,fix_10530], 0));
} else {
}


var G__10531 = seq__10266_10517;
var G__10532 = chunk__10268_10518;
var G__10533 = count__10269_10519;
var G__10534 = (i__10270_10520 + (1));
seq__10266_10517 = G__10531;
chunk__10268_10518 = G__10532;
count__10269_10519 = G__10533;
i__10270_10520 = G__10534;
continue;
} else {
var temp__5753__auto___10535 = cljs.core.seq(seq__10266_10517);
if(temp__5753__auto___10535){
var seq__10266_10536__$1 = temp__5753__auto___10535;
if(cljs.core.chunked_seq_QMARK_(seq__10266_10536__$1)){
var c__4638__auto___10537 = cljs.core.chunk_first(seq__10266_10536__$1);
var G__10538 = cljs.core.chunk_rest(seq__10266_10536__$1);
var G__10539 = c__4638__auto___10537;
var G__10540 = cljs.core.count(c__4638__auto___10537);
var G__10541 = (0);
seq__10266_10517 = G__10538;
chunk__10268_10518 = G__10539;
count__10269_10519 = G__10540;
i__10270_10520 = G__10541;
continue;
} else {
var vec__10289_10542 = cljs.core.first(seq__10266_10536__$1);
var test_ns_10543 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10289_10542,(0),null);
var ns_info_10544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10289_10542,(1),null);
var map__10292_10545 = ns_info_10544;
var map__10292_10546__$1 = cljs.core.__destructure_map(map__10292_10545);
var fixtures_10547 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10292_10546__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___10548__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_10547);
if(cljs.core.truth_(temp__5753__auto___10548__$1)){
var fix_10549 = temp__5753__auto___10548__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_10543,fix_10549], 0));
} else {
}

var temp__5753__auto___10550__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_10547);
if(cljs.core.truth_(temp__5753__auto___10550__$1)){
var fix_10551 = temp__5753__auto___10550__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_10543,fix_10551], 0));
} else {
}


var G__10552 = cljs.core.next(seq__10266_10536__$1);
var G__10553 = null;
var G__10554 = (0);
var G__10555 = (0);
seq__10266_10517 = G__10552;
chunk__10268_10518 = G__10553;
count__10269_10519 = G__10554;
i__10270_10520 = G__10555;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10259_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__10259_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__10294 = cljs.test.get_current_env();
var map__10294__$1 = cljs.core.__destructure_map(map__10294);
var env = map__10294__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10294__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10294__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__10352 = arguments.length;
switch (G__10352) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__10359 = arguments.length;
switch (G__10359) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__10423 = shadow.test.env.get_test_ns_info(ns);
var map__10423__$1 = cljs.core.__destructure_map(map__10423);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10423__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__10438 = arguments.length;
switch (G__10438) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10436_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__10436_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__10445 = arguments.length;
switch (G__10445) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10442_SHARP_){
var or__4212__auto__ = (re == null);
if(or__4212__auto__){
return or__4212__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__10442_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
