goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_14836 = (function (this$){
var x__4509__auto__ = (((this$ == null))?null:this$);
var m__4510__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4510__auto__.call(null,this$));
} else {
var m__4508__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4508__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_14836(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_14837 = (function (this$){
var x__4509__auto__ = (((this$ == null))?null:this$);
var m__4510__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4510__auto__.call(null,this$));
} else {
var m__4508__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4508__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_14837(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__14175 = coll;
var G__14176 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__14175,G__14176) : shadow.dom.lazy_native_coll_seq.call(null,G__14175,G__14176));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4212__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__14231 = arguments.length;
switch (G__14231) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__14241 = arguments.length;
switch (G__14241) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__14251 = arguments.length;
switch (G__14251) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__14260 = arguments.length;
switch (G__14260) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__14271 = arguments.length;
switch (G__14271) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__14282 = arguments.length;
switch (G__14282) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4212__auto__ = (!((typeof document !== 'undefined')));
if(or__4212__auto__){
return or__4212__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e14295){if((e14295 instanceof Object)){
var e = e14295;
return console.log("didnt support attachEvent",el,e);
} else {
throw e14295;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4212__auto__ = (!((typeof document !== 'undefined')));
if(or__4212__auto__){
return or__4212__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__14300 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__14301 = null;
var count__14302 = (0);
var i__14303 = (0);
while(true){
if((i__14303 < count__14302)){
var el = chunk__14301.cljs$core$IIndexed$_nth$arity$2(null,i__14303);
var handler_14844__$1 = ((function (seq__14300,chunk__14301,count__14302,i__14303,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__14300,chunk__14301,count__14302,i__14303,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_14844__$1);


var G__14845 = seq__14300;
var G__14846 = chunk__14301;
var G__14847 = count__14302;
var G__14848 = (i__14303 + (1));
seq__14300 = G__14845;
chunk__14301 = G__14846;
count__14302 = G__14847;
i__14303 = G__14848;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14300);
if(temp__5753__auto__){
var seq__14300__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14300__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14300__$1);
var G__14849 = cljs.core.chunk_rest(seq__14300__$1);
var G__14850 = c__4638__auto__;
var G__14851 = cljs.core.count(c__4638__auto__);
var G__14852 = (0);
seq__14300 = G__14849;
chunk__14301 = G__14850;
count__14302 = G__14851;
i__14303 = G__14852;
continue;
} else {
var el = cljs.core.first(seq__14300__$1);
var handler_14853__$1 = ((function (seq__14300,chunk__14301,count__14302,i__14303,el,seq__14300__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__14300,chunk__14301,count__14302,i__14303,el,seq__14300__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_14853__$1);


var G__14854 = cljs.core.next(seq__14300__$1);
var G__14855 = null;
var G__14856 = (0);
var G__14857 = (0);
seq__14300 = G__14854;
chunk__14301 = G__14855;
count__14302 = G__14856;
i__14303 = G__14857;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__14313 = arguments.length;
switch (G__14313) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__14323 = cljs.core.seq(events);
var chunk__14324 = null;
var count__14325 = (0);
var i__14326 = (0);
while(true){
if((i__14326 < count__14325)){
var vec__14345 = chunk__14324.cljs$core$IIndexed$_nth$arity$2(null,i__14326);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14345,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14345,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__14859 = seq__14323;
var G__14860 = chunk__14324;
var G__14861 = count__14325;
var G__14862 = (i__14326 + (1));
seq__14323 = G__14859;
chunk__14324 = G__14860;
count__14325 = G__14861;
i__14326 = G__14862;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14323);
if(temp__5753__auto__){
var seq__14323__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14323__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14323__$1);
var G__14863 = cljs.core.chunk_rest(seq__14323__$1);
var G__14864 = c__4638__auto__;
var G__14865 = cljs.core.count(c__4638__auto__);
var G__14866 = (0);
seq__14323 = G__14863;
chunk__14324 = G__14864;
count__14325 = G__14865;
i__14326 = G__14866;
continue;
} else {
var vec__14348 = cljs.core.first(seq__14323__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14348,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14348,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__14867 = cljs.core.next(seq__14323__$1);
var G__14868 = null;
var G__14869 = (0);
var G__14870 = (0);
seq__14323 = G__14867;
chunk__14324 = G__14868;
count__14325 = G__14869;
i__14326 = G__14870;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__14351 = cljs.core.seq(styles);
var chunk__14352 = null;
var count__14353 = (0);
var i__14354 = (0);
while(true){
if((i__14354 < count__14353)){
var vec__14361 = chunk__14352.cljs$core$IIndexed$_nth$arity$2(null,i__14354);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14361,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14361,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__14871 = seq__14351;
var G__14872 = chunk__14352;
var G__14873 = count__14353;
var G__14874 = (i__14354 + (1));
seq__14351 = G__14871;
chunk__14352 = G__14872;
count__14353 = G__14873;
i__14354 = G__14874;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14351);
if(temp__5753__auto__){
var seq__14351__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14351__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14351__$1);
var G__14875 = cljs.core.chunk_rest(seq__14351__$1);
var G__14876 = c__4638__auto__;
var G__14877 = cljs.core.count(c__4638__auto__);
var G__14878 = (0);
seq__14351 = G__14875;
chunk__14352 = G__14876;
count__14353 = G__14877;
i__14354 = G__14878;
continue;
} else {
var vec__14364 = cljs.core.first(seq__14351__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14364,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14364,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__14879 = cljs.core.next(seq__14351__$1);
var G__14880 = null;
var G__14881 = (0);
var G__14882 = (0);
seq__14351 = G__14879;
chunk__14352 = G__14880;
count__14353 = G__14881;
i__14354 = G__14882;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__14367_14883 = key;
var G__14367_14884__$1 = (((G__14367_14883 instanceof cljs.core.Keyword))?G__14367_14883.fqn:null);
switch (G__14367_14884__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_14886 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4212__auto__ = goog.string.startsWith(ks_14886,"data-");
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return goog.string.startsWith(ks_14886,"aria-");
}
})())){
el.setAttribute(ks_14886,value);
} else {
(el[ks_14886] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__14395){
var map__14396 = p__14395;
var map__14396__$1 = cljs.core.__destructure_map(map__14396);
var props = map__14396__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14396__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__14398 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14398,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14398,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14398,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__14401 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__14401,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__14401;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__14404 = arguments.length;
switch (G__14404) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__14409){
var vec__14411 = p__14409;
var seq__14412 = cljs.core.seq(vec__14411);
var first__14413 = cljs.core.first(seq__14412);
var seq__14412__$1 = cljs.core.next(seq__14412);
var nn = first__14413;
var first__14413__$1 = cljs.core.first(seq__14412__$1);
var seq__14412__$2 = cljs.core.next(seq__14412__$1);
var np = first__14413__$1;
var nc = seq__14412__$2;
var node = vec__14411;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__14415 = nn;
var G__14416 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__14415,G__14416) : create_fn.call(null,G__14415,G__14416));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__14417 = nn;
var G__14418 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__14417,G__14418) : create_fn.call(null,G__14417,G__14418));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__14420 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14420,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14420,(1),null);
var seq__14426_14888 = cljs.core.seq(node_children);
var chunk__14427_14889 = null;
var count__14428_14890 = (0);
var i__14429_14891 = (0);
while(true){
if((i__14429_14891 < count__14428_14890)){
var child_struct_14892 = chunk__14427_14889.cljs$core$IIndexed$_nth$arity$2(null,i__14429_14891);
var children_14893 = shadow.dom.dom_node(child_struct_14892);
if(cljs.core.seq_QMARK_(children_14893)){
var seq__14452_14894 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_14893));
var chunk__14454_14895 = null;
var count__14455_14896 = (0);
var i__14456_14897 = (0);
while(true){
if((i__14456_14897 < count__14455_14896)){
var child_14898 = chunk__14454_14895.cljs$core$IIndexed$_nth$arity$2(null,i__14456_14897);
if(cljs.core.truth_(child_14898)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_14898);


var G__14899 = seq__14452_14894;
var G__14900 = chunk__14454_14895;
var G__14901 = count__14455_14896;
var G__14902 = (i__14456_14897 + (1));
seq__14452_14894 = G__14899;
chunk__14454_14895 = G__14900;
count__14455_14896 = G__14901;
i__14456_14897 = G__14902;
continue;
} else {
var G__14903 = seq__14452_14894;
var G__14904 = chunk__14454_14895;
var G__14905 = count__14455_14896;
var G__14906 = (i__14456_14897 + (1));
seq__14452_14894 = G__14903;
chunk__14454_14895 = G__14904;
count__14455_14896 = G__14905;
i__14456_14897 = G__14906;
continue;
}
} else {
var temp__5753__auto___14907 = cljs.core.seq(seq__14452_14894);
if(temp__5753__auto___14907){
var seq__14452_14908__$1 = temp__5753__auto___14907;
if(cljs.core.chunked_seq_QMARK_(seq__14452_14908__$1)){
var c__4638__auto___14909 = cljs.core.chunk_first(seq__14452_14908__$1);
var G__14910 = cljs.core.chunk_rest(seq__14452_14908__$1);
var G__14911 = c__4638__auto___14909;
var G__14912 = cljs.core.count(c__4638__auto___14909);
var G__14913 = (0);
seq__14452_14894 = G__14910;
chunk__14454_14895 = G__14911;
count__14455_14896 = G__14912;
i__14456_14897 = G__14913;
continue;
} else {
var child_14914 = cljs.core.first(seq__14452_14908__$1);
if(cljs.core.truth_(child_14914)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_14914);


var G__14915 = cljs.core.next(seq__14452_14908__$1);
var G__14916 = null;
var G__14917 = (0);
var G__14918 = (0);
seq__14452_14894 = G__14915;
chunk__14454_14895 = G__14916;
count__14455_14896 = G__14917;
i__14456_14897 = G__14918;
continue;
} else {
var G__14919 = cljs.core.next(seq__14452_14908__$1);
var G__14920 = null;
var G__14921 = (0);
var G__14922 = (0);
seq__14452_14894 = G__14919;
chunk__14454_14895 = G__14920;
count__14455_14896 = G__14921;
i__14456_14897 = G__14922;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_14893);
}


var G__14923 = seq__14426_14888;
var G__14924 = chunk__14427_14889;
var G__14925 = count__14428_14890;
var G__14926 = (i__14429_14891 + (1));
seq__14426_14888 = G__14923;
chunk__14427_14889 = G__14924;
count__14428_14890 = G__14925;
i__14429_14891 = G__14926;
continue;
} else {
var temp__5753__auto___14927 = cljs.core.seq(seq__14426_14888);
if(temp__5753__auto___14927){
var seq__14426_14928__$1 = temp__5753__auto___14927;
if(cljs.core.chunked_seq_QMARK_(seq__14426_14928__$1)){
var c__4638__auto___14929 = cljs.core.chunk_first(seq__14426_14928__$1);
var G__14930 = cljs.core.chunk_rest(seq__14426_14928__$1);
var G__14931 = c__4638__auto___14929;
var G__14932 = cljs.core.count(c__4638__auto___14929);
var G__14933 = (0);
seq__14426_14888 = G__14930;
chunk__14427_14889 = G__14931;
count__14428_14890 = G__14932;
i__14429_14891 = G__14933;
continue;
} else {
var child_struct_14934 = cljs.core.first(seq__14426_14928__$1);
var children_14935 = shadow.dom.dom_node(child_struct_14934);
if(cljs.core.seq_QMARK_(children_14935)){
var seq__14473_14936 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_14935));
var chunk__14475_14937 = null;
var count__14476_14938 = (0);
var i__14477_14939 = (0);
while(true){
if((i__14477_14939 < count__14476_14938)){
var child_14940 = chunk__14475_14937.cljs$core$IIndexed$_nth$arity$2(null,i__14477_14939);
if(cljs.core.truth_(child_14940)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_14940);


var G__14941 = seq__14473_14936;
var G__14942 = chunk__14475_14937;
var G__14943 = count__14476_14938;
var G__14944 = (i__14477_14939 + (1));
seq__14473_14936 = G__14941;
chunk__14475_14937 = G__14942;
count__14476_14938 = G__14943;
i__14477_14939 = G__14944;
continue;
} else {
var G__14945 = seq__14473_14936;
var G__14946 = chunk__14475_14937;
var G__14947 = count__14476_14938;
var G__14948 = (i__14477_14939 + (1));
seq__14473_14936 = G__14945;
chunk__14475_14937 = G__14946;
count__14476_14938 = G__14947;
i__14477_14939 = G__14948;
continue;
}
} else {
var temp__5753__auto___14949__$1 = cljs.core.seq(seq__14473_14936);
if(temp__5753__auto___14949__$1){
var seq__14473_14950__$1 = temp__5753__auto___14949__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14473_14950__$1)){
var c__4638__auto___14951 = cljs.core.chunk_first(seq__14473_14950__$1);
var G__14952 = cljs.core.chunk_rest(seq__14473_14950__$1);
var G__14953 = c__4638__auto___14951;
var G__14954 = cljs.core.count(c__4638__auto___14951);
var G__14955 = (0);
seq__14473_14936 = G__14952;
chunk__14475_14937 = G__14953;
count__14476_14938 = G__14954;
i__14477_14939 = G__14955;
continue;
} else {
var child_14956 = cljs.core.first(seq__14473_14950__$1);
if(cljs.core.truth_(child_14956)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_14956);


var G__14957 = cljs.core.next(seq__14473_14950__$1);
var G__14958 = null;
var G__14959 = (0);
var G__14960 = (0);
seq__14473_14936 = G__14957;
chunk__14475_14937 = G__14958;
count__14476_14938 = G__14959;
i__14477_14939 = G__14960;
continue;
} else {
var G__14961 = cljs.core.next(seq__14473_14950__$1);
var G__14962 = null;
var G__14963 = (0);
var G__14964 = (0);
seq__14473_14936 = G__14961;
chunk__14475_14937 = G__14962;
count__14476_14938 = G__14963;
i__14477_14939 = G__14964;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_14935);
}


var G__14965 = cljs.core.next(seq__14426_14928__$1);
var G__14966 = null;
var G__14967 = (0);
var G__14968 = (0);
seq__14426_14888 = G__14965;
chunk__14427_14889 = G__14966;
count__14428_14890 = G__14967;
i__14429_14891 = G__14968;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__14498 = cljs.core.seq(node);
var chunk__14499 = null;
var count__14500 = (0);
var i__14501 = (0);
while(true){
if((i__14501 < count__14500)){
var n = chunk__14499.cljs$core$IIndexed$_nth$arity$2(null,i__14501);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__14969 = seq__14498;
var G__14970 = chunk__14499;
var G__14971 = count__14500;
var G__14972 = (i__14501 + (1));
seq__14498 = G__14969;
chunk__14499 = G__14970;
count__14500 = G__14971;
i__14501 = G__14972;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14498);
if(temp__5753__auto__){
var seq__14498__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14498__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14498__$1);
var G__14973 = cljs.core.chunk_rest(seq__14498__$1);
var G__14974 = c__4638__auto__;
var G__14975 = cljs.core.count(c__4638__auto__);
var G__14976 = (0);
seq__14498 = G__14973;
chunk__14499 = G__14974;
count__14500 = G__14975;
i__14501 = G__14976;
continue;
} else {
var n = cljs.core.first(seq__14498__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__14977 = cljs.core.next(seq__14498__$1);
var G__14978 = null;
var G__14979 = (0);
var G__14980 = (0);
seq__14498 = G__14977;
chunk__14499 = G__14978;
count__14500 = G__14979;
i__14501 = G__14980;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__14511 = arguments.length;
switch (G__14511) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__14521 = arguments.length;
switch (G__14521) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__14533 = arguments.length;
switch (G__14533) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4212__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4824__auto__ = [];
var len__4818__auto___14984 = arguments.length;
var i__4819__auto___14985 = (0);
while(true){
if((i__4819__auto___14985 < len__4818__auto___14984)){
args__4824__auto__.push((arguments[i__4819__auto___14985]));

var G__14986 = (i__4819__auto___14985 + (1));
i__4819__auto___14985 = G__14986;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__14553_14987 = cljs.core.seq(nodes);
var chunk__14554_14988 = null;
var count__14555_14989 = (0);
var i__14556_14990 = (0);
while(true){
if((i__14556_14990 < count__14555_14989)){
var node_14991 = chunk__14554_14988.cljs$core$IIndexed$_nth$arity$2(null,i__14556_14990);
fragment.appendChild(shadow.dom._to_dom(node_14991));


var G__14992 = seq__14553_14987;
var G__14993 = chunk__14554_14988;
var G__14994 = count__14555_14989;
var G__14995 = (i__14556_14990 + (1));
seq__14553_14987 = G__14992;
chunk__14554_14988 = G__14993;
count__14555_14989 = G__14994;
i__14556_14990 = G__14995;
continue;
} else {
var temp__5753__auto___14996 = cljs.core.seq(seq__14553_14987);
if(temp__5753__auto___14996){
var seq__14553_14997__$1 = temp__5753__auto___14996;
if(cljs.core.chunked_seq_QMARK_(seq__14553_14997__$1)){
var c__4638__auto___14998 = cljs.core.chunk_first(seq__14553_14997__$1);
var G__14999 = cljs.core.chunk_rest(seq__14553_14997__$1);
var G__15000 = c__4638__auto___14998;
var G__15001 = cljs.core.count(c__4638__auto___14998);
var G__15002 = (0);
seq__14553_14987 = G__14999;
chunk__14554_14988 = G__15000;
count__14555_14989 = G__15001;
i__14556_14990 = G__15002;
continue;
} else {
var node_15003 = cljs.core.first(seq__14553_14997__$1);
fragment.appendChild(shadow.dom._to_dom(node_15003));


var G__15004 = cljs.core.next(seq__14553_14997__$1);
var G__15005 = null;
var G__15006 = (0);
var G__15007 = (0);
seq__14553_14987 = G__15004;
chunk__14554_14988 = G__15005;
count__14555_14989 = G__15006;
i__14556_14990 = G__15007;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq14547){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq14547));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__14569_15008 = cljs.core.seq(scripts);
var chunk__14570_15009 = null;
var count__14571_15010 = (0);
var i__14572_15011 = (0);
while(true){
if((i__14572_15011 < count__14571_15010)){
var vec__14584_15012 = chunk__14570_15009.cljs$core$IIndexed$_nth$arity$2(null,i__14572_15011);
var script_tag_15013 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14584_15012,(0),null);
var script_body_15014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14584_15012,(1),null);
eval(script_body_15014);


var G__15015 = seq__14569_15008;
var G__15016 = chunk__14570_15009;
var G__15017 = count__14571_15010;
var G__15018 = (i__14572_15011 + (1));
seq__14569_15008 = G__15015;
chunk__14570_15009 = G__15016;
count__14571_15010 = G__15017;
i__14572_15011 = G__15018;
continue;
} else {
var temp__5753__auto___15019 = cljs.core.seq(seq__14569_15008);
if(temp__5753__auto___15019){
var seq__14569_15020__$1 = temp__5753__auto___15019;
if(cljs.core.chunked_seq_QMARK_(seq__14569_15020__$1)){
var c__4638__auto___15021 = cljs.core.chunk_first(seq__14569_15020__$1);
var G__15022 = cljs.core.chunk_rest(seq__14569_15020__$1);
var G__15023 = c__4638__auto___15021;
var G__15024 = cljs.core.count(c__4638__auto___15021);
var G__15025 = (0);
seq__14569_15008 = G__15022;
chunk__14570_15009 = G__15023;
count__14571_15010 = G__15024;
i__14572_15011 = G__15025;
continue;
} else {
var vec__14591_15026 = cljs.core.first(seq__14569_15020__$1);
var script_tag_15027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14591_15026,(0),null);
var script_body_15028 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14591_15026,(1),null);
eval(script_body_15028);


var G__15029 = cljs.core.next(seq__14569_15020__$1);
var G__15030 = null;
var G__15031 = (0);
var G__15032 = (0);
seq__14569_15008 = G__15029;
chunk__14570_15009 = G__15030;
count__14571_15010 = G__15031;
i__14572_15011 = G__15032;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__14596){
var vec__14597 = p__14596;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14597,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14597,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__14608 = arguments.length;
switch (G__14608) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__14621 = cljs.core.seq(style_keys);
var chunk__14622 = null;
var count__14623 = (0);
var i__14624 = (0);
while(true){
if((i__14624 < count__14623)){
var it = chunk__14622.cljs$core$IIndexed$_nth$arity$2(null,i__14624);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__15034 = seq__14621;
var G__15035 = chunk__14622;
var G__15036 = count__14623;
var G__15037 = (i__14624 + (1));
seq__14621 = G__15034;
chunk__14622 = G__15035;
count__14623 = G__15036;
i__14624 = G__15037;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14621);
if(temp__5753__auto__){
var seq__14621__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14621__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__14621__$1);
var G__15038 = cljs.core.chunk_rest(seq__14621__$1);
var G__15039 = c__4638__auto__;
var G__15040 = cljs.core.count(c__4638__auto__);
var G__15041 = (0);
seq__14621 = G__15038;
chunk__14622 = G__15039;
count__14623 = G__15040;
i__14624 = G__15041;
continue;
} else {
var it = cljs.core.first(seq__14621__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__15042 = cljs.core.next(seq__14621__$1);
var G__15043 = null;
var G__15044 = (0);
var G__15045 = (0);
seq__14621 = G__15042;
chunk__14622 = G__15043;
count__14623 = G__15044;
i__14624 = G__15045;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k14626,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__14630 = k14626;
var G__14630__$1 = (((G__14630 instanceof cljs.core.Keyword))?G__14630.fqn:null);
switch (G__14630__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14626,else__4464__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__14641){
var vec__14643 = p__14641;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14643,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14643,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14625){
var self__ = this;
var G__14625__$1 = this;
return (new cljs.core.RecordIter((0),G__14625__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
})(this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14627,other14628){
var self__ = this;
var this14627__$1 = this;
return (((!((other14628 == null)))) && ((((this14627__$1.constructor === other14628.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14627__$1.x,other14628.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14627__$1.y,other14628.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14627__$1.__extmap,other14628.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k14626){
var self__ = this;
var this__4468__auto____$1 = this;
var G__14673 = k14626;
var G__14673__$1 = (((G__14673 instanceof cljs.core.Keyword))?G__14673.fqn:null);
switch (G__14673__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14626);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__14625){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__14676 = cljs.core.keyword_identical_QMARK_;
var expr__14677 = k__4470__auto__;
if(cljs.core.truth_((pred__14676.cljs$core$IFn$_invoke$arity$2 ? pred__14676.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__14677) : pred__14676.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__14677)))){
return (new shadow.dom.Coordinate(G__14625,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__14676.cljs$core$IFn$_invoke$arity$2 ? pred__14676.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__14677) : pred__14676.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__14677)))){
return (new shadow.dom.Coordinate(self__.x,G__14625,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__14625),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__14625){
var self__ = this;
var this__4460__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__14625,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4467__auto__,(0)),cljs.core._nth(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__14629){
var extmap__4501__auto__ = (function (){var G__14688 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14629,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__14629)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14688);
} else {
return G__14688;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__14629),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__14629),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k14701,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__14711 = k14701;
var G__14711__$1 = (((G__14711 instanceof cljs.core.Keyword))?G__14711.fqn:null);
switch (G__14711__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14701,else__4464__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__14716){
var vec__14717 = p__14716;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14717,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14717,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#shadow.dom.Size{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14700){
var self__ = this;
var G__14700__$1 = this;
return (new cljs.core.RecordIter((0),G__14700__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (coll__4458__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
})(this__4457__auto____$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14702,other14703){
var self__ = this;
var this14702__$1 = this;
return (((!((other14703 == null)))) && ((((this14702__$1.constructor === other14703.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14702__$1.w,other14703.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14702__$1.h,other14703.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14702__$1.__extmap,other14703.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k14701){
var self__ = this;
var this__4468__auto____$1 = this;
var G__14739 = k14701;
var G__14739__$1 = (((G__14739 instanceof cljs.core.Keyword))?G__14739.fqn:null);
switch (G__14739__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14701);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__14700){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__14742 = cljs.core.keyword_identical_QMARK_;
var expr__14743 = k__4470__auto__;
if(cljs.core.truth_((pred__14742.cljs$core$IFn$_invoke$arity$2 ? pred__14742.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__14743) : pred__14742.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__14743)))){
return (new shadow.dom.Size(G__14700,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__14742.cljs$core$IFn$_invoke$arity$2 ? pred__14742.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__14743) : pred__14742.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__14743)))){
return (new shadow.dom.Size(self__.w,G__14700,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__14700),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__14700){
var self__ = this;
var this__4460__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__14700,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4467__auto__,(0)),cljs.core._nth(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__14705){
var extmap__4501__auto__ = (function (){var G__14756 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14705,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__14705)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14756);
} else {
return G__14756;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__14705),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__14705),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4692__auto__ = opts;
var l__4693__auto__ = a__4692__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4693__auto__)){
var G__15050 = (i + (1));
var G__15051 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__15050;
ret = G__15051;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14761){
var vec__14762 = p__14761;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14762,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14762,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__14766 = arguments.length;
switch (G__14766) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__15053 = ps;
var G__15054 = (i + (1));
el__$1 = G__15053;
i = G__15054;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__14767 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14767,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14767,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14767,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__14770_15055 = cljs.core.seq(props);
var chunk__14771_15056 = null;
var count__14772_15057 = (0);
var i__14773_15058 = (0);
while(true){
if((i__14773_15058 < count__14772_15057)){
var vec__14780_15059 = chunk__14771_15056.cljs$core$IIndexed$_nth$arity$2(null,i__14773_15058);
var k_15060 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14780_15059,(0),null);
var v_15061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14780_15059,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_15060);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_15060),v_15061);


var G__15062 = seq__14770_15055;
var G__15063 = chunk__14771_15056;
var G__15064 = count__14772_15057;
var G__15065 = (i__14773_15058 + (1));
seq__14770_15055 = G__15062;
chunk__14771_15056 = G__15063;
count__14772_15057 = G__15064;
i__14773_15058 = G__15065;
continue;
} else {
var temp__5753__auto___15066 = cljs.core.seq(seq__14770_15055);
if(temp__5753__auto___15066){
var seq__14770_15067__$1 = temp__5753__auto___15066;
if(cljs.core.chunked_seq_QMARK_(seq__14770_15067__$1)){
var c__4638__auto___15068 = cljs.core.chunk_first(seq__14770_15067__$1);
var G__15069 = cljs.core.chunk_rest(seq__14770_15067__$1);
var G__15070 = c__4638__auto___15068;
var G__15071 = cljs.core.count(c__4638__auto___15068);
var G__15072 = (0);
seq__14770_15055 = G__15069;
chunk__14771_15056 = G__15070;
count__14772_15057 = G__15071;
i__14773_15058 = G__15072;
continue;
} else {
var vec__14783_15073 = cljs.core.first(seq__14770_15067__$1);
var k_15074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14783_15073,(0),null);
var v_15075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14783_15073,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_15074);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_15074),v_15075);


var G__15076 = cljs.core.next(seq__14770_15067__$1);
var G__15077 = null;
var G__15078 = (0);
var G__15079 = (0);
seq__14770_15055 = G__15076;
chunk__14771_15056 = G__15077;
count__14772_15057 = G__15078;
i__14773_15058 = G__15079;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__14787 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14787,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14787,(1),null);
var seq__14790_15080 = cljs.core.seq(node_children);
var chunk__14792_15081 = null;
var count__14793_15082 = (0);
var i__14794_15083 = (0);
while(true){
if((i__14794_15083 < count__14793_15082)){
var child_struct_15084 = chunk__14792_15081.cljs$core$IIndexed$_nth$arity$2(null,i__14794_15083);
if((!((child_struct_15084 == null)))){
if(typeof child_struct_15084 === 'string'){
var text_15085 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_15085),child_struct_15084].join(''));
} else {
var children_15086 = shadow.dom.svg_node(child_struct_15084);
if(cljs.core.seq_QMARK_(children_15086)){
var seq__14808_15087 = cljs.core.seq(children_15086);
var chunk__14810_15088 = null;
var count__14811_15089 = (0);
var i__14812_15090 = (0);
while(true){
if((i__14812_15090 < count__14811_15089)){
var child_15091 = chunk__14810_15088.cljs$core$IIndexed$_nth$arity$2(null,i__14812_15090);
if(cljs.core.truth_(child_15091)){
node.appendChild(child_15091);


var G__15092 = seq__14808_15087;
var G__15093 = chunk__14810_15088;
var G__15094 = count__14811_15089;
var G__15095 = (i__14812_15090 + (1));
seq__14808_15087 = G__15092;
chunk__14810_15088 = G__15093;
count__14811_15089 = G__15094;
i__14812_15090 = G__15095;
continue;
} else {
var G__15096 = seq__14808_15087;
var G__15097 = chunk__14810_15088;
var G__15098 = count__14811_15089;
var G__15099 = (i__14812_15090 + (1));
seq__14808_15087 = G__15096;
chunk__14810_15088 = G__15097;
count__14811_15089 = G__15098;
i__14812_15090 = G__15099;
continue;
}
} else {
var temp__5753__auto___15100 = cljs.core.seq(seq__14808_15087);
if(temp__5753__auto___15100){
var seq__14808_15101__$1 = temp__5753__auto___15100;
if(cljs.core.chunked_seq_QMARK_(seq__14808_15101__$1)){
var c__4638__auto___15102 = cljs.core.chunk_first(seq__14808_15101__$1);
var G__15103 = cljs.core.chunk_rest(seq__14808_15101__$1);
var G__15104 = c__4638__auto___15102;
var G__15105 = cljs.core.count(c__4638__auto___15102);
var G__15106 = (0);
seq__14808_15087 = G__15103;
chunk__14810_15088 = G__15104;
count__14811_15089 = G__15105;
i__14812_15090 = G__15106;
continue;
} else {
var child_15107 = cljs.core.first(seq__14808_15101__$1);
if(cljs.core.truth_(child_15107)){
node.appendChild(child_15107);


var G__15108 = cljs.core.next(seq__14808_15101__$1);
var G__15109 = null;
var G__15110 = (0);
var G__15111 = (0);
seq__14808_15087 = G__15108;
chunk__14810_15088 = G__15109;
count__14811_15089 = G__15110;
i__14812_15090 = G__15111;
continue;
} else {
var G__15112 = cljs.core.next(seq__14808_15101__$1);
var G__15113 = null;
var G__15114 = (0);
var G__15115 = (0);
seq__14808_15087 = G__15112;
chunk__14810_15088 = G__15113;
count__14811_15089 = G__15114;
i__14812_15090 = G__15115;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_15086);
}
}


var G__15116 = seq__14790_15080;
var G__15117 = chunk__14792_15081;
var G__15118 = count__14793_15082;
var G__15119 = (i__14794_15083 + (1));
seq__14790_15080 = G__15116;
chunk__14792_15081 = G__15117;
count__14793_15082 = G__15118;
i__14794_15083 = G__15119;
continue;
} else {
var G__15120 = seq__14790_15080;
var G__15121 = chunk__14792_15081;
var G__15122 = count__14793_15082;
var G__15123 = (i__14794_15083 + (1));
seq__14790_15080 = G__15120;
chunk__14792_15081 = G__15121;
count__14793_15082 = G__15122;
i__14794_15083 = G__15123;
continue;
}
} else {
var temp__5753__auto___15124 = cljs.core.seq(seq__14790_15080);
if(temp__5753__auto___15124){
var seq__14790_15125__$1 = temp__5753__auto___15124;
if(cljs.core.chunked_seq_QMARK_(seq__14790_15125__$1)){
var c__4638__auto___15126 = cljs.core.chunk_first(seq__14790_15125__$1);
var G__15127 = cljs.core.chunk_rest(seq__14790_15125__$1);
var G__15128 = c__4638__auto___15126;
var G__15129 = cljs.core.count(c__4638__auto___15126);
var G__15130 = (0);
seq__14790_15080 = G__15127;
chunk__14792_15081 = G__15128;
count__14793_15082 = G__15129;
i__14794_15083 = G__15130;
continue;
} else {
var child_struct_15131 = cljs.core.first(seq__14790_15125__$1);
if((!((child_struct_15131 == null)))){
if(typeof child_struct_15131 === 'string'){
var text_15132 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_15132),child_struct_15131].join(''));
} else {
var children_15133 = shadow.dom.svg_node(child_struct_15131);
if(cljs.core.seq_QMARK_(children_15133)){
var seq__14814_15134 = cljs.core.seq(children_15133);
var chunk__14816_15135 = null;
var count__14817_15136 = (0);
var i__14818_15137 = (0);
while(true){
if((i__14818_15137 < count__14817_15136)){
var child_15138 = chunk__14816_15135.cljs$core$IIndexed$_nth$arity$2(null,i__14818_15137);
if(cljs.core.truth_(child_15138)){
node.appendChild(child_15138);


var G__15139 = seq__14814_15134;
var G__15140 = chunk__14816_15135;
var G__15141 = count__14817_15136;
var G__15142 = (i__14818_15137 + (1));
seq__14814_15134 = G__15139;
chunk__14816_15135 = G__15140;
count__14817_15136 = G__15141;
i__14818_15137 = G__15142;
continue;
} else {
var G__15143 = seq__14814_15134;
var G__15144 = chunk__14816_15135;
var G__15145 = count__14817_15136;
var G__15146 = (i__14818_15137 + (1));
seq__14814_15134 = G__15143;
chunk__14816_15135 = G__15144;
count__14817_15136 = G__15145;
i__14818_15137 = G__15146;
continue;
}
} else {
var temp__5753__auto___15147__$1 = cljs.core.seq(seq__14814_15134);
if(temp__5753__auto___15147__$1){
var seq__14814_15148__$1 = temp__5753__auto___15147__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14814_15148__$1)){
var c__4638__auto___15149 = cljs.core.chunk_first(seq__14814_15148__$1);
var G__15150 = cljs.core.chunk_rest(seq__14814_15148__$1);
var G__15151 = c__4638__auto___15149;
var G__15152 = cljs.core.count(c__4638__auto___15149);
var G__15153 = (0);
seq__14814_15134 = G__15150;
chunk__14816_15135 = G__15151;
count__14817_15136 = G__15152;
i__14818_15137 = G__15153;
continue;
} else {
var child_15154 = cljs.core.first(seq__14814_15148__$1);
if(cljs.core.truth_(child_15154)){
node.appendChild(child_15154);


var G__15155 = cljs.core.next(seq__14814_15148__$1);
var G__15156 = null;
var G__15157 = (0);
var G__15158 = (0);
seq__14814_15134 = G__15155;
chunk__14816_15135 = G__15156;
count__14817_15136 = G__15157;
i__14818_15137 = G__15158;
continue;
} else {
var G__15159 = cljs.core.next(seq__14814_15148__$1);
var G__15160 = null;
var G__15161 = (0);
var G__15162 = (0);
seq__14814_15134 = G__15159;
chunk__14816_15135 = G__15160;
count__14817_15136 = G__15161;
i__14818_15137 = G__15162;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_15133);
}
}


var G__15163 = cljs.core.next(seq__14790_15125__$1);
var G__15164 = null;
var G__15165 = (0);
var G__15166 = (0);
seq__14790_15080 = G__15163;
chunk__14792_15081 = G__15164;
count__14793_15082 = G__15165;
i__14794_15083 = G__15166;
continue;
} else {
var G__15167 = cljs.core.next(seq__14790_15125__$1);
var G__15168 = null;
var G__15169 = (0);
var G__15170 = (0);
seq__14790_15080 = G__15167;
chunk__14792_15081 = G__15168;
count__14793_15082 = G__15169;
i__14794_15083 = G__15170;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4824__auto__ = [];
var len__4818__auto___15171 = arguments.length;
var i__4819__auto___15172 = (0);
while(true){
if((i__4819__auto___15172 < len__4818__auto___15171)){
args__4824__auto__.push((arguments[i__4819__auto___15172]));

var G__15173 = (i__4819__auto___15172 + (1));
i__4819__auto___15172 = G__15173;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq14820){
var G__14821 = cljs.core.first(seq14820);
var seq14820__$1 = cljs.core.next(seq14820);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14821,seq14820__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__14823 = arguments.length;
switch (G__14823) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4210__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4210__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4210__auto__;
}
})())){
var c__12569__auto___15175 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__12570__auto__ = (function (){var switch__12533__auto__ = (function (state_14828){
var state_val_14829 = (state_14828[(1)]);
if((state_val_14829 === (1))){
var state_14828__$1 = state_14828;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14828__$1,(2),once_or_cleanup);
} else {
if((state_val_14829 === (2))){
var inst_14825 = (state_14828[(2)]);
var inst_14826 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_14828__$1 = (function (){var statearr_14830 = state_14828;
(statearr_14830[(7)] = inst_14825);

return statearr_14830;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14828__$1,inst_14826);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__12534__auto__ = null;
var shadow$dom$state_machine__12534__auto____0 = (function (){
var statearr_14831 = [null,null,null,null,null,null,null,null];
(statearr_14831[(0)] = shadow$dom$state_machine__12534__auto__);

(statearr_14831[(1)] = (1));

return statearr_14831;
});
var shadow$dom$state_machine__12534__auto____1 = (function (state_14828){
while(true){
var ret_value__12535__auto__ = (function (){try{while(true){
var result__12536__auto__ = switch__12533__auto__(state_14828);
if(cljs.core.keyword_identical_QMARK_(result__12536__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__12536__auto__;
}
break;
}
}catch (e14832){var ex__12537__auto__ = e14832;
var statearr_14833_15176 = state_14828;
(statearr_14833_15176[(2)] = ex__12537__auto__);


if(cljs.core.seq((state_14828[(4)]))){
var statearr_14834_15177 = state_14828;
(statearr_14834_15177[(1)] = cljs.core.first((state_14828[(4)])));

} else {
throw ex__12537__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12535__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15178 = state_14828;
state_14828 = G__15178;
continue;
} else {
return ret_value__12535__auto__;
}
break;
}
});
shadow$dom$state_machine__12534__auto__ = function(state_14828){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__12534__auto____0.call(this);
case 1:
return shadow$dom$state_machine__12534__auto____1.call(this,state_14828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__12534__auto____0;
shadow$dom$state_machine__12534__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__12534__auto____1;
return shadow$dom$state_machine__12534__auto__;
})()
})();
var state__12571__auto__ = (function (){var statearr_14835 = f__12570__auto__();
(statearr_14835[(6)] = c__12569__auto___15175);

return statearr_14835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12571__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
