/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.configurations.sources;

import io.slingr.services.configurations.sources.PropertySource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmPropertiesSource
implements PropertySource {
    private static final Logger logger = LoggerFactory.getLogger(JvmPropertiesSource.class);

    @Override
    public String findProperty(String propertyName) {
        if (StringUtils.isNotBlank((CharSequence)propertyName)) {
            try {
                return System.getProperty(propertyName);
            }
            catch (Exception ex) {
                logger.warn(String.format("Property [%s] on JVM properties is invalid and will be ignored: %s", propertyName, ex.getMessage()));
            }
        }
        return null;
    }
}

