/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.concurrency;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyService {
    private final Logger logger = LoggerFactory.getLogger(ConcurrencyService.class);
    private static final int MAX_THREADS = 10;
    private static final int SLEEP_TIME = 100;
    private ExecutorService executor = Executors.newFixedThreadPool(10);
    private volatile boolean running = Boolean.FALSE;
    private Queue<Task> pendingTasks = new LinkedList<Task>();

    public void start() {
        this.running = true;
        this.logger.info("Starting services concurrency service");
        while (this.running) {
            Task task = this.pendingTasks.poll();
            if (task != null) {
                if (((ThreadPoolExecutor)this.executor).getActiveCount() < 10) {
                    this.executor.execute(task);
                    continue;
                }
                this.pendingTasks.add(task);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        this.logger.info("Stopping services concurrency service");
        this.running = false;
        this.pendingTasks.clear();
        this.executor.shutdown();
    }

    public void queueTask(Task task) {
        this.pendingTasks.add(task);
    }

    public static interface Task
    extends Runnable {
    }
}

