/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.configurations;

import io.slingr.services.utils.ThreadAttributes;
import org.apache.commons.lang.StringUtils;

public class ServiceContext {
    public static void initContext(String app, String env) {
        if (!StringUtils.isBlank((String)app)) {
            ServiceContext.setCurrentApp(app);
        }
        if (!StringUtils.isBlank((String)env)) {
            ServiceContext.setCurrentEnv(env);
        }
    }

    public static String getCurrentApp() {
        return (String)ThreadAttributes.get("app");
    }

    public static void setCurrentApp(String app) {
        ThreadAttributes.set("app", app);
    }

    public static void setCurrentEnv(String env) {
        ThreadAttributes.set("env", env);
    }

    public static String getCurrentEnv() {
        return (String)ThreadAttributes.get("env");
    }

    public static String getCurrentProvision() {
        if (ServiceContext.getCurrentApp() != null && ServiceContext.getCurrentEnv() != null) {
            return ServiceContext.getCurrentApp() + "-" + ServiceContext.getCurrentEnv();
        }
        return null;
    }

    public static void endContext() {
        ServiceContext.setCurrentApp(null);
        ServiceContext.setCurrentEnv(null);
    }
}

