/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework;

import io.slingr.services.framework.annotations.classes.ClassWebService;
import io.slingr.services.framework.annotations.classes.MethodAccessorType;
import io.slingr.services.framework.annotations.classes.MethodParameterType;
import io.slingr.services.framework.annotations.classes.WebServiceResponseType;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.utils.Json;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredWebService
implements Comparable<RegisteredWebService> {
    private static final Logger logger = LoggerFactory.getLogger(RegisteredWebService.class);
    private final String key;
    private final String name;
    private final RestMethod restMethod;
    private final String path;
    private final String method;
    private final MethodParameterType parameterType;
    private final WebServiceResponseType responseType;
    private final MethodAccessorType accessorType;
    private final Map<String, Integer> variables = new HashMap<String, Integer>();
    private final Pattern pattern;
    private final Pattern extractPattern;
    private final Class<?> serviceClass;
    private static Method namedGroupsMethod = null;

    public RegisteredWebService(String name, RestMethod restMethod, String path, String method, MethodParameterType parameterType, WebServiceResponseType responseType, MethodAccessorType accessorType) {
        this(name, restMethod, path, method, parameterType, responseType, accessorType, null);
    }

    public RegisteredWebService(String name, RestMethod restMethod, String path, String method, MethodParameterType parameterType, WebServiceResponseType responseType, MethodAccessorType accessorType, Class<?> serviceClass) {
        this.name = name;
        this.restMethod = restMethod;
        this.path = path;
        this.method = method;
        this.parameterType = parameterType;
        this.responseType = responseType;
        this.accessorType = accessorType;
        this.serviceClass = serviceClass;
        String cleanedPath = ClassWebService.cleanPath(path);
        String regex = cleanedPath.replaceAll("/", "\\/").replaceAll("\\{\\w+:(.*)}", "$1").replaceAll("\\{\\w+}", "[\\\\w\\\\-\\\\.]+").replaceAll("\\*", ".+");
        String extractRegex = cleanedPath.replaceAll("/", "\\/").replaceAll("\\{(\\w+):(.*)}", "(?<$1>$2)").replaceAll("\\{(\\w+)}", "(?<$1>[\\\\w\\\\-\\\\.]+)").replaceAll("\\*", ".+");
        this.pattern = Pattern.compile(String.format("\\/?%s\\/?", regex), 2);
        this.extractPattern = Pattern.compile(String.format("\\/?%s\\/?", extractRegex), 2);
        if (namedGroupsMethod != null) {
            try {
                Map namedGroups = (Map)namedGroupsMethod.invoke((Object)this.extractPattern, new Object[0]);
                if (namedGroups != null && !namedGroups.isEmpty()) {
                    this.variables.putAll(namedGroups);
                }
            }
            catch (Exception ex) {
                logger.error(String.format("Service can not extract variables from web services path [%s]: %s", path, ex.getMessage()), (Throwable)ex);
            }
        }
        this.key = name.replaceAll("\\{[\\w\\-.]+:([\\w\\-\\.]+)}", "aaaaaaa-filter-zz$1").replaceAll("\\{[\\w\\-.]+}", "aaaaaaa-filter-aa").replaceAll("\\*", "aaaaaaa-filter").toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public RestMethod getRestMethod() {
        return this.restMethod;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public MethodParameterType getParameterType() {
        return this.parameterType;
    }

    public WebServiceResponseType getResponseType() {
        return this.responseType;
    }

    public MethodAccessorType getAccessorType() {
        return this.accessorType;
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public Json getPathVariables(String route) {
        Matcher matcher;
        Json vars = Json.map();
        if (!this.variables.isEmpty() && (route = this.checkRoute(route)) != null && (matcher = this.extractPattern.matcher(route)).matches()) {
            this.variables.forEach((key, index) -> vars.set((String)key, matcher.group((int)index)));
        }
        return vars;
    }

    public boolean isValidRoute(String route) {
        return this.checkRoute(route) != null;
    }

    private String checkRoute(String route) {
        route = StringUtils.isBlank((CharSequence)route) ? "" : route.trim();
        return this.pattern.matcher(route).matches() ? route : null;
    }

    @Override
    public int compareTo(RegisteredWebService o) {
        return -1 * this.getKey().compareTo(o.getKey());
    }

    static {
        try {
            namedGroupsMethod = Pattern.class.getDeclaredMethod("namedGroups", new Class[0]);
            namedGroupsMethod.setAccessible(true);
        }
        catch (Exception ex) {
            logger.error(String.format("Service can not extract variables on web services path: %s", ex.getMessage()), (Throwable)ex);
            namedGroupsMethod = null;
        }
    }
}

