/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.logs;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class ServiceLayout
extends PatternLayout {
    private static final char APP_NAME_CHAR = 'a';
    private static final char POD_ID_CHAR = 'i';
    private static final char SERVICE_NAME_CHAR = 'e';
    private static final char ENVIRONMENT_NAME_CHAR = 'v';
    private static final char DEPLOYMENT_NAME_CHAR = 'y';
    private static final char COMPONENT_NAME_CHAR = 'c';
    private static final char LINE_BREAK_CHAR = 'j';
    private static String application = "-";
    private static String podId = "-";
    private static String service = "-";
    private static String environment = "-";
    private static String deployment = "-";
    private static String component = "service";

    public static void setApplication(String application) {
        ServiceLayout.application = application;
    }

    public static void setPodId(String podId) {
        ServiceLayout.podId = podId;
    }

    public ServiceLayout() {
    }

    public ServiceLayout(String pattern) {
        super(pattern);
    }

    public static void setService(String service) {
        ServiceLayout.service = service;
    }

    public static void setEnvironment(String environment) {
        ServiceLayout.environment = environment;
    }

    public static void setDeployment(String deployment) {
        ServiceLayout.deployment = deployment;
    }

    public static void setComponent(String component) {
        ServiceLayout.component = component;
    }

    protected PatternParser createPatternParser(String pattern) {
        return new ServicePatternParser(pattern);
    }

    private class BreakLineConverter
    extends PatternConverter {
        private BreakLineConverter() {
        }

        protected String convert(LoggingEvent evt) {
            if (evt.getThrowableInformation() != null) {
                return ": " + StringUtils.join((Object[])evt.getThrowableInformation().getThrowableStrRep(), (String)"\n");
            }
            return "\n";
        }
    }

    private class ComponentConverter
    extends PatternConverter {
        private ComponentConverter() {
        }

        protected String convert(LoggingEvent evt) {
            return component;
        }
    }

    private class DeploymentNameConverter
    extends PatternConverter {
        private DeploymentNameConverter() {
        }

        protected String convert(LoggingEvent evt) {
            return deployment;
        }
    }

    private class EnvironmentNameConverter
    extends PatternConverter {
        private EnvironmentNameConverter() {
        }

        protected String convert(LoggingEvent evt) {
            return environment;
        }
    }

    private class ServiceNameConverter
    extends PatternConverter {
        private ServiceNameConverter() {
        }

        protected String convert(LoggingEvent evt) {
            return service;
        }
    }

    private class PodIdConverter
    extends PatternConverter {
        private PodIdConverter() {
        }

        protected String convert(LoggingEvent evt) {
            String podSuffix = podId;
            if (podSuffix.length() > 5) {
                podSuffix = podSuffix.substring(podSuffix.length() - 5);
            }
            return podSuffix;
        }
    }

    private class AppNameConverter
    extends PatternConverter {
        private AppNameConverter() {
        }

        protected String convert(LoggingEvent evt) {
            return application;
        }
    }

    private class ServicePatternParser
    extends PatternParser {
        public ServicePatternParser(String pattern) {
            super(pattern);
        }

        protected void finalizeConverter(char c) {
            switch (c) {
                case 'a': {
                    this.currentLiteral.setLength(0);
                    this.addConverter(new AppNameConverter());
                    break;
                }
                case 'i': {
                    this.currentLiteral.setLength(0);
                    this.addConverter(new PodIdConverter());
                    break;
                }
                case 'e': {
                    this.currentLiteral.setLength(0);
                    this.addConverter(new ServiceNameConverter());
                    break;
                }
                case 'v': {
                    this.currentLiteral.setLength(0);
                    this.addConverter(new EnvironmentNameConverter());
                    break;
                }
                case 'y': {
                    this.currentLiteral.setLength(0);
                    this.addConverter(new DeploymentNameConverter());
                    break;
                }
                case 'c': {
                    this.currentLiteral.setLength(0);
                    this.addConverter(new ComponentConverter());
                    break;
                }
                case 'j': {
                    this.currentLiteral.setLength(0);
                    this.addConverter(new BreakLineConverter());
                    break;
                }
                default: {
                    super.finalizeConverter(c);
                }
            }
        }
    }
}

