/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.configurations.sources;

import io.slingr.services.configurations.sources.PropertySource;
import io.slingr.services.utils.FilesUtils;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileSource
implements PropertySource {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesFileSource.class);
    private final String filename;
    private final Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesFileSource(String propertyFilename, boolean internal) {
        this.filename = propertyFilename;
        if (StringUtils.isBlank((CharSequence)propertyFilename)) {
            logger.error(String.format("Invalid name of property filename. This source will be ignored: %s", propertyFilename));
        } else {
            InputStream input = null;
            try {
                input = internal ? FilesUtils.getInternalFile(propertyFilename) : FilesUtils.getLocalFile(propertyFilename);
                this.properties.load(input);
            }
            catch (Exception ex) {
                logger.error(String.format("Exception when read property file [%s]. This source will be ignored: %s", propertyFilename, ex.toString()));
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public String findProperty(String propertyName) {
        if (!this.properties.isEmpty() && StringUtils.isNotBlank((CharSequence)propertyName) && this.properties.containsKey(propertyName)) {
            try {
                return this.properties.getProperty(propertyName);
            }
            catch (Exception ex) {
                try {
                    logger.warn(String.format("Property [%s] on file [%s] is invalid and will be ignored [%s]: %s", propertyName, this.filename, this.properties.get(propertyName), ex.toString()));
                }
                catch (Exception ex2) {
                    logger.warn(String.format("Property [%s] on file [%s] is invalid and will be ignored: %s (%s)", propertyName, this.filename, ex.toString(), ex2.toString()));
                }
            }
        }
        return null;
    }
}

