/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.Files;
import io.slingr.services.services.rest.DownloadedFile;
import io.slingr.services.services.rest.HttpRequest;
import io.slingr.services.services.rest.RestClientBuilder;
import io.slingr.services.services.rest.RestClientFactory;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.services.rest.authentication.AuthenticationType;
import io.slingr.services.utils.Base64Utils;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.Strings;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestClient {
    private static final Logger logger = LoggerFactory.getLogger(RestClient.class);
    static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    static final int DEFAULT_READ_TIMEOUT = 60000;
    static final boolean DEFAULT_FOLLOW_REDIRECTS = true;
    private static final boolean DEFAULT_ALLOW_EXTERNAL_URL = false;
    private static final String BASIC_AUTH = "BASIC";
    private static final String DIGEST_AUTH = "DIGEST";
    protected static final String DEFAULT_FILE_NAME = "file";
    private static final String DEFAULT_EMPTY_PATH = "/";
    static final String DEFAULT_UPLOAD_PARAMETER = "file";
    static final String DEFAULT_UPLOAD_BODY = "data";
    public static final String BASIC_AUTHENTICATION_HEADER = "Basic";
    public static final String BEARER_AUTHENTICATION_HEADER = "Bearer";
    public static final String OAUTH_AUTHENTICATION_HEADER = "OAuth";
    public static int DEFAULT_MAX_REDIRECTS = 10;
    protected boolean debug = false;
    private boolean skipEncodeParams = false;
    private RestClientFactory factory;
    private WebTarget apiTarget;
    private final Map<String, Object> apiHeaders = new HashMap<String, Object>();
    private final Map<String, String> apiParams = new HashMap<String, String>();
    private Integer connectionTimeout = 5000;
    private Integer readTimeout = 60000;
    private boolean followRedirects = true;
    private String defaultEmptyPath = "/";
    private boolean allowExternalUrl = false;
    private String uploadParameter = "file";
    private String uploadBody = "data";
    private String defaultAuth = null;
    private String authUsername = null;
    private String authPassword = null;
    private static RestClientFactory defaultFactory = null;
    private static final ReentrantLock defaultFactoryLock = new ReentrantLock();

    public RestClient(String apiUri) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)apiUri)) {
            apiUri = "";
        }
        this.factory = new RestClientFactory();
        this.apiTarget = this.factory.uri(apiUri);
    }

    public RestClient(String apiUri, RestClientFactory factory) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)apiUri)) {
            apiUri = "";
        }
        this.factory = factory;
        this.apiTarget = factory.uri(apiUri);
    }

    public static RestClientBuilder builder(String apiUri) {
        return new RestClientBuilder(apiUri, new RestClientFactory());
    }

    public void restartClient() {
        this.factory = new RestClientFactory();
        this.apiTarget = this.factory.uri(this.apiTarget.getUri().toString());
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.factory.setDebug(debug);
    }

    public void setSkipEncodeParams(boolean skipEncodeParams) {
        this.skipEncodeParams = skipEncodeParams;
    }

    public WebTarget getApiTarget() {
        return this.apiTarget;
    }

    public void setupBasicAuthentication(String username, String password) {
        this.defaultAuth = BASIC_AUTH;
        this.authUsername = username;
        this.authPassword = password;
        this.apiTarget = this.factory.setupBasicAuthentication(this.apiTarget, username, password);
    }

    public void setupDigestAuthentication(String username, String password) {
        this.defaultAuth = DIGEST_AUTH;
        this.authUsername = username;
        this.authPassword = password;
        this.apiTarget = this.factory.setupDigestAuthentication(this.apiTarget, username, password);
    }

    public void setupAuthentication(Map<String, String> params) {
        AuthenticationType authenticationType = AuthenticationType.fromType(params);
        this.apiTarget = this.factory.setupAuthentication(this.apiTarget, authenticationType, params);
    }

    public void setupBasicAuthenticationHeader(String username, String password) {
        this.setupAuthenticationHeader(BASIC_AUTHENTICATION_HEADER, username, password);
    }

    public void setupBasicAuthenticationHeader(String authorizationToken) {
        this.setupAuthenticationHeader(BASIC_AUTHENTICATION_HEADER, authorizationToken);
    }

    public void setupBearerAuthenticationHeader(String username, String password) {
        this.setupAuthenticationHeader(BEARER_AUTHENTICATION_HEADER, username, password);
    }

    public void setupBearerAuthenticationHeader(String authorizationToken) {
        this.setupAuthenticationHeader(BEARER_AUTHENTICATION_HEADER, authorizationToken);
    }

    public void setupAuthenticationHeader(String type, String username, String password) {
        String authorizationToken = Base64Utils.encodeBasicAuthorization(username, password);
        this.setupAuthenticationHeader(type, authorizationToken);
    }

    public void setupAuthenticationHeader(String type, String authorizationToken) {
        this.setupDefaultHeader("Authorization", String.format("%s %s", StringUtils.isNotBlank((CharSequence)type) ? type.trim() : BASIC_AUTHENTICATION_HEADER, authorizationToken));
    }

    public void setRememberCookies(boolean rememberCookies) {
        this.factory.setRememberCookies(rememberCookies);
    }

    public void setupDefaultParam(String name, String value) {
        this.apiParams.put(name, value);
        this.apiTarget = this.apiTarget.queryParam(name, new Object[]{Strings.urlEncode(value)});
    }

    protected void setPath(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            this.apiTarget = this.apiTarget.path(path);
        }
    }

    protected WebTarget target(String path) {
        return this.apiTarget.path(path);
    }

    protected WebTarget target(String path, Json parameters) {
        WebTarget response = this.target(path);
        if (response != null && parameters != null && parameters.isMap()) {
            for (Map.Entry<String, Object> entry : parameters.toMap().entrySet()) {
                response = response.queryParam(entry.getKey(), new Object[]{entry.getValue() != null ? entry.getValue().toString() : Boolean.valueOf(true)});
            }
        }
        return response;
    }

    public void setupDefaultHeader(String name, Object value) {
        this.apiHeaders.put(name, value);
    }

    public Object getDefaultHeader(String name) {
        return this.apiHeaders.get(name);
    }

    public Map<String, Object> getDefaultHeaders() {
        return this.apiHeaders;
    }

    public void removeDefaultHeader(String name) {
        this.apiHeaders.remove(name);
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout != null && readTimeout >= 0 ? readTimeout : null;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout != null && connectionTimeout >= 0 ? connectionTimeout : null;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = Boolean.TRUE.equals(followRedirects);
    }

    public void setDefaultEmptyPath(String defaultEmptyPath) {
        this.defaultEmptyPath = defaultEmptyPath != null ? defaultEmptyPath.trim() : DEFAULT_EMPTY_PATH;
    }

    public void setAllowExternalUrl(boolean allowExternalUrl) {
        this.allowExternalUrl = allowExternalUrl;
    }

    public void setUploadParameter(String uploadParameter) {
        this.uploadParameter = uploadParameter;
    }

    public void setUploadBody(String uploadBody) {
        this.uploadBody = uploadBody;
    }

    public void setDisabledSslOptions() {
        System.setProperty("com.sun.net.ssl.enableECC", "false");
        System.setProperty("jsse.enableSNIExtension", "false");
    }

    public Json httpGet(Json request) throws ServiceException {
        return this.httpGet(HttpRequest.fromJson(RestMethod.GET, request));
    }

    public Json httpGet(HttpRequest request) throws ServiceException {
        return this.executeHttpRequest(RestMethod.GET, request);
    }

    public Json get() throws ServiceException {
        return this.get(null);
    }

    public Json get(WebTarget target) throws ServiceException {
        return this.get(target, null, false);
    }

    public Json get(boolean fullResponse) throws ServiceException {
        return this.get((WebTarget)null, fullResponse);
    }

    public Json get(WebTarget target, boolean fullResponse) throws ServiceException {
        return this.get(target, null, fullResponse);
    }

    public Json get(WebTarget target, Json headers) throws ServiceException {
        return this.get(target, headers, false);
    }

    public Json get(Json headers, boolean fullResponse) throws ServiceException {
        return this.get(null, headers, fullResponse);
    }

    public Json get(WebTarget target, Json headers, boolean fullResponse) throws ServiceException {
        HttpRequest request = new HttpRequest.HttpRequestBuilder().setFullResponse(fullResponse).build();
        return this.get(target, headers, request);
    }

    public Json get(WebTarget target, Json headers, HttpRequest request) throws ServiceException {
        return this.execute(RestMethod.GET, target, null, headers, request);
    }

    public Json httpPost(Json request) throws ServiceException {
        return this.httpPost(HttpRequest.fromJson(RestMethod.POST, request));
    }

    public Json httpPost(HttpRequest request) throws ServiceException {
        return this.executeHttpRequest(RestMethod.POST, request);
    }

    public Json post() throws ServiceException {
        return this.post(null);
    }

    public Json post(WebTarget target) throws ServiceException {
        return this.post(target, null, null, false);
    }

    public Json post(boolean fullResponse) throws ServiceException {
        return this.post((WebTarget)null, fullResponse);
    }

    public Json post(WebTarget target, boolean fullResponse) throws ServiceException {
        return this.post(target, null, null, fullResponse);
    }

    public Json post(Object content) throws ServiceException {
        return this.post(null, content);
    }

    public Json post(WebTarget target, Object content) throws ServiceException {
        return this.post(target, content, null, false);
    }

    public Json post(Object content, boolean fullResponse) throws ServiceException {
        return this.post(null, content, fullResponse);
    }

    public Json post(WebTarget target, Object content, boolean fullResponse) throws ServiceException {
        return this.post(target, content, null, fullResponse);
    }

    public Json post(WebTarget target, Object content, Json headers) throws ServiceException {
        return this.post(target, content, headers, false);
    }

    public Json post(Object content, Json headers, boolean fullResponse) throws ServiceException {
        return this.post(null, content, headers, fullResponse);
    }

    public Json post(WebTarget target, Object content, Json headers, boolean fullResponse) throws ServiceException {
        HttpRequest request = new HttpRequest.HttpRequestBuilder().setFullResponse(fullResponse).build();
        return this.post(target, content, headers, request);
    }

    public Json post(WebTarget target, Object content, Json headers, HttpRequest request) throws ServiceException {
        return this.execute(RestMethod.POST, target, content, headers, request);
    }

    public Json httpPut(Json request) throws ServiceException {
        return this.httpPut(HttpRequest.fromJson(RestMethod.PUT, request));
    }

    public Json httpPut(HttpRequest request) throws ServiceException {
        return this.executeHttpRequest(RestMethod.PUT, request);
    }

    public Json put() throws ServiceException {
        return this.put(null);
    }

    public Json put(WebTarget target) throws ServiceException {
        return this.put(target, null, null, false);
    }

    public Json put(boolean fullResponse) throws ServiceException {
        return this.put((WebTarget)null, fullResponse);
    }

    public Json put(WebTarget target, boolean fullResponse) throws ServiceException {
        return this.put(target, null, null, fullResponse);
    }

    public Json put(Object content) throws ServiceException {
        return this.put(null, content);
    }

    public Json put(WebTarget target, Object content) throws ServiceException {
        return this.put(target, content, null, false);
    }

    public Json put(Object content, boolean fullResponse) throws ServiceException {
        return this.put(null, content, fullResponse);
    }

    public Json put(WebTarget target, Object content, boolean fullResponse) throws ServiceException {
        return this.put(target, content, null, fullResponse);
    }

    public Json put(WebTarget target, Object content, Json headers) throws ServiceException {
        return this.put(target, content, headers, false);
    }

    public Json put(Object content, Json headers, boolean fullResponse) throws ServiceException {
        return this.put(null, content, headers, fullResponse);
    }

    public Json put(WebTarget target, Object content, Json headers, boolean fullResponse) throws ServiceException {
        HttpRequest request = new HttpRequest.HttpRequestBuilder().setFullResponse(fullResponse).build();
        return this.put(target, content, headers, request);
    }

    public Json put(WebTarget target, Object content, Json headers, HttpRequest request) throws ServiceException {
        return this.execute(RestMethod.PUT, target, content, headers, request);
    }

    public Json httpPatch(Json request) throws ServiceException {
        return this.httpPatch(HttpRequest.fromJson(RestMethod.PATCH, request));
    }

    public Json httpPatch(HttpRequest request) throws ServiceException {
        return this.executeHttpRequest(RestMethod.PATCH, request);
    }

    public Json patch() throws ServiceException {
        return this.patch(null);
    }

    public Json patch(WebTarget target) throws ServiceException {
        return this.patch(target, null, null, false);
    }

    public Json patch(boolean fullResponse) throws ServiceException {
        return this.patch((WebTarget)null, fullResponse);
    }

    public Json patch(WebTarget target, boolean fullResponse) throws ServiceException {
        return this.patch(target, null, null, fullResponse);
    }

    public Json patch(Object content) throws ServiceException {
        return this.patch(null, content);
    }

    public Json patch(WebTarget target, Object content) throws ServiceException {
        return this.patch(target, content, null, false);
    }

    public Json patch(Object content, boolean fullResponse) throws ServiceException {
        return this.patch(null, content, fullResponse);
    }

    public Json patch(WebTarget target, Object content, boolean fullResponse) throws ServiceException {
        return this.patch(target, content, null, fullResponse);
    }

    public Json patch(Object content, Json headers) throws ServiceException {
        return this.patch(null, content, headers);
    }

    public Json patch(WebTarget target, Object content, Json headers) throws ServiceException {
        return this.patch(target, content, headers, false);
    }

    public Json patch(Object content, Json headers, boolean fullResponse) throws ServiceException {
        return this.patch(null, content, headers, fullResponse);
    }

    public Json patch(WebTarget target, Object content, Json headers, boolean fullResponse) throws ServiceException {
        HttpRequest request = new HttpRequest.HttpRequestBuilder().setFullResponse(fullResponse).build();
        return this.patch(target, content, headers, request);
    }

    public Json patch(WebTarget target, Object content, Json headers, HttpRequest request) throws ServiceException {
        return this.execute(RestMethod.PATCH, target, content, headers, request);
    }

    public Json httpDelete(Json request) throws ServiceException {
        return this.httpDelete(HttpRequest.fromJson(RestMethod.DELETE, request));
    }

    public Json httpDelete(HttpRequest request) throws ServiceException {
        return this.executeHttpRequest(RestMethod.DELETE, request);
    }

    public Json delete() throws ServiceException {
        return this.delete(null);
    }

    public Json delete(WebTarget target) throws ServiceException {
        return this.delete(target, null, false);
    }

    public Json delete(boolean fullResponse) throws ServiceException {
        return this.delete((WebTarget)null, fullResponse);
    }

    public Json delete(WebTarget target, boolean fullResponse) throws ServiceException {
        return this.delete(target, null, fullResponse);
    }

    public Json delete(WebTarget target, Json headers) throws ServiceException {
        return this.delete(target, headers, false);
    }

    public Json delete(Json headers, boolean fullResponse) throws ServiceException {
        return this.delete(null, headers, fullResponse);
    }

    public Json delete(WebTarget target, Json headers, boolean fullResponse) throws ServiceException {
        HttpRequest request = new HttpRequest.HttpRequestBuilder().setFullResponse(fullResponse).build();
        return this.delete(target, headers, request);
    }

    public Json delete(WebTarget target, Json headers, HttpRequest request) throws ServiceException {
        return this.execute(RestMethod.DELETE, target, null, headers, request);
    }

    public Json httpHead(Json request) throws ServiceException {
        return this.httpHead(HttpRequest.fromJson(RestMethod.HEAD, request));
    }

    public Json httpHead(HttpRequest request) throws ServiceException {
        return this.executeHttpRequest(RestMethod.HEAD, request);
    }

    public Json head() throws ServiceException {
        return this.head(null);
    }

    public Json head(WebTarget target) throws ServiceException {
        return this.head(target, null, false);
    }

    public Json head(boolean fullResponse) throws ServiceException {
        return this.head((WebTarget)null, fullResponse);
    }

    public Json head(WebTarget target, boolean fullResponse) throws ServiceException {
        return this.head(target, null, fullResponse);
    }

    public Json head(WebTarget target, Json headers) throws ServiceException {
        return this.head(target, headers, false);
    }

    public Json head(Json headers, boolean fullResponse) throws ServiceException {
        return this.head(null, headers, fullResponse);
    }

    public Json head(WebTarget target, Json headers, boolean fullResponse) throws ServiceException {
        HttpRequest request = new HttpRequest.HttpRequestBuilder().setFullResponse(fullResponse).build();
        return this.head(target, headers, request);
    }

    public Json head(WebTarget target, Json headers, HttpRequest request) throws ServiceException {
        return this.execute(RestMethod.HEAD, target, null, headers, request);
    }

    public Json httpOptions(Json request) throws ServiceException {
        return this.httpOptions(HttpRequest.fromJson(RestMethod.OPTIONS, request));
    }

    public Json httpOptions(HttpRequest request) throws ServiceException {
        return this.executeHttpRequest(RestMethod.OPTIONS, request);
    }

    public Json options() throws ServiceException {
        return this.options(null);
    }

    public Json options(WebTarget target) throws ServiceException {
        return this.options(target, null, false);
    }

    public Json options(boolean fullResponse) throws ServiceException {
        return this.options((WebTarget)null, fullResponse);
    }

    public Json options(WebTarget target, boolean fullResponse) throws ServiceException {
        return this.options(target, null, fullResponse);
    }

    public Json options(WebTarget target, Json headers) throws ServiceException {
        return this.options(target, headers, false);
    }

    public Json options(Json headers, boolean fullResponse) throws ServiceException {
        return this.options(null, headers, fullResponse);
    }

    public Json options(WebTarget target, Json headers, boolean fullResponse) throws ServiceException {
        HttpRequest request = new HttpRequest.HttpRequestBuilder().setFullResponse(fullResponse).build();
        return this.options(target, headers, request);
    }

    public Json options(WebTarget target, Json headers, HttpRequest request) throws ServiceException {
        return this.execute(RestMethod.OPTIONS, target, null, headers, request);
    }

    public DownloadedFile httpDownload(Json request) throws ServiceException {
        return this.httpDownload(HttpRequest.fromJson(RestMethod.GET, request));
    }

    public DownloadedFile httpDownload(HttpRequest request) throws ServiceException {
        return this.downloadHttpRequest(request);
    }

    public DownloadedFile download() throws ServiceException {
        return this.download(null, null);
    }

    public DownloadedFile download(WebTarget target) throws ServiceException {
        return this.download(target, null);
    }

    public DownloadedFile download(WebTarget target, Json headers) throws ServiceException {
        HttpRequest request = new HttpRequest.HttpRequestBuilder().build();
        return this.download(target, headers, request);
    }

    public DownloadedFile download(WebTarget target, Json headers, HttpRequest request) throws ServiceException {
        Response response = this.request(RestMethod.GET, target, null, headers, request);
        return this.factory.processDownloadedFile(response);
    }

    public Json httpMultipart(Json request, Files files) throws ServiceException {
        return this.httpMultipart(HttpRequest.fromJson(RestMethod.POST, request), files);
    }

    public Json httpMultipart(HttpRequest request, Files files) throws ServiceException {
        if (request == null) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "Invalid request");
        }
        try {
            request.setBody(this.factory.processMultipart(request, files));
            if (request.getRestMethod() == RestMethod.POST) {
                return this.httpPost(request);
            }
            if (request.getRestMethod() == RestMethod.PUT) {
                return this.httpPut(request);
            }
            throw ServiceException.permanent(ErrorCode.API, "HTTP method not supported for multipart requests");
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn(String.format("An exception occurs when try to upload a file [%s] - Exception: %s", request.getPath(), ex.getMessage()), (Throwable)ex);
            throw ServiceException.permanent(ErrorCode.CLIENT, (Object)ex.getMessage(), ex);
        }
    }

    public Json upload(InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload(null, inputStream, filename, contentType);
    }

    public Json upload(WebTarget target, InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload(target, false, inputStream, filename, contentType);
    }

    public Json upload(boolean fullResponse, InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload((WebTarget)null, fullResponse, inputStream, filename, contentType);
    }

    public Json upload(WebTarget target, boolean fullResponse, InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload(target, null, null, fullResponse, inputStream, filename, contentType);
    }

    public Json upload(Object content, InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload(null, content, inputStream, filename, contentType);
    }

    public Json upload(WebTarget target, Object content, InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload(target, content, false, inputStream, filename, contentType);
    }

    public Json upload(Object content, boolean fullResponse, InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload(null, content, fullResponse, inputStream, filename, contentType);
    }

    public Json upload(WebTarget target, Object content, boolean fullResponse, InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload(target, content, null, fullResponse, inputStream, filename, contentType);
    }

    public Json upload(Object content, Json headers, boolean fullResponse, InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload(null, content, headers, fullResponse, inputStream, filename, contentType);
    }

    public Json upload(WebTarget target, Object content, Json headers, boolean fullResponse, InputStream inputStream, String filename, String contentType) throws ServiceException {
        return this.upload(target, content, headers, fullResponse, null, null, null, null, inputStream, filename, contentType, null, null);
    }

    public Json upload(WebTarget target, Object content, Json headers, boolean fullResponse, Integer connectionTimeout, Integer readTimeout, Boolean followRedirects, Boolean forceDisableCookies, InputStream inputStream, String filename, String contentType, String uploadParameter, String uploadBody) throws ServiceException {
        uploadParameter = uploadParameter != null ? uploadParameter : this.uploadParameter;
        uploadBody = uploadBody != null ? uploadBody : this.uploadBody;
        HttpRequest request = new HttpRequest.HttpRequestBuilder().setFullResponse(fullResponse).setConnectionTimeout(connectionTimeout != null ? connectionTimeout : 5000).setReadTimeout(readTimeout != null ? readTimeout : 60000).setFollowRedirects(followRedirects != null ? followRedirects : true).setForceDisableCookies(forceDisableCookies != null ? forceDisableCookies : false).build();
        try {
            content = this.factory.processUploadFile(inputStream, filename, contentType, uploadParameter, uploadBody, content);
            return this.execute(RestMethod.POST, target, content, headers, request);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn(String.format("An exception occurs when try to upload a file - Exception: %s", ex.getMessage()), (Throwable)ex);
            throw ServiceException.permanent(ErrorCode.CLIENT, (Object)ex.getMessage(), ex);
        }
    }

    protected DownloadedFile downloadHttpRequest(HttpRequest request) throws ServiceException {
        Response response = this.requestHttpRequest(RestMethod.GET, request);
        return this.factory.processDownloadedFile(response);
    }

    protected Json executeHttpRequest(RestMethod method, HttpRequest request) throws ServiceException {
        Response response = this.requestHttpRequest(method, request);
        return this.factory.processResponse(response, method, request != null && request.isFullResponse());
    }

    private Response requestHttpRequest(RestMethod method, HttpRequest request) throws ServiceException {
        WebTarget target;
        String path;
        if (request == null) {
            request = new HttpRequest();
        }
        if (StringUtils.isBlank((CharSequence)(path = request.getPath()))) {
            path = this.defaultEmptyPath;
        }
        path = path.trim();
        Json params = request.getParams();
        if (path.contains("?")) {
            String pq = path.substring(path.indexOf("?") + 1);
            path = path.substring(0, path.indexOf("?"));
            try {
                Strings.parseQueryString(pq).forEachMap(params::set);
            }
            catch (Exception e) {
                if (this.debug) {
                    logger.info(String.format("%s Exception when process HTTP request params: %s", "DEBUG>", e.getMessage()));
                }
                logger.debug("Exception when process HTTP request params: " + e.getMessage());
            }
        }
        if (path.startsWith("http://") || path.startsWith("https://")) {
            if (!this.allowExternalUrl) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("External URLs are not allowed as request path [%s]", path));
            }
            Object simpleClient = RestClient.builder(path);
            for (Map.Entry<String, Object> entry : this.apiHeaders.entrySet()) {
                simpleClient = ((RestClientBuilder)simpleClient).header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.apiParams.entrySet()) {
                simpleClient = ((RestClientBuilder)simpleClient).parameter(entry.getKey(), (String)entry.getValue());
            }
            if (request.getAuthorization().isNotEmpty()) {
                ((RestClient)simpleClient).setupAuthentication(request.getAuthorization().toMapString());
            }
            target = ((RestClientBuilder)simpleClient).target();
        } else {
            target = this.getApiTarget().path(path);
        }
        if (!params.isEmpty()) {
            this.skipEncodeParams = request.isEncodeUrl() == null ? this.skipEncodeParams : request.isEncodeUrl() == false;
            for (String key : params.keys()) {
                Object object = params.object(key);
                if (object == null) continue;
                if (!(object instanceof String) && params.isList(key)) {
                    target = target.queryParam(key, this.skipEncodeParams ? params.strings(key).toArray() : Strings.urlEncode(params.strings(key)).toArray());
                    continue;
                }
                target = target.queryParam(key, new Object[]{this.skipEncodeParams ? object.toString() : Strings.urlEncode(object.toString())});
            }
        }
        target = (WebTarget)target.property("jersey.config.client.followRedirects", (Object)this.followRedirects);
        Object body = null;
        if (method == RestMethod.POST || method == RestMethod.PUT || method == RestMethod.PATCH) {
            body = request.getBody();
        }
        return this.request(method, target, body, request.getHeaders(), request);
    }

    protected Json execute(RestMethod method, WebTarget target, Object content, Json headers, HttpRequest request) throws ServiceException {
        Response response = this.request(method, target, content, headers, request);
        return this.factory.processResponse(response, method, request.isFullResponse());
    }

    protected Response request(RestMethod method, WebTarget target, Object content, Json headers, HttpRequest request) throws ServiceException {
        target = target != null ? target : this.apiTarget;
        Json headersToSend = Json.map();
        this.apiHeaders.forEach(headersToSend::set);
        if (headers != null && headers.isMap()) {
            headers.forEachMap(headersToSend::set);
        }
        return this.factory.request(method, target, content, headersToSend, request);
    }
}

