/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.ws.exchange;

import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WebServiceResponse
implements JsonSource {
    private int httpCode = 200;
    private final Object body;
    private final Json headers;

    public WebServiceResponse() {
        this(Json.map());
    }

    public WebServiceResponse(Object body) {
        this(body, Json.map());
    }

    public WebServiceResponse(Object body, String contentType) {
        this(body, Json.map().setIfNotEmpty("Content-Type", contentType));
    }

    public WebServiceResponse(int httpCode, Object body) {
        this(httpCode, body, Json.map());
    }

    public WebServiceResponse(int httpCode, Object body, String contentType) {
        this(httpCode, body, Json.map().setIfNotEmpty("Content-Type", contentType));
    }

    public WebServiceResponse(Object body, Json headers) {
        this(200, body, headers);
    }

    public WebServiceResponse(int httpCode, Object body, Json headers) {
        this.httpCode = httpCode;
        this.body = body;
        this.headers = headers != null ? headers : Json.map();
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(int httpCode) {
        this.httpCode = httpCode > 0 && httpCode < 700 ? httpCode : 200;
    }

    public Object getBody() {
        return this.body;
    }

    public Json getHeaders() {
        return this.headers;
    }

    public void setHeader(String header, Object value) {
        if (this.getHeaders() != null && StringUtils.isNotBlank((String)header)) {
            this.getHeaders().set(header, value);
        }
    }

    public Object getHeader(String header) {
        if (this.getHeaders() != null && StringUtils.isNotBlank((String)header)) {
            return this.getHeaders().object(header);
        }
        return null;
    }

    public String getStringHeader(String header) {
        if (this.getHeaders() != null && StringUtils.isNotBlank((String)header)) {
            return this.getHeaders().string(header);
        }
        return null;
    }

    @Override
    public Json toJson() {
        return this.toJson(false);
    }

    public Json toJson(boolean escapeBody) {
        Object b = this.body;
        if (escapeBody) {
            if (b == null) {
                b = "null";
            } else if (!(b instanceof JsonSource || b instanceof Collection || b instanceof Map || b instanceof String || b instanceof Number || b instanceof Boolean)) {
                b = String.format("Body[%s]", b.getClass());
            }
        }
        return Json.map().set("code", this.httpCode).set("body", b).setIfNotNull("headers", this.headers);
    }

    public String toString() {
        return this.toJson(true).toString();
    }
}

