/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils.tests;

import io.slingr.services.Service;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.framework.BaseModule;
import io.slingr.services.framework.IRunner;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.services.application.AppUser;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.Strings;
import io.slingr.services.utils.tests.ExtensionBrokerMock;
import io.slingr.services.utils.tests.MessageProcessor;
import io.slingr.services.ws.exchange.FunctionRequest;
import io.slingr.services.ws.exchange.UploadedFile;
import io.slingr.services.ws.exchange.WebServiceRequest;
import io.slingr.services.ws.exchange.WebServiceResponse;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTests {
    private static final Logger logger = LoggerFactory.getLogger(ServiceTests.class);
    public static final String TEST = "TEST>";
    private final Service service;
    private final BaseModule baseModule;
    private final ExtensionBrokerMock extensionBroker;

    public static ServiceTests start(IRunner runner, String configurationFile) throws Exception {
        if (runner == null) {
            throw new IllegalArgumentException("Runner is null");
        }
        Service service = runner.startService(configurationFile);
        if (service == null) {
            throw new IllegalArgumentException("Service is null");
        }
        return new ServiceTests(service);
    }

    public ServiceTests(Service service) {
        if (service == null) {
            throw new IllegalArgumentException("Service is null");
        }
        this.service = service;
        try {
            Method getBaseModule = Service.class.getDeclaredMethod("getBaseModule", new Class[0]);
            getBaseModule.setAccessible(true);
            this.baseModule = (BaseModule)getBaseModule.invoke((Object)service, new Object[0]);
            getBaseModule.setAccessible(false);
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Exception when find methods to test: %s", ex.getMessage()), ex);
        }
        ExtensionBrokerApi extensionBrokerApi = this.baseModule.getExtensionBroker();
        if (extensionBrokerApi instanceof ExtensionBrokerMock) {
            this.extensionBroker = (ExtensionBrokerMock)extensionBrokerApi;
        } else {
            logger.warn(String.format("%s --------------------------", TEST));
            logger.warn(String.format("%s Invalid Extension Broker services: Enable the flag '_testing_mode=true' on configuration to start testing mode.", TEST));
            logger.warn(String.format("%s --------------------------", TEST));
            this.extensionBroker = null;
        }
    }

    public Service getService() {
        return this.service;
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path) throws ServiceException {
        return this.executeWebServices(method, path, null, null, null, null, null);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body) throws ServiceException {
        return this.executeWebServices(method, path, body, null, null, null, null);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body, Json headers) throws ServiceException {
        return this.executeWebServices(method, path, body, headers, null, null, null);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body, Json headers, Json parameters) throws ServiceException {
        return this.executeWebServices(method, path, body, headers, parameters, null, null);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body, Json headers, Json parameters, Json requestInfo) throws ServiceException {
        return this.executeWebServices(method, path, body, headers, parameters, requestInfo, null);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body, Json headers, Json parameters, Json requestInfo, List<UploadedFile> files) throws ServiceException {
        return this.executeWebServices(method, path, body, headers, parameters, requestInfo, files, false);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, boolean expectedError) throws ServiceException {
        return this.executeWebServices(method, path, null, null, null, null, null, expectedError);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body, boolean expectedError) throws ServiceException {
        return this.executeWebServices(method, path, body, null, null, null, null, expectedError);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body, Json headers, boolean expectedError) throws ServiceException {
        return this.executeWebServices(method, path, body, headers, null, null, null, expectedError);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body, Json headers, Json parameters, boolean expectedError) throws ServiceException {
        return this.executeWebServices(method, path, body, headers, parameters, null, null, expectedError);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body, Json headers, Json parameters, Json requestInfo, boolean expectedError) throws ServiceException {
        return this.executeWebServices(method, path, body, headers, parameters, requestInfo, null, expectedError);
    }

    public WebServiceResponse executeWebServices(RestMethod method, String path, Object body, Json headers, Json parameters, Json requestInfo, List<UploadedFile> files, boolean expectedError) throws ServiceException {
        return this.executeWebServices(new WebServiceRequest(method, path, body, headers, parameters, requestInfo, files), expectedError);
    }

    public WebServiceResponse executeWebServices(WebServiceRequest request) throws ServiceException {
        return this.executeWebServices(request, false);
    }

    public WebServiceResponse executeWebServices(WebServiceRequest request, boolean expectedError) throws ServiceException {
        WebServiceResponse response;
        if (request == null) {
            throw new IllegalArgumentException("Request is null");
        }
        logger.info(String.format("%s -------------------------- INI", TEST));
        logger.info(String.format("%s Testing web service: [%s %s]", new Object[]{TEST, request.getMethod(), request.getPath()}));
        logger.info(String.format("%s  - WS REQUEST: %s", TEST, request.toJson()));
        boolean isException = false;
        try {
            response = this.baseModule.executeWebServices(request);
            logger.info(String.format("%s  - WS RESPONSE: %s", TEST, response != null ? response.toJson() : "<null>"));
        }
        catch (ServiceException ee) {
            if (expectedError) {
                isException = true;
                logger.error(String.format("%s  - WS EXPECTED ERROR: %s", TEST, ee.toJson()));
                response = new WebServiceResponse(ee.toJson());
            }
            logger.error(String.format("%s  - WS ERROR: %s", TEST, ee.toJson()));
            throw ee;
        }
        catch (Exception ex) {
            logger.error(String.format("%s  - WS UNEXPECTED ERROR: %s", TEST, ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        if (expectedError && !isException) {
            logger.error(String.format("%s  - WS UNEXPECTED RESPONSE: %s", TEST, response != null ? response : "<null>"));
            throw new IllegalStateException("Expected exception but received response: %s");
        }
        logger.info(String.format("%s -------------------------- END", TEST));
        return response;
    }

    public Json executeFunction(String functionName) throws ServiceException {
        return this.executeFunction(null, functionName, null, null, null, null);
    }

    public Json executeFunction(String functionName, Object params) throws ServiceException {
        return this.executeFunction(null, functionName, null, params, null, null);
    }

    public Json executeFunction(String functionName, Object params, String userId) throws ServiceException {
        return this.executeFunction(null, functionName, null, params, userId, null);
    }

    public Json executeFunction(String functionName, Object params, String userId, String userEmail) throws ServiceException {
        return this.executeFunction(null, functionName, null, params, userId, userEmail);
    }

    public Json executeFunction(String functionName, String functionId, Object params) throws ServiceException {
        return this.executeFunction(null, functionName, functionId, params, null, null);
    }

    public Json executeFunction(String functionName, String functionId, Object params, String userId) throws ServiceException {
        return this.executeFunction(null, functionName, functionId, params, userId, null);
    }

    public Json executeFunction(String functionName, String functionId, Object params, String userId, String userEmail) throws ServiceException {
        return this.executeFunction(null, functionName, functionId, params, userId, userEmail);
    }

    public Json executeFunction(Long date, String functionName, String functionId, Object params, String userId, String userEmail) throws ServiceException {
        return this.executeFunction(date, functionName, functionId, params, userId, userEmail, false);
    }

    public Json executeFunction(String functionName, boolean expectedError) throws ServiceException {
        return this.executeFunction(null, functionName, null, null, null, null, expectedError);
    }

    public Json executeFunction(String functionName, Object params, boolean expectedError) throws ServiceException {
        return this.executeFunction(null, functionName, null, params, null, null, expectedError);
    }

    public Json executeFunction(String functionName, Object params, String userId, boolean expectedError) throws ServiceException {
        return this.executeFunction(null, functionName, null, params, userId, null, expectedError);
    }

    public Json executeFunction(String functionName, Object params, String userId, String userEmail, boolean expectedError) throws ServiceException {
        return this.executeFunction(null, functionName, null, params, userId, userEmail, expectedError);
    }

    public Json executeFunction(String functionName, String functionId, Object params, boolean expectedError) throws ServiceException {
        return this.executeFunction(null, functionName, functionId, params, null, null, expectedError);
    }

    public Json executeFunction(String functionName, String functionId, Object params, String userId, String userEmail, boolean expectedError) throws ServiceException {
        return this.executeFunction(null, functionName, functionId, params, userId, userEmail, expectedError);
    }

    public Json executeFunction(Long date, String functionName, String functionId, Object params, String userId, String userEmail, boolean expectedError) throws ServiceException {
        return this.executeFunction(ServiceTests.generateRequest(date, functionName, functionId, params, userId, userEmail), expectedError);
    }

    public Json executeFunction(FunctionRequest request) throws ServiceException {
        return this.executeFunction(request, false);
    }

    public Json executeFunction(FunctionRequest request, boolean expectedError) throws ServiceException {
        Json response;
        if (request == null) {
            throw new IllegalArgumentException("Request is null");
        }
        logger.info(String.format("%s -------------------------- INI", TEST));
        logger.info(String.format("%s Testing function: [%s]", TEST, request.getFunctionName()));
        logger.info(String.format("%s  - FC REQUEST: %s", TEST, request.toJson()));
        boolean isException = false;
        try {
            response = this.baseModule.executeFunction(request);
            logger.info(String.format("%s  - FC RESPONSE: %s", TEST, response != null ? response.toJson() : "<null>"));
        }
        catch (ServiceException ee) {
            if (expectedError) {
                isException = true;
                logger.error(String.format("%s  - FC EXPECTED ERROR: %s", TEST, ee.toJson()));
                response = ee.toJson();
            }
            logger.error(String.format("%s  - FC ERROR: %s", TEST, ee.toJson()));
            throw ee;
        }
        catch (Exception ex) {
            logger.error(String.format("%s  - FC UNEXPECTED ERROR: %s", TEST, ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        if (expectedError && !isException) {
            logger.error(String.format("%s  - FC UNEXPECTED RESPONSE: %s", TEST, response != null ? response : "<null>"));
            throw new IllegalStateException(String.format("Expected exception but received response: %s", response != null ? response : "<null>"));
        }
        logger.info(String.format("%s -------------------------- END", TEST));
        return response;
    }

    public static FunctionRequest generateRequest(Long date, String functionName, String functionId, Object params, String userId, String userEmail) {
        return new FunctionRequest(Json.map().set("date", date != null ? date : System.currentTimeMillis()).setIfNotEmpty("function", functionName).setIfNotEmpty("id", functionId).setIfNotEmpty("params", params).setIfNotEmpty("userId", userId).setIfNotEmpty("userEmail", userEmail));
    }

    private void isTestingModeEnabled() {
        if (this.extensionBroker == null) {
            String error = String.format("%s Testing mode is not enabled. Use the flag '_testing_mode=true' on configuration.", TEST);
            logger.warn(error);
            throw new IllegalStateException(error);
        }
    }

    public void clearReceivedEvents() {
        this.isTestingModeEnabled();
        this.extensionBroker.clearReceivedEvents();
        logger.info(String.format("%s received events cleared", TEST));
    }

    public List<Json> getReceivedEvents() {
        this.isTestingModeEnabled();
        List<Json> events = this.extensionBroker.getReceivedEvents();
        logger.info(String.format("%s received events [%s]", TEST, events.size()));
        return events;
    }

    public void registerEventProcessor(String event, MessageProcessor processor) {
        this.isTestingModeEnabled();
        this.extensionBroker.registerEventProcessor(event, processor);
        logger.info(String.format("%s registered event processor [%s]", TEST, event));
    }

    public void removeEventProcessor(String event) {
        this.isTestingModeEnabled();
        this.extensionBroker.removeEventProcessor(event);
        logger.info(String.format("%s event processor removed [%s]", TEST, event));
    }

    public void clearEventProcessors() {
        this.isTestingModeEnabled();
        this.extensionBroker.clearEventProcessors();
        logger.info(String.format("%s event processors cleaned", TEST));
    }

    public void clearLocks() {
        this.isTestingModeEnabled();
        this.extensionBroker.clearLocks();
        logger.info(String.format("%s cleaned locks", TEST));
    }

    public List<String> getLocks() {
        this.isTestingModeEnabled();
        List<String> locks = this.extensionBroker.getLocks();
        logger.info(String.format("%s locks [%s]", TEST, locks.size()));
        return locks;
    }

    public void addFile(String fileId, ExtensionBrokerMock.FileMock file) {
        this.isTestingModeEnabled();
        this.extensionBroker.addFile(fileId, file);
        logger.info(String.format("%s file added [%s]", TEST, fileId));
    }

    public void clearFiles() {
        this.isTestingModeEnabled();
        this.extensionBroker.clearFiles();
        logger.info(String.format("%s cleaned files", TEST));
    }

    public List<ExtensionBrokerMock.FileMock> getFiles() {
        this.isTestingModeEnabled();
        List<ExtensionBrokerMock.FileMock> files = this.extensionBroker.getFiles();
        logger.info(String.format("%s files [%s]", TEST, files.size()));
        return files;
    }

    public void clearDataStores() {
        this.isTestingModeEnabled();
        this.extensionBroker.clearDataStores();
        logger.info(String.format("%s cleaned data stores", TEST));
    }

    public void clearDataStore(String dataStoreName) {
        this.isTestingModeEnabled();
        this.extensionBroker.clearDataStore(dataStoreName);
        logger.info(String.format("%s cleaned data store [%s]", TEST, dataStoreName));
    }

    public void clearUserDataStore() {
        this.clearDataStore("__services_users__");
    }

    public List<String> getDataStoreNames() {
        this.isTestingModeEnabled();
        List<String> names = this.extensionBroker.getDataStoreNames();
        logger.info(String.format("%s data store names [%s]", TEST, names.size()));
        return names;
    }

    public List<Json> getDataStoreItems(String dataStoreName) {
        this.isTestingModeEnabled();
        List<Json> items = this.extensionBroker.getDataStoreItems(dataStoreName);
        logger.info(String.format("%s data store [%s] items [%s]", TEST, dataStoreName, items.size()));
        return items;
    }

    public List<Json> getUserDataStoreItems() {
        return this.getDataStoreItems("__services_users__");
    }

    public Json addDataStoreItem(String dataStoreName, Json document) throws ServiceException {
        this.isTestingModeEnabled();
        Json item = this.extensionBroker.saveDocument(dataStoreName, document);
        logger.info(String.format("%s saved data store [%s] item [%s]", TEST, dataStoreName, item));
        return item;
    }

    public Json addUserDataStoreItem(Json document) throws ServiceException {
        return this.addDataStoreItem("__services_users__", document);
    }

    public void addAppUser(AppUser appUser) {
        this.addAppUser(Strings.randomUUIDString(), appUser);
    }

    public void addAppUser(String token, AppUser appUser) {
        this.isTestingModeEnabled();
        this.extensionBroker.addAppUser(token, appUser);
        logger.info(String.format("%s user added [%s]", TEST, token));
    }

    public void clearAppUsers() {
        this.isTestingModeEnabled();
        this.extensionBroker.clearAppUsers();
        logger.info(String.format("%s cleaned users", TEST));
    }

    public List<AppUser> getAppUsers() {
        this.isTestingModeEnabled();
        List<AppUser> users = this.extensionBroker.getAppUsers();
        logger.info(String.format("%s users [%s]", TEST, users.size()));
        return users;
    }

    public AppUser createAppUser(String email, String firstName, String lastName, boolean developer) {
        return this.createAppUser(email, firstName, lastName, "ACTIVE", developer);
    }

    public AppUser createAppUser(String email, String firstName, String lastName, String status, boolean developer) {
        return this.createAppUser(email, firstName, lastName, status, developer, null);
    }

    public AppUser createAppUser(String email, String firstName, String lastName, String status, boolean developer, List<Json> groups) {
        return this.createAppUser(Strings.randomUUIDString(), email, firstName, lastName, status, developer, groups);
    }

    public AppUser createAppUser(String id, String email, String firstName, String lastName, String status, boolean developer, List<Json> groups) {
        return this.createAppUser(id, email, firstName, lastName, status, developer, groups, null, null);
    }

    public AppUser createAppUser(String id, String email, String firstName, String lastName, String status, boolean developer, List<Json> groups, Json localization, Json permissions) {
        String fullName = String.format("%s %s", firstName, lastName);
        return new AppUser(id, "1", email, firstName, lastName, fullName, status, developer, groups, localization, permissions);
    }
}

