/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.services.ExtensionBroker;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.utils.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Locks {
    private static final Logger logger = LoggerFactory.getLogger(Locks.class);
    private final ExtensionBrokerApi api;
    private final boolean debug;

    public Locks(ExtensionBrokerApi api, boolean debug) {
        this.api = api;
        this.debug = debug;
    }

    public boolean lock(String key) {
        ExtensionBroker.isNotBlank(key, "empty key to lock");
        if (this.debug) {
            logger.info(String.format("%s locking key [%s]", "DEBUG>", key));
        }
        boolean result = false;
        try {
            Json response = this.api.acquireLock(key);
            if (response != null && response.contains("lockAcquired")) {
                result = response.is("lockAcquired");
            }
            if (this.debug) {
                logger.info(String.format("%s locked key [%s]: %s", "DEBUG>", key, result));
            }
        }
        catch (Exception ex) {
            logger.warn(String.format("Exception when try to lock key [%s]", key), (Throwable)ex);
        }
        return result;
    }

    public boolean unlock(String key) {
        ExtensionBroker.isNotBlank(key, "empty key to unlock");
        if (this.debug) {
            logger.info(String.format("%s unlocking key [%s]", "DEBUG>", key));
        }
        boolean result = false;
        try {
            Json response = this.api.releaseLock(key);
            if (response != null && response.contains("lockReleased")) {
                result = response.bool("lockReleased");
            }
            if (this.debug) {
                logger.info(String.format("%s unlocked key [%s]: %s", "DEBUG>", key, result));
            }
        }
        catch (Exception ex) {
            logger.warn(String.format("Exception when try to unlock key [%s]", key), (Throwable)ex);
        }
        return result;
    }
}

