/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework.annotations.classes;

import io.slingr.services.framework.annotations.ServiceDataStore;
import io.slingr.services.framework.annotations.classes.AccessorType;
import io.slingr.services.framework.annotations.classes.PropertyType;
import io.slingr.services.framework.annotations.classes.SettableProperty;
import io.slingr.services.framework.annotations.processor.AnnotationsUtils;
import io.slingr.services.services.datastores.DataStore;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang3.StringUtils;

public class ClassDataStore
implements SettableProperty {
    public static final String SDS_NAME = ServiceDataStore.class.getSimpleName();
    private final String simpleName;
    private final String name;
    private final AccessorType accessorType;
    private final String accessor;

    public ClassDataStore(Element sDataStoreElement) throws IllegalArgumentException {
        this(sDataStoreElement, sDataStoreElement.getAnnotation(ServiceDataStore.class));
    }

    private ClassDataStore(Element sDataStoreElement, ServiceDataStore annotation) throws IllegalArgumentException {
        this(sDataStoreElement, annotation != null ? annotation.name() : null);
    }

    public ClassDataStore(Element sDataStoreElement, String dataStoreName) throws IllegalArgumentException {
        VariableElement annotatedElement = (VariableElement)sDataStoreElement;
        this.simpleName = annotatedElement.getSimpleName().toString().trim();
        this.name = StringUtils.isNotBlank((CharSequence)dataStoreName) ? dataStoreName : this.simpleName;
        AnnotationsUtils.checkNotEmpty(this.name, "name", SDS_NAME, "data store", this.name);
        String setterName = String.format("set%S%s", this.simpleName.substring(0, 1), this.simpleName.length() > 1 ? this.simpleName.substring(1) : "");
        PropertyType type = AnnotationsUtils.isValidSetter(DataStore.class, annotatedElement, this.simpleName, setterName);
        if (type == null) {
            this.accessor = this.simpleName;
            type = AnnotationsUtils.isValidProperty(DataStore.class, annotatedElement, this.simpleName, this.accessor);
            if (type == null) {
                throw new IllegalStateException(String.format("Data Store [%s] is not valid", this.simpleName));
            }
            this.accessorType = annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE) || annotatedElement.getModifiers().contains((Object)Modifier.PROTECTED) ? AccessorType.REFLECTION : AccessorType.PROPERTY;
        } else {
            this.accessorType = AccessorType.SETTER;
            this.accessor = setterName;
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getAccessor() {
        return this.accessor;
    }

    @Override
    public AccessorType getAccessorType() {
        return this.accessorType;
    }
}

