/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils.tests;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.ExtensionBroker;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.services.application.AppUser;
import io.slingr.services.services.datastores.DataStoreResponse;
import io.slingr.services.services.logs.AppLogLevel;
import io.slingr.services.services.rest.DownloadedFile;
import io.slingr.services.utils.FilesUtils;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.Strings;
import io.slingr.services.utils.converters.JsonSource;
import io.slingr.services.utils.tests.MessageProcessor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionBrokerMock
implements ExtensionBrokerApi {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionBrokerMock.class);
    private final ReentrantLock eventsLock = new ReentrantLock();
    private final List<Json> receivedEvents = new ArrayList<Json>();
    private final Map<String, MessageProcessor> eventProcessors = new HashMap<String, MessageProcessor>();
    private final ReentrantLock locksLock = new ReentrantLock();
    private final Map<String, Boolean> locks = new HashMap<String, Boolean>();
    private final ReentrantLock filesLock = new ReentrantLock();
    private final Map<String, FileMock> files = new HashMap<String, FileMock>();
    private final ReentrantLock dataStoresLock = new ReentrantLock();
    private final Map<String, List<Json>> dataStores = new HashMap<String, List<Json>>();
    private final ReentrantLock usersLock = new ReentrantLock();
    private final Map<String, AppUser> users = new HashMap<String, AppUser>();

    @Override
    public void newEvent(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail) throws ServiceException {
        this.processEvent("event", date, event, data, fromFunctionId, userId, userEmail);
        logger.info(String.format("%s --------------", "TEST>"));
    }

    @Override
    public Object newSyncEvent(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail) throws ServiceException {
        Object response = this.processEvent("sync event", date, event, data, fromFunctionId, userId, userEmail);
        logger.info(String.format("%s EB: sync events response: %s", "TEST>", response));
        logger.info(String.format("%s --------------", "TEST>"));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processEvent(String type, Long date, String event, Object data, String fromFunctionId, String userId, String userEmail) throws ServiceException {
        ExtensionBroker.isNotBlank(event, "empty event name");
        if (date == null) {
            date = System.currentTimeMillis();
        }
        Json eventContent = Json.map().set("date", date).set("event", event).setIfNotNull("data", data).setIfNotEmpty("fromFunction", fromFunctionId).setIfNotEmpty("userId", userId).setIfNotEmpty("userEmail", userEmail);
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: new %s: %s", "TEST>", type, eventContent));
        Object response = null;
        this.eventsLock.lock();
        try {
            this.receivedEvents.add(eventContent);
            if (this.eventProcessors.containsKey(event)) {
                logger.info(String.format("%s EB: event processor found for [%s]", "TEST>", event));
                response = this.eventProcessors.get(event).processMessage(eventContent);
            } else {
                logger.info(String.format("%s EB: default event response for [%s]", "TEST>", event));
            }
        }
        finally {
            this.eventsLock.unlock();
        }
        if (response == null) {
            response = Json.map();
        }
        return response;
    }

    public void clearReceivedEvents() {
        this.eventsLock.lock();
        try {
            this.receivedEvents.clear();
        }
        finally {
            this.eventsLock.unlock();
        }
    }

    public List<Json> getReceivedEvents() {
        ArrayList<Json> events = new ArrayList<Json>();
        this.eventsLock.lock();
        try {
            events.addAll(this.receivedEvents);
        }
        finally {
            this.eventsLock.unlock();
        }
        return events;
    }

    public void registerEventProcessor(String event, MessageProcessor processor) {
        if (StringUtils.isEmpty((CharSequence)event)) {
            throw new IllegalArgumentException("Invalid event name");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Invalid processor");
        }
        this.eventsLock.lock();
        try {
            this.eventProcessors.put(event, processor);
        }
        finally {
            this.eventsLock.unlock();
        }
    }

    public void removeEventProcessor(String event) {
        if (StringUtils.isEmpty((CharSequence)event)) {
            throw new IllegalArgumentException("Invalid event name");
        }
        this.eventsLock.lock();
        try {
            this.eventProcessors.remove(event);
        }
        finally {
            this.eventsLock.unlock();
        }
    }

    public void clearEventProcessors() {
        this.eventsLock.lock();
        try {
            this.eventProcessors.clear();
        }
        finally {
            this.eventsLock.unlock();
        }
    }

    @Override
    public void newAppLogs(Long date, String level, String message, Json additionalInfo) throws ServiceException {
        ExtensionBroker.isNotBlank(message, "empty app log message");
        if (date == null) {
            date = System.currentTimeMillis();
        }
        level = AppLogLevel.checkStringValue(level);
        if (additionalInfo == null) {
            additionalInfo = Json.map();
        }
        Json restContent = Json.map().set("date", date).set("level", level).set("message", message).setIfNotEmpty("additionalInfo", additionalInfo);
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: app log: %s", "TEST>", restContent));
        logger.info(String.format("%s --------------", "TEST>"));
    }

    @Override
    public Json acquireLock(String key) throws ServiceException {
        ExtensionBroker.isNotBlank(key, "empty key to lock");
        boolean acquired = false;
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: acquire lock: %s", "TEST>", key));
        this.locksLock.lock();
        try {
            if (!this.locks.containsKey(key) || !Boolean.TRUE.equals(this.locks.get(key))) {
                acquired = true;
                this.locks.put(key, true);
            }
        }
        finally {
            this.locksLock.unlock();
        }
        Json jsonResponse = Json.map().set("lockAcquired", acquired);
        logger.info(String.format("%s EB: lock: %s", "TEST>", jsonResponse));
        logger.info(String.format("%s --------------", "TEST>"));
        return jsonResponse;
    }

    @Override
    public Json releaseLock(String key) throws ServiceException {
        ExtensionBroker.isNotBlank(key, "empty key to unlock");
        boolean released = false;
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: release lock: %s", "TEST>", key));
        this.locksLock.lock();
        try {
            if (this.locks.containsKey(key) && Boolean.TRUE.equals(this.locks.get(key))) {
                released = true;
                this.locks.put(key, false);
            }
        }
        finally {
            this.locksLock.unlock();
        }
        Json jsonResponse = Json.map().set("lockReleased", released);
        logger.info(String.format("%s EB: unlock: %s", "TEST>", jsonResponse));
        logger.info(String.format("%s --------------", "TEST>"));
        return jsonResponse;
    }

    public void clearLocks() {
        this.locksLock.lock();
        try {
            this.locks.clear();
        }
        finally {
            this.locksLock.unlock();
        }
    }

    public List<String> getLocks() {
        ArrayList<String> locks = new ArrayList<String>();
        this.locksLock.lock();
        try {
            locks.addAll(this.locks.entrySet().stream().filter(lock -> Boolean.TRUE.equals(lock.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()));
        }
        finally {
            this.locksLock.unlock();
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Json uploadFile(String filename, InputStream content, String contentType) throws ServiceException {
        ExtensionBroker.isNotBlank(filename, "empty file name");
        ExtensionBroker.isNotNull(content, "empty file content");
        String fileContent = Strings.readAsString(content);
        if (fileContent == null) {
            logger.warn(String.format("Local copy not created for file [%s]. The file will not be uploaded.", filename));
            throw ServiceException.permanent(ErrorCode.CONVERSION, String.format("File [%s] was not uploaded. The file could not be downloaded.", filename));
        }
        long fileLength = fileContent.length();
        if (fileLength < 1L) {
            logger.warn(String.format("Empty local copy of file [%s]. The file will not be uploaded.", filename));
            return null;
        }
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: upload file [%s], length [%s], content type [%s]", "TEST>", filename, fileLength, contentType));
        MediaType mediaType = FilesUtils.getMediaTypeForMultipart(contentType, filename);
        if (mediaType != null) {
            contentType = mediaType.toString();
        }
        String fileId = Strings.randomUUIDString();
        FileMock fileMock = new FileMock(fileContent, fileId, filename, contentType, fileLength);
        this.filesLock.lock();
        try {
            this.files.put(fileId, fileMock);
        }
        finally {
            this.filesLock.unlock();
        }
        Json response = fileMock.getFileDescriptor();
        logger.info(String.format("%s EB: uploaded file: %s", "TEST>", response));
        logger.info(String.format("%s --------------", "TEST>"));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadedFile downloadFile(String fileId) throws ServiceException {
        ExtensionBroker.isNotBlank(fileId, "empty file id");
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: download file [%s]", "TEST>", fileId));
        this.filesLock.lock();
        try {
            if (this.files.containsKey(fileId)) {
                FileMock file = this.files.get(fileId);
                InputStream is = Strings.readAsInputStream(file.fileContent);
                DownloadedFile response = new DownloadedFile(200, is, file.getHeaders());
                logger.info(String.format("%s EB: downloaded file: %s", "TEST>", response));
                logger.info(String.format("%s --------------", "TEST>"));
                DownloadedFile downloadedFile = response;
                return downloadedFile;
            }
        }
        finally {
            this.filesLock.unlock();
        }
        throw ServiceException.permanent(ErrorCode.CLIENT, String.format("%s File does not exists on application [%s]", "TEST>", fileId));
    }

    @Override
    public Json getFileMetadata(String fileId) throws ServiceException {
        ExtensionBroker.isNotBlank(fileId, "empty file id");
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: get file metadata [%s]", "TEST>", fileId));
        Json response = null;
        this.filesLock.lock();
        try {
            if (this.files.containsKey(fileId)) {
                response = this.files.get(fileId).getMetadata();
            }
        }
        finally {
            this.filesLock.unlock();
        }
        logger.info(String.format("%s EB: file metadata: %s", "TEST>", response));
        logger.info(String.format("%s --------------", "TEST>"));
        return response;
    }

    public void addFile(String fileId, FileMock file) {
        if (StringUtils.isEmpty((CharSequence)fileId)) {
            throw new IllegalArgumentException("Invalid file id");
        }
        if (file == null) {
            throw new IllegalArgumentException("Invalid file");
        }
        this.filesLock.lock();
        try {
            this.files.put(fileId, file);
        }
        finally {
            this.filesLock.unlock();
        }
    }

    public void clearFiles() {
        this.filesLock.lock();
        try {
            this.files.clear();
        }
        finally {
            this.filesLock.unlock();
        }
    }

    public List<FileMock> getFiles() {
        ArrayList<FileMock> response = new ArrayList<FileMock>();
        this.filesLock.lock();
        try {
            response.addAll(this.files.values());
        }
        finally {
            this.filesLock.unlock();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStoreResponse findDocuments(String dataStoreName, Json filter) throws ServiceException {
        DataStoreResponse response;
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        filter = ExtensionBroker.checkDataStoreFilter(filter);
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: find documents [%s], filter [%s]", "TEST>", dataStoreName, filter));
        this.dataStoresLock.lock();
        try {
            response = this.getDataStoreItems(dataStoreName, filter);
        }
        finally {
            this.dataStoresLock.unlock();
        }
        logger.info(String.format("%s EB: found documents: %s", "TEST>", response));
        logger.info(String.format("%s --------------", "TEST>"));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Json countDocuments(String dataStoreName, Json filter) throws ServiceException {
        Json response;
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        filter = ExtensionBroker.checkDataStoreFilter(filter);
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: count documents [%s], filter [%s]", "TEST>", dataStoreName, filter));
        this.dataStoresLock.lock();
        try {
            DataStoreResponse items = this.getDataStoreItems(dataStoreName, filter);
            response = Json.map().set("total", items.getTotal());
        }
        finally {
            this.dataStoresLock.unlock();
        }
        logger.info(String.format("%s EB: found documents count: %s", "TEST>", response));
        logger.info(String.format("%s --------------", "TEST>"));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Json getDocument(String dataStoreName, String documentId) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotBlank(documentId, "empty document id");
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: find document [%s], document id [%s]", "TEST>", dataStoreName, documentId));
        Json response = null;
        this.dataStoresLock.lock();
        try {
            List<Json> ds = this.getDataStore(dataStoreName);
            for (Json r : ds) {
                if (!documentId.equals(r.string("_id"))) continue;
                response = r;
            }
        }
        finally {
            this.dataStoresLock.unlock();
        }
        logger.info(String.format("%s EB: found document: %s", "TEST>", response));
        logger.info(String.format("%s --------------", "TEST>"));
        return response;
    }

    @Override
    public Json saveDocument(String dataStoreName, Json document) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotNull(document, "empty document");
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: save document [%s], document [%s]", "TEST>", dataStoreName, document));
        String documentId = document.string("_id");
        if (StringUtils.isBlank((CharSequence)documentId)) {
            documentId = Strings.randomUUIDString();
        }
        this.saveDocument(dataStoreName, documentId, document);
        logger.info(String.format("%s EB: saved document: %s", "TEST>", document));
        logger.info(String.format("%s --------------", "TEST>"));
        return document;
    }

    @Override
    public Json updateDocument(String dataStoreName, String documentId, Json document) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotBlank(documentId, "empty document id");
        ExtensionBroker.isNotNull(document, "empty document");
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: update document [%s], document id [%s], document [%s]", "TEST>", dataStoreName, documentId, document));
        this.saveDocument(dataStoreName, documentId, document);
        logger.info(String.format("%s EB: updated document: %s", "TEST>", document));
        logger.info(String.format("%s --------------", "TEST>"));
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Json removeDocuments(String dataStoreName, Json filter) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        filter = ExtensionBroker.checkDataStoreFilter(filter);
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: remove documents [%s], filter [%s]", "TEST>", dataStoreName, filter));
        Json response = Json.map().set("result", false).set("total", 0);
        filter.remove("_size");
        filter.remove("_offset");
        this.dataStoresLock.lock();
        try {
            ArrayList<Json> items = new ArrayList<Json>();
            int removed = 0;
            List<Json> ds = this.getDataStore(dataStoreName);
            if (filter.isEmpty()) {
                removed = ds.size();
            } else {
                for (Json r : ds) {
                    boolean remove = true;
                    for (String k : filter.keys()) {
                        if (filter.string(k).equals(r.string(k))) continue;
                        remove = false;
                        break;
                    }
                    if (!remove) {
                        items.add(r);
                        continue;
                    }
                    ++removed;
                }
            }
            this.dataStores.put(dataStoreName, items);
            response.set("result", removed > 0);
            response.set("total", removed);
        }
        finally {
            this.dataStoresLock.unlock();
        }
        logger.info(String.format("%s EB: removed documents: %s", "TEST>", response));
        logger.info(String.format("%s --------------", "TEST>"));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Json removeDocument(String dataStoreName, String documentId) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotBlank(documentId, "empty document id");
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: remove document [%s], document id [%s]", "TEST>", dataStoreName, documentId));
        Json response = Json.map().set("result", false).set("total", 0);
        this.dataStoresLock.lock();
        try {
            ArrayList<Json> items = new ArrayList<Json>();
            int removed = 0;
            List<Json> ds = this.getDataStore(dataStoreName);
            for (Json r : ds) {
                if (!documentId.equals(r.string("_id"))) {
                    items.add(r);
                    continue;
                }
                ++removed;
            }
            this.dataStores.put(dataStoreName, items);
            response.set("result", removed > 0);
            response.set("total", removed);
        }
        finally {
            this.dataStoresLock.unlock();
        }
        logger.info(String.format("%s EB: removed document: %s", "TEST>", response));
        logger.info(String.format("%s --------------", "TEST>"));
        return response;
    }

    private List<Json> getDataStore(String dataStoreName) {
        List<Json> ds = this.dataStores.get(dataStoreName);
        if (ds == null) {
            ds = new ArrayList<Json>();
        }
        this.dataStores.put(dataStoreName, ds);
        return ds;
    }

    private DataStoreResponse getDataStoreItems(String dataStoreName, Json filter) {
        List<Json> ds = this.getDataStore(dataStoreName);
        ArrayList<Json> items = new ArrayList<Json>();
        int total = 0;
        String newOffset = null;
        if (!ds.isEmpty()) {
            Integer size = filter.integer("_size");
            if (size == null) {
                size = ds.size() + 1;
            }
            filter.remove("_size");
            String offset = filter.string("_offset");
            filter.remove("_offset");
            boolean checkOffset = StringUtils.isNotBlank((CharSequence)offset);
            for (Json r : ds) {
                boolean include = true;
                if (!filter.isEmpty()) {
                    for (String k : filter.keys()) {
                        if (filter.string(k).equals(r.string(k))) continue;
                        include = false;
                        break;
                    }
                }
                if (include) {
                    ++total;
                }
                if (size < 0) {
                    include = false;
                } else if (checkOffset) {
                    if (offset.compareTo(r.string("_id")) >= 0) {
                        include = false;
                    } else {
                        checkOffset = false;
                    }
                }
                if (!include) continue;
                items.add(r);
                Integer n = size;
                size = size - 1;
                newOffset = r.string("_id");
            }
        }
        return new DataStoreResponse(items, total, newOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocument(String dataStoreName, String documentId, Json document) {
        document.set("_id", documentId);
        this.dataStoresLock.lock();
        try {
            ArrayList<Json> newDs = new ArrayList<Json>();
            List<Json> ds = this.getDataStore(dataStoreName);
            boolean saved = false;
            for (Json r : ds) {
                if (documentId.equals(r.string("_id"))) {
                    newDs.add(document);
                    saved = true;
                    continue;
                }
                newDs.add(r);
            }
            if (!saved) {
                newDs.add(document);
            }
            this.dataStores.put(dataStoreName, newDs);
        }
        finally {
            this.dataStoresLock.unlock();
        }
    }

    public void clearDataStores() {
        this.dataStoresLock.lock();
        try {
            this.dataStores.clear();
        }
        finally {
            this.dataStoresLock.unlock();
        }
    }

    public void clearDataStore(String dataStoreName) {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        this.dataStoresLock.lock();
        try {
            this.dataStores.put(dataStoreName, new ArrayList());
        }
        finally {
            this.dataStoresLock.unlock();
        }
    }

    public List<Json> getDataStoreItems(String dataStoreName) {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ArrayList<Json> response = new ArrayList<Json>();
        this.dataStoresLock.lock();
        try {
            response.addAll(this.getDataStore(dataStoreName));
        }
        finally {
            this.dataStoresLock.unlock();
        }
        return response;
    }

    public List<String> getDataStoreNames() {
        ArrayList<String> response = new ArrayList<String>();
        this.dataStoresLock.lock();
        try {
            response.addAll(this.dataStores.keySet());
        }
        finally {
            this.dataStoresLock.unlock();
        }
        return response;
    }

    @Override
    public Json getConfiguration() throws ServiceException {
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: get configuration", "TEST>"));
        Json jsonResponse = Json.map().set("proxy", false).set("webServiceUri", null);
        logger.info(String.format("%s EB: configuration response: %s", "TEST>", jsonResponse));
        logger.info(String.format("%s --------------", "TEST>"));
        return jsonResponse;
    }

    @Override
    public AppUser getUserInformationByToken(String token) throws ServiceException {
        ExtensionBroker.isNotBlank(token, "empty token");
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: get user information by token [%s]", "TEST>", token));
        AppUser response = null;
        this.usersLock.lock();
        try {
            if (this.users.containsKey(token)) {
                response = this.users.get(token);
            }
        }
        finally {
            this.usersLock.unlock();
        }
        logger.info(String.format("%s EB: get user information by token [%s]: %s", "TEST>", token, response));
        logger.info(String.format("%s --------------", "TEST>"));
        if (response == null) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("User not found with token [%s]", token));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppUser getUserInformationByEmail(String email) throws ServiceException {
        ExtensionBroker.isNotBlank(email, "empty email");
        logger.info(String.format("%s --------------", "TEST>"));
        logger.info(String.format("%s EB: get user information by email [%s]", "TEST>", email));
        AppUser response = null;
        this.usersLock.lock();
        try {
            for (String token : this.users.keySet()) {
                AppUser user = this.users.get(token);
                if (!email.equalsIgnoreCase(user.getEmail())) continue;
                response = user;
                break;
            }
        }
        finally {
            this.usersLock.unlock();
        }
        logger.info(String.format("%s EB: get user information by email [%s]: %s", "TEST>", email, response));
        logger.info(String.format("%s --------------", "TEST>"));
        if (response == null) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("User not found with email [%s]", email));
        }
        return response;
    }

    @Override
    public void clearCache() throws ServiceException {
    }

    public void addAppUser(String token, AppUser appUser) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new IllegalArgumentException("Invalid token");
        }
        if (appUser == null) {
            throw new IllegalArgumentException("Invalid app user");
        }
        this.usersLock.lock();
        try {
            this.users.put(token, appUser);
        }
        finally {
            this.usersLock.unlock();
        }
    }

    public void clearAppUsers() {
        this.usersLock.lock();
        try {
            this.users.clear();
        }
        finally {
            this.usersLock.unlock();
        }
    }

    public List<AppUser> getAppUsers() {
        ArrayList<AppUser> response = new ArrayList<AppUser>();
        this.usersLock.lock();
        try {
            response.addAll(this.users.values());
        }
        finally {
            this.usersLock.unlock();
        }
        return response;
    }

    public static class FileMock
    implements JsonSource {
        private String fileContent;
        private String fileId;
        private String fileName;
        private String contentType;
        private Long length;
        private final Long uploadDate = System.currentTimeMillis();
        private final Long expirationDate = System.currentTimeMillis();
        private final Boolean expired = false;

        public FileMock() {
        }

        public FileMock(String fileContent, String fileId, String fileName, String contentType, Long length) {
            this();
            this.fileContent = fileContent;
            this.fileId = fileId;
            this.fileName = fileName;
            this.contentType = contentType;
            this.length = length;
        }

        public Json getMetadata() {
            return Json.map().setIfNotNull("fileName", this.fileName).setIfNotNull("contentType", this.contentType).setIfNotNull("length", this.length).setIfNotNull("uploadDate", this.uploadDate).setIfNotNull("expirationDate", this.expirationDate).setIfNotNull("expired", this.expired);
        }

        public Json getHeaders() {
            return Json.map().setIfNotNull("Content-Type", this.contentType).setIfNotNull("Content-Length", this.length);
        }

        public Json getFileDescriptor() {
            return Json.map().setIfNotEmpty("fileId", this.fileId).setIfNotEmpty("fileName", this.fileName).setIfNotEmpty("contentType", this.contentType);
        }

        @Override
        public Json toJson() {
            return Json.map().setIfNotNull("fileId", this.fileId).setIfNotNull("fileName", this.fileName).setIfNotNull("fileContent", this.fileContent).setIfNotNull("contentType", this.contentType).setIfNotNull("length", this.length).setIfNotNull("uploadDate", this.uploadDate).setIfNotNull("expirationDate", this.expirationDate).setIfNotNull("expired", this.expired);
        }
    }
}

